// bind.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CBind dialog

class CBind : public CDialog
{
// Construction
public:
	CBind(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CBind)
	enum { IDD = IDD_DIALOG_BIND };
	CButton	m_AddBtn;
	CStatic	m_XTo;
	CStatic	m_XFrm;
	CStatic	m_RTo;
	CStatic	m_RFrm;
	CListBox	m_LstWnd;
	CButton	m_DelEnd;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;
	
	void	ShowErrMsg(int index);
	void	AddEntry(BindingType *pBind);
	BOOL CheckIfIPAddressBound(LPCSTR IPAddress, LPSTR retmacadr);
	BOOL CheckIfMACAddressBound(LPCSTR MacAddress, LPSTR retipadr);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CBind)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonDel();
	afx_msg void OnHelp();
	afx_msg void OnSelchangeListBind();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CBindAdd dialog

class CBindAdd : public CDialog
{
// Construction
public:
	CBindAdd(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CBindAdd)
	enum { IDD = IDD_DIALOG_BIND_ADD };
	CEdit	m_MacLenWnd;
	CEdit	m_MacAdrWnd;
	CEdit	m_IPAdrWnd;
	CString	m_MacAdr;
	int		m_MacLen;
	CDotDecimal	m_IPAdr;
	CString	m_RLAdr;
	CString	m_RHAdr;
	CString	m_XLAdr;
	CString	m_XHAdr;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;

	AddrRangeType *ppAdrNode;
	BOOL ValidEditFields();
	void ShowErrMsg(int index);
	void ShowErrMsg(LPCSTR Msg);
	BOOL	GetAnUnBoundIPAddress(AddrRangeType *pAdrNode, LPSTR NextAddress);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CBindAdd)
	virtual BOOL OnInitDialog();
	afx_msg void OnHelp();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
