// -------------------------------------------------------------------------
// Project Name                 :       MultiRouter Setup for Windows 
// File Name                    :       BOOT.h
// Description                  :       Defines various structures.
// Start Date                   :       8th May 1995
// Author                   	  :       Pravin
// Date Last Modified   		  :       
// Modifications                :       
// -------------------------------------------------------------------------
#define COLD_BOOT_MODE 0x00
#define DOWNLOAD_MODE 0xA5  /* Number for download mode */
#define WARM_BOOT_MODE 0x5A  /* Number for warm boot (after new cnf) mode */

/* NEW_BOOT */
/* chetan 10/2/97 */
#if 1
#define COD_LOAD_ADDR 0x00002000L
#define COD_START_ADDR 0x00002040L
#define UDB_DNLD_ADDR 0x080C0000L
#define OLD_COD_LOAD_ADDR 0x102000L
#define OLD_COD_START_ADDR 0x102040L
#else
#define COD_LOAD_ADDR	0x102000L
#define COD_START_ADDR	0x102040L
#define UDB_DNLD_ADDR 0xC0000L
#endif
/* chetan 10/2/97 */
/* NEW_BOOT */

#define SINGLE_SCR_SIZE (8 * 1024)
#define TOT_SCR_SIZES (3 * SINGLE_SCR_SIZE)
#define SCRIPT_ONE_DNLD_ADDR (UDB_DNLD_ADDR - TOT_SCR_SIZES)
#define SCRIPT_TWO_DNLD_ADDR (SCRIPT_ONE_DNLD_ADDR + SINGLE_SCR_SIZE)
#define SCRIPT_THREE_DNLD_ADDR (SCRIPT_TWO_DNLD_ADDR + SINGLE_SCR_SIZE)

#define MAGIC_NUM   0xABCD   /* Magic number in CodeHeader and Config recs */

#define FRAME_DELIM 0x7e

#define BOOT_CODE_SIZE  ((unsigned long) 68 * 1024) /* 68K for boot code */
#define FL_PAGE_SIZE 512
/* assuming 512 BYTEs as FLASH PROM page length */

/* NEW_BOOT */
/* chetan 10/2/97 */
#if 0
#define FL_ROMM_START   0x00000000L
#else
#define FLASH_1_BASE 0x08000000L
#define FL_ROMM_START FLASH_1_BASE
#endif
/* chetan 10/2/97 */
/* NEW_BOOT */
																			/*	offsets */
#define FL_BOOT_HDR     (FL_ROMM_START + BOOT_CODE_SIZE)	/* 11000 */
		/* 1 page for boot cfg hdr */

#define FL_CODE_HDR     (FL_BOOT_HDR + FL_PAGE_SIZE)     /* 11200 */
		/* 1 page for code hdr */

#define FL_CFG_HDR      (FL_CODE_HDR + FL_PAGE_SIZE)		/* 11400 */
		/* 1 page for system cfg hdr */

#define UDB_HEADER_START (FL_CFG_HDR + FL_PAGE_SIZE)		/* 11600 */
		/* 1 page for User database hdr */

#define SCRIPT_HEADER (UDB_HEADER_START + FL_PAGE_SIZE)	/* 11800 */
		/* 1 page for Script hdr */

#define SNMP_HEADER (SCRIPT_HEADER + FL_PAGE_SIZE)			/* 11A00 */
		/* 1 page for SNMP hdr */

#define RESERVED_HDR_1 (SNMP_HEADER + FL_PAGE_SIZE)		/* 11C00 */
#define RESERVED_HDR_2 (RESERVED_HDR_1 + FL_PAGE_SIZE)	/* 11E00 */
#define RESERVED_HDR_3 (RESERVED_HDR_2 + FL_PAGE_SIZE)	/* 12000 */
		/* 3 pages reserved for later use */

#define SNMP_VARIABLES (RESERVED_HDR_3 + FL_PAGE_SIZE)	/* 12200 */
		/* 2 pages for snmp variables */

#define FL_SYSTEM_CFG (SNMP_VARIABLES + (2 * FL_PAGE_SIZE))    /* 12600 */
		/* 61400 for system cfg */

/* NEW_BOOT */
/* chetan 10/2/97 */
#if 0
#define FL_CODE_START  0x21600L  /* FL_SYSTEM_CFG + 0x0000F000L 21600H */
#else
		/* Start of compressed code */
#define FL_CODE_START (FLASH_1_BASE + 0x21600L)
#define OLD_FL_CODE_START 0x21600L
#endif
/* chetan 10/2/97 */
/* NEW_BOOT */

/* sudha 10 Aug 1999 */
/* Boot prom width */
#define	PROM_WIDTH_UNKNOWN	0
#define	PROM_WIDTH_8BITS		1
#define	PROM_WIDTH_16BITS		2
#define	PROM_WIDTH_32BITS		3


#define RECV_7E     0
#define RECV_DATA   1
#define RECV_QUOTE  2

#define		NO_ERR							0
#define ERR_CRC         12      /* part of UI err codes */
#define ERR_PASSWORD    13
#define ERR_SCC1            14
#define ERR_SCC2            15
#define ERR_SCC3            16
#define ERR_SCC4            17

#define ERR_NO_BRD_GET_PASSWORD     18
#define ERR_NO_BRD_NO_PASSWORD      19
#define ERR_INV_MEM_RANGE               20
#define		ERR_READ_EVENT_LOG			25
#define		ERR_NO_LOGGING					26

#define TRGT_CMND_TYPE  0   /* part of UI commands */
#define RES_TYPE        12
#define PASSWORD_TYPE   30
#define REBOOT_TYPE     22
#define READ_REQ_TYPE   31
#define READ_RESP_TYPE  32

/* configuration manager lock commands */
#define	GET_LOCK			48
#define	FREE_LOCK		49

// Lock Response Type
#define LOCK_RESP_TYPE	50
#define	HANGUP_AND_REDIAL	51

#define	OPEN_EVENT_LOG			61
#define	READ_EVENT_LOG			62
#define	CLOSE_EVENT_LOG		63
#define	RESET_EVENT_LOG		64

/* configuration manager lock command responses */
#define	LK_LOCKED_OK					0
#define	LK_LOCK_OWNED_BY_TELNET		1
#define	LK_LOCK_OWNED_BY_WEB			2
#define	LK_LOCK_OWNED_BY_DUMB_TTY	3
#define	LK_LOCK_OWNED_BY_ROUCON		4
#define	LK_LOCK_OWNED_BY_SOMEONE	5

/* target command types */
#define DNLOAD_CODE_TYPE        0
#define HW_DIAG_TYPE            1
#define DNLOAD_CFG_TYPE     3

/* download types */
#define NO_DNLD     0
#define DNLD_CODE   1
#define DNLD_CFG    2
#define ONLINE_FLASH_WRITE 4

/* Ports */
#define SCC1        1
#define SCC2        2
#define SCC3        3
#define SCC4        4

/* Packet types */
#define	PT_UNKNOWN	0
#define	PT_HEADER	1		/* download header type - from UI */
#define	PT_DATA		2		/* download data pkt - from UI */
#define	PT_ABORT  	3	    /* abort download pkt - from UI and Target */
#define	PT_EOF		4		/* endof download packet - from UI */
#define	PT_NACK		5		/* negative ack - from Target */
#define	PT_ACK		6		/* positive ack - from Target */
#define	PT_TMOUT	7		/* Timeout packet - from Target */
#define	PT_INFO		8		/* Info req./response - from UI and Target */

#define RES_TYPE             12
#define QUERY_BRIDGE_NAME    13
#define REBOOT_TYPE          22
#define TRGT_CMD_TYPE         0
#define PASSWD_TYPE          30
#define	READ_REQ_TYPE        31
#define	READ_RESP_TYPE       32
#define DN_LD                 0
#define TST_HW                1
#define	REBOOT		   		  2
#define DN_LD_CNF             3


#define STATUS_PACKET_TYPES 100
#define GET_PORT_STATUS (STATUS_PACKET_TYPES + 0)

#define	ERR_NO_BRD_GET_PASSWORD		 18
#define	ERR_NO_BRD_NO_PASSWORD		 19
#define	ERR_CRC			             12		/* part of UI err codes */
#define	ERR_PASSWORD	             13
#define  ERR_ROUTER_UP				    21

#define MIN_PKT_SIZE    4   /* DnLdPktHead(2 Abort Pkt) + CRC(2) */

#define INC_CIR_IDX(seqnum, maxval) seqnum++; seqnum &= (maxval - 1)

/* Packet format of all Target Command packets 
   +----+------+------+----+----+---+-----+----+----+---...----
   | 7e |  SMC header | Pkt data... |    CRC   | 7e |   
   +----+------+------+----+----+---------+----+----+---...----
	  1         4                          2      1
CRC is calculated from Type  */

// For Requesting
typedef struct {
	BYTE Ptype ;
	BYTE ReqType ;
	BYTE ReqSubType ;
	BYTE Dmy0 ;
} ReqType ;


// Result of a request
typedef struct	{
	BYTE Ptype ;	
	BYTE Dmy0 ;  	
	WORD ErrorCode ;		
} ResultType ;

// Getting the bridge name
typedef struct {
	BYTE Ptype ;
	BYTE BrdName[11] ;
	BYTE BridgeID[4] ;
} OpenConnectionType ;

typedef struct {
	BYTE Version[10] ;		/* version number as ASCIIZ */
	BYTE DateStamp[25] ;		/* date as ASCIIZ */	
	BYTE Dmy[3] ;			   	
	WORD MagicNum ;	
   DWORD LoadAddr ; 			/* Address to start loading at */
	DWORD StartAddr ;			/* Address to start execution at */
  	DWORD DnLdAddress ;		/* Address to download at */
  	BYTE Reserved[21] ;		/* 56.. 76	for future use */
} DnLdHeadType ;

typedef struct tagDnLdPktHdr {
  	BYTE PacketType ;
  	BYTE SeqNum ;
} DnLdPktHdrType ;
  				 
typedef struct {
	DnLdPktHdrType hdr ;
  	DnLdHeadType headtype ;
} dnld_head_type ;

typedef struct {
	BYTE Version[10] ;        /* version number of this record ASCIIZ */
	BYTE EthernetAddr[6] ;    /* Ethernet address of bridge */
	BYTE PassWord[20] ;       /* passWORD for Boot config */   
	BYTE NumberOfPorts ;     /* Total Lan and Wan Ports */   
	BYTE	Base1;
	BYTE  Size1;
	BYTE  Base2;
	BYTE  Size2;
	BYTE	ClockSpeed;			/* added on 16/12/97 */
	BYTE	PROMWidth;
	BYTE	ModelNumber;
	BYTE Reserved[8] ;       /* for future use */   
	DWORD MagicNumber;		/* 0xA55AA55A to indicate valid config */
	DWORD FlashPromSize ;      /* System related information */  
	DWORD RamSize ;  
	DWORD RamStart ;  
} BootConfigType ;

/* Generic Header Pkt for all downloads. Each download type will use some 
or all of these fields */
typedef struct {
	BYTE Version[10] ;    /* 0 .. 9   version number as ASCIIZ */    
	BYTE DateStamp[25] ;  /* 10.. 34  date as ASCIIZ */    
	BYTE Dmy ;            /* 35 */    
	WORD MagicNum ;       /* 36.. 37 */    
	WORD CRC ;            /* 38.. 39  16bit CRC value */    
	DWORD CodeLength ;    /* 40.. 43  Valid length of compressed code */    
	DWORD DnLdAddr ;      /* 52.. 55  Address where compressed code is put */    
	DWORD LoadAddr ;      /* 44.. 47  Address to start loading at */    
	DWORD StartAddr ;     /* 48.. 51  Address to start execution at */    
	BYTE Reserved[20] ;   /* 56.. 75  for future use */    
} HeaderType ;

typedef struct {
	BYTE BridgeNumber[4] ;
} SMCPktHeadType ;

typedef struct {
	BYTE Ptype ;              // 0
	char Password[11] ;       // 1 .. 11
} PasswordPktType ;

typedef struct {
	BYTE Ptype ;              // 0
	BYTE TargetAction ;       // 1
	BYTE Port ;               // 2      These 2 fields are for 
	BYTE BaudIndex ;          // 3      Hardware Diagnostics
} TargetCmdType ;

// Read Location Request
typedef struct {
	BYTE Ptype ;                // 0
	BYTE Length ;               // 1
	BYTE Dmy[2] ;               // 2..3
	DWORD Address ;             // 4..7
} ReadLocReqType ;

// Read Location Response
typedef struct {
	BYTE Ptype ;              // 0
	BYTE ErrCode ;                // 1
	BYTE Length ;             // 2
	BYTE Dmy[1] ;			// just for alignment
	DWORD Address ;				// 3
	BYTE buffer[128] ;        // 3..131
}  ReadLocRespType ;

typedef struct {
	BYTE Ptype ;	
	BYTE BootType ;
} RebootType ;

#define UDB_SENT_ONCE_COM 512

typedef struct {
	BYTE TargetAction ;
	DWORD DnLdAddress ;
	UINT Length ;
	BYTE buffer[UDB_SENT_ONCE_COM] ;
	UINT CRC ;
} OnLineFlashWriteType ;		

extern DWORD UDBDnldAddress ;

extern DWORD CodeLoadAddress ;
extern DWORD CodeStartAddress ;
extern DWORD FlCodeStartAddress ;


