// com.h : header file
//
#ifndef COM_H
#define COM_H 1

#define MAGIC_SIZE	1024

extern	int idComDev;		//Shared for all instances of CMiscCom.

#define	DCD_8250	0x80			// DCD Mask in MSR of 8250

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 0xFF)] ^ (crc << 8) ^ ((cp) & 0xFF))

/////////////////////////////////////////////////////////////////////////////
// CMiscCom Class

class CMiscCom : public CObject
{
	
public:
	CMiscCom();			

// Attributes
public:
	int TimeOut , ABORT;
   WORD CODE_CRC;
	WORD UDBPktCRC ;
   DWORD ComprCodeSize;
	DWORD PrevComprCodeSize;
	WORD UDBActualLen ;
   char *DateStamp;
// Operations
public:
	void FlushReadBuf();
	void SetDateStamp();
	void fill(BYTE ch);
	void snd_packet(BYTE *pkt_data, int pkt_size);
	void snd_dnld_packet(BYTE *pkt_data, int pkt_size);
   void snd_eof_packet(BOOL *Timer, BOOL EnableCtrl);
   void snd_abort_pkt();
	char rcv_char(BOOL *Timer);
	BOOL timer_rcv_char(char FAR *Ch);
	void snd_char(char ch);
	int rcv_packet(BYTE *pkt_data, int pkt_size, BOOL *Timer);
	int rcv_dnld_packet(BYTE *pkt_data, int pkt_size, BOOL *Timer);
	int rcv_packet2(BYTE *pkt_data, int pkt_size, BOOL *Timer);
	int rcv_dnld_packet2(BYTE *pkt_data, int pkt_size, BOOL *Timer);
	BOOL Open_Comm(void);
	void Close_Comm(void);
	BOOL	IsDCDPresent(void);
	BYTE GetRS232(void);
	WORD ltl_endian_word(WORD num);
   DWORD little_endian(DWORD num);
   void cnf_dnld(BOOL *Timer , CString CNF_FileName, BOOL EnableCtrl);
   int LZWcompress(BOOL *Timer, CString CodeFileName, BOOL EnableCtrl, BOOL Compress);
	int SendAway(BOOL bFileEnd, BYTE *pbySendBuf, int iSizeToSent, BOOL *Timer, BOOL EnableCtrl);
	void	snd_mdm_command(BYTE *pkt_data, int pkt_size);
	BOOL	rcv_mdm_response(BYTE *mdm_resp, BOOL *Timer);
	BOOL	search_substr(BYTE *resp_str, BYTE *reqd_resp, int resp_len);
	void	ConvertControls(BYTE *dst_str,BYTE *src_str);
	void	hangup_mdm(char *hangup_string, BOOL *Timer);
   void updatecrc(BYTE ch);	
	int send_data_online (BYTE *str, UINT count, BOOL *Timer, BOOL EnableCtrl) ;
	int SendAwayUDB (BOOL bFileEnd, BYTE *pbySendBuf, int iSizeToSend, 
															BOOL *Timer, BOOL EnableCtrl) ;
#if 1 /* Sachin, 07/01/1997 */
	int receive_buffer (char FAR *buffer, int buffer_length) ;
#endif

private:
   void InttoMonth(int j, char Temp[10]);
   int send_data(BYTE *str,UINT count, BOOL *Timer, BOOL EnableCtrl);
   BYTE SEQ;
	BYTE *Pkt ;
	int Pindex;
	COMSTAT FAR* lpStat;    
	
	int iSizePartOfPrev;
	BYTE abyPartOfPrevBuf[MAGIC_SIZE];

// Implementation
public:
	virtual ~CMiscCom();
};
#endif

