// dhcpadt.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "dhcpk.h"
#include "dhcp.h"
#include "dhcpadt.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDHCPAdt dialog


CDHCPAdt::CDHCPAdt(CWnd* pParent /*=NULL*/)
	: CDialog(CDHCPAdt::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDHCPAdt)
	m_AdrFrom = "";
	m_AdrTo = "";
	m_AdrMsk = "";
	m_XFrom = "";
	m_XTo = "";
	//}}AFX_DATA_INIT
}

void CDHCPAdt::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDHCPAdt)
	DDX_Control(pDX, IDC_STATIC_MSG, m_MsgDefs);
	DDX_Control(pDX, IDC_EDIT5, m_XToWnd);
	DDX_Control(pDX, IDC_EDIT4, m_XFromWnd);
	DDX_Control(pDX, IDC_EDIT3, m_AdrMskWnd);
	DDX_Control(pDX, IDC_EDIT2, m_AdrToWnd);
	DDX_Control(pDX, IDC_EDIT1, m_AdrFromWnd);
	DDX_Text(pDX, IDC_EDIT1, m_AdrFrom);
	DDV_MaxChars(pDX, m_AdrFrom, 15);
	DDX_Text(pDX, IDC_EDIT2, m_AdrTo);
	DDX_Text(pDX, IDC_EDIT3, m_AdrMsk);
	DDX_Text(pDX, IDC_EDIT4, m_XFrom);
	DDX_Text(pDX, IDC_EDIT5, m_XTo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDHCPAdt, CDialog)
	//{{AFX_MSG_MAP(CDHCPAdt)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDHCPAdt message handlers

BOOL CDHCPAdt::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;


	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	//Get pointer to current selection, we need it if Edit;
	pLstItm = ((CDHCP *)GetParent())->pCurEditTag;

	//Limit text on all dot decimal fields
	m_XToWnd.LimitText(15);
	m_XFromWnd.LimitText(15);
	m_AdrMskWnd.LimitText(15);
	m_AdrToWnd.LimitText(15);
	m_AdrFromWnd.LimitText(15);

	//Fillup the address ranges and mask
	if (pLstItm)
	{
		//hide message saying "will copy option values...
		m_MsgDefs.ShowWindow(SW_HIDE);

		m_AdrFrom = pLstItm->LAddr;
		m_AdrTo = pLstItm->HAddr;
		m_AdrMsk = pLstItm->Mask;

		//No editing of the range and mask
//		m_AdrToWnd.EnableWindow(FALSE);
//		m_AdrFromWnd.EnableWindow(FALSE);
		m_AdrMskWnd.EnableWindow(FALSE);
//		m_XToWnd.EnableWindow(FALSE);
//		m_XFromWnd.EnableWindow(FALSE);

		if (pLstItm->XAddrList)
		{
			m_XFrom = pLstItm->XAddrList->XLAddr;
			m_XTo = pLstItm->XAddrList->XHAddr;
		}
	}
	UpdateData(FALSE);	//copy values to dialog
	return TRUE;  // return TRUE  unless you set the focus to a control
}

static char *ErrMsgs[] =
{
/* 0 */	"Invalid IP Address",
/* 1 */	"Invalid IP Address Mask",
/* 2 */	"IP Address mask can't have holes.\nCheck help for details",
/* 3 */	"Range bounds are not in same network",
/* 4 */	"Range lower address greater than upper address!",
/* 5 */	"Exclusion lower address not in defined network",
/* 6 */	"Exclusion upper address not in defined network",
/* 7 */	"Exclusion lower address out of range",
/* 8 */	"Exclusion upper address out of range",
/* 9 */	"Exclusion from address greater than till address!",
/* 10 */	"No memory for new node",
/* 11 */	"Exclusion upper bound undefined",
/* 12 */ "Full range can't be excluded!",
};

void CDHCPAdt::DisplayErrMsg(int index)
{
			::MessageBox (GetSafeHwnd(), (LPCSTR) ErrMsgs[index],
					(LPCSTR) "Address Range", MB_OK | MB_ICONEXCLAMATION) ;
}

BOOL CDHCPAdt::ValidEditFields()
{
	if (m_AdrFrom.IsEmpty() || !m_AdrFrom.IsValid())
	{
		DisplayErrMsg(0);
		m_AdrFromWnd.SetFocus();
		return FALSE;
	}

	if (m_AdrTo.IsEmpty() || !m_AdrTo.IsValid())
	{
		DisplayErrMsg(0);
		m_AdrToWnd.SetFocus();
		return FALSE;
	}

	if (m_AdrMsk.IsEmpty() || !m_AdrMsk.IsValid())
	{
		DisplayErrMsg(1);
		m_AdrMskWnd.SetFocus();
		return FALSE;
	}

	if ( !verify_ip_subnet_mask ((LPCSTR)m_AdrMsk))		//Check for holes
	{
		DisplayErrMsg(2);
		m_AdrMskWnd.SetFocus();
		return FALSE;
	}

	if (!m_XFrom.IsEmpty())
	{
		if (!m_XFrom.IsValid())
		{
			DisplayErrMsg(0);
			m_XFromWnd.SetFocus();
			return FALSE;
		}
	}
	if (!m_XFrom.IsEmpty())
	{
		if (m_XTo.IsEmpty())
		{
			DisplayErrMsg(11);
			m_XToWnd.SetFocus();
			return FALSE;
		}
		else
		{
			if (!m_XTo.IsValid())
			{
				DisplayErrMsg(0);
				m_XToWnd.SetFocus();
				return FALSE;
			}
		}
	}
	unsigned long adrf, adrt, msk, adrxf, adrxt;
	//Now check if all the IP addresses (valid IP addr by now)fall in same net
	//first convert all addresses to ineget form
	get_ip_address(m_AdrFrom, &adrf);
	get_ip_address(m_AdrTo, &adrt);
	get_ip_address(m_AdrMsk, &msk);
	get_ip_address(m_XFrom, &adrxf);
	get_ip_address(m_XTo, &adrxt);

	//upper and lower address of range must be in same ip network
	if ((adrf & msk) != (adrt & msk))
	{
		DisplayErrMsg(3);
		m_AdrToWnd.SetFocus();
		return FALSE;
	}
	//lower bound can't be greater than upper bound
	if (adrf > adrt)
	{
		DisplayErrMsg(4);
		m_AdrToWnd.SetFocus();
		return FALSE;
	}
	//if exclusion range has one entry non-zero
	if (adrxf || adrxt)
	{
		//exclusion lower bound must be in same net as range lower bound
		if ((adrf & msk) != (adrxf & msk))
		{
			DisplayErrMsg(5);
			m_XFromWnd.SetFocus();
			return FALSE;
		}

		//exclusion upper bound also must be in the same net
		if ((adrxf & msk) != (adrxt & msk))
		{
			DisplayErrMsg(6);
			m_XToWnd.SetFocus();
			return FALSE;
		}
		//exclusion lower bound must be in the range
		if (adrxf < adrf || adrxf > adrt)
		{
			DisplayErrMsg(7);
			m_XFromWnd.SetFocus();
			return FALSE;
		}
		//exclusion upper bound must be in the range
		if (adrxt < adrf || adrxt > adrt)
		{
			DisplayErrMsg(8);
			m_XToWnd.SetFocus();
			return FALSE;
		}
		//exclusion lower address can't be great than upper
		if (adrxf > adrxt)
		{
			DisplayErrMsg(9);
			m_XToWnd.SetFocus();
			return FALSE;
		}
		//if full range is excluded, range has no meaning
		if ((adrf == adrxf) && (adrt == adrxt))
		{
			DisplayErrMsg(12);
			m_XFromWnd.SetFocus();
			return FALSE;
		}
	}
	//if any binding is already defined and the
	//new range doesn't include it , user must delete the
	//bindings which will be orphaned otherwise
	if (pLstItm)	// possible only if editing
	{
		BindingType *pBind;
		pBind = pLstItm->Binds;

		unsigned long bndadr;
		char szBuf[80];
		while(pBind)
		{
			get_ip_address(pBind->IPAddr, &bndadr);

			if (bndadr < adrf || bndadr > adrt)
			{
				sprintf(szBuf, "Bound IP Address out of range!\n\
IP Address %s bound to MAC address %s", pBind->IPAddr, pBind->MacAddr);
				::MessageBox (GetSafeHwnd(), (LPCSTR) szBuf,
						(LPCSTR) "Address Range", MB_OK | MB_ICONEXCLAMATION) ;
				m_AdrFromWnd.SetFocus();
				return FALSE;
			}

			if (adrxf)	//if exclusions are defined, binds shouldn't be orphaned
			{
				if (bndadr >= adrxf && bndadr <= adrxt)
				{
					sprintf(szBuf, "Bound IP Address excluded from range!\n\
IP Address %s bound to MAC address %s", pBind->IPAddr, pBind->MacAddr);
					::MessageBox (GetSafeHwnd(), (LPCSTR) szBuf,
							(LPCSTR) "Address Range", MB_OK | MB_ICONEXCLAMATION) ;
					m_XFromWnd.SetFocus();
					return FALSE;
				}
			}
			pBind = pBind->NextNode;
		}
	}
	return TRUE;
}

void CDHCPAdt::OnOK()
{
	char szBuf[80];
	DWORD lvalue;

	// TODO: Add extra validation here
	UpdateData(TRUE);	//copy values From dialog

	//check for validity in fields
	if (!ValidEditFields())
		return;

	//we need the parent class pointer many times
	CDHCP	*pClPtr;
	pClPtr = (CDHCP *)GetParent();

	//now this range entry is valid, get an AddrRangeType node and fill up
	AddrRangeType *NewAddrRange;
	if ( !(NewAddrRange = pClPtr->GetAnAddrNode(pLstItm)))
	{
		DisplayErrMsg(9);
		return;
	}
	//write Address ranges
	//Write exclusion range
	//write address mask
	strcpy(NewAddrRange->LAddr, m_AdrFrom);
	strcpy(NewAddrRange->HAddr, m_AdrTo);
	strcpy(NewAddrRange->Mask, m_AdrMsk);

	//fill up the mask option into the options list
	strcpy(szBuf, m_AdrMsk);
	get_ip_address(szBuf, &lvalue);
	sprintf(szBuf, "%08lx",lvalue);
	if ((NewAddrRange->OLPtr[1].OptionList =
						(char *) malloc(IP_ADDR_LEN)) == 0)
	{
			strcpy(szBuf, "No memory for Mask Option");
			goto ErrorExit;
	}
	strcpy(NewAddrRange->OLPtr[1].OptionList, szBuf);
	NewAddrRange->OLPtr[1].OptionCount = 4;	//mask is 4 bytes
	NewAddrRange->OLPtr[1].OptionType = 1;		//IP Subnet mask type

	//

	if (!m_XFrom.IsEmpty())
	{
		XAddrType *Xtmp;
		//Allocate mem for x_struct
		Xtmp = (XAddrType *)calloc(1, sizeof(XAddrType));
		if (!Xtmp)
		{
			strcpy(szBuf, "No memory for exclusion!");
			goto ErrorExit;
		}
		strcpy(Xtmp->XLAddr, m_XFrom);
		strcpy(Xtmp->XHAddr, m_XTo);
		NewAddrRange->XAddrList = Xtmp;	//Attach this exclusion entry
	}

	//check for any range clash with existing list, avoid edit node if editing
	int retval;

	retval = pClPtr->CheckUnique(NewAddrRange, pLstItm);
	if(retval != NO_CLASHING_ENTRY)
	{
		sprintf(szBuf, "Range clash with entry number %d.", retval + 1);
ErrorExit:
		pClPtr->FreeARange(NewAddrRange);
		::MessageBox (GetSafeHwnd(), (LPCSTR) szBuf,
					(LPCSTR) "Address Range", MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}

#if 0
	//Fillup the address ranges and mask
	if (pLstItm)
	{
		//Since we are editing an existing range of managed addresses
		//we need to makesure that any existing bindings are not
		//getting spilt over
		BindingType *pTmpBind;
		DWORD ipaddr;

		pTmpBind = pLstItm->Binds;

		while(pTmpBind)
		{
			if ( !CheckIPAddressInRange(NewAddrRange, pTmpBind->IPAddr))
			{
				sprintf(szBuf, "A bound IP address going out of range!.\n\
Address is %s. Cannot accept new values", pTmpBind->IPAddr);
				goto ErrorExit;
			}
			pTmpBind = pTmpBind->NextNode;	//advance to next node
		}
	}
#endif

	//Add / substitute node
	pClPtr->AddOrReplaceRange(NewAddrRange, pLstItm);

	CDialog::OnOK();
}

void CDHCPAdt::OnHelp()
{
	// TODO: Add your control notification handler code here
	
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_DHCP_RANGE, HELP_CONTEXT) ;
}
