
// dnldupgr.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "dnldupgr.h"

extern BOOL DefaultSetup ; /* July 27 1998 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDnldUpGrade dialog


CDnldUpGrade::CDnldUpGrade(CWnd* pParent /*=NULL*/)
	: CDialog(CDnldUpGrade::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDnldUpGrade)
	m_DHCPAddrStr = "";
	m_DNSAddrStr = "";
	m_IPAddrStr = "";
	m_MaskStr = "";
	m_ModeTypeStr = "";
	m_PwordStr = "";
	m_RASAddrStr = "";
	m_UnameStr = "";
	m_WANEnable = FALSE;
	m_SpeedStr = "";
	m_ISP = FALSE;
	//m_StrDialNumber = "";
	m_DialNumberStr = "";
	//}}AFX_DATA_INIT
}

void CDnldUpGrade::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDnldUpGrade)
	DDX_Control(pDX, IDC_EDIT_UP_DIAL_NUMBER, m_DialNumberWnd);
	DDX_Control(pDX, IDC_STATIC_UP_USER_NAME, m_static_UserName);
	DDX_Control(pDX, IDC_STATIC_UP_SPEED, m_static_Speed);
	DDX_Control(pDX, IDC_EDIT_UP_SPEED, m_SpeedWnd);
	DDX_Control(pDX, IDC_CHECK_UP_ENABLE, m_WANEnableWnd);
	DDX_Control(pDX, IDC_STATIC_UP_WAN_GROUP, m_static_WAN_Group);
	DDX_Control(pDX, IDC_EDIT_UP_UNAME, m_UnameWnd);
	DDX_Control(pDX, IDC_STATIC_UP_SEL_PORT, m_static_SEL_PORT);
	DDX_Control(pDX, IDC_STATIC_UP_REMOTE_ADDR, m_static_RAS_Addr);
	DDX_Control(pDX, IDC_STATIC_UP_PWORD, m_static_Pword);
	DDX_Control(pDX, IDC_STATIC_UP_PORT_SETUP, m_static_Port_Setup);
	DDX_Control(pDX, IDC_STATIC_UP_PORT, m_static_Port);
	DDX_Control(pDX, IDC_STATIC_UP_NETMASK, m_static_NetMask);
	DDX_Control(pDX, IDC_STATIC_UP_MODEM_TYPE, m_static_ModemType);
	DDX_Control(pDX, IDC_STATIC_UP_IP_ADDR, m_static_IPAddr);
	DDX_Control(pDX, IDC_STATIC_UP_DNS_SERVER, m_static_DNS_Addr);
	DDX_Control(pDX, IDC_STATIC_UP_DIAL_NUMBER, m_static_Dial_Number);
	DDX_Control(pDX, IDC_STATIC_UP_DHCP_SERVER, m_static_DHCP_Addr);
	DDX_Control(pDX, IDC_STATIC_UP_DHCP_DNS_GROUP, m_static_DHCP_DNS_Group);
	DDX_Control(pDX, IDC_EDIT_UP_REMOTE_ADDR, m_RASAddrWnd);
	DDX_Control(pDX, IDC_EDIT_UP_PWORD, m_PwordWnd);
	DDX_Control(pDX, IDC_EDIT_UP_MODEM_TYPE, m_ModemTypeWnd);
	DDX_Control(pDX, IDC_EDIT_UP_MASK, m_MaskWnd);
	DDX_Control(pDX, IDC_LIST_UP_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_EDIT_UP_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_EDIT_UP_DNS_SERVER_ADDR, m_DNSAddrWnd);
	DDX_Control(pDX, IDC_EDIT_UP_DHCP_SERVER_ADDR, m_DHCPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_UP_IP_ADDR, m_ISPWnd);
	DDX_Control(pDX, IDC_CHECK_UP_REMOTE, m_RAS_enable);
	DDX_Check(pDX, IDC_CHECK_UP_IP_ADDR, m_ISPCheck);
	DDX_Text(pDX, IDC_EDIT_UP_DHCP_SERVER_ADDR, m_DHCPAddrStr);
	DDX_Text(pDX, IDC_EDIT_UP_DNS_SERVER_ADDR, m_DNSAddrStr);
	DDX_Text(pDX, IDC_EDIT_UP_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_UP_MASK, m_MaskStr);
	DDX_Text(pDX, IDC_EDIT_UP_MODEM_TYPE, m_ModemTypeStr);
	DDX_Text(pDX, IDC_EDIT_UP_PWORD, m_PwordStr);
	DDX_Text(pDX, IDC_EDIT_UP_REMOTE_ADDR, m_RASAddrStr);
	DDX_Text(pDX, IDC_EDIT_UP_UNAME, m_UnameStr);
	DDX_Check(pDX, IDC_CHECK_UP_ENABLE, m_WANEnable);
	DDX_Text(pDX, IDC_EDIT_UP_SPEED, m_SpeedStr);
	DDX_Text(pDX, IDC_EDIT_UP_DIAL_NUMBER, m_DialNumberStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDnldUpGrade, CDialog)
	//{{AFX_MSG_MAP(CDnldUpGrade)
	ON_LBN_SELCHANGE(IDC_LIST_UP_PORTS, OnSelchangeListUpPorts)
	ON_BN_CLICKED(IDC_UP_OK, OnUpOk)
	ON_BN_CLICKED(IDC_UP_CANCEL, OnUpCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDnldUpGrade message handlers


void CdnldUpgrade::Common(int index)
{


        char	szRHS[40];
	char	szLHS[40];
	CDotDecimal DotValue;

        m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",4,
				(LPCSTR) IniInWinForm);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	// If MLPPP is enabled no ras is possible for now
	m_MLPPP = FALSE;
	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
			StrNull, szRHS, sizeof(szRHS), IniInWinForm))
		m_MLPPP = TRUE;

       	wsprintf (szLHS, "IP Port%d Address", index);
  	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHS, ZeroIPAddress, (LPSTR) szRHS,
		sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	DotValue = 	m_IPAddrStr = szRHS;
	if ( ! DotValue.IsValid())
		m_IPAddrStr = ZeroIPAddress;
	//If IP address == 0.0.0.0 then it is ISP assigned
       	m_ISPCheck = FALSE;
       	if (index > 0)		//not for LAN port
       		if ( ! strcmp((LPCSTR)m_IPAddrStr, ZeroIPAddress))
       			m_ISPCheck = TRUE;
       	//Get subnet mask for the port
        wsprintf (szLHS, "IP Port%d Address Mask", index);
	GetPrivateProfileString(IPSectionHeader, (LPCSTR) szLHS,
 			ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   			(LPCSTR) IniInWinForm);
        m_MaskStr = szRHS;
	if ( ! verify_ip_subnet_mask((LPCSTR)m_MaskStr))
		m_MaskStr = ZeroIPAddress;
        //// RAS support
	m_RAS_enable = 0;
	if ((index > 0) && !m_MLPPP)
	{
		wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index-1);
	  	GetPrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) szLHS, StrDisabled, (LPSTR) szRHS,
			sizeof (szRHS), (LPCSTR) IniInWinForm) ;
		if (!strcmp (szRHS, StrEnabled))
			m_RAS_enable = 1;
	}

	wsprintf(szLHS, "IP Port%d Remote Address", index);
	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHS, StrNull, (LPSTR) szRHS,
		sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	m_RASAddrStr = szRHS;
	
        //// Strings for DNS
	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP DNS Server Address1", (LPCSTR) StrNull, 
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
	m_DNSAddrStr = szRHS;


        //  DHCP  Support

        GetPrivateProfileString ((LPCSTR) DHCPSectionHeader, 
			(LPCSTR) "DHCP Server IP Address", (LPCSTR) StrNull, 
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
	m_DHCPAddrStr = szRHS;
	
       	if (index == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(FALSE);
		m_RAS_enable.EnableWindow (FALSE);
		m_RASAddrWnd.EnableWindow (FALSE);
		m_static_RAS_Addr.EnableWindow (FALSE);

                // Disable WAN Properties
                m_static_WAN_Group.EnableWindow (FALSE);     //WAN Properties Group Box
                m_WANEnableWnd.EnableWindow (FALSE);         //WAN Enable Check Box
                m_static_Dial_Number.EnableWindow (FALSE);   //Static "Dial Number" - TEXT
                m_DialNumberWnd.EnableWindow (FALSE);        //Edit "Dial Number" - CONTROL
                m_ static_Speed.EnableWindow (FALSE);        //Static "Speed" - TEXT
                m_SpeedWnd.EnableWindow (FALSE);             //Edit "Speed" - CONTROL
                m_static_ModemType.EnableWindow (FALSE);     //Static "Modem Type" - TEXT
                m_ModemTypeWnd.EnableWindow (FALSE);         //Edit "Modem Type" - CONTROL
                m_static_UserName.EnableWindow (FALSE);      //Static "User Name" - TEXT
                m_UnameWnd.EnableWindow (FALSE);             //Edit "Uname" - CONTROL
                m_static_Pword.EnableWindow (FALSE);         //Static "Pword" - TEXT
                m_PwordWnd.EnableWindow (FALSE);             //Edit "Pword" - CONTROL

		//Change the group heading to that of the selected port
		m_static_SEL_PORT.SetWindowText("LAN");
	}
	else
        {    
                // Enable WAN Properties
                m_static_WAN_Group.EnableWindow (TRUE);     //WAN Properties Group Box
                m_WANEnableWnd.EnableWindow (TRUE);         //WAN Enable Check Box
                m_static_Dial_Number.EnableWindow (TRUE);   //Static "Dial Number" - TEXT
                m_DialNumberWnd.EnableWindow (TRUE);        //Edit "Dial Number" - CONTROL
                m_ static_Speed.EnableWindow (TRUE);        //Static "Speed" - TEXT
                m_SpeedWnd.EnableWindow (TRUE);             //Edit "Speed" - CONTROL
                m_static_ModemType.EnableWindow (TRUE);     //Static "Modem Type" - TEXT
                m_ModemTypeWnd.EnableWindow (TRUE);         //Edit "Modem Type" - CONTROL
                m_static_UserName.EnableWindow (TRUE);      //Static "User Name" - TEXT
                m_UnameWnd.EnableWindow (TRUE);             //Edit "Uname" - CONTROL
                m_static_Pword.EnableWindow (TRUE);         //Static "Pword" - TEXT
                m_PwordWnd.EnableWindow (TRUE);             //Edit "Pword" - CONTROL

                wsprintf (szLHS, "WAN Port%d Dial Number", index-1);
                GetPrivateProfileString((LPCSTR) WANSectionHeader, (LPCSTR) szLHS,
                        StrNull, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
                m_DialNumberStr = szRHS;

                wsprintf (szLHS, "WAN Port%d Speed", index-1);
                GetPrivateProfileString((LPCSTR) WANSectionHeader, (LPCSTR) szLHS,
                        StrNull, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
                m_SpeedStr = szRHS;

                wsprintf (szLHS, "WAN Port%d Modem Type", index-1);
                GetPrivateProfileString((LPCSTR) WANSectionHeader, (LPCSTR) szLHS,
                        StrNull, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
                m_ModemTypeStr = szRHS;

                wsprintf (szLHS, "PPP Port%d User Name", index-1);
                GetPrivateProfileString((LPCSTR) PPPSectionHeader, (LPCSTR) szLHS,
                        StrNull, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);
                m_UnameStr = szRHS;        

                char pass[80];
                wsprintf (szLHS, "PPP Port%d User Password", index-1);
                GetPrivateProfileString((LPCSTR) PPPSectionHeader, (LPCSTR) szLHS,
                        StrNull, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm);

                Decrypt(szRHS, pass);
                m_PwordStr = pass;
                
	        if (index == 1)
	        {
		        m_RAS_enable.EnableWindow (FALSE);
		        m_RASAddrWnd.EnableWindow (FALSE);
		        m_static_RAS_Addr.EnableWindow (FALSE);
		        m_ISPWnd.EnableWindow(TRUE);
		        if (m_nPorts <= 2)
			        m_static_SEL_PORT.SetWindowText("WAN");
		        else
			        m_static_SEL_PORT.SetWindowText("WAN 1");
	        }
                else
	        {
		        //If the selected port is NOT LAN enable ISP_Assigned_Address
		        m_ISPWnd.EnableWindow(TRUE);
		        //Change the group heading to that of the selected port
		        if (m_MLPPP)
			        m_RAS_enable.EnableWindow (FALSE);
		        else
			        m_RAS_enable.EnableWindow (TRUE);

		        if (m_RAS_enable)
		        {
			        m_RASAddrWnd.EnableWindow (TRUE);
			        m_static_RAS_Addr.EnableWindow (TRUE);
		        }
		        else
                        {
		                m_RASAddrWnd.EnableWindow (FALSE);
			        m_static_RAS_Addr.EnableWindow (FALSE);
		        }
		        if (m_nPorts <= 2)
		        {
			        m_static_SEL_PORT.SetWindowText("WAN");
		        }
		        else
		        {
			        char Buf[10];

			        sprintf(Buf, "WAN %d", index);
			        m_static_SEL_PORT.SetWindowText(Buf);
		        }
	        }
        }
	m_static_IPAddr.EnableWindow(!m_ISPCheck);
	m_IPAddrWnd.EnableWindow(!m_ISPCheck);
	m_static_NetMask.EnableWindow(!m_ISPCheck);
	m_MaskWnd.EnableWindow(!m_ISPCheck);

}








BOOL CDnldUpGrade::OnInitDialog()
{
	CDialog::OnInitDialog();
////////////////////////////////////////////////////////////////////////////
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////
       	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();


	// TODO: Add extra initialization here
	


       	// Read the configuration file and init the variables
 	int	index;
 	

 /*    	m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",4,
				(LPCSTR) IniInWinForm);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	// If MLPPP is enabled no ras is possible for now
	m_MLPPP = FALSE;
	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
			StrNull, szRHS, sizeof(szRHS), IniInWinForm))
		m_MLPPP = TRUE;  */



        //Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < m_nPorts-1; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

        Common(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
/*	m_ISPWnd.EnableWindow(FALSE);
	m_static_SEL_PORT.SetWindowText("LAN");
	m_RAS_enable.EnableWindow (FALSE);
	m_RASAddrWnd.EnableWindow (FALSE);
	m_static_RAS_Addr.EnableWindow (FALSE); */
	if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT))
	{
		m_static_DHCP_Addr.EnableWindow (FALSE);
	      //	m_check_client.EnableWindow(FALSE);
		m_static_DNS_address.EnableWindow (FALSE);
		m_DNSAddrWnd.EnableWindow (FALSE);
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CDnldUpGrade::OnSelchangeListUpPorts()
{
        int PortIndex;
        UpdateData(TRUE); 

	// TODO: Add your control notification handler code here


        PortIndex = m_PortListWnd.GetCurSel();
       	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

       	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MaskStr;
        m_RAS[m_OldPort] = m_RAS_enable;
	m_RemoteAddr[m_nOldPort] = m_RASAddrStr;

        Common(PortIndex);

	UpdataData(FALSE);
        m_nOldPort = PortIndex;
}

void CDnldUpGrade::OnUpCancel()
{
	// TODO: Add your control notification handler code here
	
}

void CDnldUpGrade::OnUpOk()
{
	// TODO: Add your control notification handler code here
	
}
