/****************************************************************************
	file		:	hardware.h
	purpose	:	includes the define values for hardware types
					will be used by "setaddr" utility and configuration UI
					and configuration manager to identify the hardware.
					The hardware model information is stored in the bootconfig
					Setaddr sets this info during production process
*****************************************************************************/
/* a byte bootconfig to denote the hardware model */
#define	MODEL_UNKNOWN			0	/* unknown hardware type */
#define	MODEL_MTSR3				1	/* one LAN, 3 RS232/V.35 WAN ports */
#define	MODEL_MTSR1_100		2	/* one LAN, 1 RS232/V.35 WAN port */
#define	MODEL_MTSR1_200		3	/* one LAN, one 33.6K modem port */
#define	MODEL_MTSR3_200		4	/* one LAN, three modems port */
#define	MODEL_MTSR1_202ST		5	/* one LAN, one ISDN ST port */
#define	MODEL_MTSR1_202NT		6	/* one LAN, one ISDN NT port */
#define	MODEL_MTSR2_201		7	/* one LAN, one DSU and one RS232/V.35 WAN ports */
#define	MODEL_MTSR1_120		8	/* 2 LAN and one RS232/V.35 WAN ports */


#if 0
/* WARNING :
DO NOT INSERT ANY MEMBERS OR CHANGE THEIR SIZES. IF ADDITION IS REQUIRED
YOU MAY DO SO AT THE END OF THE STRUCTURE ONLY.
EVEN ROM MONITOR DEPENDS ON THE SIZES OF THE ELEMENTS DURING WARM BOOT
*/
typedef	struct {
	byte	Version[10];		/* version number of this record ASCIIZ */
	word	EthernetAddr_H;	/* Ethernet address of bridge */
	dword	EthernetAddr_L;	/* Ethernet address of bridge */
	byte	PassWord[20];		/* password for Boot config */
	byte	NumberOfPorts;
	byte	Base1;
	byte	Size1;
	byte	Base2;
	byte	Size2;

	byte	ClockSpeed;			/* added on 16/12/97 */
	byte	PROMWidth;
	byte	ModelNumber;

	byte Reserved[8] ;       /* for future use */   
	dword MagicNumber;		/* 0xA55AA55A to indicate valid config */
	dword	FlashPromSize;		/* System related information */
	dword	RamSize;
	dword	RamStart;
}BootConfigType;
#endif

extern char *ModelNameNumberTable[];
extern	int	NumberOfModels;

