#include	<windows.h>
#include	"install.h"
#include	"animate.h"

int		TimerCt;
BOOL	NameDispl;

/*----------------------- Animation functions ------------------------------*/

/*----------------------------------------------------------------------------
	Function 	: 	LogoTimer()
	Synopsis 	: 	Updates the Logo every three seconds.
----------------------------------------------------------------------------*/
WORD FAR PASCAL LogoTimer (HWND hWnd, WORD wMsg, int nIDEvent, DWORD dwTime)
{
	TimerCt ++ ;

	// Don't display the logo for 2 seconds, display the logo for 8 secs
	if (NameDispl || (TimerCt == 5))
	{
		TimerCt = 0 ;
		Animate (FALSE) ;
	}

	return TRUE ;
}

/*----------------------------------------------------------------------------
	Function	:	Animate (BOOL)
	Synopsis	:	Draws the logo and the name in the install dialog.
	Input		:	If flag is TRUE the name and logo are displayed else
					only the logo is displayed or hidden.
	Output 		:	TRUE.
----------------------------------------------------------------------------*/
int Animate (BOOL Flag)
{
	static int right ; 
	BITMAP bmp ;
	HWND hWndCtl ;
	HBRUSH hOBr ;
	HPEN hOPen ;
  	HDC hDc, hMemDc ;
	RECT Rect ;
	HBITMAP hOldBmp ;
	HBRUSH hBkBrush ;
	HPEN hBkPen ;
//	HBITMAP hBmpName1 ;
//	HRGN hRegion ;
	COLORREF PixColorGet, PixColorSet ;
	COLORREF LtGray ;
//	static COLORREF OldPixel ;
	int x, y ;
	static BOOL fDoneName = FALSE ;
	static BOOL fDoneLogo = FALSE ;

	if (hInstallDlg == NULL)
		return TRUE ;
	hWndCtl = GetDlgItem (hInstallDlg, 2000) ;
	GetClientRect (hWndCtl, (LPRECT) &Rect) ;
	hDc = GetDC (hWndCtl) ;

	LtGray = RGB (192, 192, 192) ;
//	if (!fDoneName || !fDoneLogo)
//		OldPixel = LtGray ;
	PixColorSet = GetSysColor (COLOR_BTNFACE) ;
  	hMemDc = CreateCompatibleDC (hDc) ;


//	right = Rect.right - 150;

	if (Flag)
	{
		hBkBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
		hOBr = SelectObject (hDc, (HGDIOBJ) hBkBrush) ;
//		hOBr = SelectObject (hDc, GetStockObject (LTGRAY_BRUSH)) ;
//		hOPen = SelectObject (hDc, GetStockObject (NULL_PEN)) ;
		hBkPen = CreatePen (PS_SOLID, 0, GetSysColor (COLOR_BTNFACE)) ;
		hOPen = SelectObject (hDc, (HGDIOBJ) hBkPen) ;
		Rectangle (hDc, 0, 0, Rect.right + 1, Rect.bottom + 1) ;
//		FloodFill (hDc, 15, 15, GetSysColor (COLOR_BTNFACE)) ;
//		FillRect (hDc, &Rect, hBkBrush) ;
		SelectObject (hDc, hOPen) ;
		SelectObject (hDc, hOBr) ;
		DeleteObject ((HGDIOBJ) hBkPen) ;
		DeleteObject ((HGDIOBJ) hBkBrush) ;

  		hOldBmp = SelectObject (hMemDc, hBmpName) ;
		GetObject (hBmpName, sizeof (BITMAP), (LPSTR) &bmp) ;
//		hRegion = CreateRectRgn (Rect.left, Rect.top,
//										Rect.right, Rect.bottom) ;
//		CombineRgn (hRegion, hBmpName, hBmpName1, RGN_AND) ;
//		SelectObject (hDc, hRegion) ;
//		PaintRgn (hDc, hRegion) ;
		if (! fDoneName) // || (OldPixel != PixColorSet))
		{
			fDoneName = TRUE ;
			for (y = 0 ; y < bmp.bmHeight ; y ++)
				for (x = 0 ; x < bmp.bmWidth ; x ++)
					if ((PixColorGet = GetPixel (hMemDc, x, y)) == LtGray) // OldPixel)
						SetPixel (hMemDc, x, y, PixColorSet) ;
//			OldPixel = PixColorSet ;
		}
	  	BitBlt (hDc, 0, 0, bmp.bmWidth, bmp.bmHeight,
											hMemDc, 0, 0, SRCCOPY) ;
//	  	BitBlt (hDc, 0, 0, bmp.bmWidth, bmp.bmHeight,
// 											hMemDc, 0, 0, SRCPAINT) ;
//		DeleteObject (hRegion) ;
		right = bmp.bmWidth ; 
		SelectObject (hMemDc, hOldBmp) ;
	}

	if (NameDispl) 
	{
  		hOldBmp = SelectObject (hMemDc, hBmpLogo) ;
		GetObject (hBmpLogo, sizeof (BITMAP), (LPSTR) &bmp) ;
//		if (!fDoneLogo)
//			OldPixel = LtGray ;
		if (! fDoneLogo) // || (OldPixel != PixColorSet))
		{
			fDoneLogo = TRUE ;
			for (y = 0 ; y < bmp.bmHeight ; y ++)
				for (x = 0 ; x < bmp.bmWidth ; x ++)
					if ((PixColorGet = GetPixel (hMemDc, x, y)) == LtGray) //OldPixel)
						SetPixel (hMemDc, x, y, PixColorSet) ;
//			OldPixel = PixColorSet ;
		}
		AnimateCircles (hDc, right + 5, 0, Rect.right - right - 5,
													Rect.bottom - 5) ;

//		hBmp = LoadBitmap (hInst, "LOGO") ; 9-2-96

  		BitBlt (hDc, right + 5, 0, bmp.bmWidth, bmp.bmHeight,
													hMemDc, 0, 0, SRCCOPY) ;
	  	SelectObject (hMemDc, hOldBmp) ;
//  		DeleteObject (hBmp) ; 9-2-96
	}
	else 
	{
		hBkBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
		hOBr = SelectObject (hDc, (HGDIOBJ) hBkBrush) ;
//		hOBr = SelectObject (hDc, GetStockObject (LTGRAY_BRUSH)) ;
//		hOPen = SelectObject (hDc, GetStockObject (NULL_PEN)) ;
		hBkPen = CreatePen (PS_SOLID, 0, GetSysColor (COLOR_BTNFACE)) ;
		hOPen = SelectObject (hDc, (HGDIOBJ) hBkPen) ;
		Rectangle (hDc, right + 5, 0, Rect.right, Rect.bottom) ;
		SelectObject (hDc, hOPen) ;
		SelectObject (hDc, hOBr) ;
		DeleteObject ((HGDIOBJ) hBkPen) ;
		DeleteObject ((HGDIOBJ) hBkBrush) ;
	}

	NameDispl = !NameDispl ;
	DeleteDC (hMemDc) ;
	ReleaseDC (hWndCtl, hDc) ;
	return TRUE ;
}

/*----------------------------------------------------------------------------
	Function	:	AnimateCircles ()
	Synopsis	:	Draws a series of circles before displaying
					the MultiTech logo.
	Input		:	hDC and coordinates of the logo area.
	Output 		:	None.
----------------------------------------------------------------------------*/
void AnimateCircles (HDC hDC, int x, int y, int right, int bottom)
{
	int i, j ;
	HBRUSH hOBr ;

	hOBr = SelectObject (hDC, hBlueBr) ;

	for (j = 1 ; j < 25 ; j += 1)
	{
		Ellipse (hDC, x + j, j, x + (j * 2), j * 2) ;
		for (i = 0 ; i < 15000 ; i ++)
			i *= 1 ;
	}

	SelectObject (hDC, hOBr) ;
}
