/* ------------------------------------------------------------------------
	File		:	DLGBOX.H
	Synopsis	:	Modifies the dialog control colors and draws borders
					for Listbox, Edit controls and group box.
					This file has to be included by all applications
					using the DLG module.
	Author		:	Srinivasan S
	Date		:	20 Apr 1993
 ----------------------------------------------------------------------- */

/* Files need include only dlgbox.h */
#include <commdlg.h>

/* Bitmap ids to be used in the RC file */
/* Include dlg.h along with other files in the RC file */

#define	IDR_CHECK_UP		100
#define	IDR_CHECK_DOWN		101
#define	IDR_CHECK_GRAY		102
#define	IDR_RADIO_DOWN		103
#define	IDR_RADIO_UP		104
#define	IDR_RADIO_GRAY		105

/* Groupboxes will be modified only if the ids are greater then or equal */
/* to this base number */

#define	GROUPBOX_ID_BASE	4000

/* Ids of owner draw check boxes should be in the range 3000 to 3100    */
#define	CHECK_BEGIN		3000
#define	CHECK_END		3100

/* Ids of owner draw radio buttons should be in the range 3200 to 3300  */
#define	RADIO_BEGIN		3200
#define	RADIO_END		3300

/* Functions available in the DLG module */
BOOL 	FAR PASCAL DLGInit(void);				// changed //
void	FAR PASCAL DLGClose(void);
void 	FAR PASCAL DLGCenterDialog(HWND hDlg);
HBRUSH	FAR PASCAL DLGModifyColors(WPARAM wParam, LPARAM lParam);

/* Commdlg dialogs */
BOOL 	FAR PASCAL DLGShowFileOpenDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowSaveAsDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowPrintDlgBox(LPPRINTDLG lpPd);
BOOL 	FAR PASCAL DLGShowFontDlgBox(LPCHOOSEFONT lpCf);

/* Owner draw radio buttons and check boxes */
void 	FAR PASCAL DLGInitDialog(HWND hDlg, LPSTR lpControlBuf);	// changed //
BOOL	FAR PASCAL DLGEndDialog(HWND hDlg);
void 	FAR PASCAL DLGCheckDlgButton(HWND hDlg, WORD CntlId, UINT uChecked);
int 	FAR PASCAL DLGIsDlgButtonChecked(HWND hDlg, WORD CntlId);
void 	FAR PASCAL DLGCheckRadioButton(HWND hDlg, WORD StartId,
										WORD EndId, WORD CheckId);
void 	FAR PASCAL DLGEnableRadioButton(HWND hDlg, WORD CtlID, BOOL State);
void 	FAR PASCAL DLGDrawItemControl(HWND hDlg, WORD idCtl,
										LPDRAWITEMSTRUCT lpInfo);

/* Call back function to be exported */
UINT	CALLBACK DLGCtlColorFunc(HWND, UINT, WPARAM, LPARAM);

/* ************************ FUNCTION SYNOPSIS **************************** */
/*
	1.	DLGInit()				-	Initialises the Dlg module and creates
									the pen and brush of the required colors.

	2.	DLGClose()				-	Frees up the local resources.  Should be
									called before PostQuitMessage().

	3.	DLGShowFileOpenDlgBox()	-	Displays the FileOpen common dialog box
									after installing a HOOK function to
									modify the colors.
	4.	DLGShowSaveAsDlgBox()	-	Displays the Save as common dialog box
									after installing a HOOK function to
									modify the colors.
	5.	DLGShowPrintDlgBox()	-	Displays the printer common dialog box
									after installing a HOOK function to
									modify the colors.

	6.	DLGShowFontDlgBox()		-	Displays the Font common dialog box
									after installing a HOOK function to
									modify the colors.

	7.	DLGModifyColors()		-	Modifies the colors of a dialog box.
									Should be called in response to a
									WM_CTLCOLOR message.

	8.	DLGInitDialog()			-	To be called in response to WM_INITDIALOG
									message if the dialog box has owner
									draw radio buttons or check boxes.

	9.	DLGEndDialog()			-	To be called before EndDialog() is made
									if DLGInitDialog() call was made to use
									owner draw radio buttons or check boxes.

	10.	DLGCheckDlgButton()		-	Function to replace CheckDlgButton()
									for owner draw radio button or check box.

	11.	DLGIsDlgButtonChecked()	-	Function to replace IsDlgButtonChecked()
									for owner draw radio button or check box.

	12.	DLGCheckRadioButton()	-	Function to replace CheckRadioButton()
									for owner draw radio button or check box.

	13.	DLGEnableRadioButton()	-	Function to disable or enable a owner
									drawn radio button.  Should be used
									instead of EnableWindow() call.

	14.	DLGDrawItemControl()	-	Function to be called in response to
									WM_DRAWITEM message for drawing owner
									draw radio buttons and check boxes.

	15.	DLGCtlColorFunc()		-	The callback HOOK function.

*/

