/****************************************************************************
 * Filename   : install.c
 * Purpose    : This file installs the ROUCON software in the directory selected.
 ****************************************************************************/

#include	"sys\types.h"
#include	"sys\stat.h"
#include	"windows.h"
#include	"direct.h"
#include	"errno.h"
#include	"dde.h"
#include "lzexpand.h"

#include	"install.h"
#include	"display.h"
#include	"ddehdlr.h"
#include	"utils.h"
#include	"dlgbox.h"
#include	"ourdlgbx.h"
#include	"mirtns.h"
#include	"ctl3d.h"
#include	"defsetup.h"
#include "init.h"								// 9-2-96
#include "diskdlg.h"							// 9-2-96

#include "string.h"
#include "stdio.h"

#define MAX_PATH_LEN		150				// 9-2-96

HWND	hgWnd;			/* main window handle */
HWND	hgWndPM;		/* program manager window handle */
HANDLE	hInst;			/* main window instance handle */
HINSTANCE	hCtl3dInst;
HCURSOR	hCurCursor;		/* current cursor */
HCURSOR	hSaveCursor;	/* saved cursor */
HCURSOR	hStandard;		/* standard arrow cursor */
HCURSOR	hHourGlass;		/* hour glass cursor */

HWND	hProgCtl;
HWND	hProgTtlCtl;
HBRUSH hBlueBr, hRedBr ;		/* Brush handles */

FileNameListType	*InstallFiles;
int NumFiles = 0 ;
int Messagetosend ;
HANDLE hMainInsWnd ;
BYTE PortToUse = 0 ;
BYTE *PortNames[] =  {
	"COM1",
	"COM2",
	"COM3",
	"COM4",
};

BYTE	RouconDir[67] ;

BOOL	AbortInstall = FALSE;

BYTE	SourceDir[128] = { "A:\\" };			/* source directory for files */
BYTE	DestDir[128] ; /* = "C:\\MTROUTER";		 destination dir to store files */
char	*FileName = "PROGMAN.INI";		/* groups stored here by progman */
char	*GroupsName = "Groups";			/* groups application name */
char	*MRGroupName = "MTR.GRP";	/* MTR group value */
char	*SystemIniFile = "SETUP.INI";	/* system parameters stored here */
char	*RouconParamsSec = "MTRouter Console";

char	SysFilesDir[67];		/* system files dir (all .TRM files ) */
char	WindowsDir[67];

#define	LOGO_TIME	4
WORD	LogoTime = 0;		/* logo is displayed for 4 secs */
int CreateState = 0;	/* state variable for creating groups */
WORD	NextState = 0;	/* state variable for creating groups */
RECT	MainWndRect;

BOOL	InDisplayLogo = FALSE;
BOOL	InInstallFiles = FALSE;
int	CurInstallState = START_XFER;
DWORD	FileSize, BytesDone, TotalSize, CumSize;

int		Width, Height;
int		TtlWidth, TtlHeight;

SECTIONSTRUCT SectionStringStruct ; 
FILESTRUCT FilesStruct[MAX_NO_OF_FILES] ;	
ICONSTRUCT IconsStruct[NO_OF_ICONS] ; 
ICONSTRUCT OldIconsStruct[NO_OF_ICONS] ; 
DWORD TotalSize = 0 ;	
PRODUCTSTRUCT ProductStringStruct ;

int TimerCreated = 0 ; 
BYTE DiskNoBuf[5] ;

HBITMAP hBmpLogo ;  
HBITMAP hBmpName ;
HBITMAP hBmpRoucon ;
HBITMAP hBmpAddr ;

HICON hDiskIcon ; 

char InstallTitle[100] ;
int CurFileIndex ;


BYTE GlobalGrpPathName[50] ;
BYTE GlobalGrpName[50] ;

/****************************************************************************/
/*++++++++++++++++++ System Parameters Stored in SETUP.INI file ++++++++++++++*/
/****************************************************************************/

#define	MAX_SYSTEM_DEFAULTS	(sizeof(SystemParams) / sizeof (char *))

char	*SystemParams[] = {
/* Version number */
	"Version",					/* 0 */

/* The following are related to system looks */
	"ConsoleWindow",		 	/* 1 */
	"TopStatusWindow",	 	/* 2 */
	"BottomStatusWindow",	/* 3 */
	"ToolBarWindow",			/* 4 */
	"TerminalFont",			/* 5 */
	"ColorSetup",				/* 6 */

/* The following are system defaults */
	"ScrollBufSize",	 		/* 7 */
};

/****************************************************************************
 * FUNCTION	: GetROUCONPathName
 * PURPOSE	: Get the ROUCON exe pathname.
 				  The module name is a misnomer because the path is
	 			  actually that of the install.exe file
 ***************************************************************************/
void GetROUCONPathName (LPSTR szFileName)
{
	LPSTR	pcFileName ;
	int nFileNameLen ;

	nFileNameLen = GetModuleFileName (hInst, szFileName, 127) ;
	pcFileName = szFileName + nFileNameLen ;

	while (pcFileName > szFileName)
	{
		if (*pcFileName == '\\' || *pcFileName == ':') 
		{
			*(++pcFileName) = '\0';
			break;
		}
		nFileNameLen -- ;
		pcFileName -- ;
	}
	return ;
}

/****************************************************************************
 * Function   : WinMain(HANDLE, HANDLE, LPSTR, int)
 * Synopsis   : Creates the main app. window, calls an initialization
 *		 		function and enters the message loop.
 ****************************************************************************/

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
											LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg ;
	int j ;
	FARPROC ProcedureAddress ;
	char szBufFilename[MAX_PATH_LEN] ;		
	char szGroupName[GRP_PATH_LEN] ;

   /* Register main window class if this is the first instance of the app. */
	if (!hPrevInstance)
		if (!InstallInit (hInstance))
	   	return NULL ;

	hInst = hInstance ;

	/* get the exe directory from and set sourcedir to same path */ 
	GetROUCONPathName ((LPSTR) SourceDir) ;

	/*	get the full path of the exe file for install */
	/* can use the same thing as above and use strcpy */
	/* to copy SourceDir to szBufFilename  */
	/* and strcat szBufFilename with "\\INSTALL.ini" */
	GetModuleFileName (hInstance, (LPSTR) szBufFilename,
			  									sizeof (szBufFilename)) ;
	/* Modify for INSTALL.INI's path */
	FindInstIniPath ((LPSTR) szBufFilename) ;

	/* Get the Product name */
	GetProductName (&ProductStringStruct) ;

	lstrcpy (InstallTitle, ProductStringStruct.ProductName) ;
	lstrcat (InstallTitle, (LPCSTR) " Installation") ;

	hDiskIcon = LoadIcon (hInst, (LPCSTR) "DiskIcon") ;

	CreateFilesList() ;

	// before doing anything we need to check the presence of ctl3dv2
	// in system directory and copy it if not present
	if (! CheckAndCopyCtl3dv2())
	{
		DestroyIcon (hDiskIcon) ;
		return 0 ;
	}

	if (!GetInstallGroupName ((LPSTR) szGroupName))
		lstrcpy (szGroupName, ProductStringStruct.ProductName) ;

	lstrcpy (GlobalGrpPathName, szGroupName) ;
	lstrcpy (GlobalGrpName, ProductStringStruct.ProductName) ;

	hBmpName = LoadBitmap (hInst, "NAME") ;
	hBmpLogo = LoadBitmap (hInst, "LOGO") ;  
  	hBmpRoucon = LoadBitmap (hInst, "ROUCONBMP") ;
  	hBmpAddr = LoadBitmap (hInst, "ADDR") ;

	hStandard = LoadCursor (NULL, IDC_ARROW) ;
	hHourGlass = LoadCursor (NULL, IDC_WAIT) ;

	/* create the app. window */
   hgWnd = CreateWindow (
		   		"install",
		   		InstallTitle,
		   		WS_POPUP | WS_CLIPCHILDREN,
		   		CW_USEDEFAULT,
		   		CW_USEDEFAULT,
		   		CW_USEDEFAULT,
		   		CW_USEDEFAULT,
		   		(HWND) NULL,
		   		NULL,
		   		hInstance,
		   		(LPSTR) NULL
		   ) ;

   if (!hgWnd)
		return NULL ;

	/* process the command line */
	if (lpCmdLine[0])
	{
		ProcessCommandLine (lpCmdLine) ;
		if (AbortInstall)
		{
			UnInstall() ;
			Messagetosend = WM_COMPLETE ;
			DestroyWindow (hgWnd) ;
		}
	}
	hCtl3dInst = LoadLibrary (DialogLib) ;
	if (hCtl3dInst < HINSTANCE_ERROR)
		DestroyWindow (hgWnd) ;

	ShowWindow (hgWnd, SW_SHOWMAXIMIZED) ;
    UpdateWindow (hgWnd) ;
	GetClientRect (hgWnd, (LPRECT) &MainWndRect) ;

	hCurCursor = hStandard;
	SetCursor (hStandard);

	DisplayROUCONLogo ();
	InDisplayLogo = TRUE;


	/* Get the Windows directory*/
	j = GetWindowsDirectory ((LPSTR)WindowsDir, 149);
	if (WindowsDir[j - 1] != '\\')
		strcat (WindowsDir, "\\");

	// Create a solid blue brush
	hBlueBr = CreateSolidBrush (RGB (0, 0, 0xFF));
	// Create a solid red brush
	hRedBr = CreateSolidBrush (RGB (0xFF, 0, 0));

	ProcedureAddress = GetProcAddress (hCtl3dInst, "Ctl3dRegister");
	if (ProcedureAddress)
	{
		(*ProcedureAddress)() ;
		ProcedureAddress = GetProcAddress (hCtl3dInst, "Ctl3dAutoSubclass") ;
		if (ProcedureAddress)
			(*ProcedureAddress)() ;
	}

	SetTimer (hgWnd, TIMER_ID, (WORD) PERIOD, NULL) ;

	while (GetMessage (&msg, NULL, NULL, NULL))
	{
		TranslateMessage (&msg) ;
     	DispatchMessage (&msg) ; 
  	}
   return (msg.wParam) ;
}

/****************************************************************************
 * Function   : InstallInit (hInstance)
 * Synopsis   : Registers the main window class.
 * returns    : TRUE	-  if RegisterClass() went off ok
 *	     	 		 FALSE	-  otherwise.
 ****************************************************************************/
BOOL NEAR PASCAL InstallInit (HANDLE hInstance)
{
   WNDCLASS WndClass ;
   LPWNDCLASS pWndClass ;
   BOOL bSuccess ;

   /* Initialize the menu window class */
   pWndClass = (LPWNDCLASS) &WndClass ;

	/* register the parent window class */
   pWndClass->style	= NULL ;
   pWndClass->cbClsExtra = 0 ;
   pWndClass->cbWndExtra = 0 ;
   pWndClass->lpfnWndProc = InstallWndProc ;
   pWndClass->hInstance = hInstance ;
   pWndClass->hIcon = LoadIcon (hInstance, "install") ;
   pWndClass->hCursor = NULL ;
   pWndClass->hbrBackground = GetStockObject (LTGRAY_BRUSH) ;
   pWndClass->lpszMenuName = NULL ;
   pWndClass->lpszClassName = (LPSTR) "install" ;

   bSuccess = RegisterClass (pWndClass) ; 

   return bSuccess ;
}

/****************************************************************************
 * Function   : InstallWndProc (hWnd, message, wParam, lParam)
 * Purpose    : Window function for the main app. window. Processes all the
 *		 		menu selections and other messages.
 ****************************************************************************/
LONG FAR PASCAL InstallWndProc (HWND hWnd, unsigned message,
		   									WORD wParam, LONG lParam)
{
    HDC hDc ;
    PAINTSTRUCT ps ;
    FARPROC	ProcedureAddress ;

    switch (message)
    {
		case WM_LBUTTONUP :
		case WM_CHAR :
			if (InDisplayLogo)
				goto StartInstall ;
	    	return (DefWindowProc (hWnd, message, wParam, lParam)) ;

		case WM_SIZE :
			GetClientRect (hWnd, (LPRECT) &MainWndRect) ;
			break ;

		case WM_TIMER :
			if (wParam == TIMER_ID)
			{
				LogoTime ++ ;
				if (LogoTime == LOGO_TIME)
				{
					StartInstall :
						KillTimer (hWnd, TIMER_ID) ;
						InitiateInstall () ;
				}
			}
			else
			    if (wParam == DDE_TIMER_ID)
				{
					KillTimer (hWnd, DDE_TIMER_ID) ;
	    			ClientAcknowledge (hWnd, (HWND) wParam, lParam, TRUE) ;
				}
	    	break ;

		case WM_DDE_ACK :
	    	ClientAcknowledge (hWnd, (HWND) wParam, lParam, FALSE) ;
		    break ;

		case WM_MOUSEMOVE:
			SetCursor (hCurCursor);
			break;

		case WM_PAINT:
		   hDc = BeginPaint (hWnd, (LPPAINTSTRUCT) &ps);
		   DisplayLogo (hDc);
		   ValidateRect (hWnd, NULL);
           EndPaint(hWnd, (LPPAINTSTRUCT) &ps);
	       break;

		case WM_DESTROY:
			if (AbortInstall)
				PostMessage(hMainInsWnd, Messagetosend, 0, 0L) ;
			
			if (hCtl3dInst)
			{
				ProcedureAddress = GetProcAddress (hCtl3dInst,
										 			"Ctl3dUnregister") ;
				if (ProcedureAddress)
					(*ProcedureAddress)() ;
				FreeLibrary (hCtl3dInst) ;
			}
			DeleteObject (hBmpLogo) ; 
		  	DeleteObject (hBmpName) ;
		  	DeleteObject (hBmpRoucon) ;
		  	DeleteObject (hBmpAddr) ;

	    	PostQuitMessage (0) ;
	    	break ;

		default:
	    	return (DefWindowProc (hWnd, message, wParam, lParam)) ;
    }
    return NULL ;
}

/****************************************************************************
 * Function   : InitiateInstall(void)
 * Purpose    : initiates the installation dialog box.
 ****************************************************************************/
void InitiateInstall(void)
{
	char drive ;
	DWORD FreeSpace ;
	char szBufTotalSize[15] ;
	char szBufFreeSpace[15] ;
	char szBufText[150] ;
	int DriveNo ;
	char szInstallPath[DIRECTORY_NAME_LEN] ;

	strcpy (DestDir, "C:\\");				

	if (!GetDestInstallPath ((LPSTR) szInstallPath))
		strcat (DestDir, ProductStringStruct.ProductName) ;  
	else
		strcat (DestDir, szInstallPath) ;  
	AnsiUpper (DestDir) ;   

	/* Get the source and destination dirs for copying */
	if (! InvokeDialog (hgWnd, (LPSTR) "SETDIRSDLG", SetDirsDlgFn))
	{
		GetOut() ;
		return ;
	}

   drive = *DestDir ; 
	DriveNo = (int) (drive - 'A') + 1 ;

	FreeSpace = GetFreeSpaceInCurDrive ((unsigned int) DriveNo) ;  
	if (FreeSpace < TotalSize)  
	{
		ConvertNumToStrWithCommas (FreeSpace, szBufFreeSpace) ;
		ConvertNumToStrWithCommas (TotalSize, szBufTotalSize) ;
		lstrcpy ((LPSTR) szBufText, 
					(LPCSTR) "Out Of Disk Space\nDisk Space Free : ") ; 
		lstrcat ((LPSTR) szBufText, (LPCSTR) szBufFreeSpace) ;
		lstrcat ((LPSTR) szBufText, (LPCSTR) " KB.\nRequired Disk Space : ") ;
		lstrcat ((LPSTR) szBufText, (LPCSTR) szBufTotalSize) ;
		lstrcat ((LPSTR) szBufText, (LPCSTR) " KB.\n") ;
		MessageBox (hgWnd, (LPCSTR) szBufText, InstallTitle,
									  			MB_ICONSTOP | MB_OK) ; 
		GetOut () ;
		return ;
	}

	if( DestDir[strlen(DestDir) -1]  != '\\')
		strcat(DestDir, "\\") ;

	CumSize = 0 ;

	if (!InvokeDialog (hgWnd, (LPSTR)"INSTALLDLG", InstallDlgFn)) 
	{
		GetOut () ;
		return ;
    }
	if ((*DestDir == 'A' || *DestDir == 'B') && *(DestDir + 1) == ':')
				DestroyWindow (hgWnd); // if destdir is in a: or b:
	return ;
}

/****************************************************************************
 * Function   : CreateDir (char *)
 * Purpose    : creates the directory.
 ****************************************************************************/
int CreateDir (char *Dir)
{
	int len ;
	char CurrentDir[128] ;
	int drive ;

	drive = _getdrive () ;
	_getdcwd ( drive, CurrentDir, 128) ;
	
	len = strlen (Dir);
	if (Dir[len-1] == '\\')
		Dir[len-1] = NULL_TERM ;
	/* If directory exists or could be created then return 0*/
	if (!_chdir (Dir))
	{  
		_chdir (CurrentDir);
		return 0;
	}
	return (_mkdir (Dir));
}

/****************************************************************************
 * Function   : CreateMTRGroup(void)
 * Purpose    : creates the MTRouter group file after establishing
 *				a conversation with the program manager.
 ****************************************************************************/
void CreateMTRGroup(void)
{
	if (! InitConnection (hgWnd))	/* establish connection with manager */
		return ;
	CreateState = CREATE_GROUP ; 
	CreateMTRGroupStateMC ();		/* start the state machine */
}

#define BUF_SIZE 2048
BYTE	DataBuf[BUF_SIZE];
BYTE	TempStr[128];

/****************************************************************************
 * Function   : CreateMTRGroupStateMC(void)
 * Purpose    : state machine for creating the MTR group.
 ****************************************************************************/
void CreateMTRGroupStateMC (void)
{
	BYTE GrpName[50] ;
	BYTE name[128] ;
	char IniFile[128] ;
	int Reply ;
	BYTE GrpPathName[50] ;
	char Buf1[256] ;
	char WindowsDir[200] ;

	lstrcpy ((LPSTR) GrpName, GlobalGrpName) ;
	lstrcpy ((LPSTR) GrpPathName, GlobalGrpPathName) ;
	strcat (GrpPathName, ".GRP") ;

	switch (CreateState)
	{
		case DELETE_GROUP :	/* delete MultiExpress Icon */
			sprintf (DataBuf, "[DeleteGroup(%s)]", GrpName) ;
			SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
			break ;

		case CREATE_GROUP :	/*activate the group if it exists else create it*/
			GetWindowsDirectory ((LPSTR) WindowsDir, sizeof (WindowsDir)) ;
			if (*(WindowsDir + strlen (WindowsDir) - 1) != '\\')
				strcat (WindowsDir, "\\") ;
			strcat (WindowsDir, GrpPathName) ;
			remove (WindowsDir) ;
			sprintf (DataBuf, "[CreateGroup(%s,%s)]", GrpName, GrpPathName) ;
			SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
			break ;

		case SHOW_GROUP :	/* show the group */
			sprintf (DataBuf, "[ShowGroup(%s,%d)]", GrpName, SW_SHOWNORMAL) ;
			SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
			break ;

		case DELETE_OLD_ITEM :
			lstrcpy ((LPSTR) name,
				 OldIconsStruct[DeleteOldIconIndex - 1].IconDescription) ;
			sprintf (DataBuf, "[DeleteItem(%s)]", name) ;
			SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
			break ;

		case DELETE_ITEM :
			lstrcpy ((LPSTR) name,
					IconsStruct[DeleteIconIndex - 1].IconDescription) ;
			sprintf (DataBuf, "[DeleteItem(%s)]", name) ;
			SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
			break ; 

	   case ADD_ITEM :
			AddItemToGroup (IconsStruct[AddIconIndex - 1].Filename,
				IconsStruct[AddIconIndex - 1].IconDescription,				
				IconsStruct[AddIconIndex - 1].IconNo) ;
			break ;

		case END_CONV:		/* terminate the conversation */
			SendTerminate (hgWnd, hgWndPM);
			ShowWindow (hgWnd, SW_SHOWNORMAL);

			lstrcpy ((LPSTR) Buf1, (LPCSTR) ProductStringStruct.ProductName) ;
			lstrcat ((LPSTR) Buf1, (LPCSTR) " installation successful.\n") ;
			lstrcat ((LPSTR) Buf1,
			 	 (LPCSTR) "Do you want to setup default parameters?") ;
			Reply = MessageBox(hgWnd, (LPCSTR) Buf1, InstallTitle,
										MB_YESNO | MB_ICONINFORMATION) ;
			if (Reply == IDYES)
			{
				lstrcpy ((LPSTR) IniFile, (LPCSTR) DestDir) ;
				lstrcat ((LPSTR) IniFile, (LPCSTR) "roucon.exe 3") ;
				WinExec (IniFile, SW_SHOW) ;
			}

			Messagetosend =	WM_COMPLETE ;
			DestroyWindow (hgWnd) ;
			break ;
	}
}
/****************************************************************************
 * Function   : AddItemToGroup (PSTR, PSTR, int)
 * Purpose    : Adds the item to the new MEW group.
 ****************************************************************************/
void AddItemToGroup (PSTR ExecStr, PSTR NameStr, int IconIndex)
{
	char PathName[64] ;
	char IcoPath[64] ;

	lstrcpy ((LPSTR) PathName, (LPCSTR) DestDir) ;
	if (PathName[lstrlen ((LPCSTR) PathName) - 1] != '\\')
		lstrcat ((LPSTR) PathName, (LPCSTR) "\\") ;
	lstrcat ((LPSTR) PathName, (LPCSTR) ExecStr) ;
	lstrcpy ((LPSTR) IcoPath, (LPCSTR) PathName) ;
	sprintf (DataBuf, "[AddItem(%s,%s,%s,%d)]", PathName,
										NameStr, PathName, IconIndex) ;
	SendExecCommand (hgWnd, hgWndPM, (LPSTR) &DataBuf[0]) ;
}

/****************************************************************************/
/*++++++++++++++++++ State Machine for Copying the ROUCON files +++++++++++++++*/
/****************************************************************************/

HANDLE	hSrcFile, hDestFile;
OFSTRUCT ofStrSrc;
HWND	hInstallDlg ;

int		hInstallTimer;


BOOL InstallFilesStateMC (void)
{
	char IniFile[128] ;
	static BOOL fCheck = FALSE ;
	char szBufText[150] ;

	switch (CurInstallState) 
	{
		case START_XFER :
			CurFileIndex = 0 ;
			InInstallFiles = TRUE ;

			if (TimerCreated)  
			{
				TimerCreated = 0 ;
				DestroyInstallTimer() ; 
			}

			if (!OpenSrcDestFiles (1)) 
				return FALSE ;
			if (!TimerCreated) 
			{
				TimerCreated = 1 ;
				CreateInstallTimer() ;		
			}

  			CurInstallState = COPY_FILE ;
			if (CurFileIndex == Ctl3dv2Index)
				CurInstallState = NEXT_FILE ; 				
			return TRUE ;

		case COPY_FILE :
			if (!CopyOneBlock (1)) 
			{
				CurInstallState = NEXT_FILE ;
				CloseSrcDestFiles() ;
			}
			return TRUE ;

		case NEXT_FILE :
			CurFileIndex ++ ; 
			if (CurFileIndex == NumFiles)
			{	/* all files over */
				CurInstallState = END_XFER ;
				return TRUE ;
			}
			if (!fCheck)
			{
				if (CurFileIndex == Ctl3dv2Index)
				{
					fCheck = TRUE ;
					CurFileIndex ++ ;
					if (CurFileIndex == NumFiles)
					{	 /* all files over */
						CurInstallState = END_XFER ;
						return TRUE ;
					}
				}
			}


			if (TimerCreated)   
			{
				DestroyInstallTimer() ;		  
				TimerCreated = 0 ;
			}
			if (!OpenSrcDestFiles (1)) 
			{
				return FALSE ;
			}
			if (!TimerCreated)    
			{
				CreateInstallTimer() ; 
				TimerCreated = 1 ;
			}
			CurInstallState = COPY_FILE;
			return TRUE ;

		case END_XFER:
			InInstallFiles = FALSE;
			if (TimerCreated)   
			{
				DestroyInstallTimer() ; 
				TimerCreated = 0 ;
			}

			// Get rid of the animation timer
			KillTimer (hgWnd, 0x1) ;
			FreeProcInstance (LogoTimerFn) ;

			EndDialog (hInstallDlg, IDOK) ;

			ShowWindow (hgWnd, SW_SHOW) ;/* hide the main window */
    		UpdateWindow (hgWnd);

			lstrcpy ((LPSTR) IniFile, (LPCSTR) DestDir) ;
			lstrcat ((LPSTR) IniFile, (LPCSTR) SystemIniFile) ; 
			InvokeDialog (hgWnd, (LPSTR) "PORTTOUSE", PortToUseDlgFn) ;
			WritePrivateProfileString ("Port Setup", "Select Port",
											PortNames[PortToUse], (LPCSTR)IniFile) ;

			/* Write the product name into SETUP.INI file */
			WritePrivateProfileString (
					(LPCSTR)"Port Setup",
					(LPCSTR)"Application Name",
					(LPCSTR) ProductStringStruct.ProductName,
					(LPCSTR) IniFile
			) ;

			/* if not installing on Floppy drives, create the group */
			if ((DestDir[1] == ':') &&
						((DestDir[0] == 'a') || (DestDir[0] == 'A')
							|| (DestDir[0] == 'b') || (DestDir[0] == 'B')))
			{
				SaveSystemInfo ();  	/* saves the system info in SETUP.INI */
				lstrcpy ((LPSTR) szBufText,
										(LPCSTR) ProductStringStruct.ProductName) ;
				lstrcat ((LPSTR) szBufText,
										(LPCSTR) " \nInstallation Successfull.") ; 
				MessageBox(hgWnd, (LPCSTR) szBufText, InstallTitle,
													 MB_OK | MB_ICONINFORMATION) ;
				Messagetosend =	WM_COMPLETE;
			}
			else
				CreateMTRGroup();
			/* send message back to main install window */
			return TRUE ;
	}
}


void GetSetFileDate (int srcfile, int dstfile)
{
	_asm {
		push	cx
		push	bx
		push	dx

		mov		ax, 5700h
		mov		bx, srcfile
		int		21h
		jc		error

		mov		ax, 5701h
		mov		bx, dstfile
		int		21h
error:
		pop		dx
		pop		bx
		pop		cx
	}
}

void GetRealName (LPSTR CompressedName, LPSTR RealName)
{
	int i ;
	LPSTR ExtnPtr ;


	lstrcpy (RealName, CompressedName) ;
	i = lstrlen (RealName) ;
	ExtnPtr = RealName + i - 1 ; // point to last char
	if (*ExtnPtr != '_')			// return if uncompressed name
		return ;
	while (*ExtnPtr && (ExtnPtr >= RealName) && (*ExtnPtr != '.'))	// Point to Dot in name
		ExtnPtr -- ;
	if (*ExtnPtr != '.')
		return ;

	for (i = 0 ; *RealExtns[i] ; i ++)
   {
   	if ((ExtnPtr[1] == *(char *) (RealExtns[i] + 1)) &&
					(ExtnPtr[2] == *(char *) (RealExtns[i] + 2)) ) 
		{
			ExtnPtr[3] = *(char *) (RealExtns[i] + 3) ;
			ExtnPtr[4] = NULL_TERM ;
			return ;
		}
	}
}

static	char	SrcPathName[64];		// this is needed for setfile date later

BOOL OpenSrcDestFiles (BOOL ShowStatus)
{
	char DestPathName[200] ;
	char RealName[60] ;

	/* build the complete pathname for the source file */
	lstrcpy ((LPSTR) SrcPathName, (LPCSTR) SourceDir) ;

	if (SrcPathName[strlen (SrcPathName) - 1] != '\\')
		strcat (SrcPathName, "\\") ;
	lstrcat ((LPSTR) SrcPathName,						
						(LPCSTR) FilesStruct[CurFileIndex].Filename) ;

	/* build the complete pathname for the destination file */
	lstrcpy ((LPSTR) DestPathName, (LPCSTR) DestDir) ;
	if (DestPathName[lstrlen ((LPCSTR) DestPathName) - 1] != '\\')
		lstrcat ((LPSTR) DestPathName, (LPCSTR) "\\") ;
	GetRealName (FilesStruct[CurFileIndex].Filename, RealName) ;
	lstrcat ((LPSTR) DestPathName, (LPCSTR) RealName) ;

	/* open the source file */
	while ((hSrcFile = LZOpenFile(SrcPathName, &ofStrSrc, OF_READ)) == -1)
	{
		if (!CheckForExactDiskette())
				return FALSE ;
	}
	
	/* create the destination file */
	if ((hDestFile = _lcreat (DestPathName, 0)) == -1)
		return FALSE ;

	if (!ShowStatus)
		return TRUE ;

	/* get the source file size */
	BytesDone = 0 ;

	FileSize = FilesStruct[CurFileIndex].FileSize ; 

	/* display one line message */
	SetDlgItemText (hInstallDlg, 105, 
						FilesStruct[CurFileIndex].FileDescription) ;
	UpdateFileProgress (0) ;
	AnsiUpper((LPSTR) SrcPathName) ;
	AnsiUpper((LPSTR) DestPathName) ;

	/* update file being copied */
	SetDlgItemText (hInstallDlg, IDC_INST_SRCFILE, (LPSTR) SrcPathName) ;
	SetDlgItemText (hInstallDlg, IDC_INST_DESTFILE, (LPSTR) DestPathName) ;

	AnsiUpper ((LPSTR) DestDir) ;
	/* Update destination directory also */
	SetDlgItemText (hInstallDlg, IDC_INST_DEST, DestDir) ;

	return TRUE ;
}

void CloseSrcDestFiles (void)
{
	LZClose (hSrcFile);	// a file opended in LZW readwrite gives error
								// for getdate operation
	hSrcFile = _lopen(SrcPathName, READ_WRITE);		// this is needed for setfile date later
	GetSetFileDate(hSrcFile, hDestFile);
	_lclose (hSrcFile); 
	_lclose (hDestFile); 
	hSrcFile = hDestFile = 0xFFFF ;
}

BOOL CopyOneBlock (BOOL ShowStatus)
{
	int	count ;

	if ((count = LZRead (hSrcFile, (LPSTR) &DataBuf[0], BUF_SIZE)) > 0)
	{
		_lwrite (hDestFile, (LPSTR) &DataBuf[0], count) ;
		if (ShowStatus)
		{
			BytesDone += (DWORD) count ;
			CumSize += (DWORD) count ;
			UpdateFileProgress (1) ;
			UpdateTotalProgress (1) ;
		}
		return TRUE ;
	}
	if (count == -1)
		return FALSE ;
}


void CreateInstallTimer(void)
{
	SetTimer (hInstallDlg, INSTALL_TIMER_ID, INSTALL_TIME_OUT,
																(TIMERPROC) NULL) ;
}


void DestroyInstallTimer (void)
{
	KillTimer (hInstallDlg, INSTALL_TIMER_ID) ;
}

/****************************************************************************
 * Name		: MakeIniStr (int, char *)
 * Synopsis : Makes the INI string to store it in the WIN.INI file.
***************************************************************************/
void MakeIniStr (int index, char *Val)
{
	switch (index) 
	{
		case 0:
			strcpy(Val, "1.00");
			break;

		case 1:				/* MEW main window position & size */
			sprintf (Val, "%d %d %d %d", 0, 0, 0, 0, 0); /* will default */
			break;

		case 2:				/* time status window */
		case 3:				/* status window */
		case 4:				/* tool bar window */
			strcpy(Val, "ON");
			break;

		case 5:				/* terminal font info */
			strcpy (Val, "Terminal 12 8");
			break;

		case 6:				/* Color setup */
			sprintf (Val, "%d %d %d %d %d %d %d", 7, 0, 15, 7, 7, 0, 7);
			break;

		case 7:
			strcpy(Val, "8192");
			break;

		default :
			*Val = NULL;
			break;
	}
}

/****************************************************************************
 * Name		: SaveSystemInfo (void)
 * Synopsis : Saves the ROUCON system params in WIN.INI.
 ***************************************************************************/
BOOL SaveSystemInfo (void)
{
	int i ;
	char RetStr[128] ;
	char IniFile[128] ;

	lstrcpy ((LPSTR) IniFile, (LPCSTR) DestDir) ;
	lstrcat ((LPSTR) IniFile, (LPCSTR) SystemIniFile) ;

	for (i = 0 ; i < (MAX_SYSTEM_DEFAULTS) ; i ++) 
	{
		MakeIniStr (i, RetStr) ;
		WritePrivateProfileString (RouconParamsSec, SystemParams[i],
													(LPSTR) RetStr, (LPSTR) IniFile) ;
	}
	return TRUE ;
}


/*--------------------------------------------------------------------------
	Function	:	UpdateFileProgress()
	Synopsis	:	Updates the guage on screen.
	Input		:	Flag to reset the rectangle.
	Output		:	None.
 ------------------------------------------------------------------------ */
void UpdateFileProgress (int Flag)
{
	HBRUSH hOBr ;
	HPEN hPen, hOPen ;
	HDC	hProgDC ;
	HBRUSH hOBrush ;
	RECT rct ;
	HBRUSH hBkBrush ;
	HPEN hBkPen ;

	if (hInstallDlg == NULL)
		return ;
	hProgCtl = GetDlgItem (hInstallDlg, IDC_INST_PROGRESS) ;
	if (! Flag)
	{
		GetWindowRect (hProgCtl, (LPRECT) &rct) ;
		Width = rct.right - rct.left - 2 ;
		Height = rct.bottom - rct.top ;
		hProgDC = GetDC (hProgCtl) ;
		hBkBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
		hBkPen = CreatePen (PS_SOLID, 1, GetSysColor (COLOR_BTNFACE)) ;
		hOBr = SelectObject (hProgDC, (HGDIOBJ) hBkBrush) ;
		hOPen = SelectObject (hProgDC, (HGDIOBJ) hBkPen) ;
		Rectangle (hProgDC, 1, 1, Width, Height - 1) ;
		SelectObject (hProgDC, hOPen) ;
		SelectObject (hProgDC, hOBr) ;
		DeleteObject ((HGDIOBJ) hBkPen) ;
		DeleteObject ((HGDIOBJ) hBkBrush) ;
		ReleaseDC (hProgCtl, hProgDC) ;
		return ;
	}

	hProgDC = GetDC (hProgCtl) ;
	hOBrush = SelectObject (hProgDC, hRedBr) ;
	hOPen = SelectObject (hProgDC, GetStockObject (NULL_PEN)) ;

	if (FileSize)
	{
		Rectangle (hProgDC, 1, Height, Width,
			Height - (int)(((DWORD)((DWORD)BytesDone
								* (DWORD)Height)) / (DWORD)FileSize));
	}

	SelectObject (hProgDC, hOPen) ;
	SelectObject (hProgDC, hOBrush) ;

	// draw the gray and white lines.
	hPen = CreatePen (PS_SOLID, 2, RGB (255, 255, 255)) ;
	hOPen = SelectObject (hProgDC, hPen) ;
	MoveTo (hProgDC, 0, Height) ;
	LineTo (hProgDC, 0, 0) ;
	LineTo (hProgDC, Width, 0) ;
	SelectObject (hProgDC, hOPen) ;
	DeleteObject (hPen) ;

	hPen = CreatePen (PS_SOLID, 2, GetSysColor (COLOR_BTNSHADOW)) ;
	hOPen = SelectObject (hProgDC, hPen) ;
	MoveTo (hProgDC, Width, 2) ;
	LineTo (hProgDC, Width, Height) ;
	LineTo (hProgDC, 2, Height) ;
	SelectObject (hProgDC, hOPen) ;
	DeleteObject (hPen) ;

	ReleaseDC (hProgCtl, hProgDC) ;
}

/* -------------------------------------------------------------------------
	Function	:	UpdateTotalProgress()
	Synopsis	:	Updates the total files guage on screen.
	Input		:	Flag to reset the rectangle.
	Output		:	None.
 ------------------------------------------------------------------------ */
void UpdateTotalProgress (int Flag)
{
	HBRUSH	hOBr;
	HPEN	hPen, hOPen;
	HDC		hProgDC;
	HBRUSH	hOBrush;
	RECT	rct;
	HBRUSH hBkBrush ;
	HPEN hBkPen ;

	if (hInstallDlg == NULL) 
		return ;
	hProgTtlCtl = GetDlgItem(hInstallDlg, IDC_INST_TOT_PROGRESS);
	if (! Flag) 
	{
 		GetWindowRect (hProgTtlCtl, (LPRECT) &rct) ;
 		TtlWidth = rct.right - rct.left ;
 		TtlHeight = rct.bottom - rct.top ;
		hProgDC = GetDC(hProgTtlCtl) ;
		hBkBrush = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
		hBkPen = CreatePen (PS_SOLID, 1, GetSysColor (COLOR_BTNFACE)) ;
		hOBr = SelectObject (hProgDC, (HGDIOBJ) hBkBrush) ;
		hOPen = SelectObject (hProgDC, (HGDIOBJ) hBkPen) ;
		Rectangle (hProgDC, 1, 1, TtlWidth, TtlHeight);
		SelectObject (hProgDC, hOPen);
		SelectObject (hProgDC, hOBr);
		DeleteObject ((HGDIOBJ) hBkPen) ;
		DeleteObject ((HGDIOBJ) hBkBrush) ;
		ReleaseDC (hProgTtlCtl, hProgDC);
		return;
	}

	hProgDC = GetDC(hProgTtlCtl);
	hOBrush = SelectObject (hProgDC, hBlueBr);
	hOPen = SelectObject (hProgDC, GetStockObject(NULL_PEN));

	if (TotalSize)
	{
		Rectangle(hProgDC, 1, 1, (int)(((DWORD)((DWORD)CumSize * 
						(DWORD)TtlWidth))/(DWORD)TotalSize), TtlHeight);
	}

	SelectObject (hProgDC, hOPen);
	SelectObject (hProgDC, hOBrush);

	// draw the gray and white lines.
	hPen = CreatePen (PS_SOLID, 2, GetSysColor (COLOR_BTNSHADOW)) ;
	hOPen = SelectObject(hProgDC, hPen);
	MoveTo(hProgDC, 0, TtlHeight);
	LineTo(hProgDC, 0, 0);
	LineTo(hProgDC, TtlWidth, 0);
	SelectObject(hProgDC, hOPen);
	DeleteObject(hPen);

	hPen = CreatePen(PS_SOLID, 2, RGB(255, 255, 255));
	hOPen = SelectObject(hProgDC, hPen);
	MoveTo(hProgDC, TtlWidth, 2);
	LineTo(hProgDC, TtlWidth, TtlHeight);
	LineTo(hProgDC, 2, TtlHeight);
	SelectObject(hProgDC, hOPen);
	DeleteObject(hPen);

	ReleaseDC (hProgTtlCtl, hProgDC);
}


/*----------------------------------------------------------------------------
Module : CheckForExactDiskette
Input  :
Output :
----------------------------------------------------------------------------*/
int CheckForExactDiskette (void)
{
	int ret_val ;

	ret_val = InvokeDialog (hInstallDlg, (LPSTR) "DISKDLG", DiskDlgFn) ;
	return ret_val ;
}


/*----------------------------------------------------------------------------
Module : DiskDlgFn

----------------------------------------------------------------------------*/
int FAR PASCAL DiskDlgFn (
						HWND hDlg,
						unsigned message,
						WORD wParam,
						LONG lParam
					)
{
	switch (message)
	{
		case WM_INITDIALOG :
			DLGCenterDialog (hDlg) ;
		 	sprintf(DiskNoBuf, "%d", FilesStruct[CurFileIndex].DisketteNo) ;
			SetWindowText (hDlg, (LPCSTR) ProductStringStruct.ProductName) ;
			SetDlgItemText (hDlg, DISK_NO, (LPCSTR) DiskNoBuf) ;
			SetDlgItemText (hDlg, PROD_NAME,
										(LPCSTR) ProductStringStruct.ProductName) ;
			return TRUE ;

		case WM_COMMAND :
			switch (wParam)
			{
				case IDOK :
					EndDialog (hDlg, TRUE) ;
					return TRUE ;

				case IDCANCEL :
					EndDialog (hDlg, FALSE) ;
					return TRUE ;
			}
			break;

		default:
			break;
	}
	return FALSE;
}


void GetOut (void)
{
	char Buf1[100] ;

	lstrcpy ((LPSTR) Buf1, ProductStringStruct.ProductName) ;
	lstrcat ((LPSTR) Buf1, (LPCSTR) " \n could not be installed") ;
	MessageBox (hgWnd, (LPCSTR) Buf1, InstallTitle,	MB_OK | MB_ICONHAND) ;
	Messagetosend = WM_USERABORT ;
	DestroyWindow (hgWnd) ;
	return ;
}
	
