// ipdetect.cpp : implementation file
//	Imran,16/2/99 : For autodetection

#include "stdafx.h"
#include "procon.h"
#include "ipdetect.h"
#include "tftpif.h"
#include "autodete.h"
#include "maskdot.h"
#include "types.h"
#include "utils.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIPdetect dialog

ULONG configured_ip_address ;
BYTE mac_address[MAX_MAC_ADDRESS_LENGTH] ;

extern SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS] ;
extern int number_of_responses ;
extern CDotDecimal dotdecimal_configured_ip_address ;
extern char obtd_host_ip_address[16] ;


CIPdetect::CIPdetect(CWnd* pParent /*=NULL*/)
	: CDialog(CIPdetect::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPdetect)
	m_static_desc3 = "";
	m_proxy_details = "";
	m_edit_ip = "";
	//}}AFX_DATA_INIT
}

void CIPdetect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPdetect)
	DDX_Control(pDX, IDOK, m_onok);
	DDX_Control(pDX, IDC_STATIC_CONFIG_IP, m_ip_ctrl_static);
	DDX_Control(pDX, IDC_PROXY_DETAILS, m_ctrl_proxy_details);
	DDX_Control(pDX, IDC_EDIT_IP_CONFIG, m_ctrl_ip);
	DDX_Text(pDX, IDC_DESC_STATIC3, m_static_desc3);
	DDX_LBString(pDX, IDC_PROXY_DETAILS, m_proxy_details);
	DDX_Text(pDX, IDC_EDIT_IP_CONFIG, m_edit_ip);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPdetect, CDialog)
	//{{AFX_MSG_MAP(CIPdetect)
	ON_LBN_DBLCLK(IDC_PROXY_DETAILS, OnDblclkProxyDetails)
	ON_LBN_SELCHANGE(IDC_PROXY_DETAILS, OnSelchangeProxyDetails)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPdetect message handlers

BOOL CIPdetect::OnInitDialog()
{
	char buff[80], temp_dot_value[20] ;
	int  TabStop = 40 ;

	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	m_ctrl_proxy_details.SetTabStops (1, (LPINT)&TabStop)  ;

	for (int i = 0 ; i < number_of_responses; i++)
	{
		get_dot_decimal_ip_address (response_entries[i].server_ip_address, temp_dot_value) ;
		if (i == 0)
		{
//			if (check_if_ip_address_belongs_to_same_net(obtd_host_ip_address, temp_dot_value))
//			{
//  			m_ctrl_ip.SetWindowText((char *)temp_dot_value) ;
//			}
//			memcpy (mac_address, response_entries[i].server_mac_address, MAX_MAC_ADDRESS_LENGTH) ;
//			m_mac_ctrl.SetWindowText((char *)response_entries[i].server_mac_address) ;
//			UpdateData (TRUE);
		}
//		UpdateData (FALSE) ;
		sprintf (buff, "%s\t%s", temp_dot_value, response_entries[i].server_mac_address) ; 
		m_ctrl_proxy_details.AddString (buff) ;
//		m_ctrl_proxy_details.AddString (buff) ;
	}
	if (number_of_responses)
	  	m_ctrl_proxy_details.SetCurSel(0) ;
//	m_onok.EnableWindow(TRUE) ;
//	m_static_mac.EnableWindow(FALSE) ;
//	m_mac_ctrl.EnableWindow(FALSE) ;

//	UpdateData(FALSE);
   OnDblclkProxyDetails() ;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIPdetect::OnOK()
{
	// TODO: Add extra validation here
   int flag, error_code ;

	UpdateData(TRUE);
       
   if (m_edit_ip.IsEmpty())
   {
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP address",
		  (LPCSTR) "Auto Detect", MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_ip.SetFocus() ;
		return ;
   }
	
   if (m_edit_ip == ZeroIPAddress)
   {
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP address",
		  (LPCSTR) "Auto Detect", MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_ip.SetFocus() ;
	 	return ;
   }

   if (!m_edit_ip.IsValid())
   {
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP address",
			(LPCSTR) "Auto Detect", MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_ip.SetFocus() ;
		return ;
   }
	dotdecimal_configured_ip_address = m_edit_ip ;
   get_cdotdecimal_to_ulong_ip_address (m_edit_ip, &configured_ip_address) ;
   
	flag = 1 ;
	int ret = StartAutoDetection (m_hWnd, &error_code, configured_ip_address, mac_address, flag) ;  
	if (ret == -1)
	{
		AfxMessageBox("Failed to set configured address") ;
  	    return ;
	}
	
	CDialog::OnOK();
}

void CIPdetect::OnDblclkProxyDetails()
{
	// TODO: Add your control notification handler code here

		char IPMACAddress[50], ip_address[20], next_ip_address[20] ;
	int SelIndex ;
	char desc1[] = "Press Ok to continue. (You may change the IP address.\
 Make sure the new address is unique and belongs to the same network)." ;

	char desc2[] = "Selected ProxyServer needs IP address reconfiguration. Make\
 sure the above suggested IP address is unique on your LAN and press OK." ;

	if ((SelIndex = m_ctrl_proxy_details.GetCurSel()) == LB_ERR)
		return ;
	if (m_ctrl_proxy_details.GetText(SelIndex,  IPMACAddress) == LB_ERR)
		return ;
	sscanf (IPMACAddress, "%s\t%s", ip_address, mac_address) ;

  	if (check_if_ip_address_belongs_to_same_net(obtd_host_ip_address, ip_address))
  	{
		m_static_desc3 = desc1 ;
		m_ip_ctrl_static.SetWindowText("&IP Address") ;
		UpdateData(FALSE);
  		m_ctrl_ip.SetWindowText((char *)ip_address) ;
	}
	else
	{
		m_static_desc3 = desc2 ;
		m_ip_ctrl_static.SetWindowText("Suggested &IP Address") ;
		UpdateData(FALSE);
		get_next_ip_address(obtd_host_ip_address, next_ip_address) ;
  		m_ctrl_ip.SetWindowText((char *)next_ip_address) ;
	}
}

void CIPdetect::OnSelchangeProxyDetails()
{
	// TODO: Add your control notification handler code here
	OnDblclkProxyDetails() ;
}
