// ipdnld.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include	"dot.h"
#include "maskdot.h"
#include "ipdnld.h"
#include "hardware.h"
#include "dhcpk.h"


char	*IPDnldMsgHeader="IP Setup";
LPCSTR IPDnldSectionHeader ="IP Routing" ;
LPCSTR DHCPSectHeader = "DHCP" ;
LPCSTR DHCPServerSection = "DHCP";
extern int FirstTimeInEdit = 1;

/* Imran on 17.02.99 */
extern BOOL ModifyIPAddress ; 
extern CDotDecimal dotdecimal_configured_ip_address ;
/* Imran on 17.02.99 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIPDNLD dialog


CIPDNLD::CIPDNLD(CWnd* pParent /*=NULL*/)
	: CDialog(CIPDNLD::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPDNLD)
	m_ISPcheck = FALSE;
	m_IPAddrStr = "";
	m_MskStr = "";
	m_remote_addr = "";
	m_sel_port = "";
	m_primary_address = "";
	m_secondary_address = "";
	m_port_static1 = "";
	m_port_static2 = "";
	//}}AFX_DATA_INIT
}

void CIPDNLD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPDNLD)
	DDX_Control(pDX, IDC_STATIC_SECONDARY_ADDRESS, m_static_secondary);
	DDX_Control(pDX, IDC_STATIC_PRIMARY_ADDRESS, m_static_primary);
	DDX_Control(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_ctrl_secondary);
	DDX_Control(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_ctrl_primary);
	DDX_Control(pDX, IDC_STATIC_DNS, m_grp_dns);
	DDX_Control(pDX, IDC_STATIC_SEL_PORT, m_ctrl_sel_port);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_STATIC_MASK, m_staticMskWnd);
	DDX_Control(pDX, IDC_STATIC_REMOTE_ADDRESS, m_static_remote_addr);
	DDX_Control(pDX, IDC_EDIT_REMOTE_ADDRESS, m_ctrl_remote_addr);
	DDX_Control(pDX, IDC_RADIO_YES, m_ctrl_dhcp_yes);
	DDX_Control(pDX, IDC_RADIO_NO, m_ctrl_dhcp_no);
	DDX_Control(pDX, IDC_STATIC_USER_ASSIGNED, m_ctrl_user_assigned);
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_RAS, m_ras_enable);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPcheck);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Text(pDX, IDC_EDIT_REMOTE_ADDRESS, m_remote_addr);
	DDX_Text(pDX, IDC_STATIC_SEL_PORT, m_sel_port);
	DDX_Text(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_primary_address);
	DDX_Text(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_secondary_address);
	DDX_Text(pDX, IDC_STATIC1, m_port_static1);
	DDX_Text(pDX, IDC_STATIC3, m_port_static2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPDNLD, CDialog)
	//{{AFX_MSG_MAP(CIPDNLD)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_CHECK_RAS, OnCheckRas)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	ON_BN_CLICKED(IDC_RADIO_NO, OnDhcpNo)
	ON_BN_CLICKED(IDC_RADIO_YES, OnDhcpYes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPDNLD message handlers

BOOL CIPDNLD::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	// Read the configuration file and init the variables
	int	index;
	char	szRHS[40];
	char	szLHS[40];
	char PortString[20];
	CDotDecimal DotValue;

        // Checking for UPGRADE PROXY - Brindha on 28/7/98
        if (CommandLineArgument == 6)
                strcpy(FileName, NewIniInWinForm);
        else
                strcpy(FileName, IniInWinForm);


	m_nPorts = GetPrivateProfileInt(IPDnldSectionHeader,
				(LPCSTR) "IP Number of Ports",4,
				(LPCSTR) FileName);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	// If MLPPP is enabled no ras is possible for now
	m_MLPPP = FALSE;
	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
			StrNull, szRHS, sizeof(szRHS), FileName))
		m_MLPPP = TRUE;


	for (index = 0; index < m_nPorts; index++)
	{
		//Get IP address of the port
		wsprintf (szLHS, "IP Port%d Address", index);
	  	GetPrivateProfileString ((LPCSTR) IPDnldSectionHeader,
			(LPCSTR) szLHS, ZeroIPAddress, (LPSTR) szRHS,
									sizeof (szRHS), (LPCSTR) FileName) ;
		DotValue = 	m_IPAddr[index] = szRHS;
		if ( ! DotValue.IsValid())
			m_IPAddr[index] = ZeroIPAddress;

/* Imran, for AutoDetection */
/* set LAN address for that configured during autodetection */
		if (ModifyIPAddress == TRUE)
		{
			if ( ! dotdecimal_configured_ip_address.IsValid())
				m_IPAddr[0] = ZeroIPAddress ;
			else
				m_IPAddr[0] = dotdecimal_configured_ip_address ;
		}
/* Imran, for AutoDetection */


		//If IP address == 0.0.0.0 then it is ISP assigned
		m_ISP[index] = FALSE;
		if (index > 0)		//not for LAN port
			if ( ! strcmp((LPCSTR)m_IPAddr[index], ZeroIPAddress))
				m_ISP[index] = TRUE;

		//Get subnet mask for the port
		wsprintf (szLHS, "IP Port%d Address Mask", index);
	 	GetPrivateProfileString(IPDnldSectionHeader, (LPCSTR) szLHS,
 					ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   				(LPCSTR) FileName);
   	m_IPMask[index] = szRHS;
		if ( ! verify_ip_subnet_mask((LPCSTR)m_IPMask[index]))
			m_IPMask[index] = ZeroIPAddress;

		////Prabha, 11/3/98, for RAS support
		m_RAS[index] = 0;
		if ((index > 0) && !m_MLPPP)
		{
			wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index-1);
		  	GetPrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szLHS, StrDisabled, (LPSTR) szRHS,
										sizeof (szRHS), (LPCSTR) FileName) ;
			if (!strcmp (szRHS, StrEnabled))
				m_RAS[index] = 1;
		}

		wsprintf(szLHS, "IP Port%d Remote Address", index);
	  	GetPrivateProfileString ((LPCSTR) IPDnldSectionHeader,
			(LPCSTR) szLHS, StrNull, (LPSTR) szRHS,
								sizeof (szRHS), (LPCSTR) FileName) ;
		m_RemoteAddr[index] = szRHS;
	}

	//Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < m_nPorts-1; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
	m_IPAddrStr = m_IPAddr[m_nOldPort];
 	m_MskStr = m_IPMask[m_nOldPort];
	m_ISPcheck = m_ISP[m_nOldPort];

	strcpy(PortString,"LAN");
	m_sel_port = PortString;
	
	m_ISPWnd.ShowWindow(FALSE);
	m_ras_enable.ShowWindow (FALSE);
	m_ctrl_remote_addr.ShowWindow (FALSE);
	m_static_remote_addr.ShowWindow (FALSE);

	m_ISPWnd.EnableWindow(FALSE);
	m_ras_enable.EnableWindow (FALSE);
	m_ctrl_remote_addr.EnableWindow (FALSE);
	m_static_remote_addr.EnableWindow (FALSE);

	GetPrivateProfileString(DHCPServerSection, "DHCP Server", StrNull,
				szRHS, sizeof(szRHS), (LPCSTR) FileName);
	if (!strcmp(szRHS, StrEnabled))
	{
		m_ctrl_dhcp_yes.SetCheck(1);
		m_ctrl_dhcp_no.SetCheck(0);
	}
	else
	{
		m_ctrl_dhcp_yes.SetCheck(0);
		m_ctrl_dhcp_no.SetCheck(1);
	}

	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP DNS Server Address1", (LPCSTR) StrNull, 
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
	m_primary_address = szRHS;
			
	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP DNS Server Address2", (LPCSTR) StrNull, 
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
	m_secondary_address = szRHS;		

	m_grp_dns.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_static_primary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_static_secondary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());

	m_ctrl_primary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	m_ctrl_secondary.EnableWindow(m_ctrl_dhcp_yes.GetCheck());
	
	m_port_static1.LoadString(IDS_LAN_SETUP1);
	m_port_static2.LoadString(IDS_LAN_SETUP2);

	UpdateData(FALSE);
	CenterWindow();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CIPDNLD::ValidPortSettings()
{
	CDotDecimal DotValue;
	unsigned long addr1, addr2, mask1, mask2;

	DotValue = m_IPAddrStr;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

	if(m_ISPcheck)			// If ISP assigns we make it 0.0.0.0
		DotValue = ZeroIPAddress;
	else
	{
		if (!DotValue.IsValid())
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
					(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( ! verify_ip_subnet_mask((LPCSTR)m_MskStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE ;
	}

	////Prabha, 11/3/98, validity of remote address
	if (m_PortListWnd.GetCurSel())
	{
		if (m_ras_enable.GetCheck())
		{
			if (!strcmp (m_remote_addr, ZeroIPAddress) || m_remote_addr.IsEmpty()) 
			{	// remote address is not given, DHCP client must be enabled
			}
			else
			{
				if (!m_remote_addr.IsValid())
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Remote Address",
							(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_addr.SetFocus() ;
					return FALSE ;
				}
				if (!strcmp (m_remote_addr, m_IPAddr[0]))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses are same",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
				get_ip_address (m_IPAddr[0], &addr1);
				get_ip_address (m_IPMask[0], &mask1);
				get_ip_address (m_remote_addr, &addr2);
				get_ip_address (m_MskStr, &mask2);
				if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should be in same network.\n\r\
Due to Auto Detection LAN ip address might have been changed.\n\r\
So change the Remote address accordingly to the same IP net of LAN.",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_IPAddrWnd.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}
	return TRUE ;
}

BOOL CIPDNLD::ValidEditFields()
{
	//makesure that the current edit controls have valid entries
	char Msg[120];
	UpdateData (TRUE);
	if (!ValidPortSettings())
		return FALSE;

	//Since the data is validated we need to put into the
	//local structs before we start writing out
	m_ISP[m_nOldPort] = m_ISPcheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;
	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_addr;

	////Prabha 20/2/98, check the LAN and WAN addresses are not of the same
	////network.
	unsigned long addr1, addr2, mask1, mask2;
	get_ip_address (m_IPAddr[0], &addr1);
	get_ip_address (m_IPMask[0], &mask1);
	for (int index = 1; index < m_nPorts; index++)
	{
		get_ip_address (m_IPAddr[index], &addr2);
		get_ip_address (m_IPMask[index], &mask2);

		if ((addr1 & mask1) == (addr2 & mask2))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and WAN Addresses belong to the same net",
				(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
		if (m_RAS[index])
		{
			get_ip_address (m_RemoteAddr[index], &addr2);
			get_ip_address (m_IPMask[index], &mask2);
			if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should belong to the same net.\n\r\
Due to Auto Detection LAN address might have been changed.\n\r\
So change the Remote address accordingly to the same LAN IP net.",
					(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_IPAddrWnd.SetFocus() ;
				return FALSE ;
			}

			CDotDecimal rem_addr;
			rem_addr = m_RemoteAddr[index];			
			if (!rem_addr.IsValid() || rem_addr.IsEmpty()) 
			{
/* sudha 06 July 1999.*/
#if 0
				if ( FirstTimeInEdit == 1 )
				{
				}
#endif
  				sprintf(Msg, "Enter an IP Address for Remote Client on WAN %d\n\
or reconfigure & make sure to enable DHCP after downloading the setup", index);
  				::MessageBox (GetSafeHwnd(), Msg,
  					(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
  				m_PortListWnd.SetCurSel(index);	//Set the selection
  				OnSelchangeListPorts();				//call the handler explict
  				m_ctrl_remote_addr.SetFocus();	
  				return FALSE;

/* sudha 06 July 1999.*/
#if 0
				else
				{
					sprintf(Msg, "No IP Address for Remote Client on WAN %d\n\
Make sure to reconfigure & enable DHCP after downloading the setup", index);
					::MessageBox (GetSafeHwnd(), Msg,
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				}
#endif
			}
		}
		for (int index2 = index+1; index2 < m_nPorts; index2++)
		{
			if (m_RAS[index] && m_RAS[index2])
			{
				if ((m_RemoteAddr[index] == m_RemoteAddr[index2]) 
					&& ( strcmp ( (LPCSTR)m_RemoteAddr[index],ZeroIPAddress ) != 0 ))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "The Remote addresses should not be similar",
						(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_addr.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}

	if (!m_primary_address.IsEmpty())
	{
		if ((m_primary_address != ZeroIPAddress) && !m_primary_address.IsValid())
		{
				wsprintf(Msg, "Invalid DNS Primary Address");
				::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
					MB_OK|MB_ICONEXCLAMATION);
				m_ctrl_primary.SetFocus();
				return FALSE;
		}
	}
	if (!m_secondary_address.IsEmpty())
	{
		if ((m_secondary_address != ZeroIPAddress) && !m_secondary_address.IsValid())
		{
			wsprintf(Msg, "Invalid DNS Secondary Address");
			::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPDnldMsgHeader, 
					MB_OK|MB_ICONEXCLAMATION);
				m_ctrl_secondary.SetFocus();
			return FALSE;
		}
	}
	return TRUE;
}

void CIPDNLD::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here
	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		UpdateData(TRUE);			//Get the dialog updates
		m_IPHdrWnd.EnableWindow(FALSE);
		m_IPAddrWnd.EnableWindow(FALSE);
		m_ctrl_user_assigned.ShowWindow(FALSE);
		m_ctrl_user_assigned.EnableWindow(FALSE);

		if (m_PortListWnd.GetCurSel() != 0)
		{
			m_staticMskWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
		}
		m_IPAddrStr = ZeroIPAddress; //reset address
		UpdateData(FALSE);		//display data in dialog
	}
	else
	{
		m_ctrl_user_assigned.ShowWindow(TRUE);
		m_ctrl_user_assigned.EnableWindow(TRUE);

		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
		m_staticMskWnd.EnableWindow(TRUE);
		m_MskWnd.EnableWindow(TRUE);
	}
}

void CIPDNLD::OnCheckRas()
{
	// TODO: Add your control notification handler code here
	if (m_ras_enable.GetCheck())
	{
		m_static_remote_addr.EnableWindow (TRUE);
		m_ctrl_remote_addr.EnableWindow (TRUE);
	}
	else
	{
		m_static_remote_addr.EnableWindow (FALSE);
		m_ctrl_remote_addr.EnableWindow (FALSE);
	}
//	UpdateData (FALSE);
	
}

void CIPDNLD::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_IP_DNLD, HELP_CONTEXT);
}

void CIPDNLD::OnSelchangeListPorts()
{
	// TODO: Add your control notification handler code here
	int PortIndex;
	BOOL rasctrl ;
	char StrLHS[40], StrRHS[40], StrRHS2[40] ;
	char PortString[20];

	UpdateData(TRUE);

	// TODO: Add your control notification handler code here
	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

	if (!ValidPortSettings())
	{
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}
	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPcheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_addr;

	m_ISPcheck = m_ISP[PortIndex];
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];

	m_ctrl_user_assigned.ShowWindow(m_ISPcheck);

	if (m_RAS[PortIndex])
		m_ras_enable.SetCheck (1);
	else
		m_ras_enable.SetCheck (0);

	m_remote_addr = m_RemoteAddr[PortIndex];
	m_static_remote_addr.EnableWindow(m_RAS[PortIndex]);
	m_ctrl_remote_addr.EnableWindow(m_RAS[PortIndex]);

/* sudha 14 nov 1998 */

/* sudha 17 Nov 1998 */		
/* modified by brindha on 30/4/99. */	
	sprintf(StrLHS,"WAN Port%d DialInOut Type",PortIndex-1);
	GetPrivateProfileString(WANSectionHeader,
		(LPCSTR) StrLHS, "0", (LPSTR) StrRHS, sizeof (StrRHS),
		(LPCSTR) FileName);

	if (!strcmp (StrRHS, "0"))
		m_ras_enable.EnableWindow ( FALSE ) ;
	else
		m_ras_enable.EnableWindow ( TRUE ) ;

	if ( m_MLPPP || !m_RAS[PortIndex])
		rasctrl = FALSE ;
	else
		rasctrl = TRUE ;

	if (PortIndex == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address

		m_port_static1.LoadString(IDS_LAN_SETUP1);
		m_port_static2.LoadString(IDS_LAN_SETUP2);

		m_ISPWnd.ShowWindow(FALSE);
		m_ras_enable.ShowWindow (FALSE);
		m_ctrl_remote_addr.ShowWindow (FALSE);
		m_static_remote_addr.ShowWindow (FALSE);

		m_ISPWnd.EnableWindow(FALSE);
		m_ras_enable.EnableWindow (FALSE);
		m_ctrl_remote_addr.EnableWindow (FALSE);
		m_static_remote_addr.EnableWindow (FALSE);

		m_ctrl_user_assigned.ShowWindow(TRUE);
		m_ctrl_user_assigned.EnableWindow(TRUE);

		//Change the group heading to that of the selected port
		strcpy(PortString,"LAN");
		m_sel_port = PortString;
	}
	else
	{
/* sudha 14 nov 1998 */
		m_ISPWnd.ShowWindow(TRUE);
		m_ras_enable.ShowWindow(TRUE);
		m_ctrl_user_assigned.ShowWindow(!m_ISPcheck);

		m_ISPWnd.EnableWindow(TRUE);
		m_ras_enable.EnableWindow(TRUE);
		m_ctrl_user_assigned.EnableWindow(!m_ISPcheck);

		m_ctrl_remote_addr.ShowWindow (TRUE);
		m_static_remote_addr.ShowWindow (TRUE);

		m_port_static1.LoadString(IDS_WAN_SETUP1);
		m_port_static2.LoadString(IDS_WAN_SETUP2);

		m_ctrl_remote_addr.EnableWindow (rasctrl);
		m_static_remote_addr.EnableWindow (rasctrl);

		if (m_nPorts <= 2)
			strcpy(PortString,"WAN");
		else
		{
			char Buf[10];

			sprintf(PortString, "WAN %d", PortIndex);
		}
		m_sel_port = PortString;
	}

	if ((model == MODEL_MTSR2_201) && (PortIndex == 1))
	{
		m_ras_enable.ShowWindow (FALSE);
		m_ctrl_remote_addr.ShowWindow (FALSE);
		m_static_remote_addr.ShowWindow (FALSE);

		m_ras_enable.EnableWindow (FALSE);
		m_ctrl_remote_addr.EnableWindow (FALSE);
		m_static_remote_addr.EnableWindow (FALSE);
	}

	m_IPHdrWnd.EnableWindow(!m_ISPcheck);
	m_IPAddrWnd.EnableWindow(!m_ISPcheck);
	m_staticMskWnd.EnableWindow(!m_ISPcheck);
	m_MskWnd.EnableWindow(!m_ISPcheck);


	UpdateData(FALSE);
	m_nOldPort = PortIndex;
}

void CIPDNLD::OnDhcpNo()
{
	// TODO: Add your control notification handler code here
	m_grp_dns.EnableWindow(FALSE);
	m_static_primary.EnableWindow(FALSE);
	m_static_secondary.EnableWindow(FALSE);

	m_ctrl_primary.EnableWindow(FALSE);
	m_ctrl_secondary.EnableWindow(FALSE);
	
}

void CIPDNLD::OnDhcpYes()
{
	// TODO: Add your control notification handler code here
	m_grp_dns.EnableWindow(TRUE);
	m_static_primary.EnableWindow(TRUE);
	m_static_secondary.EnableWindow(TRUE);

	m_ctrl_primary.EnableWindow(TRUE);
	m_ctrl_secondary.EnableWindow(TRUE);
	
}

void CIPDNLD::OnDhcpServerEnabled()
{
	// TODO: Add your control notification handler code here

	int TagIndex, index;
	char szLHS[40];
	char szRHS[MAX_INI_OPTN_LEN*3];
	char LAddr[20], HAddr[20] ;
	unsigned long addr1, addr2, addr3, addr4,laddr1,haddr1, gaddr ;

	addr1 = addr2 = addr3 = addr4 = 0L ;
	laddr1 = haddr1 = gaddr = 0L ;

	get_ip_address(m_IPAddr[0], &gaddr);

	LPCSTR ptmp;
	TagIndex = GetPrivateProfileInt ((LPCSTR) IPDnldSectionHeader, "IP Number of Ports",
			0, (LPCSTR) FileName);
	if (m_ctrl_dhcp_yes.GetCheck())
/* Sachin, Oct. 4th, 1997 */
	{
		ptmp = StrEnabled;
		for (int index = 0; index < TagIndex; index++)
		{
			wsprintf (szLHS, "IP Port%d BOOTP", index);
			WritePrivateProfileString ((LPCSTR) IPDnldSectionHeader, 
				(LPCSTR) szLHS, (LPCSTR) ptmp, (LPCSTR) FileName);
		}
	}
/* Sachin, Oct. 4th, 1997 */
	else
	{
		ptmp = StrDisabled;
		GetPrivateProfileString ((LPCSTR) DHCPSectHeader, "DHCP Client",
			StrDisabled, szRHS, sizeof (szRHS), (LPCSTR) FileName);
		if (!strcmp (szRHS, StrDisabled))
		{
			for (int index = 0; index < TagIndex; index++)
			{
				wsprintf (szLHS, "IP Port%d BOOTP", index);
				WritePrivateProfileString ((LPCSTR) IPDnldSectionHeader, 
					(LPCSTR) szLHS, (LPCSTR) ptmp, (LPCSTR) FileName);
			}
		}
	}

	WritePrivateProfileString((LPCSTR)DHCPServerSection,
		(LPCSTR)"DHCP Server", (LPCSTR)ptmp, (LPCSTR)FileName);
	//before anything we need to write count of entries

#if 0
	if(check_for_unique_entry_for_the_same_net(m_IPAddr[0],m_IPMask[0]) == TRUE)
#endif

	sscanf (m_IPAddr[0], "%03u.%03u.%03u.%03u", &addr1, &addr2, &addr3, &addr4) ;

	if ( addr4 > 150 )
	{
		laddr1 = 1;
		haddr1 = 100;
	}
	else
	{
		laddr1 = addr4 + 3;
		haddr1 = addr4 + 100;
	}

	LAddr[0] = 0;
	HAddr[0] = 0;

	sprintf(LAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,laddr1);
	sprintf(HAddr,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,haddr1);

/* Delete all the previous existing entries except for the default entry */
	
	TagIndex = GetPrivateProfileInt ((LPCSTR) DHCPServerSection, "DHCP Number of Tags",
			0, (LPCSTR) FileName);

	for ( index = 1; index < TagIndex; index++ )	
	{
//Delete the TagString first
		sprintf(szLHS, "DHCP Tag%d Address Range", index);
		WritePrivateProfileString((LPCSTR)DHCPServerSection,
				(LPCSTR)szLHS, NULL, (LPCSTR)FileName);

//Delete properties next
		sprintf(szLHS, "$A DHCP Tag%d Properties",index);
		WritePrivateProfileString((LPCSTR)DHCPServerSection,
			(LPCSTR)szLHS, NULL, (LPCSTR)FileName);

	}

	TagIndex = 1;
	sprintf(szRHS,"%d", TagIndex+1);
	WritePrivateProfileString((LPCSTR)DHCPServerSection,
		(LPCSTR)"DHCP Number of Tags", (LPCSTR)szRHS, (LPCSTR)FileName);

//Write the TagString first
	sprintf(szLHS, "DHCP Tag%d Address Range", TagIndex);
	sprintf(szRHS, "%s,%s,%s",LAddr,HAddr,m_IPMask[0]);
	WritePrivateProfileString((LPCSTR)DHCPServerSection,
			(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)FileName);

//write properties next
	sprintf(szLHS, "$A DHCP Tag%d Properties",TagIndex);
	sprintf(szRHS, "01,04,FFFFFF00,03,04,%lx,33,04,0000FFFF",gaddr); 
	WritePrivateProfileString((LPCSTR)DHCPServerSection,
		(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)FileName);
	return;
}

void CIPDNLD::OnOK()
{
	// TODO: Add extra validation here
	int index, function_type;
	char	szRHS[128], strRHS[10], fn_type[2];
	char	szLHSAddr[50];
	char	szLHSMask[40];
	char szPPPRHS[128];

	if (!UpdateData(TRUE))	
		return;
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidPortSettings())
		return;
	index = m_PortListWnd.GetCurSel();
	m_ISP[index] = m_ISPcheck;
	m_IPAddr[index] = m_IPAddrStr;
	m_IPMask[index] = m_MskStr;
	if (m_ras_enable.GetCheck())
		m_RAS[index] = 1;
	else
		m_RAS[index] = 0;
	m_RemoteAddr[index] = m_remote_addr;
	if (!index)	
	{
		m_RAS[index] = 0;
		m_RemoteAddr[index].Empty();
	}

	if (!ValidEditFields())
	{
		FirstTimeInEdit = 0;
		return;
	}

	//write the new values out into the ini file

	strcpy(szLHSAddr, "IP Port0 Address");
	strcpy(szLHSMask, "IP Port0 Address Mask");
	for (index = 0; index < m_nPorts; index++)
	{
		//Write IP Address
	  	WritePrivateProfileString ((LPCSTR) IPDnldSectionHeader,
			(LPCSTR) szLHSAddr, m_IPAddr[index], (LPCSTR) FileName) ;

		//If ISP assigned WAN address write 0.0.0.0 and
		// In PPP make local option negotiable
		if (index > 0)		//not for LAN port
		{
			wsprintf(szRHS, "PPP Port%d Option%%IPCP%%IP Address", index - 1);
		 	if (m_ISP[index] == TRUE)
			{
			// PPP local address is 0.0.0.0 and negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
			}
			else
			{
			// PPP local address is user assinged (non-0.0.0.0) and NOT negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) m_IPAddr[index]) ;
			}
			wsprintf(szRHS, "PPP Port%d Remote Option%%IPCP%%IP Address", index-1);
			if (m_RAS[index] == TRUE)
			{	
				if (m_RemoteAddr[index].IsEmpty())				
				{
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
/* sudha changed index from 1 to 0 on 14 nov 1998 */
					if (index > 0)
					{
					wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_IPAddr[0]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, ZeroIPAddress);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					}
					wsprintf (szRHS, "IP Port%d Remote Address", index);
				 	WritePrivateProfileString(IPDnldSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) ZeroIPAddress, (LPCSTR) FileName);
				}
				else
				{
#if 0
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 5, (LPCSTR) m_RemoteAddr[index]) ;
#endif
/* sudha changed index > 1 to index > 0 on 14 nov 1998 */

					if (index > 0)
					{
					wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_IPAddr[0]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_RemoteAddr[index]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					}
					wsprintf (szRHS, "IP Port%d Remote Address", index);
				 	WritePrivateProfileString(IPDnldSectionHeader, (LPCSTR) szRHS,
							m_RemoteAddr[index], (LPCSTR) FileName);
				}
				if (index > 0)
				{
					wsprintf (szRHS, "PPP Port%d Remote Port Client Only", index-1);
				 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) StrEnabled, (LPCSTR) FileName);

/* Sudha 11 June 1999.Since ras is enabled here,wan port function type has 
also to be updated properly with ras enabled.*/

					wsprintf (szRHS, "WAN Port%d Function Type", index-1);
				   GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, StrNull, strRHS, sizeof(strRHS),(LPCSTR) IniInWinForm) ;
					sscanf(strRHS,"%d",&function_type);

/* Whatever may be the previous function type, just set the ras bit also */
					function_type |= 0x04;
					sprintf(fn_type,"%d",function_type);
			   	WritePrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, (LPCSTR) fn_type, (LPCSTR) IniInWinForm) ;

/* Similarly, if wan dialinout type is previously dial out only, change it
to dial in out type */

					wsprintf (szRHS, "WAN Port%d DialInOut Type", index-1);
				   GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, StrNull, strRHS, sizeof(strRHS),(LPCSTR) IniInWinForm) ;
					sscanf(strRHS,"%d",&function_type);

					if (function_type == 0x00) /* if dial out type */
						function_type = 0x02;  /* assign dial in out type */

					sprintf(fn_type,"%d",function_type);
			   	WritePrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, (LPCSTR) fn_type, (LPCSTR) IniInWinForm) ;
					
				}
			}
			else
			{
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
/* sudha changed index from 1 to 0 on 14 nov 1998 */
				if (index > 0)
				{
				wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				}
				wsprintf (szRHS, "IP Port%d Remote Address", index);
			 	WritePrivateProfileString(IPDnldSectionHeader, (LPCSTR) szRHS,
						(LPCSTR) ZeroIPAddress, (LPCSTR) FileName);
				if (index > 0)
				{
					wsprintf (szRHS, "PPP Port%d Remote Port Client Only", index-1);
				 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) StrDisabled, (LPCSTR) FileName);

/* Sudha 11 June 1999.Since ras is disabled here,wan port function type has 
also to be updated properly with ras disabled.*/

					wsprintf (szRHS, "WAN Port%d Function Type", index-1);
				   GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, StrNull, strRHS, sizeof(strRHS),(LPCSTR) IniInWinForm) ;
					sscanf(strRHS,"%d",&function_type);

/* Whatever may be the previous function type, just mask the ras bit alone */

					function_type &= 0xFB;
					sprintf(fn_type,"%d",function_type);
			   	WritePrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, (LPCSTR) fn_type, (LPCSTR) IniInWinForm) ;
					

/* Similarly, if wan dialinout type is previously dial in out type, change it
to dial out type */

					wsprintf (szRHS, "WAN Port%d DialInOut Type", index-1);
				   GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, StrNull, strRHS, sizeof(strRHS),(LPCSTR) IniInWinForm) ;
					sscanf(strRHS,"%d",&function_type);

					if (function_type == 0x02) /* if dial in out type */
						function_type = 0x00;  /* assign dial in out type */

					sprintf(fn_type,"%d",function_type);
			   	WritePrivateProfileString (WANSectionHeader,
						(LPCSTR) szRHS, (LPCSTR) fn_type, (LPCSTR) IniInWinForm) ;
					

				}
			}
		}
		else		// the LAN IP address is to be copied into SNMP section also
		{
			WritePrivateProfileString ((LPCSTR) SNMPSectionHeader,
				(LPCSTR) "SNMP Local Internet Address",
					(LPCSTR) m_IPAddr[index], (LPCSTR) FileName) ;
		}
		//write subnet mask for the port
	 	WritePrivateProfileString(IPDnldSectionHeader, (LPCSTR) szLHSMask,
					m_IPMask[index], (LPCSTR) FileName);

		szLHSAddr[7]++;		//next Port
		szLHSMask[7]++;		//next Port
	}

	if (!m_primary_address.IsEmpty())
	{
		strcpy (szRHS, m_primary_address);
		WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address1", (LPCSTR) szRHS, (LPCSTR) FileName) ;
		for (index = 1; index < m_nPorts; index++)
		{
			wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address1", index-1);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
			wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address1", index-1);
			wsprintf (szRHS, "129,Auto,Negotiation Not Required,Not Negotiable,IP,%s", m_primary_address);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
		}
	}
	else
	{
		strcpy (szRHS, StrDisabled);
		WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address1", (LPCSTR) StrNull, (LPCSTR) FileName) ;
		
		for (index = 1; index < m_nPorts; index++)
		{
			wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address1", index-1);
			wsprintf (szRHS, "129,Auto,Negotiation Not Required,Negotiable,IP,%s", ZeroIPAddress);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address1", index-1);
			wsprintf (szRHS, "129,Auto,Negotiation Not Required,Not Negotiable,IP,%s", ZeroIPAddress);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
		}
	}

	if (!m_secondary_address.IsEmpty())
	{
		strcpy (szRHS, m_secondary_address);
		WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address2", (LPCSTR) szRHS, (LPCSTR) FileName) ;
		for (index = 1; index < m_nPorts; index++)
		{
			wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address2", index-1);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
			wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address2", index-1);
			wsprintf (szRHS, "131,Auto,Negotiation Not Required,Not Negotiable,IP,%s", m_secondary_address);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
		}
	}	 	
	else
	{
		strcpy (szRHS, StrDisabled);
		WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address2", (LPCSTR) StrNull, (LPCSTR) FileName) ;

		for (index = 1; index < m_nPorts; index++)
		{
			wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address2", index-1);
			wsprintf (szRHS, "131,Auto,Negotiation Not Required,Negotiable,IP,%s", ZeroIPAddress);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address2", index-1);
			wsprintf (szRHS, "131,Auto,Negotiation Not Required,Not Negotiable,IP,%s", ZeroIPAddress);
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
				szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
		}
	}

	OnDhcpServerEnabled();

	CDialog::OnOK();
}

BOOL CIPDNLD::check_for_unique_entry_for_the_same_net(const char *IPAddr, const char *IPMask)
{
	int TagIndex = 0, index;
	unsigned long laddr1,mask1,naddr2,mask2;
	char szLHS[40];
	char szRHS[MAX_INI_OPTN_LEN*3];
	char LAddr[20], HAddr[20], Mask[20];
	
	TagIndex = GetPrivateProfileInt ((LPCSTR) DHCPServerSection, "DHCP Number of Tags",
				0, (LPCSTR) FileName);

	for( index = 0; index < TagIndex; index++)
	{
		sprintf(szLHS, "DHCP Tag%d Address Range", index);
		GetPrivateProfileString(DHCPServerSection, szLHS, StrNull,
											szRHS, sizeof(szRHS), (LPCSTR) FileName);
		sscanf(szRHS,"%[^,],%[^,],%[^,]",LAddr, HAddr, Mask);
	
		get_ip_address (&LAddr[0], &laddr1);
		get_ip_address (&Mask[0], &mask1);
		get_ip_address (IPAddr, &naddr2);
		get_ip_address (IPMask, &mask2);
		if ((laddr1 & mask1) == (naddr2 & mask2))
		{
			sprintf(szLHS, "$A DHCP Tag%d Properties",index);
			sprintf(szRHS, "01,04,FFFFFF00,03,04,%lx,33,04,0000FFFF",naddr2); 
			WritePrivateProfileString((LPCSTR)DHCPServerSection,
				(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)FileName);
			
			return FALSE;
		}
	}
	return TRUE;
}

void CIPDNLD::OnCancel()
{
	CDialog::OnCancel();
}
