// ipfilter.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "ipfilter.h"
#include "tabdlg.h"
#include "maskdot.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
#define FILTER_STRING_LEN 80
#define MAX_FILTER_STRING_LENGTH 100

char FilteringMsgHeader[] = "ProxyServer - Filter Configuration Error" ;


char *PortTypes[] =
{
   " LAN", "WAN1", "WAN2", "WAN3", 
   "WAN4", "WAN5", "WAN6", "WAN7",
   "WAN8", "WAN9", "WAN10", "WAN11",
   "WAN12", "WAN13", "WAN14", "WAN15",
   "WAN16", "WAN17", ""
} ;

char *FilterStrings[] = 
{
   "IPX Filter Destination Address",
   "IPX Filter Source Address",
   "IPX Forward Destination Address",
   "IPX Forward Source Address",

   "Spanning Tree Filter Destination Address",
   "Spanning Tree Filter Source Address",
   "Spanning Tree Forward Destination Address",
   "Spanning Tree Forward Source Address",
   "Spanning Tree Filter Source or Destination Address",
   "Spanning Tree Forward Source or Destination Address",

   "IP Filter Destination Address",
   "IP Filter Source Address",
   "IP Forward Destination Address",
   "IP Forward Source Address",

   "IP Filter Destination Port",
   "IP Filter Source Port",
   "IP Forward Destination Port",
   "IP Forward Source Port",

   ""
} ;

char *TCPPorts[] = {"TELNET", "FTP", "SFTP", ""} ;
char *TCPPortNumbers[] = {"0023", "0021", "0115", ""} ;
char *UDPPorts[] = {"TFTP", "SFTP", ""} ;
char *UDPPortNumbers[] = {"0069", "0115", ""} ;

char DefFilterString[] = "filter" ;
char DefForwardString[] = "forward" ;

int DisplayMessage (char *, LPCSTR, int) ;
int IsHexString (char *) ;
int IsDecimalString (char *) ;
void RightJustify (char *SrcString, char *DestString, int Length) ;

BOOL bICMPWritten = FALSE ;
BOOL bIPPortandAddressWritten = FALSE ;

/////////////////////////////////////////////////////////////////////////////
// IPFiltering dialog

int CurrentActiveChild = 0 ;
BOOL bActionEdit = FALSE ;

char UDPExtra[100] ;
char TCPExtra[100] ;

IPFiltering::IPFiltering(CWnd* pParent /*=NULL*/)
	: CTabDialog(IPFiltering::IDD, pParent)
{
	//{{AFX_DATA_INIT(IPFiltering)
   int i ;

   tabcount = 2 ;
   CurrentActiveChild = 0 ;

   for (i = 0 ; i < tabcount ; i++)
      m_pdlgIPFilterTypes[i] = new IPFilterType(this) ;

	ICMPFilterTabDialog = new ICMPFilterTab(this) ;
	//}}AFX_DATA_INIT

	bICMPWritten = FALSE ;
	bIPPortandAddressWritten = FALSE ;
}

void IPFiltering::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(IPFiltering)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(IPFiltering, CTabDialog)
	//{{AFX_MSG_MAP(IPFiltering)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// IPFiltering message handlers


void IPFiltering::GetConfig(void)
{
   for (int i = 0 ; i < tabcount ; i++)
   {
      switch (i)
      {
         case (0) : /* Port Filtering */
            m_pdlgIPFilterTypes[i]->m_IPFilterListHeader = "\tType\t\t    Port\t    Protocol\tProtocol Port" ;
            break ;

         case (1) : /* Address Filtering */
            m_pdlgIPFilterTypes[i]->m_IPFilterListHeader = "\tType\t\t\t Port\t\tIP Address" ;
            break ;
      }
      m_pdlgIPFilterTypes[i]->UpdateData(FALSE) ;
   }
}

char IPFilteringCfgChanged = 0 ;
char DefaultFilterType = 0 ;


BOOL IPFiltering::OnInitDialog()
{
   int nTabStops[] = {3, 2} ;
   int TabStops[3][5] ;
   char FilterString[FILTER_STRING_LEN], IniString[257] ;
	char far *Temp, far *NextAddress ;
   char StringToSearch[MAX_FILTER_STRING_LENGTH] ;
   int FilterType, PortNumber ;
   char DefaultAction[10] ;
   char Index[8] = "$A " ;

   CurrentActiveChild = 0 ;

   TabStops[0][0] = 90 ;
   TabStops[0][1] = 125 ;
   TabStops[0][2] = 180 ;
   TabStops[0][3] = 260 ;

   TabStops[1][0] = 110 ;
   TabStops[1][1] = 165 ;
   TabStops[1][2] = 250 ;

	CDialog::OnInitDialog();

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

   char Buf[3][25] ;
   strcpy (Buf[0], "&Port Filtering") ;
   strcpy (Buf[1], "Address &Filtering") ;
	strcpy (Buf[2], "&ICMP Filtering") ;
   IPFilteringCfgChanged = 0 ;

   GetPrivateProfileString (IPSectionHeader, "IP Filtering Default Action",
        DefForwardString, (LPSTR) DefaultAction, 10, (LPCSTR) IniInWinForm) ;

	if (strcmpi (DefFilterString, DefaultAction) == 0)
		DefaultFilterType = 0 ;
	else
		DefaultFilterType = 1 ;

   for (int i = 0 ; i < tabcount ; i++)
   {
      addTabView (m_pdlgIPFilterTypes[i], Buf[i], TRUE, (i == 0), 150) ;
      m_pdlgIPFilterTypes[i]->m_IPFilterListControl.SetTabStops (nTabStops[i],
																			&TabStops[i][0]) ;
		m_pdlgIPFilterTypes[i]->m_IPFilterDefaultActionControl.SetCurSel (
																						DefaultFilterType) ;

      switch (i)
      {
         case (0) : /* Port Filtering */
            for (FilterType = 0 ; FilterType < NUMBER_OF_IP_PORT_FILTERS ;
						FilterType ++)
            {
               strcpy (Index, "$A ") ;
               while (1)
               {
                  strcpy (StringToSearch, Index) ;
                  Index[1]++ ;
                  strcat (StringToSearch,
							FilterStrings[FilterType+IP_PORT_FILTERS_BASE_INDEX]) ;
                  GetPrivateProfileString (IPSectionHeader, StringToSearch,
                    StrNull, (LPSTR) IniString, 256, (LPCSTR) IniInWinForm) ;

                  if (IniString[0] == 0)
                     break ;

                  sscanf (&IniString[0], "%d", &PortNumber) ;
                  NextAddress = &IniString[0] ;
                  while ((*NextAddress != ',') && (*NextAddress != 0))
							NextAddress ++ ;
                  NextAddress ++ ;
                  while (1)
                  {
                     FilterString[0] = 0 ;
                     strcat (FilterString, &FilterStrings[FilterType 
														 +IP_PORT_FILTERS_BASE_INDEX][3]) ;
                     strcat (FilterString, "\t") ;
                     strcat (FilterString, PortTypes[PortNumber]) ;
                     strcat (FilterString, "\t") ;
                     strncat (FilterString, NextAddress, 3) ;
                     strcat (FilterString, "\t") ;
                     while ((*NextAddress != ',') && (*NextAddress != 0))
								NextAddress ++ ;
                     NextAddress ++ ;
                     Temp = strrchr (FilterString, 0) ;
                     while ((*NextAddress != ',') && (*NextAddress != 0))
                        *Temp ++ = *NextAddress ++ ;
                     *Temp = 0 ;
                     m_pdlgIPFilterTypes[i]->m_IPFilterListControl.AddString (
																								FilterString) ;

                     if (*NextAddress == 0)
                        break ;
                     NextAddress ++ ;
                  }
               }
            }
            m_pdlgIPFilterTypes[i]->UpdateData (FALSE) ;

            break ;

         case (1) : /* Address Filtering */
            for (FilterType = 0 ; FilterType < NUMBER_OF_IP_ADDRESS_FILTERS ;
									FilterType ++)
            {
               strcpy (Index, "$A ") ;
               while (1)
               {
                  strcpy (StringToSearch, Index) ;
                  Index[1] ++ ;
                  strcat (StringToSearch, FilterStrings[FilterType +
														IP_ADDRESS_FILTERS_BASE_INDEX]) ;
                  GetPrivateProfileString (IPSectionHeader, StringToSearch,
                     StrNull, (LPSTR) IniString, 256, (LPCSTR) IniInWinForm) ;

                  if (IniString[0] == 0)
                     break ;

                  sscanf (&IniString[0], "%d", &PortNumber) ;
                  NextAddress = &IniString[0] ;
                  while ((*NextAddress != ',') && (*NextAddress != 0))
							NextAddress ++ ;
                  NextAddress ++ ;
                  while (1)
                  {
                     FilterString[0] = 0 ;
                     strcat (FilterString, &FilterStrings[FilterType + 
													IP_ADDRESS_FILTERS_BASE_INDEX][3]) ;
                     strcat (FilterString, "\t") ;
                     strcat (FilterString, PortTypes[PortNumber]) ;
                     strcat (FilterString, "\t") ;
                     Temp = strrchr (FilterString, 0) ;
                     while ((*NextAddress != ',') && (*NextAddress != 0))
                        *Temp ++ = *NextAddress ++ ;
                     *Temp = 0 ;
                     m_pdlgIPFilterTypes[i]->m_IPFilterListControl.AddString (
																					FilterString) ;

                     if (*NextAddress == 0)
                        break ;
                     NextAddress ++ ;
                  }
               }
            }
            m_pdlgIPFilterTypes[i]->UpdateData (FALSE) ;

            break ;
      }
		////Prabha, 20/2/98 the edit and remove buttons can be disabled
		////if the list is empty
   	if (!m_pdlgIPFilterTypes[i]->m_IPFilterListControl.GetCount())
		{
			m_pdlgIPFilterTypes[i]->m_edit.EnableWindow (FALSE);
			m_pdlgIPFilterTypes[i]->m_remove.EnableWindow (FALSE);
		}
   }

	addTabView (ICMPFilterTabDialog, Buf[2], TRUE, FALSE, 150) ;
#if 0
	ICMPFilterDialog->m_AddressMaskRequest = TRUE ;
	ICMPFilterDialog->m_DestinationUnreachable = TRUE ;
	ICMPFilterDialog->m_EchoReply = TRUE ;
	ICMPFilterDialog->m_EchoRequest = TRUE ;
	ICMPFilterDialog->m_ParameterProblem = TRUE ;
	ICMPFilterDialog->m_Redirect = TRUE ;
	ICMPFilterDialog->m_SourceQuench = TRUE ;
	ICMPFilterDialog->m_TimeExceed = TRUE ;
	ICMPFilterDialog->m_TimeStampResponse = TRUE ;
	ICMPFilterDialog->m_TimeStampRequest = TRUE ;
	ICMPFilterDialog->m_AddressMaskResponse = TRUE ;
	ICMPFilterDialog->UpdateData (FALSE) ;
#endif

   GetConfig() ;
   AfxGetApp()->DoWaitCursor (0);

   CTabDialog::OnInitDialog() ;
   CenterWindow() ;

	return FALSE;  // return TRUE  unless you set the focus to a control
}

void IPFiltering::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CTabDialog::OnCancel();
}


#define MAX_ADDRESS_FILTERS_PER_STRING 4
#define MAX_PORT_FILTERS_PER_STRING 6
void IPFiltering::OnOK()
{
   int Tab, PortNumber, FirstPosition, NextPosition, i, j, NumberOfFiltersInCurrentString, NumberOfFilters ;
   char DisplayString[80], SearchString[100], FilterStringLHS[100], FilterStringRHS[250], FilterIndex[5], TempBuff[5] ;
   char *TempPointer, *DefaultActionStrings[] = {"filter", "forward"} ;

	for (Tab = 0 ; Tab < tabcount ; Tab++)
		m_pdlgIPFilterTypes[Tab]->UpdateData (TRUE) ;

   UpdateData(TRUE) ;

#if 0
   if (IPFilteringCfgChanged == 0)
   {
      CTabDialog::OnOK() ;
      return ;
   }
#endif

	NumberOfFilters = m_pdlgIPFilterTypes[0]->m_IPFilterListControl.GetCount() 
 	         + m_pdlgIPFilterTypes[1]->m_IPFilterListControl.GetCount() ;

	WritePrivateProfileString (IPSectionHeader, (LPCSTR) "IP Filtering Default Action",
          DefaultActionStrings[m_pdlgIPFilterTypes[0]->m_IPFilterDefaultActionControl.GetCurSel()],
			 			(LPCSTR) IniInWinForm) ;

	sprintf (TempBuff, "%d", NumberOfFilters) ;
   WritePrivateProfileString (IPSectionHeader, "IP Number of Filtering Database Entries",
                              TempBuff, (LPCSTR) IniInWinForm) ;

   for (Tab = 0 ; Tab < tabcount ; Tab++)
   {
      switch (Tab)
      {
         case (0) : /* Port Filters */

         for (i = 0 ; i < NUMBER_OF_IP_PORT_FILTERS ; i++)
         {
				strcpy (FilterIndex, "$A ") ;
				while (1)
				{
				   strcpy (SearchString, FilterIndex) ;
				   strcat (SearchString, FilterStrings[IP_PORT_FILTERS_BASE_INDEX+i]) ;

				   GetPrivateProfileString (IPSectionHeader, SearchString,
				                         StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
				   if (FilterStringRHS[0] == 0)
				      break ;
				    WritePrivateProfileString (IPSectionHeader, SearchString,
				                         StrNull, (LPCSTR) IniInWinForm) ;
					FilterIndex[1]++ ;
				}

				strcpy (FilterIndex, "$A ") ;
            for (j = 0 ; j < NUMBER_OF_PORTS ; j++)
            {
               PortNumber = j ;

               strcpy (SearchString, &FilterStrings[IP_PORT_FILTERS_BASE_INDEX+i][3]) ;
               strcat (SearchString, "\t") ;
               strcat (SearchString, PortTypes[j]) ;

               FirstPosition = NextPosition = m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.FindString(-1, SearchString) ;
               sprintf (TempBuff, "%02d", PortNumber) ;
               if (FirstPosition == LB_ERR)
                  continue ;

               NumberOfFiltersInCurrentString = 0 ;

               strcpy (FilterStringLHS, FilterIndex) ;
               strcat (FilterStringLHS, FilterStrings[IP_PORT_FILTERS_BASE_INDEX+i]) ;
               strcpy (FilterStringRHS, TempBuff) ;

               while (1)
               {
                  strcat (FilterStringRHS, ",") ;
                  m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.GetText (NextPosition, DisplayString) ;
                  TempPointer = strchr (DisplayString, '\t') ;
                  TempPointer++ ;
                  TempPointer = strchr (TempPointer, '\t') ;
                  TempPointer++ ;

                  NumberOfFiltersInCurrentString++ ;
                  strcat (FilterStringRHS, TempPointer) ;
                  TempPointer = strchr (FilterStringRHS, '\t') ;
                  *TempPointer = ',' ;

                  NextPosition = m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.FindString (NextPosition, SearchString) ;
                  if (NextPosition <= FirstPosition)
                     break ;

                  if (NumberOfFiltersInCurrentString >= MAX_PORT_FILTERS_PER_STRING)
                  {
                     WritePrivateProfileString (IPSectionHeader, (LPCSTR)FilterStringLHS,
                                                FilterStringRHS, (LPCSTR) IniInWinForm) ;

                     FilterIndex[1]++ ;
                     strcpy (FilterStringLHS, FilterIndex) ;
                     strcat (FilterStringLHS, FilterStrings[IP_PORT_FILTERS_BASE_INDEX+i]) ;
                     sprintf (TempBuff, "%02d", PortNumber) ;
                     strcpy (FilterStringRHS, TempBuff) ;
                     NumberOfFiltersInCurrentString = 0 ;
                  }
               }
               if (NumberOfFiltersInCurrentString != 0)
					{
                  WritePrivateProfileString (IPSectionHeader, FilterStringLHS,
                                             FilterStringRHS, (LPCSTR) IniInWinForm) ;
						FilterIndex[1]++ ;
					}

#if 0
DeleteOldIPPortStrings :
               while (1)
               {
                  strcpy (SearchString, FilterIndex) ;
                  strcat (SearchString, FilterStrings[IP_PORT_FILTERS_BASE_INDEX+i]) ;

                  GetPrivateProfileString (IPSectionHeader, SearchString,
                                        StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
                  if (FilterStringRHS[0] == 0)
                     break ;
						sprintf (TempBuff, "%02d", PortNumber) ;
                  if (strncmp (FilterStringRHS, TempBuff, strlen (TempBuff)) == 0)
                     WritePrivateProfileString (IPSectionHeader, SearchString,
                                        StrNull, (LPCSTR) IniInWinForm) ;
						else
							break ;

						FilterIndex[1]++ ;
               }
#endif
            }
         }
         break ;

         case (1) : /* Address Filters */

         for (i = 0 ; i < NUMBER_OF_IP_ADDRESS_FILTERS ; i++)
         {
				/* Wipe off all old strings */
				strcpy (FilterIndex, "$A ") ;
				while (1)
				{
				   strcpy (SearchString, FilterIndex) ;
				   strcat (SearchString, FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+i]) ;

				   GetPrivateProfileString (IPSectionHeader, SearchString,
				                         StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
				   if (FilterStringRHS[0] == 0)
				      break ;
				   WritePrivateProfileString (IPSectionHeader, SearchString,
				                         NULL, (LPCSTR) IniInWinForm) ;
					FilterIndex[1]++ ;
				}

				strcpy (FilterIndex, "$A ") ;
            for (j = 0 ; j < NUMBER_OF_PORTS ; j++)
            {
					PortNumber = j ;

               strcpy (SearchString, &FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+i][3]) ;
               strcat (SearchString, "\t") ;
               strcat (SearchString, PortTypes[j]) ;

               FirstPosition = NextPosition = m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.FindString(-1, SearchString) ;
               sprintf (TempBuff, "%02d", PortNumber) ;
               if (FirstPosition == LB_ERR)
						continue ;

               NumberOfFiltersInCurrentString = 0 ;

               strcpy (FilterStringLHS, FilterIndex) ;
               strcat (FilterStringLHS, FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+i]) ;
               strcpy (FilterStringRHS, TempBuff) ;

               while (1)
               {
                  strcat (FilterStringRHS, ",") ;
                  m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.GetText (NextPosition, DisplayString) ;
                  TempPointer = strchr (DisplayString, '\t') ;
                  TempPointer++ ;
                  TempPointer = strchr (TempPointer, '\t') ;
                  TempPointer++ ;

                  NumberOfFiltersInCurrentString++ ;
                  strcat (FilterStringRHS, TempPointer) ;

                  NextPosition = m_pdlgIPFilterTypes[Tab]->m_IPFilterListControl.FindString (NextPosition, SearchString) ;
                  if (NextPosition <= FirstPosition)
                     break ;

                  if (NumberOfFiltersInCurrentString >= MAX_ADDRESS_FILTERS_PER_STRING)
                  {
                     WritePrivateProfileString (IPSectionHeader, (LPCSTR)FilterStringLHS,
                                                FilterStringRHS, (LPCSTR) IniInWinForm) ;

                     FilterIndex[1]++ ;
                     strcpy (FilterStringLHS, FilterIndex) ;
                     strcat (FilterStringLHS, FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+i]) ;
                     sprintf (TempBuff, "%02d", PortNumber) ;
                     strcpy (FilterStringRHS, TempBuff) ;
                     NumberOfFiltersInCurrentString = 0 ;
                  }
               }
               if (NumberOfFiltersInCurrentString != 0)
					{
                  WritePrivateProfileString (IPSectionHeader, FilterStringLHS,
                                             FilterStringRHS, (LPCSTR) IniInWinForm) ;
						FilterIndex[1]++ ;
					}

#if 0
DeleteOldIPAddressStrings :
               while (1)
               {
                  strcpy (SearchString, FilterIndex) ;
                  strcat (SearchString, FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+i]) ;

                  GetPrivateProfileString (IPSectionHeader, SearchString,
                                        StrNull, (LPSTR)FilterStringRHS, 250, (LPCSTR)IniInWinForm) ;
                  if (FilterStringRHS[0] == 0)
                     break ;
                  if (strncmp (FilterStringRHS, TempBuff, strlen (TempBuff)) == 0)
                     WritePrivateProfileString (IPSectionHeader, SearchString,
                                        StrNull, (LPCSTR) IniInWinForm) ;
						FilterIndex[1]++ ;
               }
#endif
            }
         }
         break ;
      }
   }
	
	CTabDialog::OnOK();

	bIPPortandAddressWritten = TRUE ;
	if (!bICMPWritten)
	{
		ICMPFilterTabDialog->OnOK() ;
		bICMPWritten = TRUE ;
	}
}




/////////////////////////////////////////////////////////////////////////////
// IPFilterType dialog


IPFilterType::IPFilterType(CWnd* pParent /*=NULL*/)
	: CDialog(IPFilterType::IDD, pParent)
{
	//{{AFX_DATA_INIT(IPFilterType)
	m_IPFilterListHeader = "";
	//}}AFX_DATA_INIT
   Create (IDD, NULL) ;
}

void IPFilterType::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(IPFilterType)
	DDX_Control(pDX, IDC_BUTTON_IP_FILTER_REMOVE, m_remove);
	DDX_Control(pDX, IDC_BUTTON_IP_FILTER_EDIT, m_edit);
	DDX_Control(pDX, IDC_COMBO_IP_FILTER_DEFAULT_ACTION, m_IPFilterDefaultActionControl);
	DDX_Control(pDX, IDC_STATIC_IP_FILTER_TYPE_HEADER, m_IPFilterListHeaderControl);
	DDX_Control(pDX, IDC_LIST_IP_FILTER, m_IPFilterListControl);
	DDX_Text(pDX, IDC_STATIC_IP_FILTER_TYPE_HEADER, m_IPFilterListHeader);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(IPFilterType, CDialog)
	//{{AFX_MSG_MAP(IPFilterType)
   ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_BUTTON_IP_FILTER_ADD, OnButtonIpFilterAdd)
	ON_BN_CLICKED(IDC_BUTTON_IP_FILTER_REMOVE, OnButtonIpFilterRemove)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BUTTON_IP_FILTER_EDIT, OnButtonIpFilterEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// IPFilterType message handlers

void IPFilterType::OnCancel()
{
   GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void IPFilterType::OnOK()
{
	// TODO: Add extra validation here
	if(!UpdateData(TRUE))
		return;

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}

LRESULT IPFilterType::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
   if (CurrentActiveChild == 0)
      CurrentActiveChild = 1 ;
   else
  	   CurrentActiveChild = 0 ;

	UpdateData(TRUE);
	DefaultFilterType = m_IPFilterDefaultActionControl.GetCurSel() ;

	return (0L);
}


LRESULT IPFilterType::OnSwitchToIden(WPARAM wParam, LPARAM lParam)
{
	m_IPFilterDefaultActionControl.SetCurSel(DefaultFilterType) ;

	UpdateData(FALSE);
	return (0L);
}

void IPFilterType::PostNcDestroy(void)
{
	delete this;
}


BOOL IPFilterType::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	// TODO: Add extra initialization here

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BUTTON_IP_FILTER_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BUTTON_IP_FILTER_REMOVE, this));
	DeleteBmpBtn.SizeToContent();

	if (!EditBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load EDIT bitmap");

	VERIFY (EditBmpBtn.SubclassDlgItem (IDC_BUTTON_IP_FILTER_EDIT, this));
	EditBmpBtn.SizeToContent();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

char NewIPAddress[3+1+3+1+3+1+3+ 2] ;
char NewIPProtocolPort[10] ;
int NewIPPort, NewIPFilterType, NewIPProtocol ;
char NewIPFilterAdded = 0 ;

void IPFilterType::OnButtonIpFilterAdd()
{
	// TODO: Add your control notification handler code here

	bActionEdit = FALSE ;

   NewIPFilterAdded = 0 ;
   char FilterString[FILTER_STRING_LEN] ;
   char *IPProtocols[] = {"TCP", "UDP"} ;

	// Added by cfp on 5-7-96
	// This is to prevent Add Dialog boxes getting mixed for
	// Port Filtering Tab and Address Filtering Tab
	IPFiltering *pParent = (IPFiltering *) GetParent() ;
	if (pParent->m_pdlgIPFilterTypes[0] == this)
		CurrentActiveChild = 0 ; 		
	else
		if (pParent->m_pdlgIPFilterTypes[1] == this)
			CurrentActiveChild = 1 ; 		

   if (CurrentActiveChild == 1)
   {
      NewIPAddressFilter AddIPAddressFilter ;
      AddIPAddressFilter.DoModal() ;
      if (NewIPFilterAdded == 0)
         return ;

      IPFilteringCfgChanged = 1 ;
      FilterString[0] = 0 ;
      strcat (FilterString, &FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+NewIPFilterType][3]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, PortTypes[NewIPPort]) ;
      strcat (FilterString, "\t") ;
      strncat (FilterString, NewIPAddress, 3+1+3+1+3+1+3) ;

		if (!DuplicateString (FilterString))
	      m_IPFilterListControl.AddString (FilterString) ;
   }
   else
   {
      NewIPPortFilter AddIPPortFilter ;
      AddIPPortFilter.DoModal() ;

      if (NewIPFilterAdded == 0)
         return ;

      IPFilteringCfgChanged = 1 ;
      FilterString[0] = 0 ;
      strcat (FilterString, &FilterStrings[IP_PORT_FILTERS_BASE_INDEX+NewIPFilterType][3]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, PortTypes[NewIPPort]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, IPProtocols[NewIPProtocol]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, NewIPProtocolPort) ;
		if (!DuplicateString (FilterString))
	      m_IPFilterListControl.AddString (FilterString) ;
   }
}

void IPFilterType::OnButtonIpFilterRemove()
{
	// TODO: Add your control notification handler code here

   int DeleteFilterIndex ;
   DeleteFilterIndex = m_IPFilterListControl.GetCurSel() ;
   if (DeleteFilterIndex == LB_ERR)
      return ;

   m_IPFilterListControl.DeleteString (DeleteFilterIndex) ;
   IPFilteringCfgChanged = 1 ;

   UpdateData (FALSE) ;
}

void IPFilterType::OnButtonIpFilterEdit()
{
	// TODO: Add your control notification handler code here

	bActionEdit = TRUE ;

	// Added by cfp 
	// This is to prevent Add Dialog boxes getting mixed for
	// Port Filtering Tab and Address Filtering Tab
	IPFiltering *pParent = (IPFiltering *) GetParent() ;
	if (pParent->m_pdlgIPFilterTypes[0] == this)
		CurrentActiveChild = 0 ; 		
	else
		if (pParent->m_pdlgIPFilterTypes[1] == this)
			CurrentActiveChild = 1 ; 		
 
   char FilterString[FILTER_STRING_LEN] ;
   char *IPProtocols[] = {"TCP", "UDP"} ;
	int nCurSel ;
	int nRetVal ;

   if (CurrentActiveChild == 1)
   {
		nCurSel = m_IPFilterListControl.GetCurSel() ;
		if (nCurSel == CB_ERR)
			return ;

      NewIPAddressFilter EditIPAddressFilter ;
      nRetVal = EditIPAddressFilter.DoModal() ;

		if (nRetVal == IDCANCEL)
			return ;

      if (NewIPFilterAdded == 0)
         return ;

      IPFilteringCfgChanged = 1 ;
      FilterString[0] = 0 ;
      strcat (FilterString, &FilterStrings[IP_ADDRESS_FILTERS_BASE_INDEX+NewIPFilterType][3]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, PortTypes[NewIPPort]) ;
      strcat (FilterString, "\t") ;
      strncat (FilterString, NewIPAddress, 3+1+3+1+3+1+3) ;
		if (!DuplicateString (FilterString))
		{
			m_IPFilterListControl.DeleteString (nCurSel) ;
	      m_IPFilterListControl.AddString (FilterString) ;
		}
   }
   else
   {
		nCurSel = m_IPFilterListControl.GetCurSel() ;
		if (nCurSel == CB_ERR)
			return ;

      NewIPPortFilter EditIPPortFilter ;

      nRetVal = EditIPPortFilter.DoModal() ;

		if (nRetVal == IDCANCEL)
			return ;

      if (NewIPFilterAdded == 0)
         return ;

      IPFilteringCfgChanged = 1 ;
      FilterString[0] = 0 ;
      strcat (FilterString, &FilterStrings[IP_PORT_FILTERS_BASE_INDEX+NewIPFilterType][3]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, PortTypes[NewIPPort]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, IPProtocols[NewIPProtocol]) ;
      strcat (FilterString, "\t") ;
      strcat (FilterString, NewIPProtocolPort) ;
		if (!DuplicateString (FilterString))
		{
			m_IPFilterListControl.DeleteString (nCurSel) ;
	      m_IPFilterListControl.AddString (FilterString) ;
		}
   }
}

BOOL IPFilterType::DuplicateString (CString StrInBox)
{
	int nCount = m_IPFilterListControl.GetCount() ;
	char buf[128];
	CString Str;
	unsigned long addr1, addr2;
	
	if (CurrentActiveChild == 1)
	{
		strcpy (buf, StrInBox);
		addr1 = GetUlongAddress (buf);
		for (int i = 0 ; i < nCount ; i ++)
		{
			m_IPFilterListControl.GetText (i, buf) ;
			addr2 = GetUlongAddress (buf);
			if (addr1 == addr2)
			{
				::MessageBox (GetParent()->GetSafeHwnd(), "Duplicate Entry will not be added", 
							"Warning", MB_OK | MB_ICONINFORMATION) ;
				return TRUE ;
			}
		}
	}
	else
	{
		for (int i = 0 ; i < nCount ; i ++)
		{
			m_IPFilterListControl.GetText (i, Str) ;
			if (Str == StrInBox)
			{
				::MessageBox (GetParent()->GetSafeHwnd(), "Duplicate Entry will not be added", 
							"Warning", MB_OK | MB_ICONINFORMATION) ;
				return TRUE ;
			}
		}		
	}
	return FALSE ;
}

void IPFilterType::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_IP_FILTERING_TYPE,HELP_CONTEXT);
}

unsigned long IPFilterType::GetUlongAddress (char buf[])
{
	unsigned long address;
	char *ch;
	while ((ch = strchr (buf, (int) '\t')) != NULL)
	{
		strcpy (buf, ++ch);
	}
	get_ip_address (buf, &address);
	return address;
}

/////////////////////////////////////////////////////////////////////////////
// NewIPAddressFilter dialog


NewIPAddressFilter::NewIPAddressFilter(CWnd* pParent /*=NULL*/)
	: CDialog(NewIPAddressFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(NewIPAddressFilter)
	m_IPAddress = "";
	//}}AFX_DATA_INIT
}

void NewIPAddressFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(NewIPAddressFilter)
	DDX_Control(pDX, IDC_EDIT_NEW_IP_ADD_ADDRESS, m_NewIPAddrWnd);
	DDX_Control(pDX, IDC_COMBO_NEW_IP_ADD_TYPE, m_TypeControl);
	DDX_Control(pDX, IDC_COMBO_NEW_IP_ADD_PORT, m_PortControl);
	DDX_Text(pDX, IDC_EDIT_NEW_IP_ADD_ADDRESS, m_IPAddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(NewIPAddressFilter, CDialog)
	//{{AFX_MSG_MAP(NewIPAddressFilter)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// NewIPAddressFilter message handlers

BOOL NewIPAddressFilter::OnInitDialog()
{
   char NumberOfPortsString[10] ;
   int i, NumberOfPorts ;

	char *AddressForwardFilterStrings[] =
	{
   	"Filter Destination Address",
		"Filter Source Address",
   	"Forward Destination Address",
		"Forward Source Address"
	} ;


	CDialog::OnInitDialog();

	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

   GetPrivateProfileString (WANSectionHeader, "WAN Number of Ports",
                            StrNull, (LPSTR)NumberOfPortsString, 10, (LPCSTR)IniInWinForm) ;
   sscanf (NumberOfPortsString, "%d", &NumberOfPorts) ;
   NumberOfPorts++ ;

   for (i = 0 ; i < NumberOfPorts ; i++)
      m_PortControl.InsertString (i, PortTypes[i]) ;
   m_TypeControl.SetCurSel(0) ;
   m_PortControl.SetCurSel(0) ;

	IPFiltering *pParent ;
	int nCurSel ;
	char *pTab ;
   char FilterString[FILTER_STRING_LEN], StoreFilter[FILTER_STRING_LEN] ;

	if (bActionEdit)
	{
		pParent = (IPFiltering *) GetParent() ;
		
		nCurSel =
			pParent->m_pdlgIPFilterTypes[CurrentActiveChild]->m_IPFilterListControl.GetCurSel() ;
		pParent->m_pdlgIPFilterTypes[CurrentActiveChild]->m_IPFilterListControl.GetText (nCurSel, FilterString) ;
		pTab = strchr (FilterString, (int) '\t') ;
		if (pTab != NULL)
		{
			*pTab = 0x00 ;
			for (i = 0 ; i < 4 ; i ++)
			{
				if (strcmp (AddressForwardFilterStrings[i], FilterString) == 0)
					break ;
			}
			m_TypeControl.SetCurSel (i) ;

			pTab ++ ;
			strcpy (StoreFilter, pTab) ;
			strcpy (FilterString, StoreFilter) ;
			pTab = strchr (FilterString, (int) '\t') ;

			if (pTab != NULL)
			{
				*pTab = 0x00 ;
				nCurSel = m_PortControl.FindStringExact (-1, FilterString) ;
				m_PortControl.SetCurSel (nCurSel) ;

				pTab ++ ;
				m_IPAddress = pTab ;
			}
		}
	}
   UpdateData (FALSE) ;
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void NewIPAddressFilter::OnCancel()
{
	// TODO: Add extra cleanup here
   NewIPFilterAdded = 0 ;
	
	CDialog::OnCancel();
}


void NewIPAddressFilter::OnOK()
{
	// TODO: Add extra validation here

   UpdateData (TRUE) ;

   NewIPPort = m_PortControl.GetCurSel() ;
   if ((!m_IPAddress.IsValid()) || (m_IPAddress.IsEmpty())
#ifndef BOOTP
				|| m_IPAddress == ZeroIPAddress)
#endif
   {
      NewIPAddress[0] = 0 ;
      NewIPFilterAdded = 0 ;
      RouMsgBox(MSG_FILT_INVALID_IP_ADDRESS, FilteringMsgHeader,MB_OK | MB_ICONINFORMATION);
		m_NewIPAddrWnd.SetFocus() ;
		return ;
   }
   else
   {
      strcpy (NewIPAddress, m_IPAddress.GetBuffer(0)) ;
		NewIPFilterType = m_TypeControl.GetCurSel() ;
		if (NewIPFilterType == CB_ERR)
			NewIPFilterAdded = 0 ;
		else
      	NewIPFilterAdded = 1 ;
   }
	IPFiltering *pParent = (IPFiltering *) GetParent();
	pParent->m_pdlgIPFilterTypes[1]->m_edit.EnableWindow (TRUE);
	pParent->m_pdlgIPFilterTypes[1]->m_remove.EnableWindow (TRUE);
	pParent->m_pdlgIPFilterTypes[1]->UpdateData (FALSE);

	CDialog::OnOK();
}

void NewIPAddressFilter::OnHelp()
{
	// TODO: Add your control notification handler code here
   AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_NEW_IP_ADDRESS_FILTER,HELP_CONTEXT);
	
}

int	NewIPAddressFilter::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	char NewHeader[50] ;
	int	Ret_val;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

/////////////////////////////////////////////////////////////////////////////
// NewIPPortFilter dialog


NewIPPortFilter::NewIPPortFilter(CWnd* pParent /*=NULL*/)
	: CDialog(NewIPPortFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(NewIPPortFilter)
	m_ProtocolPort = "";
	//}}AFX_DATA_INIT
}

void NewIPPortFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(NewIPPortFilter)
	DDX_Control(pDX, IDC_COMBO_NEW_IP_PROTOCOL, m_ProtocolControl);
	DDX_Control(pDX, IDC_COMBO_NEW_IP_PORT_TYPE, m_TypeControl);
	DDX_Control(pDX, IDC_COMBO_NEW_IP_PORT_PROT_PORT, m_ProtocolPortControl);
	DDX_Control(pDX, IDC_COMBO_NEW_IP_PORT_PORT, m_PortControl);
	DDX_CBString(pDX, IDC_COMBO_NEW_IP_PORT_PROT_PORT, m_ProtocolPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(NewIPPortFilter, CDialog)
	//{{AFX_MSG_MAP(NewIPPortFilter)
	ON_CBN_SELCHANGE(IDC_COMBO_NEW_IP_PROTOCOL, OnSelchangeComboNewIpProtocol)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// NewIPPortFilter message handlers

void NewIPPortFilter::OnCancel()
{
	// TODO: Add extra cleanup here
	
   NewIPFilterAdded = 0 ;
	CDialog::OnCancel();
}

void NewIPPortFilter::OnOK()
{
	// TODO: Add extra validation here
   int NewIPProtocolPortIndex ;
	char TempBuff[20] ;

   UpdateData (TRUE) ;

   NewIPProtocol = m_ProtocolControl.GetCurSel() ;
   NewIPPort = m_PortControl.GetCurSel() ;
   NewIPProtocolPortIndex = m_ProtocolPortControl.GetCurSel() ;
   NewIPFilterType = m_TypeControl.GetCurSel() ;
   if (NewIPProtocolPortIndex != CB_ERR)
   {
      if (NewIPProtocol == 0)
		{
			if (NewIPProtocolPortIndex < 3)
			{
/*	         strcpy (m_ProtocolPort.GetBuffer(4),
							TCPPortNumbers[NewIPProtocolPortIndex]) ; */
				m_ProtocolPort = TCPPortNumbers[NewIPProtocolPortIndex] ;
			}
		}
      else
		{
			if (NewIPProtocolPortIndex < 2)
			{
/*	         strcpy (m_ProtocolPort.GetBuffer(4),
							UDPPortNumbers[NewIPProtocolPortIndex]) ; */
				m_ProtocolPort = UDPPortNumbers[NewIPProtocolPortIndex] ;
			}
		}
/*      m_ProtocolPort.ReleaseBuffer(-1) ; */
   }

	// Added by cfp on 12-4-96
	if (m_ProtocolPort.IsEmpty())
	{
      NewIPFilterAdded = 0 ;
      RouMsgBox (MSG_FILT_INVALID_IP_PORT,
					FilteringMsgHeader, MB_OK | MB_ICONINFORMATION) ;
		m_ProtocolPortControl.SetFocus() ;
		return ;
	}

   m_ProtocolPort.MakeUpper() ;
   strcpy (NewIPProtocolPort, (LPCSTR) m_ProtocolPort) ;
   if ((NewIPProtocolPort[0] == 0) ||
				(!IsDecimalString (&NewIPProtocolPort[0])))
   {
      NewIPFilterAdded = 0 ;
      RouMsgBox (MSG_FILT_INVALID_IP_PORT,
					FilteringMsgHeader, MB_OK | MB_ICONINFORMATION) ;
		m_ProtocolPortControl.SetFocus() ;
		return ;
   }
   else
   {
		strcpy (TempBuff, NewIPProtocolPort) ;
		RightJustify (TempBuff, NewIPProtocolPort, 4) ;
      NewIPFilterAdded = 1 ;
   }
	IPFiltering *pParent = (IPFiltering *) GetParent();
	pParent->m_pdlgIPFilterTypes[0]->m_edit.EnableWindow (TRUE);
	pParent->m_pdlgIPFilterTypes[0]->m_remove.EnableWindow (TRUE);
	pParent->m_pdlgIPFilterTypes[0]->UpdateData (FALSE);
	CDialog::OnOK();
}


BOOL NewIPPortFilter::OnInitDialog()
{
   char NumberOfPortsString[10] ;
   char FilterString[FILTER_STRING_LEN], StoreFilter[FILTER_STRING_LEN] ;
   int i, NumberOfPorts ;
	IPFiltering *pParent ;
	int nCurSel = 0 ;
	int nType = 0 ;
	char *pTab ;

	char *PortForwardFilterStrings[] =
	{
   	"Filter Destination Port",
		"Filter Source Port",
   	"Forward Destination Port",
		"Forward Source Port"
	} ;

	CDialog::OnInitDialog();

	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

   GetPrivateProfileString (IPSectionHeader, "IP Number of Ports",
              StrNull, (LPSTR)NumberOfPortsString, 5, (LPCSTR)IniInWinForm) ;
   sscanf (NumberOfPortsString, "%d", &NumberOfPorts) ;
   NumberOfPorts++ ;	//Add for one LAN port
	if ( NumberOfPorts > 15 )
		NumberOfPorts = 15;

   for (i = 0 ; i < NumberOfPorts ; i++)
      m_PortControl.InsertString (i, PortTypes[i]) ;

	if (!bActionEdit)
	{
	   i = 0 ;
	   while (TCPPorts[i][0] != 0)
	   {
   	   m_ProtocolPortControl.InsertString (i, TCPPorts[i]) ;
	      i++ ;
	   }

	   m_PortControl.SetCurSel(0) ;
	   m_TypeControl.SetCurSel(0) ;
   	m_ProtocolControl.SetCurSel(0) ;
	}
	else
	{
		pParent = (IPFiltering *) GetParent() ;
		nCurSel =
			pParent->m_pdlgIPFilterTypes[CurrentActiveChild]->m_IPFilterListControl.GetCurSel() ;
		pParent->m_pdlgIPFilterTypes[CurrentActiveChild]->m_IPFilterListControl.GetText (nCurSel, FilterString) ;
		pTab = strchr (FilterString, (int) '\t') ;
		if (pTab != NULL)
		{
			*pTab = 0x00 ;
			for (i = 0 ; i < 4 ; i ++)
			{
				if (strcmp (PortForwardFilterStrings[i], FilterString) == 0)
					break ;
			}
			m_TypeControl.SetCurSel (i) ;

			pTab ++ ;
			strcpy (StoreFilter, pTab) ;
			strcpy (FilterString, StoreFilter) ;
			pTab = strchr (FilterString, (int) '\t') ;
			if (pTab != NULL)
			{
				*pTab = 0x00 ;
				nType = m_PortControl.FindStringExact (-1, FilterString) ;
				m_PortControl.SetCurSel (nType) ;

				pTab ++ ;
				strcpy (StoreFilter, pTab) ;
				strcpy (FilterString, StoreFilter) ;
				pTab = strchr (FilterString, (int) '\t') ;
				if (pTab != NULL)
				{
					*pTab = 0x00 ;
					nType = m_ProtocolControl.FindStringExact (-1, FilterString) ;
					m_ProtocolControl.SetCurSel (nType) ;

					i = 0 ;
					if (nType == 0)
					{
						while (TCPPorts[i][0] != 0)
						{
							m_ProtocolPortControl.InsertString (i, TCPPorts[i]) ;
							i ++ ;
						}
					}
					else
					{
						if (nType == 1)
						{
							while (UDPPorts[i][0] != 0)
							{
								m_ProtocolPortControl.InsertString (i, UDPPorts[i]) ;
								i ++ ;
							}
						}
					}

					BOOL bInCode = FALSE ;
					i = 0 ;
					pTab ++ ;
					strcpy (StoreFilter, pTab) ;
					if (nType == 0)
					{
						while (TCPPortNumbers[i][0] != 0)
						{
							if (strcmp (TCPPortNumbers[i], StoreFilter) == 0)
							{
								m_ProtocolPort = TCPPorts[i] ;
								bInCode = TRUE ;
								UDPExtra[0] = 0x00 ;
								TCPExtra[0] = 0x00 ;
								break ;
							}
							i ++ ;
						}
					}
					else
					{
						if (nType == 1)
						{
							while (UDPPortNumbers[i][0] != 0)
							{
								if (strcmp (UDPPortNumbers[i], StoreFilter) == 0)
								{
									m_ProtocolPort = UDPPorts[i] ;
									bInCode = TRUE ;
									UDPExtra[0] = 0x00 ;
									TCPExtra[0] = 0x00 ;
									break ;
								}
								i ++ ;
							}
						}
					}
					if (!bInCode)
					{
						i = m_ProtocolPortControl.GetCount() ;
						m_ProtocolPortControl.InsertString (i, StoreFilter) ;
						m_ProtocolPort = StoreFilter ;
						if (nType == 0)
							strcpy (TCPExtra, StoreFilter) ;
						else
							if (nType == 1)
								strcpy (UDPExtra, StoreFilter) ;
					}
				}
			}
		}
	}

   UpdateData (FALSE) ;
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void NewIPPortFilter::OnSelchangeComboNewIpProtocol()
{
	// TODO: Add your control notification handler code here
   int ProtocolIndex, i ;

   ProtocolIndex = m_ProtocolControl.GetCurSel() ;

   switch (ProtocolIndex)
   {
      case (0) : /* TCP */
         m_ProtocolPortControl.ResetContent() ;
         i = 0 ;
         while (TCPPorts[i][0] != 0)
         {
            m_ProtocolPortControl.InsertString (i, TCPPorts[i]) ;
            i++ ;
         }
			if (TCPExtra[0])
            m_ProtocolPortControl.InsertString (i, TCPExtra) ;
         break ;

      case (1) : /* UDP */
         m_ProtocolPortControl.ResetContent() ;
         i = 0 ;
         while (UDPPorts[i][0] != 0)
         {
            m_ProtocolPortControl.InsertString (i, UDPPorts[i]) ;
            i++ ;
         }
			if (UDPExtra[0])
            m_ProtocolPortControl.InsertString (i, UDPExtra) ;
         break ;

      default :
         break ;
   }
}

void NewIPPortFilter::OnHelp()
{
	// TODO: Add your control notification handler code here
   AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_NEW_IP_PORT_FILTER,HELP_CONTEXT);
	
}

int	NewIPPortFilter::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

void RightJustify (char *SrcString, char *DestString, int Length)
{
	int i ;
	int Temp, SrcStringLength = strlen (SrcString) ;

	for (i = 0 ; i < Length ; i++)
		DestString[i] = '0' ;
	DestString[Length] = 0 ;

	Temp = SrcStringLength ;
	while (Temp--)
	{
		DestString[Length-1] = SrcString[SrcStringLength-1] ;

		SrcStringLength-- ;
		Length-- ;
	}

   return ;
}

int IsHexString (char *String)
{
   while (*String != 0)
   {
      if (!(((*String >= '0') &&
          (*String <= '9')) ||
         ((*String >= 'a') &&
          (*String <= 'f')) ||
         ((*String >= 'A') &&
          (*String <= 'F'))))
          return 0 ;
      String++ ;
   }
   return 1 ;
}

int IsDecimalString (char *String)
{
	while (*String)
	{
		if (!((*String <= '9') && (*String >= '0')))
			return 0 ;
		String++ ;
	}
	return 1 ;
}

/////////////////////////////////////////////////////////////////////////////
// ICMPFilter dialog


ICMPFilter::ICMPFilter(CWnd* pParent /*=NULL*/)
	: CDialog(ICMPFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(ICMPFilter)
	m_AddressMaskRequest = FALSE;
	m_DestinationUnreachable = FALSE;
	m_EchoReply = FALSE;
	m_EchoRequest = FALSE;
	m_ParameterProblem = FALSE;
	m_Redirect = FALSE;
	m_SourceQuench = FALSE;
	m_TimeExceed = FALSE;
	m_TimeStampResponse = FALSE;
	m_TimeStampRequest = FALSE;
	m_AddressMaskResponse = FALSE;
	//}}AFX_DATA_INIT

	Create (IDD, NULL) ;
}

void ICMPFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ICMPFilter)
	DDX_Check(pDX, IDC_CHECK_ADDRESS_MASK_REQ, m_AddressMaskRequest);
	DDX_Check(pDX, IDC_CHECK_DESTINATION_UNREACHABLE, m_DestinationUnreachable);
	DDX_Check(pDX, IDC_CHECK_ECHO_REPLY, m_EchoReply);
	DDX_Check(pDX, IDC_CHECK_ECHO_REQUEST, m_EchoRequest);
	DDX_Check(pDX, IDC_CHECK_PARAMETER_PROBLEM, m_ParameterProblem);
	DDX_Check(pDX, IDC_CHECK_REDIRECT, m_Redirect);
	DDX_Check(pDX, IDC_CHECK_SOURCE_QUENCH, m_SourceQuench);
	DDX_Check(pDX, IDC_CHECK_TIME_EXCEED, m_TimeExceed);
	DDX_Check(pDX, IDC_CHECK_TIME_STAMP_REP, m_TimeStampResponse);
	DDX_Check(pDX, IDC_CHECK_TIME_STAMP_REQ, m_TimeStampRequest);
	DDX_Check(pDX, IDC_CHECK1_ADDRESS_MASK_REP, m_AddressMaskResponse);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ICMPFilter, CDialog)
	//{{AFX_MSG_MAP(ICMPFilter)
   ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_BUTTON_ICMP_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ICMPFilter message handlers

BOOL ICMPFilter::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_ICMP_HELP, this));
	HelpBmpBtn.SizeToContent();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void ICMPFilter::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void ICMPFilter::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_ICMP_FILTERING,HELP_CONTEXT);
}

void ICMPFilter::OnOK()
{
	// TODO: Add extra validation here
	if(!UpdateData(TRUE))
		return;

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}


LRESULT ICMPFilter::OnSwitchToIden(WPARAM wParam, LPARAM lParam)
{
	CurrentActiveChild = 2 ;
	return (0L);
}

LRESULT ICMPFilter::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	return (0L);
}

void ICMPFilter::PostNcDestroy(void)
{
	delete this;
}
/////////////////////////////////////////////////////////////////////////////
// ICMPFilterTab dialog


ICMPFilterTab::ICMPFilterTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(ICMPFilterTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(ICMPFilterTab)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	Create (IDD, NULL) ;
}

void ICMPFilterTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ICMPFilterTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(ICMPFilterTab, CTabDialog)
	//{{AFX_MSG_MAP(ICMPFilterTab)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// ICMPFilterTab message handlers

BOOL ICMPFilterTab::OnInitDialog ()
{
	int i, j, NumberOfPorts = 4 ;
	BOOL Enabled ;
	char NumberOfPortsString[10] ;
	char *Ports[] = {"&LAN", "WAN &1", "WAN &2", "WAN &3", ""} ;
	char ICMPRHS[80] ;
	char ICMPLHS[] = "IP Port0 ICMP Packet Types" ;
	char *TempPointer ;

	tabcount = 4 ;
   GetPrivateProfileString (WANSectionHeader, "WAN Number of Ports",
		      StrNull, (LPSTR) NumberOfPortsString, 
					sizeof (NumberOfPortsString), (LPCSTR) IniInWinForm) ;
	if (NumberOfPortsString[0])
	{
   	sscanf (NumberOfPortsString, "%d", &NumberOfPorts) ;
   	tabcount = ++NumberOfPorts ; // i.e. 1 Lan + No of Wan's
	}
	
	for (i = 0 ; i < tabcount ; i++)
		ICMPFilterDialog[i] = new ICMPFilter (this) ;

// TABSONRIGHT or TABSONLEFT or BOTTOM does not allow for accelerator keys, 
// so don't use them.
//	setTabPosition (TABSONRIGHT) ;

#define NUMBER_OF_TYPES 11
	for (i = 0 ; i < NumberOfPorts ; i++)
	{
		addTabView (ICMPFilterDialog[i], Ports[i], TRUE, (i==0), 50) ;
		
	   GetPrivateProfileString (IPSectionHeader, ICMPLHS,
                 StrNull, (LPSTR) ICMPRHS,
					  	sizeof (ICMPRHS), (LPCSTR) IniInWinForm) ;

		ICMPLHS[7]++ ;
		TempPointer = &ICMPRHS[0] ;
		for (j = 0 ; j < NUMBER_OF_TYPES ; j++)
		{
			if (TempPointer == NULL)
				Enabled = FALSE ;
			else
				if (strncmp (TempPointer, "enable", 6) == 0)
					Enabled = TRUE ;
				else
					Enabled = FALSE ;

			if (TempPointer)
				TempPointer = strstr (TempPointer, ",") ;
			if (TempPointer != NULL) 
				TempPointer++ ;

			switch (j)
			{
				case (0) :
					ICMPFilterDialog[i]->m_EchoReply = Enabled ;
					break ;
				case (1) :
					ICMPFilterDialog[i]->m_DestinationUnreachable = Enabled ;
					break ;
				case (2) :
					ICMPFilterDialog[i]->m_SourceQuench = Enabled ;
					break ;
				case (3) :
					ICMPFilterDialog[i]->m_Redirect = Enabled ;
					break ;
				case (4) :
					ICMPFilterDialog[i]->m_EchoRequest = Enabled ;
					break ;
				case (5) :
					ICMPFilterDialog[i]->m_TimeExceed = Enabled ;
					break ;
				case (6) :
					ICMPFilterDialog[i]->m_ParameterProblem = Enabled ;
					break ;
				case (7) :
					ICMPFilterDialog[i]->m_TimeStampRequest = Enabled ;
					break ;
				case (8) :
					ICMPFilterDialog[i]->m_TimeStampResponse = Enabled ;
					break ;
				case (9) :
					ICMPFilterDialog[i]->m_AddressMaskRequest = Enabled ;
					break ;
				case (10) :
					ICMPFilterDialog[i]->m_AddressMaskResponse = Enabled ;
					break ;
				default :
					break ;
			}
		}
		ICMPFilterDialog[i]->UpdateData (FALSE) ;
	}

	CTabDialog::OnInitDialog() ;
	CenterWindow() ;
	return FALSE;  // return TRUE  unless you set the focus to a control
}


void ICMPFilterTab::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CTabDialog::OnCancel();
}


void ICMPFilterTab::OnOK()
{
	// TODO: Add extra cleanup here
	int i ;
	char RHSString[100] ;
	char ICMPEnableStr[7] = "enable", ICMPDisableStr[8] = "disable" ;
	char ICMPLHS[] = "IP Port0 ICMP Packet Types" ;

	for (i = 0 ; i < tabcount ; i++)
	{
		RHSString[0] = 0 ;
		ICMPFilterDialog[i]->UpdateData (TRUE) ;
		
		if (ICMPFilterDialog[i]->m_EchoReply)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_DestinationUnreachable)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_SourceQuench)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_Redirect)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_EchoRequest)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_TimeExceed)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_ParameterProblem)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_TimeStampRequest)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_TimeStampResponse)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_AddressMaskRequest)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;
		strcat (RHSString, ",") ;

		if (ICMPFilterDialog[i]->m_AddressMaskResponse)
			strcat (RHSString, ICMPEnableStr) ;
		else
			strcat (RHSString, ICMPDisableStr) ;

		WritePrivateProfileString (IPSectionHeader, (LPCSTR)ICMPLHS, RHSString, (LPCSTR)IniInWinForm) ;
		ICMPLHS[7]++ ;
	}
	
	CTabDialog::OnOK();

	IPFiltering *pParent = (IPFiltering *) GetParent() ;
	bICMPWritten = TRUE ;

	if (!bIPPortandAddressWritten)
	{
		pParent->OnOK() ;
		bIPPortandAddressWritten = TRUE ;
	}

}

