// ipprx.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include	"dot.h"
#include "maskdot.h"
#include "ipprx.h"
#include "hardware.h"

#include "iproutes.h"

char	*IPMsgHeader="IP Setup";
LPCSTR IPSectionHeader ="IP Routing" ;
LPCSTR DHCPSectionHeader = "DHCP" ;
extern LPCSTR TNETSectionHeader;

extern BOOL DefaultSetup ; /* Sudha 3 June 1998 */

#define MIN_DEFAULT_TTL			0
#define MAX_DEFAULT_TTL			255
#define MIN_REASSM_TMOUT		1
#define MAX_REASSM_TMOUT		100

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ipprx dialog


ipprx::ipprx(CWnd* pParent /*=NULL*/)
	: CDialog(ipprx::IDD, pParent)
{
	//{{AFX_DATA_INIT(ipprx)
	m_ISPCheck = FALSE;
	m_MskStr = "";
	m_GwayStr = "";
	m_nDefaultTTL = 0;
	m_IPAddrStr = "";
	m_primary_address = "";
	m_secondary_address = "";
	m_remote_address = "";
	m_server_address = "";
	m_nReassemTimeout = 0;
	//}}AFX_DATA_INIT
}

void ipprx::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ipprx)
	DDX_Control(pDX, IDC_BUTTON_STAT_HOST, m_static_routes);
	DDX_Control(pDX, IDC_STATIC_OTHER, m_other_setup);
	DDX_Control(pDX, IDC_STATIC_TTL, m_ttl);
	DDX_Control(pDX, IDC_STATIC_GATEWAY, m_gateway);
	DDX_Control(pDX, IDC_STATIC_REASSM, m_reassm);
	DDX_Control(pDX, IDC_STATIC_CLIENT, m_static_client);
	DDX_Control(pDX, IDC_STATIC_DNS, m_static_dns);
	DDX_Control(pDX, IDC_STATIC_DHCP, m_static_dhcp);
	DDX_Control(pDX, IDC_EDIT_SERVER_ADDRESS, m_ctrl_server_address);
	DDX_Control(pDX, IDC_EDIT_REMOTE_ADDRESS, m_ctrl_remote_address);
	DDX_Control(pDX, IDC_STATIC_SERVER_ADDRESS, m_static_server_address);
	DDX_Control(pDX, IDC_CHECK_CLIENT, m_check_client);
	DDX_Control(pDX, IDC_STATIC_REMOTE_ADDRESS, m_static_remote_address);
	DDX_Control(pDX, IDC_CHECK_RAS, m_ras_enable);
	DDX_Control(pDX, IDC_STATIC_SECONDARY_ADDRESS, m_ctrl_static_secondary_address);
	DDX_Control(pDX, IDC_STATIC_PRIMARY_ADDRESS, m_ctrl_static_primary_address);
	DDX_Control(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_ctrl_secondary_address);
	DDX_Control(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_ctrl_primary_address);
	DDX_Control(pDX, IDC_STATIC_MASK, m_staticMskWnd);
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_STATIC_SEL_PORT, m_SelPortGrp);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_EDIT_REASSM, m_RTOWnd);
	DDX_Control(pDX, IDC_EDIT_TTL, m_TTLWnd);
	DDX_Control(pDX, IDC_EDIT_GATEWAY, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPCheck);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Text(pDX, IDC_EDIT_GATEWAY, m_GwayStr);
	DDX_Text(pDX, IDC_EDIT_TTL, m_nDefaultTTL);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_PRIMARY_ADDRESS, m_primary_address);
	DDX_Text(pDX, IDC_EDIT_SECONDARY_ADDRESS, m_secondary_address);
	DDX_Text(pDX, IDC_EDIT_REMOTE_ADDRESS, m_remote_address);
	DDX_Text(pDX, IDC_EDIT_SERVER_ADDRESS, m_server_address);
	DDX_Text(pDX, IDC_EDIT_REASSM, m_nReassemTimeout);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(ipprx, CDialog)
	//{{AFX_MSG_MAP(ipprx)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	ON_BN_CLICKED(IDC_CHECK_RAS, OnCheckRas)
	ON_BN_CLICKED(IDC_CHECK_CLIENT, OnCheckClient)
	ON_BN_CLICKED(IDC_BUTTON_STAT_HOST, OnButtonStatHost)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// ipprx message handlers

void ipprx::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here

	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		UpdateData(TRUE);			//Get the dialog updates
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
		if (m_PortListWnd.GetCurSel() != 0)
		{
			m_staticMskWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
		}
		m_IPAddrStr = ZeroIPAddress; //reset address
		UpdateData(FALSE);		//display data in dialog
	}
	else
	{
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
		m_staticMskWnd.EnableWindow(TRUE);
		m_MskWnd.EnableWindow(TRUE);
	}
}

BOOL ipprx::OnInitDialog()
{
	CDialog::OnInitDialog();
////////////////////////////////////////////////////////////////////////////
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////

	if (!FiltBitmapBtn.LoadBitmaps ("FILT1", "FILT2", "FILT3", "FILT4"))
		AfxMessageBox ("Failed to load Filtering bitmap");

	VERIFY (FiltBitmapBtn.SubclassDlgItem (IDC_FILTERING, this));
	FiltBitmapBtn.SizeToContent();

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!StaticBitmapBtn.LoadBitmaps ("STATIC1", "STATIC2", "STATIC3", "STATIC4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (StaticBitmapBtn.SubclassDlgItem (IDC_BUTTON_STAT_HOST, this));
	StaticBitmapBtn.SizeToContent();

	// Read the configuration file and init the variables
	int	index;
	char	szRHS[40];
	char	szLHS[40];
	CDotDecimal DotValue;

    // Checking for UPGRADE PROXY - Brindha on 28/7/98
    if (CommandLineArgument == 6)
		strcpy(FileName, NewIniInWinForm);
    else
	    strcpy(FileName, IniInWinForm);


	m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",4,
				(LPCSTR) FileName);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	// If MLPPP is enabled no ras is possible for now
	m_MLPPP = FALSE;
	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
			StrNull, szRHS, sizeof(szRHS), FileName))
		m_MLPPP = TRUE;


	for (index = 0; index < m_nPorts; index++)
	{
		//Get IP address of the port
		wsprintf (szLHS, "IP Port%d Address", index);
	  	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
			(LPCSTR) szLHS, ZeroIPAddress, (LPSTR) szRHS,
									sizeof (szRHS), (LPCSTR) FileName) ;
		DotValue = 	m_IPAddr[index] = szRHS;
		if ( ! DotValue.IsValid())
			m_IPAddr[index] = ZeroIPAddress;

		//If IP address == 0.0.0.0 then it is ISP assigned
		m_ISP[index] = FALSE;
		if (index > 0)		//not for LAN port
			if ( ! strcmp((LPCSTR)m_IPAddr[index], ZeroIPAddress))
				m_ISP[index] = TRUE;

		//Get subnet mask for the port
		wsprintf (szLHS, "IP Port%d Address Mask", index);
	 	GetPrivateProfileString(IPSectionHeader, (LPCSTR) szLHS,
 					ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   				(LPCSTR) FileName);
   	m_IPMask[index] = szRHS;
		if ( ! verify_ip_subnet_mask((LPCSTR)m_IPMask[index]))
			m_IPMask[index] = ZeroIPAddress;

		////Prabha, 11/3/98, for RAS support
		m_RAS[index] = 0;
		if ((index > 0) && !m_MLPPP)
		{
			wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index-1);
		  	GetPrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szLHS, StrDisabled, (LPSTR) szRHS,
										sizeof (szRHS), (LPCSTR) FileName) ;
			if (!strcmp (szRHS, StrEnabled))
				m_RAS[index] = 1;
		}

		wsprintf(szLHS, "IP Port%d Remote Address", index);
	  	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
			(LPCSTR) szLHS, StrNull, (LPSTR) szRHS,
								sizeof (szRHS), (LPCSTR) FileName) ;
		m_RemoteAddr[index] = szRHS;
	}

	if ( DefaultSetup == TRUE )
	{
		RECT FullRect ;
		RECT ClipRect ;
		
		GetWindowRect (&FullRect) ;
		m_other_setup.GetWindowRect (&ClipRect) ;
		FullRect.bottom = ClipRect.top ;
		MoveWindow (&FullRect, TRUE) ;

		m_other_setup.EnableWindow ( FALSE  ) ;

		m_GwayWnd.EnableWindow (FALSE) ;
		m_gateway.EnableWindow (FALSE);
		m_TTLWnd.EnableWindow (FALSE) ;
		m_ttl.EnableWindow (FALSE) ;
		m_RTOWnd.EnableWindow (FALSE) ;
		m_reassm.EnableWindow (FALSE) ;
		m_static_client.EnableWindow (FALSE) ;
		m_ctrl_primary_address.EnableWindow (FALSE) ;
		m_ctrl_secondary_address.EnableWindow (FALSE) ;
		m_ctrl_static_primary_address.EnableWindow (FALSE) ;
		m_ctrl_static_secondary_address.EnableWindow (FALSE) ;
		m_static_dns.EnableWindow (FALSE) ;
		m_check_client.EnableWindow (FALSE) ;
		m_static_server_address.EnableWindow (FALSE) ;
		m_ctrl_server_address.EnableWindow (FALSE) ;
		m_static_dhcp.EnableWindow (FALSE) ;
	}

	else
	{
		//Readin the other information
		m_nDefaultTTL = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
					(LPCSTR) "IP Default TTL", 255, (LPCSTR) FileName) ;

		m_nReassemTimeout = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
					(LPCSTR) "IP Reassembly Timeout", 30, (LPCSTR) FileName) ;

		char *comma; // To break the string at ',' .
		GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP Default Route", (LPCSTR) StrNull,
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
	
		if ((comma = strchr (szRHS, (int) ',')) != NULL)
  		{
	   		*comma = '\0' ;
   			DotValue = m_GwayStr = szRHS;
	   		m_nDefaultMetric = (UINT) atoi(++ comma) ;
  		}
		else
		{
			m_nDefaultMetric = 1 ; // If not provided, default to 1
		}
		
		if (!DotValue.IsEmpty() && !DotValue.IsValid())
			m_GwayStr= "" ;
			
		////Prabha, 2/3/98, Strings for DNS
		GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address1", (LPCSTR) StrNull, 
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
		m_primary_address = szRHS;
			
		GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address2", (LPCSTR) StrNull, 
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
		m_secondary_address = szRHS;		
		
		////For DHCP support
		GetPrivateProfileString ((LPCSTR) DHCPSectionHeader, 
			(LPCSTR) "DHCP Client", (LPCSTR) StrDisabled, 
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
		if (!strcmp (szRHS, StrEnabled))
		{		
			m_check_client.SetCheck(1);
			GetPrivateProfileString ((LPCSTR) DHCPSectionHeader, 
				(LPCSTR) "DHCP Server IP Address", (LPCSTR) StrNull, 
					(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName);
			m_server_address = szRHS;
		}	
		else
		{
			m_check_client.SetCheck(0);
			m_static_server_address.EnableWindow (FALSE);
			m_ctrl_server_address.EnableWindow (FALSE);
		}		
	}

	//Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < m_nPorts-1; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
	m_IPAddrStr = m_IPAddr[m_nOldPort];
 	m_MskStr = m_IPMask[m_nOldPort];
	m_ISPCheck = m_ISP[m_nOldPort];
	m_ISPWnd.EnableWindow(FALSE);
	m_SelPortGrp.SetWindowText("LAN");
	m_ras_enable.EnableWindow (FALSE);
	m_ctrl_remote_address.EnableWindow (FALSE);
	m_static_remote_address.EnableWindow (FALSE);

/* sudha 22 June 1999.Since we support proxy, ag, ras in isdn model also */
#if 0
	if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT))
	{
		m_static_dhcp.EnableWindow (FALSE);
		m_check_client.EnableWindow(FALSE);
		m_static_server_address.EnableWindow (FALSE);
		m_ctrl_server_address.EnableWindow (FALSE);
	}
#endif

	UpdateData(FALSE);
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void ipprx::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_IP, HELP_CONTEXT);
	
}

BOOL ipprx::ValidPortSettings()
{
	int selected_port;
	CDotDecimal DotValue;
	unsigned long addr1, addr2, mask1, mask2;
	char szLHS[50], szRHS[50];


	DotValue = m_IPAddrStr;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

	if(m_ISPCheck)			// If ISP assigns we make it 0.0.0.0
		DotValue = ZeroIPAddress;
	else
	{
		if (!DotValue.IsValid())
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( ! verify_ip_subnet_mask((LPCSTR)m_MskStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE ;
	}

	////Prabha, 11/3/98, validity of remote address
	if (m_PortListWnd.GetCurSel())
	{
/* sudha 29 July 1999.Checking first, whether wan is enabled for this port.*/
		selected_port = m_PortListWnd.GetCurSel();
		if(selected_port > 0)
		{
			sprintf(szLHS,"WAN Port%d",selected_port - 1);
			GetPrivateProfileString (WANSectionHeader,
				(LPCSTR)szLHS, StrDisabled, (LPSTR) szRHS, sizeof (szRHS),
					(LPCSTR) IniInWinForm) ;
			if(!strcmp(szRHS,StrEnabled))
			{
				if (m_ras_enable.GetCheck())
				{
					if (!strcmp (m_remote_address, ZeroIPAddress) || m_remote_address.IsEmpty()) 
					{	// remote address is not given, DHCP client must be enabled
						if ( DefaultSetup != TRUE )
						{
							if (!m_check_client.GetCheck())
							{
								::MessageBox (GetSafeHwnd(), (LPCSTR) "Need IP address or DHCP client enabled",
									(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
								m_ctrl_remote_address.SetFocus() ;
								return FALSE ;
							}
						}
					}
					else
					{
						if (!m_remote_address.IsValid())
						{
							::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Remote Address",
									(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
							m_ctrl_remote_address.SetFocus() ;
							return FALSE ;
						}
						if (!strcmp (m_remote_address, m_IPAddr[0]))
						{
							::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses are same",
								(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
							m_IPAddrWnd.SetFocus() ;
							return FALSE ;
						}
						get_ip_address (m_IPAddr[0], &addr1);
						get_ip_address (m_IPMask[0], &mask1);
						get_ip_address (m_remote_address, &addr2);
						get_ip_address (m_MskStr, &mask2);
						if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
						{
							::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should be in same network",
								(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
							m_IPAddrWnd.SetFocus() ;
							return FALSE ;
						}
					}
				}
			}
		}
	}
	return TRUE ;
}

BOOL ipprx::ValidEditFields()
{

	//makesure that the current edit controls have valid entries
	char Msg[120], szLHS[50], szRHS[50];
	UpdateData (TRUE);
	if (!ValidPortSettings())
		return FALSE;

	//Since the data is validated we need to put into the
	//local structs before we start writing out
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;
	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_address;

	////Prabha 20/2/98, check the LAN and WAN addresses are not of the same
	////network.
	unsigned long addr1, addr2, mask1, mask2;
	get_ip_address (m_IPAddr[0], &addr1);
	get_ip_address (m_IPMask[0], &mask1);
	for (int index = 1; index < m_nPorts; index++)
	{
		get_ip_address (m_IPAddr[index], &addr2);
		get_ip_address (m_IPMask[index], &mask2);

		if ((addr1 & mask1) == (addr2 & mask2))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and WAN Addresses belong to the same net",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}

		if (m_RAS[index])
		{
			get_ip_address (m_RemoteAddr[index], &addr2);
			get_ip_address (m_IPMask[index], &mask2);
			if (addr2 && ((addr1 & mask1) != (addr2 & mask2)))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN and Remote Addresses should belong to the same net",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_IPAddrWnd.SetFocus() ;
				return FALSE ;
			}

			CDotDecimal rem_addr;
			rem_addr = m_RemoteAddr[index];
		
/* sudha 29 July 1999.Checking first, whether wan is enabled for this port.*/
			sprintf(szLHS,"WAN Port%d",index - 1);
			GetPrivateProfileString (WANSectionHeader,
				(LPCSTR)szLHS, StrDisabled, (LPSTR) szRHS, sizeof (szRHS),
					(LPCSTR) IniInWinForm) ;
			if(!strcmp(szRHS,StrEnabled))
			{
				if ((!rem_addr.IsValid() || rem_addr.IsEmpty()) && !m_check_client.GetCheck())
				{
					if ( DefaultSetup == TRUE )
					{
#if 0
						if ( FirstTimeInEdit == 1 )
						{
							sprintf(Msg, "Enter an IP Address for Remote Client on WAN %d\n\
or reconfigure & make sure to enable DHCP after downloading the setup", index);
							::MessageBox (GetSafeHwnd(), Msg,
								(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
							m_PortListWnd.SetCurSel(index);	//Set the selection
							OnSelchangeListPorts();				//call the handler explict
							m_ctrl_remote_address.SetFocus();	
							return FALSE;
						}
						else
						{
							sprintf(Msg, "No IP Address for Remote Client on WAN %d\n\
Make sure to reconfigure & enable DHCP after downloading the setup", index);
							::MessageBox (GetSafeHwnd(), Msg,
								(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
						}
#endif
					}
					else
					{
						sprintf(Msg, "Remote Client on WAN %d needs an IP Address.\n\
Enter an IP Address or enable DHCP", index);

						::MessageBox (GetSafeHwnd(), Msg,
							(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
						m_PortListWnd.SetCurSel(index);	//Set the selection
						OnSelchangeListPorts();				//call the handler explict
						m_ctrl_remote_address.SetFocus();	
						return FALSE;
					}
				}
			}
		}

		if ( DefaultSetup != TRUE )
		{
			if (m_check_client.GetCheck())
			{
			   if (m_server_address.IsEmpty() || !m_server_address.IsValid())
		  		{
		  			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DHCP server address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_server_address.SetFocus();
					return FALSE;
				}
			}
		}

		for (int index2 = index+1; index2 < m_nPorts; index2++)
		{
			if (m_RAS[index] && m_RAS[index2])
			{
				if ((!m_check_client.GetCheck()) && (m_RemoteAddr[index] == m_RemoteAddr[index2]) 
					&& ( strcmp ( (LPCSTR)m_RemoteAddr[index],ZeroIPAddress ) != 0 ))
				{
					::MessageBox (GetSafeHwnd(), (LPCSTR) "The Remote addresses should not be similar",
						(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_remote_address.SetFocus() ;
					return FALSE ;
				}
			}
		}
	}

	if ( DefaultSetup != TRUE )
	{
#if 0 
/* sudha 19 Aug 1999.Commented these checks as these controls are
removed from ip dialog now.*/

		CDotDecimal DotValue;
		DotValue = m_GwayStr;
		
		if ( ! DotValue.IsValid())
		{
			if (DotValue != ZeroIPAddress)
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid gateway address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
		}
		//Check to see that the gateway address, if entered
		//is in the same network as the LAN
		if (DotValue != ZeroIPAddress)
		{
			DWORD LANIPAddress, GWAYIPAddress, NETMask;
			get_ip_address((LPCSTR) m_IPAddr[0], &LANIPAddress);
			get_ip_address((LPCSTR) m_IPMask[0], &NETMask);
			get_ip_address((LPCSTR) m_GwayStr, &GWAYIPAddress);
			if ((LANIPAddress & NETMask) != (GWAYIPAddress & NETMask))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN port IP address and Gateway \
IP address\nmust be in the same IP network",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
			if (LANIPAddress == GWAYIPAddress)
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway IP address must \
point to another\nhost or router on the same IP network",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				m_GwayWnd.SetFocus() ;
				return FALSE ;
			}
		}

		if ( (m_nDefaultTTL < MIN_DEFAULT_TTL) ||
							(m_nDefaultTTL > MAX_DEFAULT_TTL))
		{
			wsprintf(Msg, "Invalid TTL. Must be between %d and %d",
				MIN_DEFAULT_TTL, MAX_DEFAULT_TTL);
			::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_TTLWnd.SetFocus() ;
			return FALSE ;
		}

		if ( (m_nReassemTimeout < MIN_REASSM_TMOUT) ||
							(m_nReassemTimeout > MAX_REASSM_TMOUT))
		{		
			wsprintf(Msg, "Invalid Reassembly Timeout.\n\
Must be between %d and %d", MIN_REASSM_TMOUT, MAX_REASSM_TMOUT);
			::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_RTOWnd.SetFocus() ;
			return FALSE ;
		}

		if (m_GwayStr.IsEmpty())
			m_GwayStr = ZeroIPAddress;
#endif

		if (!m_primary_address.IsEmpty())
		{
			if ((m_primary_address != ZeroIPAddress) && !m_primary_address.IsValid())
			{
					wsprintf(Msg, "Invalid DNS Primary Address");
					::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION);
					m_ctrl_primary_address.SetFocus();
					return FALSE;
			}
		}
		if (!m_secondary_address.IsEmpty())
		{
			if ((m_secondary_address != ZeroIPAddress) && !m_secondary_address.IsValid())
			{
				wsprintf(Msg, "Invalid DNS Secondary Address");
				::MessageBox (GetSafeHwnd(), (LPCSTR) Msg, (LPCSTR) IPMsgHeader, 
						MB_OK|MB_ICONEXCLAMATION);
					m_ctrl_secondary_address.SetFocus();
				return FALSE;
			}
		}
	}
  	return TRUE;
}

void ipprx::OnOK()
{
	// TODO: Add extra validation here
	int index;
	char	szRHS[128];
	char	szLHSAddr[50];
	char	szLHSMask[40];
	char szPPPRHS[128];

	if (!UpdateData(TRUE))	
		return;
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidPortSettings())
		return;
	index = m_PortListWnd.GetCurSel();
	m_ISP[index] = m_ISPCheck;
	m_IPAddr[index] = m_IPAddrStr;
	m_IPMask[index] = m_MskStr;
	if (m_ras_enable.GetCheck())
		m_RAS[index] = 1;
	else
		m_RAS[index] = 0;
	m_RemoteAddr[index] = m_remote_address;
	if (!index)	
	{
		m_RAS[index] = 0;
		m_RemoteAddr[index].Empty();
	}

	if (!ValidEditFields())
	{
#if 0
		if ( DefaultSetup == TRUE )
			FirstTimeInEdit = 0;
#endif
		return;
	}

	//write the new values out into the ini file

	strcpy(szLHSAddr, "IP Port0 Address");
	strcpy(szLHSMask, "IP Port0 Address Mask");
	for (index = 0; index < m_nPorts; index++)
	{
		//Write IP Address
	  	WritePrivateProfileString ((LPCSTR) IPSectionHeader,
			(LPCSTR) szLHSAddr, m_IPAddr[index], (LPCSTR) FileName) ;

		//If ISP assigned WAN address write 0.0.0.0 and
		// In PPP make local option negotiable
		if (index > 0)		//not for LAN port
		{
			wsprintf(szRHS, "PPP Port%d Option%%IPCP%%IP Address", index - 1);
		 	if (m_ISP[index] == TRUE)
			{
			// PPP local address is 0.0.0.0 and negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
			}
			else
			{
			// PPP local address is user assinged (non-0.0.0.0) and NOT negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) m_IPAddr[index]) ;
			}
			wsprintf(szRHS, "PPP Port%d Remote Option%%IPCP%%IP Address", index-1);
			if (m_RAS[index] == TRUE)
			{	
				if (m_RemoteAddr[index].IsEmpty())				
				{
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
/* sudha changed index from 1 to 0 on 14 nov 1998 */
					if (index > 0)
					{
					wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_IPAddr[0]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, ZeroIPAddress);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					}
					wsprintf (szRHS, "IP Port%d Remote Address", index);
				 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) ZeroIPAddress, (LPCSTR) FileName);
				}
				else
				{
#if 0
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
					ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
						(LPCSTR) szRHS, 5, (LPCSTR) m_RemoteAddr[index]) ;
#endif
/* sudha changed index > 1 to index > 0 on 14 nov 1998 */

					if (index > 0)
					{
					wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_IPAddr[0]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
					strcpy (szPPPRHS, "3,Auto,Negotiation Not Required,Negotiable,IP,");
					strcat (szPPPRHS, m_RemoteAddr[index]);
					WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) 
						szRHS, szPPPRHS, (LPCSTR) FileName);
					}
					wsprintf (szRHS, "IP Port%d Remote Address", index);
				 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szRHS,
							m_RemoteAddr[index], (LPCSTR) FileName);
				}
				if (index > 0)
				{
					wsprintf (szRHS, "PPP Port%d Remote Port Client Only", index-1);
				 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) StrEnabled, (LPCSTR) FileName);
				}
			}
			else
			{
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
/* sudha changed index from 1 to 0 on 14 nov 1998 */
				if (index > 0)
				{
				wsprintf(szRHS, "PPP Port%d RAS Option%%IPCP%%IP Address", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				wsprintf(szRHS, "PPP Port%d RAS Remote Option%%IPCP%%IP Address", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				}
				wsprintf (szRHS, "IP Port%d Remote Address", index);
			 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szRHS,
						(LPCSTR) ZeroIPAddress, (LPCSTR) FileName);
				if (index > 0)
				{
					wsprintf (szRHS, "PPP Port%d Remote Port Client Only", index-1);
				 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szRHS,
							(LPCSTR) StrDisabled, (LPCSTR) FileName);
				}
			}
		}
		else		// the LAN IP address is to be copied into SNMP section also
		{
			WritePrivateProfileString ((LPCSTR) SNMPSectionHeader,
				(LPCSTR) "SNMP Local Internet Address",
					(LPCSTR) m_IPAddr[index], (LPCSTR) FileName) ;
		}
		//write subnet mask for the port
	 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
					m_IPMask[index], (LPCSTR) FileName);

		szLHSAddr[7]++;		//next Port
		szLHSMask[7]++;		//next Port
	}
	if ( DefaultSetup != TRUE )
	{
#if 0 
/* sudha 19 Aug 1999.Commented these checks as these controls are
removed from ip dialog now.*/

		wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nDefaultTTL);
		WritePrivateProfileString(IPSectionHeader ,
				(LPCSTR) "IP Default TTL",(LPSTR)szRHS, (LPCSTR) FileName);

		wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nReassemTimeout);
		WritePrivateProfileString(IPSectionHeader ,
					(LPCSTR) "IP Reassembly Timeout", szRHS, (LPCSTR) FileName) ;

		wsprintf(szRHS, "%s,%d", (LPCSTR)m_GwayStr, m_nDefaultMetric);
		WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP Default Route", (LPCSTR) szRHS, (LPCSTR) FileName) ;
#endif

		if (m_check_client.GetCheck())
		{	
			WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, "DHCP Client",
					StrEnabled, FileName);
			WritePrivateProfileString ((LPCSTR) DHCPSectionHeader,
				"DHCP Server IP Address", m_server_address, (LPCSTR)FileName);
			for (index = 0; index < m_nPorts; index++)
			{
				wsprintf (szLHSAddr, "IP Port%d BOOTP", index);
				WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
					(LPCSTR) szLHSAddr, (LPCSTR) StrEnabled, (LPCSTR) FileName) ;
			}
		}
		else
		{
			WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, "DHCP Client",
					StrDisabled, FileName);
			WritePrivateProfileString ((LPCSTR) DHCPSectionHeader,
				"DHCP Server IP Address", ZeroIPAddress, (LPCSTR)FileName);
			GetPrivateProfileString ((LPCSTR) DHCPSectionHeader, "DHCP Server",
				StrDisabled, szPPPRHS, sizeof (szPPPRHS), FileName);
			if (!strcmp (szPPPRHS, StrDisabled))
			{
				for (index = 0; index < m_nPorts; index++)
				{
					wsprintf (szLHSAddr, "IP Port%d BOOTP", index);
					WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
						(LPCSTR) szLHSAddr, (LPCSTR) StrDisabled, (LPCSTR) FileName) ;
				}
			}
		}

		if (!m_primary_address.IsEmpty())
		{
			strcpy (szRHS, m_primary_address);
			WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
				(LPCSTR) "IP DNS Server Address1", (LPCSTR) szRHS, (LPCSTR) FileName) ;
			for (index = 1; index < m_nPorts; index++)
			{
				wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address1", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address1", index-1);
				wsprintf (szRHS, "129,Auto,Negotiation Not Required,Not Negotiable,IP,%s", m_primary_address);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			}
		}
		else
		{
			strcpy (szRHS, StrDisabled);
			WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
				(LPCSTR) "IP DNS Server Address1", (LPCSTR) StrNull, (LPCSTR) FileName) ;
			
			for (index = 1; index < m_nPorts; index++)
			{
				wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address1", index-1);
				wsprintf (szRHS, "129,Auto,Negotiation Not Required,Negotiable,IP,%s", ZeroIPAddress);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
				wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address1", index-1);
				wsprintf (szRHS, "129,Auto,Negotiation Not Required,Not Negotiable,IP,%s", ZeroIPAddress);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			}
		}

		if (!m_secondary_address.IsEmpty())
		{
			strcpy (szRHS, m_secondary_address);
			WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
				(LPCSTR) "IP DNS Server Address2", (LPCSTR) szRHS, (LPCSTR) FileName) ;

			for (index = 1; index < m_nPorts; index++)
			{
				wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address2", index-1);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) NULL, (LPCSTR) FileName) ;
				wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address2", index-1);
				wsprintf (szRHS, "131,Auto,Negotiation Not Required,Not Negotiable,IP,%s", m_secondary_address);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			}
		}	 	
		else
		{
			strcpy (szRHS, StrDisabled);
			WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
			(LPCSTR) "IP DNS Server Address2", (LPCSTR) StrNull, (LPCSTR) FileName) ;

			for (index = 1; index < m_nPorts; index++)
			{
				wsprintf (szPPPRHS, "PPP Port%d Option%%IPCP%%DNS Address2", index-1);
				wsprintf (szRHS, "131,Auto,Negotiation Not Required,Negotiable,IP,%s", ZeroIPAddress);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
				wsprintf (szPPPRHS, "PPP Port%d RAS Remote Option%%IPCP%%DNS Address2", index-1);
				wsprintf (szRHS, "131,Auto,Negotiation Not Required,Not Negotiable,IP,%s", ZeroIPAddress);
				WritePrivateProfileString ((LPCSTR) PPPSectionHeader, 
					szPPPRHS, (LPCSTR) szRHS, (LPCSTR) FileName) ;
			}
		}
	}
	CDialog::OnOK();
	return;
}

void ipprx::OnSelchangeListPorts()
{
	// TODO: Add your control notification handler code here
	
	int PortIndex;
	BOOL rasctrl, wanctrl ;
	char StrLHS[40], StrRHS[40] ;

	UpdateData(TRUE);

	// TODO: Add your control notification handler code here
	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

	if (!ValidPortSettings())
	{
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}
	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;
	if (m_ras_enable.GetCheck())
		m_RAS[m_nOldPort] = 1;
	else
		m_RAS[m_nOldPort] = 0;
	m_RemoteAddr[m_nOldPort] = m_remote_address;

	m_ISPCheck = m_ISP[PortIndex];
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];
	if (m_RAS[PortIndex])
		m_ras_enable.SetCheck (1);
	else
		m_ras_enable.SetCheck (0);
	m_remote_address = m_RemoteAddr[PortIndex];

/* sudha 17 Nov 1998 */		
/* modified by brindha on 30/4/99. */

	// ras can be enabled/disabled only in wan dialog.
	m_ras_enable.EnableWindow (FALSE);  
	
	sprintf(StrLHS,"WAN Port%d DialInOut Type",PortIndex-1);
	GetPrivateProfileString(WANSectionHeader,
		(LPCSTR) StrLHS, "0", (LPSTR) StrRHS, sizeof (StrRHS),
		(LPCSTR) IniInWinForm) ;

	if ( m_MLPPP || (!strcmp (StrRHS, "0")))
		rasctrl = FALSE;
	else
		rasctrl = TRUE ;


	sprintf(StrLHS,"WAN Port%d",PortIndex-1);
	GetPrivateProfileString(WANSectionHeader,
		(LPCSTR) StrLHS, StrDisabled, (LPSTR) StrRHS, sizeof (StrRHS),
		(LPCSTR) IniInWinForm) ;

	if (!strcmp (StrRHS, StrEnabled))
		wanctrl = TRUE;
	else
		wanctrl = FALSE ;

	if (PortIndex == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(FALSE);
		m_ras_enable.EnableWindow (FALSE);
		m_ctrl_remote_address.EnableWindow (FALSE);
		m_static_remote_address.EnableWindow (FALSE);
		//Change the group heading to that of the selected port
		m_SelPortGrp.SetWindowText("LAN");
	}
	else
	{
/* sudha 14 nov 1998 */
		m_ISPWnd.EnableWindow(TRUE);

		m_ctrl_remote_address.EnableWindow (rasctrl && m_RAS[PortIndex] && wanctrl);
		m_static_remote_address.EnableWindow (rasctrl && m_RAS[PortIndex] && wanctrl);

		if (m_nPorts <= 2)
			m_SelPortGrp.SetWindowText("WAN");
		else
		{
			char Buf[10];

			sprintf(Buf, "WAN %d", PortIndex);
			m_SelPortGrp.SetWindowText(Buf);
		}
	}

	m_IPHdrWnd.EnableWindow(!m_ISPCheck);
	m_IPAddrWnd.EnableWindow(!m_ISPCheck);
	m_staticMskWnd.EnableWindow(!m_ISPCheck);
	m_MskWnd.EnableWindow(!m_ISPCheck);


	UpdateData(FALSE);
	m_nOldPort = PortIndex;
}

void ipprx::OnCheckRas()
{
	// TODO: Add your control notification handler code here
	if (m_ras_enable.GetCheck())
	{
		m_static_remote_address.EnableWindow (TRUE);
		m_ctrl_remote_address.EnableWindow (TRUE);
	}
	else
	{
		m_static_remote_address.EnableWindow (FALSE);
		m_ctrl_remote_address.EnableWindow (FALSE);
	}
//	UpdateData (FALSE);
}

void ipprx::OnCheckClient()
{
	// TODO: Add your control notification handler code here
	if (m_check_client.GetCheck())
	{
		m_static_server_address.EnableWindow (TRUE);
		m_ctrl_server_address.EnableWindow (TRUE);
	}
	else
	{
		m_static_server_address.EnableWindow (FALSE);
		m_ctrl_server_address.EnableWindow (FALSE);
	}	
//	UpdateData (FALSE);
}

void ipprx::OnButtonStatHost()
{
	// TODO: Add your control notification handler code here
	ipprx *pParent = (ipprx *) GetParent() ;
	CIPHRoute IIPHRoute (pParent);
	CDotDecimal IPAddrDotValue, IPMaskDotValue ;
	int index = m_PortListWnd.GetCurSel();


	if (!UpdateData(TRUE))	
		return ;
	if (!ValidPortSettings())
		return ;

	// Added By Jyothi on 19 Aug'99
	
	m_IPAddr[index] =	m_IPAddrStr ;
	m_IPMask[index] =	m_MskStr ;   //


	for (index = 0; index < m_nPorts; index++)
	{	
		IPAddrDotValue = m_IPAddr[index] ;
		IPMaskDotValue = m_IPMask[index] ;

		if (!IPAddrDotValue.IsValid())
			continue ;
		IPMaskDotValue = m_IPMask[index] ;
		if (!IPMaskDotValue.IsValid())
			continue ;

					
			IIPHRoute.IPAddr[index] = IPAddrDotValue ;
			IIPHRoute.IPMask[index] = IPMaskDotValue ;
		
	}
   AfxGetApp()->LoadCursor(IDC_WAIT);
   AfxGetApp()->DoWaitCursor(1);
	IIPHRoute.DoModal() ;
	m_static_routes.SetFocus();
}
