
// iproutes.cpp : implementation file
//	Jo 30/06/99 : Static routes 

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "iproutes.h"
#include "ipprx.h"
#include "hardware.h"
#include "utils.h"

#define MIN_METRIC			1
#define MAX_METRIC			16
#define NO_SUCH_PORT			255

char	*StaticMsgHeader = "ProxyServer Setup - Static Route" ;
BOOL edit = FALSE ;
BOOL 	CheckGateway ;
int m_nOldCount;

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddRoute dialog


CAddRoute::CAddRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CAddRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddRoute)
	m_nAddStatRoutMetric = 1;
	m_HostNetAddr = "";
	m_HostNetGwayAddr = "";
	m_port = "";
	m_AddressMask = "";
   m_GatewayCheck = FALSE;
	//}}AFX_DATA_INIT
}

void CAddRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddRoute)
	DDX_Control(pDX, IDC_CHECK1, m_GatewayWnd);
	DDX_Control(pDX, IDC_COMBO_PORT, m_combo_port);
	DDX_Control(pDX, IDC_STATIC_PORT, m_static_port);
	DDX_Control(pDX, IDC_EDIT4, m_MaskWnd);
	DDX_Control(pDX, IDC_STATIC_MASK, m_static_mask);
	DDX_Control(pDX, IDC_STATIC_GATEWAY_ADDRESS, m_static_gateway_address);
	DDX_Control(pDX, IDC_EDIT2, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT1, m_AddrWnd);
	DDX_Control(pDX, IDC_ADD_STAT_ROUT_METRIC, m_AddStatRoutMetricWnd);
	DDX_Text(pDX, IDC_ADD_STAT_ROUT_METRIC, m_nAddStatRoutMetric);
	DDX_Text(pDX, IDC_EDIT1, m_HostNetAddr);
	DDX_Text(pDX, IDC_EDIT2, m_HostNetGwayAddr);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_port);
	DDX_Text(pDX, IDC_EDIT4, m_AddressMask);
	DDX_Check(pDX, IDC_CHECK1, m_GatewayCheck);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAddRoute, CDialog)
	//{{AFX_MSG_MAP(CAddRoute)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_PORT, OnSelchangeComboPort)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAddRoute message handlers

void CAddRoute::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_IP_ADD_ROUTE,HELP_CONTEXT);
}

void CAddRoute::OnCancel()
{
	CDialog::OnCancel();
}

void CAddRoute::OnOK()
{
	if(!UpdateData(TRUE))
		return ;
	
	if (!m_HostNetAddr.IsValid() || m_HostNetAddr.IsEmpty()
				|| m_HostNetAddr == ZeroIPAddress)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Host IP Address",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AddrWnd.SetFocus() ;
		return ;
	}

	if (!m_HostNetGwayAddr.IsValid() && (strcmp (m_HostNetGwayAddr, "ISP Assigned") != 0)) 
	{
		
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Host Gateway Address",
					(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_GwayWnd.SetFocus() ;
			return ;
		
	}

	if (!m_AddressMask.IsValid())
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MaskWnd.SetFocus() ;
		return ;
	}
	
	if (!verify_ip_subnet_mask ((LPCSTR)m_AddressMask))
	{
		ULONG subnet_mask ;
		get_ip_address ((const char *) m_AddressMask, &subnet_mask) ;
		if (subnet_mask != 0xFFFFFFFF)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_MaskWnd.SetFocus() ;
			return ;
		}
	}

	if ((m_nAddStatRoutMetric < MIN_METRIC) || (m_nAddStatRoutMetric > MAX_METRIC))
	{
	   char Buf[128] ;
		sprintf (Buf, "Invalid Metric.\n Must be %d to %d",
				   	MIN_METRIC, MAX_METRIC) ;
		::MessageBox (GetSafeHwnd(), Buf,
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AddStatRoutMetricWnd.SetFocus() ;
		return ;
	}

	if (strcmp (m_HostNetGwayAddr, "ISP Assigned") != 0) 
	   if (!GateWayAddressMatches()) 
		{
			m_GwayWnd.SetFocus() ;
			return ;
		}

	char temp[10] ;
	int index = m_combo_port.GetCurSel() ;
	sprintf (temp, "%d", index) ;
	PortStr = temp ;
    
	CDialog::OnOK();
}

BOOL CAddRoute::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
	WindowText.GetBuffer(0),SubHeadingPointer) ;

	SetWindowText (WindowHeader) ;
	
	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Filtering bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this)) ;
	HelpBitmapBtn.SizeToContent() ;

	PutStringsInPortCombo() ;

	int index = 0 ;
	if (edit)
	{
	   sscanf (PortStr, "%d", &index) ;
		m_combo_port.SetCurSel (index) ;
	}
  
	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	ULONG addr1 ;
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;

	if (((strcmp (m_HostNetGwayAddr, ZeroIPAddress) == 0) || 
			(strcmp (m_HostNetGwayAddr, "ISP Assigned") == 0))
			&& (index))
	{
		if (!addr1)
		{
			m_HostNetGwayAddr = "ISP Assigned" ;
			m_static_gateway_address.EnableWindow (FALSE) ;
			m_GwayWnd.EnableWindow (FALSE) ;
		}
		else
			m_HostNetGwayAddr = "" ;
	}
	UpdateData (FALSE);
	return TRUE ;
}

BOOL CAddRoute::GateWayAddressMatches()
{
	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	int index ;
	ULONG addr1, addr2, mask1;
	addr1 = addr2 = 0;
	index = m_combo_port.GetCurSel();

 	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;
	get_cdotdecimal_to_ulong_ip_address (m_HostNetGwayAddr, &addr2) ;
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPMask[index], &mask1) ;

   if ((addr1 == addr2) && !index)
	{
	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address is same as LAN Address. Please Reenter Gateway Address",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
	   return FALSE ;
	 }
	if ((m_HostNetGwayAddr.IsEmpty() || m_HostNetGwayAddr == ZeroIPAddress)
					&& (!index))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "If Port is LAN then Gateway Address is a must Please enter gateway address...",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}

	if (((addr1 & mask1) != (addr2 & mask1)) && !index)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address should be of the same net as that of ProxyServer",
			(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE ;
	}

	if (index)
	{
		if (addr1 != 0 && (m_HostNetGwayAddr != ZeroIPAddress))
		{
			if ((addr1 & mask1) != (addr2 & mask1))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway Address should be of the same net",
					(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
				return FALSE ;
	 		}
		}
		
		if ((addr1 == 0) && (m_HostNetGwayAddr != ZeroIPAddress))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "IP Address is ISP Assigned Dynamic for this port.So Gateway Address should be 0.0.0.0",
				(LPCSTR) StaticMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE ;
		}
	}
  	return TRUE ;
}

/////////////////////////////////////////////////////////////////////////////
// CIPHRoute dialog


CIPHRoute::CIPHRoute(CWnd* pParent /*=NULL*/)
	: CDialog(CIPHRoute::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPHRoute)
	//}}AFX_DATA_INIT
}

void CIPHRoute::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPHRoute)
	DDX_Control(pDX, IDC_BUTTON_HOST_REMOVE, m_HRemove);
	DDX_Control(pDX, IDC_LIST_HOST_ROUTES, m_HRouteList);
	DDX_Control(pDX, IDC_EDIT, m_Edit);
	DDX_Control(pDX, IDC_BUTTON_HOST_ADD, m_HAdd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPHRoute, CDialog)
	//{{AFX_MSG_MAP(CIPHRoute)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BUTTON_HOST_ADD, OnButtonHostAdd)
	ON_BN_CLICKED(IDC_BUTTON_HOST_REMOVE, OnButtonHostRemove)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_LBN_SELCANCEL(IDC_LIST_HOST_ROUTES, OnSelcancelListHostRoutes)
	ON_LBN_SELCHANGE(IDC_LIST_HOST_ROUTES, OnSelchangeListHostRoutes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPHRoute message handlers

BOOL CIPHRoute::OnInitDialog()
{
	CDialog::OnInitDialog();

	CenterWindow() ; 
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat, WindowText.GetBuffer(0),SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap") ;

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this)) ;
	OKBitmapBtn.SizeToContent() ;

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap") ;


	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this)) ;
	CancelBitmapBtn.SizeToContent() ;

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap") ;

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_BUTTON_HELP, this)) ;
	HelpBitmapBtn.SizeToContent() ;

	if (!AddMapBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap") ;

	VERIFY (AddMapBmpBtn.SubclassDlgItem (IDC_BUTTON_HOST_ADD, this)) ;
	AddMapBmpBtn.SizeToContent() ;

	if (!DeleteMapBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap") ;

	VERIFY (DeleteMapBmpBtn.SubclassDlgItem (IDC_BUTTON_HOST_REMOVE, this));
	DeleteMapBmpBtn.SizeToContent() ;

	if (!EditMapBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load EDIT bitmap") ;

	VERIFY (EditMapBmpBtn.SubclassDlgItem (IDC_EDIT, this)) ;
	EditMapBmpBtn.SizeToContent() ;

	int TabStops[] = {60, 125, 190, 218} ;
	m_HRouteList.SetTabStops (4, (LPINT) &TabStops) ;


// Set the tab positions in the list box for "address", "Gateway", "Port"
// and "Metric" to be displyed properly
// Get all the current static host entries and add them to
// the list box
	char	LHSIPStatic[60];
	char	RHStr[80];
	char tempstr[100];
	char *comma, *ch;
	char Str[80] ;		// Store the string which will be displayed.
	char temp_ip_address[20], temp_gateway_address[20], temp_mask[20], szMetric[10], port_string[5] ;
	char prefix_alphabet = 65;
	int prefix_num = 0;

	while (1)
	{
		sprintf (LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num) ;

		if (!GetPrivateProfileString (IPSectionHeader, (LPCSTR) LHSIPStatic,
					StrNull, (LPSTR) RHStr, sizeof (RHStr),
							(LPCSTR) IniInWinForm))
		{
			break ;
		}
		
		while (1)
		{
			// Convert ','s to \t to do the display
			if ((comma = _fstrchr ((char *) RHStr, (int) ',')) != NULL)
			{
	   		*comma = '\0' ;
				strcpy ((char *)temp_ip_address, (char *) RHStr) ;

				comma ++ ;
				_fstrcpy ((char *) RHStr, comma) ;

			   if ((comma = _fstrchr ((char *) RHStr, (int) ',')) != NULL)
				{
	      		*comma = '\0' ;
					strcpy ((char *)temp_gateway_address, (char *) RHStr) ;

					comma ++ ;
					_fstrcpy ((char *) RHStr, comma) ;
					if ((comma = strchr ((char *) RHStr, (int) ',')) != NULL) 
					{
				     		*comma = '\0' ;
							strcpy ((char *)temp_mask, (char *) RHStr) ;

							comma ++ ;
							_fstrcpy ((char *) RHStr, comma) ;

							if ((comma = strchr ((char *) RHStr, (int) ',')) != NULL) 
							{
				      		*comma = '\0' ;
								strcpy ((char *)szMetric, (char *) RHStr) ;

						      comma ++ ;
								_fstrcpy ((char *) RHStr, comma) ;

   							if ((comma = strchr ((char *) RHStr, (int) ';')) != NULL) 
	   						{
		   		      		*comma = '\0' ;

	   							char ports[50];
   								strcpy(ports,RHStr); //Ports

									//While Displaying the Ports convert them back to Strings LAN,WAN1..

							   	int port_index = atoi ((const char *) ports) ;
						   	  	if(strcmp(ports,"0") == 0 )
					   				strcpy ((char *)port_string, "LAN") ;

				   				if(strcmp(ports,"1")== 0 )
			   						strcpy ((char *)port_string, "WAN1") ;

		   						if(strcmp(ports,"2") == 0 )
	   								strcpy ((char *)port_string, "WAN2") ;

   								if(strcmp(ports,"3") == 0 )
								   	strcpy ((char *)port_string, "WAN3") ;

               		   	// Check whether the Gateway Address is ISP Assigned or Null

			            		if (strcmp (temp_gateway_address, ZeroIPAddress) == 0)
         		   			{	
				   	         	ULONG addr1 ;
		            				get_cdotdecimal_to_ulong_ip_address (IPAddr[port_index], &addr1) ;
         						   if (!addr1)
	   						         sprintf (temp_gateway_address, "ISP Assigned") ;
                  				else
					   	         	sprintf (temp_gateway_address, "0.0.0.0") ;
		 	         		   }
         				   	// Now Print the String
					            sprintf (Str, "%s\t%s\t%s\t%s\t%s", temp_ip_address, temp_gateway_address, temp_mask, szMetric, port_string) ;

		            			// Add the string to the listbox.
      		   				m_HRouteList.AddString (Str) ;
                        }
   					 		else
 	   				 		{
		   			 			break;
			   		 		}
						   }
					 		else
 					 		{
					 			break;
					 		}
					} 
					else
					{
						break ;
					}
				}	
				else
				{
					break;
				}                             
			} 
			else 
			{
				break ;
			}
		}

		prefix_alphabet++ ;		// Prepare for reading next entry in ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	} 

	

	m_nOldCount = m_HRouteList.GetCount() ;	// Store the no. of entries.

//	Update the remove & edit buttons.
	if (!	m_nOldCount)
 	{
		m_HRemove.EnableWindow (FALSE) ;
		m_Edit.EnableWindow (FALSE) ;
	}

// Update dialog data.
	UpdateData (FALSE) ;

	return TRUE;
}

void CIPHRoute::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_IP_HOST_ROUTES,HELP_CONTEXT) ;
}

void CIPHRoute::OnButtonHostAdd()
{ 
   CString tempstr ;
	char temp[10] ;
   CAddRoute IAddRoute (this) ;
	edit = FALSE ;
	if (IAddRoute.DoModal()==IDOK) 
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
				IAddRoute.m_AddressMask.IsEmpty() && 
					(IAddRoute.m_nAddStatRoutMetric == 0))
			return ;

		CString Str ;
		char szMetric[10] ;

		Str = IAddRoute.m_HostNetAddr + '\t' ;

		if (IAddRoute.m_HostNetGwayAddr == "")
		{
			sprintf ((char *) temp, "0.0.0.0") ;
			tempstr = temp ;
			Str += tempstr + '\t' ;
		}
		else
			Str += IAddRoute.m_HostNetGwayAddr + '\t' ;

		Str += IAddRoute.m_AddressMask + '\t' ;

		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		tempstr = szMetric ;
		Str += tempstr + '\t' ;

	   int index;
   	sscanf (IAddRoute.PortStr, "%d", &index) ;
		if (!index)
			sprintf ((char *) temp, "LAN") ;
		else
			sprintf ((char *) temp, "WAN%d", index) ;
		tempstr = temp ;
		Str += tempstr;

		if (!DuplicateString (Str))
			m_HRouteList.AddString (Str) ;
	}
	m_HRemove.EnableWindow (m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow (m_HRouteList.GetCount()) ;
}

void CIPHRoute::OnButtonHostRemove()
{
	int SelIndex ;
	if ((SelIndex = m_HRouteList.GetCurSel()) == CB_ERR)
		return ;

	m_HRouteList.DeleteString (SelIndex) ;
	m_HRouteList.SetCurSel(SelIndex)	;
	m_HRemove.EnableWindow (m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow (m_HRouteList.GetCount()) ;
	m_HAdd.SetFocus() ;
}

void CIPHRoute::OnEdit()
{
	int SelIndex;
	
	if ((SelIndex = m_HRouteList.GetCurSel()) == CB_ERR)
		return ;

	BYTE Str[80] ;
	char *temp_ptr ;

	CAddRoute IAddRoute (this) ;
	if (m_HRouteList.GetText (SelIndex, (LPSTR) Str) == LB_ERR)
		return ;
  
	if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL) 
	{
		*temp_ptr = '\0' ;
	 	IAddRoute.m_HostNetAddr = (char *) Str ;
		temp_ptr++ ;

		while (*temp_ptr == '\t')
			temp_ptr++ ;	
		_fstrcpy ((char *) Str, temp_ptr) ;

	   if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
		{
	   	*temp_ptr = '\0' ;
			IAddRoute.m_HostNetGwayAddr = (char *) Str ;
			temp_ptr++ ;	

			while (*temp_ptr == '\t')
				temp_ptr++ ;	
			_fstrcpy ((char *) Str, temp_ptr) ;
			
			if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
			{
	   		*temp_ptr = '\0' ;
				IAddRoute.m_AddressMask = (char *) Str ;
				temp_ptr++ ;	

				while (*temp_ptr == '\t')
					temp_ptr++ ;	
				_fstrcpy ((char *) Str, temp_ptr) ;
				
				if ((temp_ptr = _fstrchr ((char *) Str, (int) '\t')) != NULL)
				{
					*temp_ptr = '\0' ;
					IAddRoute.m_nAddStatRoutMetric = atoi ((char *)Str) ;
					temp_ptr++ ;	

					while (*temp_ptr == '\t')
						temp_ptr++ ;	

					_fstrcpy ((char *) Str, temp_ptr) ;
					
					int index;
					char temp [10] ;

					index = atoi ((char *)&Str[3]) ;
					sprintf (temp, "%d", index) ;
					IAddRoute.PortStr = temp ;
				}
			}
		}
	}
				
	edit = TRUE ;
	if (IDOK == IAddRoute.DoModal()) 
	{
		if (IAddRoute.m_HostNetAddr.IsEmpty() &&
				IAddRoute.m_AddressMask.IsEmpty() && 
				(IAddRoute.m_nAddStatRoutMetric == 0))
		{  
			m_HAdd.SetFocus() ;
			return ;		
		}

		CString Str,tempstr;
		char szMetric[10],temp[10];

		Str = IAddRoute.m_HostNetAddr + '\t' ;
	  
		if (strcmp(IAddRoute.m_HostNetGwayAddr, "") == 0)
		{
		   sprintf ((char *) temp, "0.0.0.0") ;
			tempstr = temp ;
			Str += tempstr + '\t' ;
		}
		else
			Str += IAddRoute.m_HostNetGwayAddr + '\t' ;

		Str += IAddRoute.m_AddressMask + '\t' ;
		itoa (IAddRoute.m_nAddStatRoutMetric, szMetric, 10) ;
		tempstr = szMetric ;
		
		Str += tempstr + '\t' ;

		int index ;	
  		sscanf (IAddRoute.PortStr, "%d", &index) ;
		if (!index)
			sprintf ((char *) temp, "LAN") ;
		else
			sprintf ((char *) temp, "WAN%d", index) ;
  		tempstr = temp ;
  		Str += tempstr;

		if (!DuplicateString (Str))
		{
			m_HRouteList.DeleteString(SelIndex) ;
			m_HRouteList.AddString(Str) ;
		}
	} 

	m_HRemove.EnableWindow(m_HRouteList.GetCount()) ;
	m_Edit.EnableWindow(m_HRouteList.GetCount()) ;
	m_HAdd.SetFocus() ;
}

void CIPHRoute::OnSelcancelListHostRoutes()
{
	// TODO: Add your control notification handler code here
}

void CIPHRoute::OnSelchangeListHostRoutes()
{
	((CIPHRoute *)this)->m_Edit.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount()) ;
	((CIPHRoute *)this)->m_HRemove.EnableWindow(((CIPHRoute *)this)->m_HRouteList.GetSelCount()) ;
}

void CIPHRoute::OnCancel()
{
	CDialog::OnCancel();
}

void CIPHRoute::OnOK()
{
 	if (!UpdateData(TRUE))
 		return ;

   int i;  // number_of_static_route_entries ;
 	BYTE	Str[80] ;
 	char *temp_ptr ;
	char	LHSIPStatic[80];
	char	RHStr[80];
	char *comma;
	char prefix_alphabet = 65;
	int prefix_num = 0;

  	int n_Count = m_HRouteList.GetCount() ;

	for (i = 0 ; i < n_Count ; i ++) 
	{
		sprintf (LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num);
		m_HRouteList.GetText (i, (LPSTR) RHStr) ;  

			// Convert '\t's to ','s to store.

			if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
			{
	   	   *comma = '\0' ;
				_fstrcpy ((char *) Str, (char *) RHStr) ;	// IP Address
				_fstrcat ((char *) Str, ",") ;
				comma ++ ;

				// if more tab then increment the pointer.
				while (*comma == '\t')
					comma ++ ;	
				_fstrcpy ((char *) RHStr, comma) ;
		
	   		if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
				{
	      		*comma = '\0' ;
					char gateway[50];
					strcpy (gateway, RHStr) ;	// Gateway Address

//While writing it into the INI File check the Gateway Address.If it is ISP 
//Assigned then store it as 0.0.0.0

					if (strcmp(gateway, "ISP Assigned") == 0)
				  		_fstrcat ((char *) Str, "0.0.0.0") ;	 // Gateway Address
					else
						_fstrcat ((char *) Str, (char *) RHStr) ;	
					_fstrcat ((char *) Str, ",") ;
					comma ++ ;
				
					// if more tabs then increment the pointer.
					while (*comma == '\t')
						comma ++ ;

					_fstrcpy ((char *) RHStr, comma) ;
					if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
						{
	      				*comma = '\0' ;
							_fstrcat ((char *) Str, (char *) RHStr) ;	 // Address Mask
							_fstrcat ((char *) Str, ",") ;
							comma ++ ;
				
							// if more tabs then increment the pointer.
							while (*comma == '\t')
								comma ++ ;
							_fstrcpy ((char *) RHStr, comma) ;
			
							if ((comma = _fstrchr ((char *) RHStr, (int) '\t')) != NULL) 
							{
   			   			*comma = '\0' ;
								_fstrcat ((char *) Str, (char *) RHStr) ;	 // Metric
								_fstrcat ((char *) Str, ",") ;
								comma ++ ;
	
								//if more tabs then increment the pointer.
								while (*comma == '\t')
									comma ++ ;
								_fstrcpy ((char *) RHStr, comma) ;

										char ports[50];	//Ports

		// Store the Ports as values 0,1,2,3 for the corresponding LAN,WAN1,WAN2
	  //  and WAN3 Ports
										strcpy(ports,RHStr); 
										char *RHStr1;
										if(strcmp(ports,"LAN") == 0 )
											RHStr1 = "0";
										if(strcmp(ports,"WAN1") == 0 )
											RHStr1 = "1";
										if(strcmp(ports,"WAN2") == 0 )
											RHStr1 = "2";
										if(strcmp(ports,"WAN3") == 0 )
											RHStr1 = "3";
										_fstrcat ((char *) Str, (char*)RHStr1) ;	  // this is Port
										_fstrcat ((char *) Str, ";") ;	  // this is end of static route
					  					  		  				 
									WritePrivateProfileString (IPSectionHeader,
										(LPCSTR) LHSIPStatic, (LPSTR) Str, (LPCSTR) IniInWinForm) ;
							}
				  		}
   	   	}
			}
		prefix_alphabet++ ;		// Prepare for writing next entry to ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

// if no. of old entries is more than new, the excess entries need to
// be blanked out.

	for (i = n_Count ; i < m_nOldCount ; i ++)
	{
		sprintf (LHSIPStatic, "$%c%dIP Static Route Table Entries", prefix_alphabet, prefix_num);
	 	WritePrivateProfileString (IPSectionHeader,
	 			(LPCSTR) LHSIPStatic, NULL, (LPCSTR) IniInWinForm) ;
		prefix_alphabet++ ;		// Prepare for writing next entry to ini file.
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	CDialog::OnOK();
}

BOOL CIPHRoute::DuplicateString (CString StrInBox)
{
	int nCount = m_HRouteList.GetCount() ;
	int cur_sel ;
	CString Str ;
	if (edit)
		cur_sel = m_HRouteList.GetCurSel() ;		

	for (int i = 0 ; i < nCount ; i ++)
	{
		if (edit && (i == cur_sel))
			continue ;
		m_HRouteList.GetText (i, Str) ;
		if (Str == StrInBox)
		{
			::MessageBox (GetParent()->GetSafeHwnd(), "Duplicate Entry will not be added", 
						"Warning", MB_OK | MB_ICONINFORMATION) ;
			return TRUE ;
		}
	}
	edit = FALSE ;
	return FALSE ;
}

void CAddRoute::OnSelchangeComboPort()
{
	CIPHRoute *ipparent = (CIPHRoute *) GetParent() ;
	ULONG addr1 ;
	int index ;

	index = m_combo_port.GetCurSel() ;		
	get_cdotdecimal_to_ulong_ip_address (ipparent->IPAddr[index], &addr1) ;
	if (!addr1)
	{
		m_HostNetGwayAddr = "ISP Assigned" ;
		m_static_gateway_address.EnableWindow (FALSE) ;
		m_GwayWnd.EnableWindow (FALSE) ;
	}
	else
	{
		m_HostNetGwayAddr = "" ;
		m_static_gateway_address.EnableWindow (TRUE) ;
		m_GwayWnd.EnableWindow (TRUE) ;
	}
	UpdateData (FALSE) ;
}

void CAddRoute::OnCheck()
{
	// TODO: Add your control notification handler code here

}

void CAddRoute::PutStringsInPortCombo()
{
	char str[10] ;
	int ports;
  	m_combo_port.ResetContent();
  	ports = GetPrivateProfileInt (IPSectionHeader, "IP Number of Ports",
												0, (LPCSTR)IniInWinForm) ;
   	
  	sprintf (str, "LAN") ;
  	m_combo_port.AddString (str) ;

	for (int index = 1; index < ports; index++)
	{
		sprintf (str, "WAN%d", index) ;
		m_combo_port.AddString (str) ;
	}
   m_combo_port.SetCurSel (0);
}
