// isddnld.cpp : implementation file
//
// Sudha coded for downloading default ISDN config parameters for ISDNProxy
// 23 Dec 1997

#include "stdafx.h"
#include "procon.h"
#include "isddnld.h"
#include "cryptfns.h"
#include "wandlg.h"
#include "hardware.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern LPCSTR WANSectionHeader;
extern LPCSTR MapHeader;
extern LPCSTR IsdnMsgHeader;

extern void ReadISDNInfoFromRouconIniToIsdntaIni(int PortIndex);

BOOL SPIDorISDN ( const char *command )
{
   if ((!strcmp(command,"!C6=")) || (!strcmp(command,"*!C6=")))
      return TRUE;
   if ((!strcmp(command,"!N1=")) || (!strcmp(command,"*!N1=")))
      return TRUE;
   else
      return FALSE; 
}

/////////////////////////////////////////////////////////////////////////////
// CIsddnld dialog


CIsddnld::CIsddnld(CWnd* pParent /*=NULL*/)
	: CDialog(CIsddnld::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIsddnld)
	m_szPPINISection = "";
	m_szPPDataDirNum = "";
	m_szPPDataIsdn = "";
	m_szPPDataSpid = "";
	m_szPPDataSub = "";
	m_szPPDataTEI = "";
	m_szPPVoiceDirNum = "";
	m_szPPVoiceIsdn = "";
	m_szPPVoiceSpid = "";
	m_szPPVoiceSub = "";
	m_szPPVoiceTEI = "";
	m_szPPNetworkSwitchType = "";
	m_szPPDataProtocol = "";
	m_szPPDataMSN = "";
	m_szPPVoiceMSN = "";
	m_bUS = TRUE;
	m_StrDialNumber1 = "";
	m_1PWord = "";
	m_1UName = "";
	//}}AFX_DATA_INIT

	m_bDialogInited = FALSE ; //A lock for password editing

}

void CIsddnld::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIsddnld)
	DDX_Control(pDX, IDC_STATIC_EUROPE, m_StatEurope);
	DDX_Control(pDX, IDC_STATIC_DATA, m_StatData);
	DDX_Control(pDX, IDC_STATIC_US, m_StatUS);
	DDX_Control(pDX, IDC_STATIC_DIAL_NUM_HDR1, m_StatDialNumberHdr1Wnd);
	DDX_Control(pDX, IDC_STATIC_PWROD1, m_1PWordHdr);
	DDX_Control(pDX, IDC_STATIC_UNAME1, m_1UNameHdr);
	DDX_Control(pDX, IDC_EDIT_UNAME1, m_1UNamWnd);
	DDX_Control(pDX, IDC_EDIT_PWORD1, m_1PWordWnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER_1, m_EditDialNumber1Wnd);
	DDX_Control(pDX, IDC_DATA_PROTOCOL, m_bDataProtocol);
	DDX_Control(pDX, IDC_SWITCH_TYPE, m_bNetworkSwitchType);
	DDX_Control(pDX, IDC_VOICE_TEI, m_bVoiceTEI);
	DDX_Control(pDX, IDC_VOICE_SUB, m_bVoiceSub);
	DDX_Control(pDX, IDC_VOICE_SPID, m_bVoiceSpid);
	DDX_Control(pDX, IDC_VOICE_ISDN, m_bVoiceIsdn);
	DDX_Control(pDX, IDC_VOICE_DIR_NUMBER, m_bVoiceDirNum);
	DDX_Control(pDX, IDC_DATA_TEI, m_bDataTEI);
	DDX_Control(pDX, IDC_DATA_SUB, m_bDataSub);
	DDX_Control(pDX, IDC_DATA_SPID, m_bDataSpid);
	DDX_Control(pDX, IDC_DATA_ISDN, m_bDataIsdn);
	DDX_Control(pDX, IDC_DATA_DIR_NUMBER, m_bDataDirNum);
	DDX_Control(pDX, IDC_CFG_LIST, m_INISectionControl);
	DDX_LBString(pDX, IDC_CFG_LIST, m_szPPINISection);
	DDX_Text(pDX, IDC_DATA_DIR_NUMBER, m_szPPDataDirNum);
	DDV_MaxChars(pDX, m_szPPDataDirNum, 24);
	DDX_Text(pDX, IDC_DATA_ISDN, m_szPPDataIsdn);
	DDV_MaxChars(pDX, m_szPPDataIsdn, 20);
	DDX_Text(pDX, IDC_DATA_SPID, m_szPPDataSpid);
	DDV_MaxChars(pDX, m_szPPDataSpid, 20);
	DDX_Text(pDX, IDC_DATA_SUB, m_szPPDataSub);
	DDX_CBString(pDX, IDC_DATA_TEI, m_szPPDataTEI);
	DDX_Text(pDX, IDC_VOICE_DIR_NUMBER, m_szPPVoiceDirNum);
	DDV_MaxChars(pDX, m_szPPVoiceDirNum, 24);
	DDX_Text(pDX, IDC_VOICE_ISDN, m_szPPVoiceIsdn);
	DDX_Text(pDX, IDC_VOICE_SPID, m_szPPVoiceSpid);
	DDV_MaxChars(pDX, m_szPPVoiceSpid, 20);
	DDX_Text(pDX, IDC_VOICE_SUB, m_szPPVoiceSub);
	DDX_CBString(pDX, IDC_VOICE_TEI, m_szPPVoiceTEI);
	DDX_Text(pDX, IDC_SWITCH_TYPE, m_szPPNetworkSwitchType);
	DDX_Text(pDX, IDC_DATA_PROTOCOL, m_szPPDataProtocol);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER_1, m_StrDialNumber1);
	DDV_MaxChars(pDX, m_StrDialNumber1, 40);
	DDX_Text(pDX, IDC_EDIT_PWORD1, m_1PWord);
	DDX_Text(pDX, IDC_EDIT_UNAME1, m_1UName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIsddnld, CDialog)
	//{{AFX_MSG_MAP(CIsddnld)
	ON_LBN_SELCHANGE(IDC_CFG_LIST, OnSelCfgList)
	ON_LBN_DBLCLK(IDC_CFG_LIST, OnCfgList)
	ON_CBN_SELCHANGE(IDC_DATA_PROTOCOL, OnDataProtocol)
	ON_CBN_SELCHANGE(IDC_DATA_TEI, OnDataTei)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_VOICE_TEI, OnVoiceTei)
	ON_EN_UPDATE(IDC_EDIT_PWORD1, OnUpdateEditPword1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIsddnld message handlers

BOOL CIsddnld::OnInitDialog()
{
	CDialog::OnInitDialog();
        
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	// TODO: Add extra initialization here

	char strLHS[40],strRHS[40];
	char *seps = "\0";
	int dwCount = 0;
	int length = 0;
	char szBuf[80] ;

	CString szDefaultConfig,Cfg,String;

	m_1PWordWnd.LimitText (PPP_PASSWORD_SIZE - 1) ;
	m_1UNamWnd.LimitText (PPP_USER_NAME_SIZE - 1) ;

	m_bDataSpid.LimitText (20);
 	m_bVoiceSpid.LimitText (20);
	m_bDataDirNum.LimitText (24);
	m_bVoiceDirNum.LimitText (24);

	m_bDataIsdn.LimitText (20);
	m_bVoiceIsdn.LimitText (20);
	m_bDataSub.LimitText (24);
	m_bVoiceSub.LimitText (24);


        //Checking for UPGRADE PROXY
        if (CommandLineArgument == 6)
                strcpy (FileName, NewIniInWinForm);
        else
                strcpy (FileName, IniInWinForm);

/* sudha 07 July 1999.This is needed especially for upgrade proxy to reflect
the recent ISDN values in roucon.ini to isdnta.ini */
   ReadISDNInfoFromRouconIniToIsdntaIni(0);

	GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) "WAN Port0 Dial Number",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_StrDialNumber1 = szBuf ;
	m_EditDialNumber1Wnd.SetWindowText ( m_StrDialNumber1 );
	
	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port0 User Name",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_1UName = szBuf ;
	m_1UNamWnd.SetWindowText ( m_1UName );



	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port0 User Password",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	char P1[80] ;
	Decrypt(szBuf, P1);
	m_1PWord = P1 ;
	m_1PWordWnd.SetWindowText ( m_1PWord );

	szDefaultConfig.LoadString ( IDS_DEFAULTCONFIG );
	Cfg.LoadString ( IDS_CONFIG );
	sprintf ( strLHS ,"%s1",Cfg );
	while(GetPrivateProfileString(szDefaultConfig,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		dwCount += 1;
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == LB_ERR )
		{
			// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)))
   			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	
	m_bDataTEI.ResetContent();
	m_bVoiceTEI.ResetContent();

	Isdn.FillComboBox ( ::GetDlgItem (m_hWnd,IDC_DATA_TEI), cfg_TEI );
	Isdn.FillComboBox ( ::GetDlgItem (m_hWnd,IDC_VOICE_TEI), cfg_TEI );	

	UpdateData ( FALSE );

	strcpy ( strLHS,"ISDN WAN Port0 ConfigName");
	GetPrivateProfileString ( WANSectionHeader,strLHS,StrNull,strRHS,sizeof ( strRHS ),
		FileName );
	
	if ( strcmp ( strRHS,StrNull ) != 0 )
 	{
		m_INISectionControl.SetCurSel ( m_INISectionControl.FindStringExact ( -1,strRHS ) );
		m_INISectionControl.GetText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
	}
	
	else
	{
		m_INISectionControl.SetCurSel(0);
		m_INISectionControl.GetText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
	}
	
	DisplayParameters();

//	UpdateData ( FALSE );

	m_bDialogInited = TRUE ; //A lock for password editing

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIsddnld::OnSelCfgList()
{
	// TODO: Add your control notification handler code here

	int index = 0;
	
	index = m_INISectionControl.GetCurSel();
	m_INISectionControl.GetText ( index, m_szPPINISection );
	DisplayParameters();
	
}

void CIsddnld::OnCfgList()
{
	// TODO: Add your control notification handler code here
		
}

void CIsddnld::DisplayParameters()
{
	char strRHS[40];
	CString String;
	BOOL DataTEI = FALSE;
	BOOL VoiceTEI = FALSE;

	strcpy(strRHS,GetStr("NetworkSwitchType"));
	m_bNetworkSwitchType.SetWindowText( strRHS );
	m_szPPNetworkSwitchType = strRHS;
	
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_SWITCH_TYPE_STR),FALSE ); 
	m_bNetworkSwitchType.EnableWindow ( FALSE );

	DetermineType ();

	strcpy(strRHS,GetStr("DataProtocol"));
	
	m_bDataProtocol.SetWindowText ( strRHS );
	m_szPPDataProtocol = strRHS ;
	
        ::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_PROTOCOL_TEXT),FALSE ); 
        m_bDataProtocol.EnableWindow ( FALSE );
        m_StatData.EnableWindow ( FALSE );
      
        strcpy(strRHS,GetStr ("DataTEI")) ;
	m_bDataTEI.SetCurSel(m_bDataTEI.FindStringExact(-1,strRHS));
	
	m_bDataTEI.GetLBText (m_bDataTEI.GetCurSel(), m_szPPDataTEI );
	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPDataTEI ) == 0 )
		DataTEI = TRUE;
	
	strcpy(strRHS,GetStr ("VoiceTEI")) ;
	m_bVoiceTEI.SetCurSel(m_bVoiceTEI.FindStringExact(-1,strRHS));
	
	m_bVoiceTEI.GetLBText ( m_bVoiceTEI.GetCurSel(),m_szPPVoiceTEI );
	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPVoiceTEI ) == 0 )
		VoiceTEI = TRUE;


	if ( !m_bUS )
	{
		m_StatUS.EnableWindow ( FALSE );
		m_StatEurope.EnableWindow ( TRUE );
	  	if ( DataTEI == TRUE )
			EuroData ( FALSE );
		else				
		{
			strcpy(strRHS,GetStr ( "DataMSN" ));
			if ( strRHS != NULL )
			{
				Isdn.MSNtoISDNSubAddress ( strRHS, m_szPPDataIsdn, m_szPPDataSub );
				m_bDataIsdn.SetWindowText(m_szPPDataIsdn);
		   	m_bDataSub.SetWindowText(m_szPPDataSub);
			}
		}
  
		if ( VoiceTEI == TRUE )
			EuroVoice ( FALSE ) ;
		else
 		{
			strcpy(strRHS,GetStr ( "VoiceMSN" ));
			if ( strRHS != NULL )
			{
				Isdn.MSNtoISDNSubAddress ( strRHS, m_szPPVoiceIsdn, m_szPPVoiceSub );
				m_bVoiceIsdn.SetWindowText(m_szPPVoiceIsdn);
				m_bVoiceSub.SetWindowText(m_szPPVoiceSub);
			}
		}
	}
	else if (m_bUS)
	{
		m_StatUS.EnableWindow ( TRUE );
		m_StatEurope.EnableWindow ( FALSE );
	  	if ( DataTEI == TRUE )
			UsData ( FALSE ) ;
		else
	  	{
			strcpy(strRHS,GetStr ( "DataSPID"));
			if ( strRHS	!= NULL )
				m_bDataSpid.SetWindowText ( strRHS );
			strcpy ( strRHS,GetStr ( "DataDirectoryNumber"));
			if ( strRHS != NULL )
				m_bDataDirNum.SetWindowText ( strRHS );
		}
		
		if ( VoiceTEI == TRUE )
			UsVoice ( FALSE );
  		else
		{
			strcpy ( strRHS,GetStr ( "VoiceSPID"));
			if ( strRHS != NULL )
				m_bVoiceSpid.SetWindowText ( strRHS );
			strcpy ( strRHS,GetStr ( "VoiceDirectoryNumber"));
			if ( strRHS != NULL )
				m_bVoiceDirNum.SetWindowText ( strRHS );
  		}
	}
}	

void CIsddnld::OnDataProtocol()
{
	// TODO: Add your control notification handler code here
	
}

void CIsddnld::OnDataTei()
{
	// TODO: Add your control notification handler code here
	CString String;

	m_bDataTEI.GetLBText ( m_bDataTEI.GetCurSel(),m_szPPDataTEI );
	
	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPDataTEI ) == 0 )
	{
		if ( m_bUS )
			UsData ( FALSE );
		else
			EuroData ( FALSE );
	}
	else
	{
		if ( m_bUS )
			UsData ( TRUE );
		else
			EuroData ( TRUE );
	}

	m_bVoiceTEI.SetFocus();
	
}

void CIsddnld::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_ISDN_DEFAULT_PARAMETERS,HELP_CONTEXT);
	
}

void CIsddnld::OnVoiceTei()
{
	// TODO: Add your control notification handler code here
	
	CString String;
	
	m_bVoiceTEI.GetLBText ( m_bVoiceTEI.GetCurSel(),m_szPPVoiceTEI );

	String.LoadString ( IDS_DISABLED );
	if ( String.CompareNoCase ( m_szPPVoiceTEI ) == 0 )
	{
		if ( m_bUS )
			UsVoice ( FALSE );
		else
			EuroVoice ( FALSE );
	}
	else
	{
		if ( m_bUS )
			UsVoice ( TRUE );
		else
			EuroVoice ( TRUE );
	}
}

void CIsddnld::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CIsddnld::OnOK()
{
	// TODO: Add extra validation here
	
	CString szDisabled;
	const int knMaxMSNLength = 24;
	const int knMaxDirLength = 24;
	const int knMaxSpidLength = 20 ;
	
	UpdateData ( TRUE );
	
	char szEncryptPassWd[42];
	char PWord[42];
 	
	int index ;
	index = m_INISectionControl.GetCurSel();
   if ( index == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Configuration file",IsdnMsgHeader,MB_OK );
		m_INISectionControl.SetFocus();
 		return;
	}

	m_INISectionControl.GetText ( index, m_szPPINISection );


	if ( m_bDataTEI.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Data TEI",IsdnMsgHeader,MB_OK );
		m_bDataTEI.SetFocus();
 		return;
	}

	if ( m_bVoiceTEI.GetCurSel() == CB_ERR )
	{
		::MessageBox ( GetSafeHwnd(),"Please select a Voice TEI",IsdnMsgHeader,MB_OK );
		m_bVoiceTEI.SetFocus();
 		return;
	}

	szDisabled.LoadString ( IDS_DISABLED );
/* Sudha 3 June 1998 */
	if (( strcmp (m_szPPNetworkSwitchType,"NET3") != 0 ) &&
			( strcmp (m_szPPNetworkSwitchType,"1TR6") != 0 ))		
	{
		if ( strcmp (m_szPPDataTEI,szDisabled ) ) 
		{
			if ( m_bUS )
			{
			 	if( m_szPPDataSpid.IsEmpty() )
				{
					::MessageBox(GetSafeHwnd(),"Enter Data SPID Number",IsdnMsgHeader,MB_OK);
					m_bDataSpid.SetFocus();
					return;
				}
				else
				{
					if ( (!Isdn.IsValid ( m_szPPDataSpid )) || (strlen ( m_szPPDataSpid ) > knMaxSpidLength ))
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 of length 20. ",IsdnMsgHeader,MB_OK );
						m_szPPDataSpid = "";
						UpdateData ( FALSE );
						m_bDataSpid.SetFocus();
						return;
					}
				}
#if 0 /* Sudha 04 Nov 1998.... */
				if ( m_szPPDataDirNum.IsEmpty () )
				{
					::MessageBox(GetSafeHwnd(),"Enter Data Directory Number",IsdnMsgHeader,MB_OK);
					m_bDataDirNum.SetFocus();
					return;
				}
				else
#endif /* Sudha 04 Nov 1998.... */
				if ( !m_szPPDataDirNum.IsEmpty () )
				{		
					if (( !Isdn.IsValid ( m_szPPDataDirNum )) || (strlen ( m_szPPDataDirNum ) > knMaxDirLength ))
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 of length 24.",IsdnMsgHeader,MB_OK );
						m_szPPDataDirNum = "";
						UpdateData ( FALSE );
						m_bDataDirNum.SetFocus();
						return;
					}	
				}
			}
			else
			{
				if( m_szPPDataIsdn.IsEmpty() )
				{
					::MessageBox(GetSafeHwnd(),"Enter Data ISDN Number",IsdnMsgHeader,MB_OK);
					m_bDataIsdn.SetFocus();
					return;
			
				}
				else
				{
					if ( !Isdn.IsValid ( m_szPPDataIsdn ) )
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPDataIsdn = "";
						UpdateData ( FALSE );
						m_bDataIsdn.SetFocus();
						return;
					 }
				}
				if ( m_szPPDataSub.IsEmpty () )
				{
					::MessageBox(GetSafeHwnd(),"Enter Data SubDirectory Address",IsdnMsgHeader,MB_OK);
					m_bDataSub.SetFocus();
					return;
				}
				else
				{
					if ( !Isdn.IsValid ( m_szPPDataSub ))
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPDataSub = "";
						UpdateData ( FALSE );
						m_bDataSub.SetFocus();
						return;
					}	
				}
			}
		}

  		if ( strcmp (m_szPPVoiceTEI,szDisabled ) ) 
		{
			if ( m_bUS )
			{
		 		if( m_szPPVoiceSpid.IsEmpty() )
				{
					::MessageBox(GetSafeHwnd(),"Enter Voice SPID Number",IsdnMsgHeader,MB_OK);
					m_bVoiceSpid.SetFocus();
					return;
				}
				else
				{
					if ( (!Isdn.IsValid ( m_szPPVoiceSpid ))	|| (strlen ( m_szPPVoiceSpid ) > knMaxSpidLength))
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPVoiceSpid = "";
						UpdateData ( FALSE );
						m_bVoiceSpid.SetFocus();
						return;
					 }
				}
#if 0 /* Sudha 04 Nov 1998.... */
				if ( m_szPPVoiceDirNum.IsEmpty () )
				{
					::MessageBox(GetSafeHwnd(),"Enter Voice Directory Number",IsdnMsgHeader,MB_OK);
					m_bVoiceDirNum.SetFocus();
					return;
				}
				else
#endif /* Sudha 04 Nov 1998.... */
				if ( !m_szPPVoiceDirNum.IsEmpty () )
				{
					if ( (!Isdn.IsValid ( m_szPPVoiceDirNum )) || (strlen( m_szPPVoiceDirNum ) > knMaxDirLength )) 
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPVoiceDirNum = "";
						UpdateData ( FALSE );
						m_bVoiceDirNum.SetFocus();
						return;
					}	
				}
			}
			else
			{
				if( m_szPPVoiceIsdn.IsEmpty() )
				{
					::MessageBox(GetSafeHwnd(),"Enter Voice ISDN Number",IsdnMsgHeader,MB_OK);
					m_bVoiceIsdn.SetFocus();
					return;
				}
				else
				{
					if ( !Isdn.IsValid ( m_szPPVoiceIsdn ) )
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPVoiceIsdn = "";
						UpdateData ( FALSE );
						m_bVoiceIsdn.SetFocus();
						return;
					 }
				}
				if ( m_szPPVoiceSub.IsEmpty () )
				{
					::MessageBox(GetSafeHwnd(),"Enter Voice SubDirectory Address",IsdnMsgHeader,MB_OK);
					m_bVoiceSub.SetFocus();
					return;
				}
				else
				{
					if ( !Isdn.IsValid ( m_szPPVoiceSub ))
					{
						::MessageBox ( GetSafeHwnd(),"Invalid Characters.Enter only 0-9 ",IsdnMsgHeader,MB_OK );
						m_szPPVoiceSub = "";
						UpdateData ( FALSE );
						m_bVoiceSub.SetFocus();
						return;
					}	
				}
			}
		}		
	}
	if ( !m_bUS )
	{
		Isdn.ISDNSubAddressToMSN ( m_szPPDataMSN, m_szPPDataIsdn, m_szPPDataSub );
		if ( (!m_szPPDataMSN.IsEmpty()) && (strlen(m_szPPDataMSN) > knMaxMSNLength ))
		{
			::MessageBox ( GetSafeHwnd(),"Length of DataISDN:DataSub exceeds 24.Enter new value",
				IsdnMsgHeader,MB_OK );
			m_szPPDataSub = "";
			UpdateData ( FALSE );
			m_bDataSub.SetFocus ();
			return ;
		}
		Isdn.ISDNSubAddressToMSN ( m_szPPVoiceMSN, m_szPPVoiceIsdn, m_szPPVoiceSub );
		if ( (!m_szPPVoiceMSN.IsEmpty()) && (strlen(m_szPPVoiceMSN) > 24 ))
		{
			::MessageBox ( GetSafeHwnd(),"Length of VoiceISDN:VoiceSub exceeds 24.Enter new value",
				IsdnMsgHeader,MB_OK );
			m_szPPVoiceSub = "";
			UpdateData ( FALSE );
			m_bVoiceSub.SetFocus ();
			return ;
		}
	}

	WriteStr("DataTEI",m_szPPDataTEI);
	WriteStr("VoiceTEI",m_szPPVoiceTEI);

	WriteStr ( "DataSPID",m_szPPDataSpid);
	WriteStr ( "DataDirectoryNumber",m_szPPDataDirNum);
	WriteStr ( "VoiceSPID", m_szPPVoiceSpid );
	WriteStr ( "VoiceDirectoryNumber", m_szPPVoiceDirNum );

	WriteStr("DataMSN",m_szPPDataMSN );
	WriteStr("VoiceMSN",m_szPPVoiceMSN );

	WritePrivateProfileString ( MapHeader,(LPCSTR) "Port0",m_szPPINISection,
		ini_INIFilename );

	WritePrivateProfileString(WANSectionHeader,
			(LPCSTR) "WAN Port0", StrEnabled, (LPCSTR) FileName);

	WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) "WAN Port0 Dial Number",
						(LPCSTR) m_StrDialNumber1, (LPCSTR) FileName) ;
	WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port0 User Name",
						(LPCSTR)m_1UName, (LPCSTR) FileName);

	if (m_1PWordWnd.GetModify()) {
		strcpy(PWord, (LPCSTR)m_1PWord);
		Encrypt (PWord, szEncryptPassWd) ;
		WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port0 User Password",
						(LPCSTR)szEncryptPassWd, (LPCSTR) FileName);
	}
	
	char LHS[40],Section[40];

	WritePrivateProfileString ( WANSectionHeader,(LPCSTR)"ISDN WAN Port0",StrEnabled,FileName );
	sprintf(LHS,"Port0");
	sprintf(Section,"%s",m_szPPINISection );
	WriteInfoInIni(LHS,Section );

	CDialog::OnOK();
}

void CIsddnld::WriteStr ( LPCSTR strLHS,LPCSTR strRHS)
{
	WritePrivateProfileString(m_szPPINISection,strLHS,strRHS,ini_INIFilename);
	return;
}

void CIsddnld::OnUpdateEditPword1()
{
	// TODO: Add your control notification handler code here
	int nPassLen = m_1PWord.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_1PWordWnd.LineLength (-1) > nPassLen || m_1PWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			UpdateData (TRUE) ;
			m_1PWord = StrNull ;
			UpdateData (FALSE) ;
		}
	}	
}

void CIsddnld::UsData ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPDataSpid = "";
		m_szPPDataDirNum = "";
		UpdateData ( FALSE );
	}

	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SPID_TEXT),set );
  	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SPID),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_DIR_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_DIR_NUMBER),set );
	
	return;
}

void CIsddnld::UsVoice ( BOOL set )
{
  	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPVoiceSpid = "";
		m_szPPVoiceDirNum = "";
		UpdateData ( FALSE );
	} 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SPID_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SPID),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_DIR_TEXT),set ); 
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_DIR_NUMBER),set);

	return;
}

void CIsddnld::EuroData ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPDataIsdn = "";
		m_szPPDataSub = "";
		UpdateData ( FALSE );
	}
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_ISDN_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SUB_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_ISDN),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_DATA_SUB),set );

	return;

}

void CIsddnld::EuroVoice ( BOOL set )
{
	if ( set == FALSE )
	{
		UpdateData ( TRUE );
		m_szPPVoiceIsdn = "";
		m_szPPVoiceSub = "";
		UpdateData ( FALSE );
  	}
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_ISDN_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SUB_TEXT),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_ISDN),set );
	::EnableWindow ( ::GetDlgItem(m_hWnd,IDC_VOICE_SUB),set );
	
	return;

}

void CIsddnld::DetermineType ()
{
 	m_bUS = Isdn.SwitchType ( m_szPPNetworkSwitchType );

 	if ( m_bUS )
	{
		m_StatUS.EnableWindow ( TRUE );
		m_StatEurope.EnableWindow ( FALSE );

		UsData ( TRUE );
		UsVoice ( TRUE );

		EuroData ( FALSE );
		EuroVoice ( FALSE );
	}
	else
	{
		m_StatUS.EnableWindow ( FALSE );
		m_StatEurope.EnableWindow ( TRUE );

		UsData ( FALSE );
		UsVoice ( FALSE );

		EuroData ( TRUE );
		EuroVoice ( TRUE );
	}
	return;
}

LPCSTR CIsddnld::GetStr ( LPCSTR strLHS )
{
	char strRHS[40];
	GetPrivateProfileString ( m_szPPINISection,strLHS,StrNull,strRHS,
		sizeof (strRHS),ini_INIFilename );
 	return strRHS;
}

void CIsddnld::WriteInfoInIni(char Buff[40],char RHS[40] )
{
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,FileName);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,FileName );
		InitstrLHS[32]++;
	}

/* Sudha 1 July 1998 */
   WritePrivateProfileString ( WANSectionHeader,InitstrLHS,"AT&W",FileName );
		InitstrLHS[32]++;

#if 0
	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,FileName );
	}
#endif	
/* Sudha 1 July 1998 */
	return;
}

void  CIsddnld::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

// Sudha 10 Feb 1998 
	if ( SPIDorISDN (command))
   {
   	if (!strcmp ( command,"!C6="))
      {      
      	WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,FileName );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
      }
	   strcat ( InitstrRHS , strRHS );
      WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,FileName );
      strcpy ( InitstrRHS ,"AT");
	   InitstrLHS[32]++;
   }
   else
   {
		len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
		if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
		if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
		{
			WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,FileName );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
			if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
				strcat ( InitstrRHS , strRHS );
		}
	}
	return ;
}


