// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	LOCPORT.CPP
// Description       :	Defines Class :
//									CLocalPortDlg	: Function of Port Setup Dialog.
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "locport.h"
#include "check.h"

LPCSTR LPortMsgHeader = "ProxyServer Local Port Setup";
LPCSTR LPortSectionHeader = "Port Setup";

LPCSTR	InitString = "Modem Init String";
LPCSTR	PortString = "Select Port";
LPCSTR	ConnectString = "Modem Connect Response";
LPCSTR	DialString = "Modem Dial String";
LPCSTR	InitRespString = "Modem Init Response";
LPCSTR	HangupString = "Modem Hangup String";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLocalPortDlg dialog


CLocalPortDlg::CLocalPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLocalPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLocalPortDlg)
	m_Port = "";
	m_ConnectResponse = "";
	m_DialString = "";
	m_InitString = "";
	m_InitResponse = "";
	m_HangupString = "";
	//}}AFX_DATA_INIT
}

void CLocalPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLocalPortDlg)
	DDX_Control(pDX, IDC_FIND_TARGET, m_FindTarget);
	DDX_Control(pDX, IDC_MODEM_TXT, m_ModemText);
	DDX_Control(pDX, IDC_RESPONSE, m_InitRespWnd);
	DDX_Control(pDX, IDC_INIT_STRING, m_InitStrWnd);
	DDX_Control(pDX, IDC_HANG_UP, m_HangWnd);
	DDX_Control(pDX, IDC_DIAL_STRING, m_DialStrWnd);
	DDX_Control(pDX, IDC_CONNECT_RESPONSE, m_ConnectWnd);
	DDX_Control(pDX, IDC_INIT_STR_TXT, m_InitStrText);
	DDX_Control(pDX, IDC_INIT_RESP_TXT, m_InitRespText);
	DDX_Control(pDX, IDC_HANG_TXT, m_HangText);
	DDX_Control(pDX, IDC_DIAL_TXT, m_DialText);
	DDX_Control(pDX, IDC_CONNECT_TXT, m_ConnectText);
	DDX_Control(pDX, IDC_PORT_TEXT, m_PortText);
	DDX_Control(pDX, IDC_COMBO1, m_PortWnd);
	DDX_Control(pDX, IDC_DIAL, m_Dial);
	DDX_CBString(pDX, IDC_COMBO1, m_Port);
	DDV_MaxChars(pDX, m_Port, 4);
	DDX_Text(pDX, IDC_CONNECT_RESPONSE, m_ConnectResponse);
	DDV_MaxChars(pDX, m_ConnectResponse, 20);
	DDX_Text(pDX, IDC_DIAL_STRING, m_DialString);
	DDV_MaxChars(pDX, m_DialString, 20);
	DDX_Text(pDX, IDC_INIT_STRING, m_InitString);
	DDV_MaxChars(pDX, m_InitString, 40);
	DDX_Text(pDX, IDC_RESPONSE, m_InitResponse);
	DDV_MaxChars(pDX, m_InitResponse, 20);
	DDX_Text(pDX, IDC_HANG_UP, m_HangupString);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLocalPortDlg, CDialog)
	//{{AFX_MSG_MAP(CLocalPortDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_DIAL, OnDial)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_FIND_TARGET, OnFindTarget)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLocalPortDlg message handlers

BOOL CLocalPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
        CenterWindow();
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;


		//-------------------------------------------------------------
		//	TargetFound  IsDCDPresent() Dial ~Dial(HangUP)  button Title
		//-------------------------------------------------------------
		//      0           0           1         0            Dial
		//      0           1           0         1           Hangup
		//      1           0           x         x         Greyed(Dial)
		//      1           1           0         1           Hangup

		m_Dial.SetWindowText((LPCSTR)"Hang&up");	//set button title to "hangup"

		BOOL isDCD, TgtFnd;
		isDCD = cMiscCom.IsDCDPresent(); 
		TgtFnd = ((CMainDlg *)GetParent())->TargetFound;

		if ( !isDCD ) 
			m_Dial.SetWindowText((LPCSTR)"Di&al");	//set button title to "Dial"
		
//Get the values of parameters
   char szBuf[50];
	GetPrivateProfileString(LPortSectionHeader, InitString,
					(LPCSTR) "ATS0=1&E5",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_InitString = szBuf;
	
	GetPrivateProfileString(LPortSectionHeader, PortString,
					(LPCSTR) "COM1",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_Port = szBuf;
	m_OldPort = m_Port;

   GetPrivateProfileString(LPortSectionHeader, ConnectString,
					(LPCSTR) "CONNECT",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_ConnectResponse = szBuf;

	GetPrivateProfileString(LPortSectionHeader, DialString,
					(LPCSTR) "ATDP",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_DialString = szBuf;

	GetPrivateProfileString(LPortSectionHeader, InitRespString,
					(LPCSTR) "OK",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_InitResponse = szBuf;

	GetPrivateProfileString(LPortSectionHeader, HangupString,
					(LPCSTR) "~~~+++~~~ATH0",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_HangupString = szBuf;
	
//Update the Dialog Box fields.
	UpdateData(FALSE);

	BOOL	NoTargetAndCD;
	NoTargetAndCD = !TgtFnd && !isDCD;
	m_InitRespWnd.EnableWindow(NoTargetAndCD);
	m_InitStrWnd.EnableWindow(NoTargetAndCD);
	m_DialStrWnd.EnableWindow(NoTargetAndCD);
	m_ConnectWnd.EnableWindow(NoTargetAndCD);
	m_HangWnd.EnableWindow(isDCD);

	m_PortText.EnableWindow(!TgtFnd);
	m_PortWnd.EnableWindow(!TgtFnd);
	m_FindTarget.EnableWindow(!TgtFnd);
	m_Dial.EnableWindow(!TgtFnd || isDCD);	

	m_InitRespText.EnableWindow(NoTargetAndCD);
	m_InitStrText.EnableWindow(NoTargetAndCD);
	m_DialText.EnableWindow(NoTargetAndCD);
	m_ConnectText.EnableWindow(NoTargetAndCD);
	m_HangText.EnableWindow(isDCD);

	m_ModemText.EnableWindow(!TgtFnd || isDCD);	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLocalPortDlg::OnOK()
{
// Update the parameters from the Dialog Box.
	UpdateData(TRUE);        

//Write the Parameters to INI file
	WritePrivateProfileString(LPortSectionHeader , PortString,
					(LPCSTR) m_Port, (LPCSTR) OwnIniFile);

   WritePrivateProfileString(LPortSectionHeader , InitString,
					(LPCSTR) m_InitString, (LPCSTR) OwnIniFile);

	WritePrivateProfileString(LPortSectionHeader , ConnectString,
					(LPCSTR) m_ConnectResponse, (LPCSTR) OwnIniFile);

	WritePrivateProfileString(LPortSectionHeader , DialString,
					(LPCSTR) m_DialString, (LPCSTR) OwnIniFile);

	WritePrivateProfileString(LPortSectionHeader , InitRespString,
					(LPCSTR) m_InitResponse, (LPCSTR) OwnIniFile);
					
	WritePrivateProfileString(LPortSectionHeader , HangupString,
					(LPCSTR) m_HangupString, (LPCSTR) OwnIniFile);

	CDialog::OnOK();
}

void CLocalPortDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PORT_SETUP,HELP_CONTEXT);
	
}

void CLocalPortDlg::OnFindTarget()
{
	ShowWindow(FALSE);
   AfxGetApp()->LoadCursor(IDC_WAIT);
   AfxGetApp()->DoWaitCursor(1);

//Update the COM port. And if changed write into INI file.
	UpdateData(TRUE);
	if (m_OldPort != m_Port) {
		m_OldPort = m_Port;			//Update the old port.
		WritePrivateProfileString(LPortSectionHeader , PortString,
					(LPCSTR) m_Port, (LPCSTR) OwnIniFile);

		//Close the current COM port and open the changed one.
		cMiscCom.Close_Comm();		//Added Pravin 5th Oct
		cMiscCom.Open_Comm();		//Added Pravin 5th Oct
	}

   CCheck cCheck(this);

	((CMainDlg *) GetParent())->CheckTarget();
	
   AfxGetApp()->DoWaitCursor(0);
	if (! ((CMainDlg *) GetParent())->TargetFound) {
  		ShowWindow(TRUE);
		return;
	}

	CDialog::OnCancel();
}

void CLocalPortDlg::OnDial()
{
	UpdateData(TRUE);	//Update the variables from dialog box.

	if (cMiscCom.IsDCDPresent()) {
	// This is hangup section 
		char    mdm_hangup[20];
		char    *tmp;

		if( RouMsgBox(MSG_LPORT_HANGUP, LPortMsgHeader, MB_YESNO 
		       | MB_DEFBUTTON2) == IDYES) {
			if( m_HangupString.IsEmpty()) {
				RouMsgBox(MSG_LPORT_INV_HUP_STR, LPortMsgHeader, MB_OK);
				m_HangWnd.SetFocus();
				return;
			}

			SetCapture();
			AfxGetApp()->LoadCursor(IDC_WAIT);
			AfxGetApp()->DoWaitCursor(1);

			m_HangupString += "^M" ;
			tmp = m_HangupString.GetBuffer(20);
			cMiscCom.ConvertControls((BYTE *)mdm_hangup, (BYTE *)tmp);
			m_HangupString.ReleaseBuffer();

			UINT nTimerID = 1;
			TimeOut = FALSE;
			while(nTimerID != SetTimer(nTimerID,(UINT)2000,NULL))
				if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, LPortMsgHeader,MB_RETRYCANCEL))
					return;

			cMiscCom.hangup_mdm(mdm_hangup, (BOOL *) &TimeOut);
			KillTimer(nTimerID);
			((CMainDlg *)GetParent())->TargetFound = FALSE;
			((CMainDlg *)GetParent())->ConfigurationRead = FALSE;
			((CMainDlg *)GetParent())->RouterUp = FALSE;
			((CMainDlg *)GetParent())->InitButtonState();
			AfxGetApp()->DoWaitCursor(0);
			ReleaseCapture();
			CDialog::OnCancel();
		}
		return;
	}

	// This is Dial Section

	SetCapture();
	AfxGetApp()->LoadCursor(IDC_WAIT);
	AfxGetApp()->DoWaitCursor(1);

//Update the COM port and write into INI file.
	if (m_OldPort != m_Port) {
		m_OldPort = m_Port;			//Update the old port.
		WritePrivateProfileString(LPortSectionHeader, PortString,
					(LPCSTR) m_Port, (LPCSTR) OwnIniFile);

		//Close the current COM port and open the changed one.
		cMiscCom.Close_Comm();		//Added Pravin 5th Oct
		cMiscCom.Open_Comm();		//Added Pravin 5th Oct
	}

	UINT nTimerID = 2;
	while(1) 
	{
		char	mdm_init_string[50];
		char	mdm_resp[30];
		char	*tmp;

		if( m_InitString.IsEmpty()) {
			RouMsgBox(MSG_LPORT_INV_INIT_STR, LPortMsgHeader, MB_OK);
			m_InitStrWnd.SetFocus();
			return;
		}
		m_InitString += "^M" ;
		tmp = m_InitString.GetBuffer(50);
		cMiscCom.ConvertControls((BYTE *)mdm_init_string, (BYTE *)tmp );
		m_InitString.ReleaseBuffer();

		tmp = m_InitResponse.GetBuffer(30);
		cMiscCom.ConvertControls((BYTE *)mdm_resp, (BYTE *)tmp);
		m_InitResponse.ReleaseBuffer();

		TimeOut = FALSE;
		while(nTimerID != SetTimer(nTimerID,(UINT)5000,NULL))
			if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, LPortMsgHeader,MB_RETRYCANCEL))
				return;

	// send modem init string
		cMiscCom.snd_mdm_command((BYTE *)mdm_init_string, strlen(mdm_init_string));
		if (!cMiscCom.rcv_mdm_response((BYTE *)mdm_resp, (BOOL *)&TimeOut) ) {
		// timeout occured and no response
			KillTimer(nTimerID);
			RouMsgBox(MSG_LPORT_NO_MDM_RESP, LPortMsgHeader,MB_OK | MB_ICONSTOP);
			return;
		}
		KillTimer(nTimerID);
		break;
	}

//Modem initialized successfully now send the dial string.

	while(1) 
	{
		char	mdm_dial_string[30];
		char	mdm_connect_resp[30];
		char	*tmp;
		
		if( m_DialString.IsEmpty()) {
			RouMsgBox(MSG_LPORT_INV_DIAL_STR, LPortMsgHeader, MB_OK);
			m_DialStrWnd.SetFocus();
			return;
		}

		WritePrivateProfileString(LPortSectionHeader , DialString,
				(LPCSTR) m_DialString, (LPCSTR) OwnIniFile);

		m_DialString += "^M" ;
		tmp = m_DialString.GetBuffer(30);
		cMiscCom.ConvertControls((BYTE *)mdm_dial_string, (BYTE *)tmp );
		m_DialString.ReleaseBuffer();

		tmp = m_ConnectResponse.GetBuffer(30);
		cMiscCom.ConvertControls((BYTE *)mdm_connect_resp, (BYTE *)tmp );
		m_ConnectResponse.ReleaseBuffer();

		TimeOut = FALSE;
		nTimerID = 3;
		while(nTimerID != SetTimer(nTimerID,(UINT)32000,NULL))
			if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, LPortMsgHeader,MB_RETRYCANCEL))
				return;

	//Send the dial string and wait for connect response.
		cMiscCom.snd_mdm_command((BYTE *)mdm_dial_string, strlen(mdm_dial_string));
		if (!cMiscCom.rcv_mdm_response((BYTE *)mdm_connect_resp, 
											(BOOL *) &TimeOut) ) {
			KillTimer(nTimerID);
			UINT nTimerID = 4;
			TimeOut = FALSE;
			char mdm_hangup[2];

			while(nTimerID != SetTimer(nTimerID,(UINT)2000,NULL))
				if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, LPortMsgHeader,MB_RETRYCANCEL))
					return;
			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0;
			cMiscCom.hangup_mdm(mdm_hangup, (BOOL *) &TimeOut);
			KillTimer(nTimerID);
			RouMsgBox(MSG_LPORT_ERR_CONNECT, LPortMsgHeader, MB_OK | 
							MB_ICONINFORMATION);    
			if(cMiscCom.IsDCDPresent()) {
				//set button title to "hangup"
				m_Dial.SetWindowText((LPCSTR)"Hang&up");	
			}
			return;
		}       
		else 
			KillTimer(nTimerID);
		break;
	}

	ShowWindow(FALSE);
	CCheck cCheck(this);
	((CMainDlg *)GetParent())->CheckTarget();
	AfxGetApp()->DoWaitCursor(0);
	CDialog::OnCancel();
}       //End of ButtonDial


void CLocalPortDlg::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
      KillTimer(nIDEvent);
      TimeOut = TRUE;
	
	CDialog::OnTimer(nIDEvent);
}

int	CLocalPortDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}


