/*----------------------------------------------------------------------------
  Project Name		:	MultiRouter Setup for Windows 
  File Name       :  MODEM.CPP
  Author          :  CFP
----------------------------------------------------------------------------*/

// modem.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "wandlg.h"
#include "modem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModemTypes dialog


CModemTypes::CModemTypes(CWnd* pParent /*=NULL*/)
	: CDialog(CModemTypes::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModemTypes)
	m_StrModemType = "";
	m_StrDialPrefix = "";
	m_StrRingMsg = "";
	m_StrDialSuffix = "";
	m_StrHangUp = "";
	m_StrMdmCmd1 = "";
	m_StrMdmCmd2 = "";
	m_StrMdmCmd3 = "";
	m_StrMdmCmd4 = "";
	m_StrMdmCmd5 = "";
	m_StrCmdOK = "";
	m_StrNoCarrier = "";
	m_StrCmdErr = "";
	m_StrNoDialTone = "";
	m_StrLineBusy = "";
	m_StrNoAnswer = "";
	m_StrConnect = "";
	//}}AFX_DATA_INIT

	m_bActionAdd = TRUE ;
}

void CModemTypes::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModemTypes)
	DDX_Control(pDX, IDC_EDIT_CONNECT, m_EditConnectWnd);
	DDX_Control(pDX, IDC_EDIT_NO_ANSWER, m_EditNoAnswerWnd);
	DDX_Control(pDX, IDC_EDIT_LINE_BUSY, m_EditLineBusyWnd);
	DDX_Control(pDX, IDC_EDIT_NO_DIAL_TONE, m_EditNoDialToneWnd);
	DDX_Control(pDX, IDC_EDIT_CMD_ERROR, m_EditCmdErrWnd);
	DDX_Control(pDX, IDC_EDIT_NO_CARRIER, m_EditNoCarrierWnd);
	DDX_Control(pDX, IDC_EDIT_CMD_OK, m_EditCmdOKWnd);
	DDX_Control(pDX, IDC_EDIT_MDM_CMD_5, m_EditMdmCmd5Wnd);
	DDX_Control(pDX, IDC_EDIT_MDM_CMD_4, m_EditMdmCmd4Wnd);
	DDX_Control(pDX, IDC_EDIT_MDM_CMD_3, m_EditMdmCmd3Wnd);
	DDX_Control(pDX, IDC_EDIT_MDM_CMD_2, m_EditMdmCmd2Wnd);
	DDX_Control(pDX, IDC_EDIT_MDM_CMD_1, m_EditMdmCmd1Wnd);
	DDX_Control(pDX, IDC_EDIT_HANGUP_STR, m_EditHangUpWnd);
	DDX_Control(pDX, IDC_EDIT_RING_MSG, m_EditRingMsgWnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_SUFFIX, m_EditDialSuffixWnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_PREFIX, m_EditDialPrefixWnd);
	DDX_Control(pDX, IDC_EDIT_MODEM_TYPES, m_EditModemTypeWnd);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPE_HDR, m_StatModemTypeWnd);
	DDX_Text(pDX, IDC_EDIT_MODEM_TYPES, m_StrModemType);
	DDX_Text(pDX, IDC_EDIT_DIAL_PREFIX, m_StrDialPrefix);
	DDX_Text(pDX, IDC_EDIT_RING_MSG, m_StrRingMsg);
	DDX_Text(pDX, IDC_EDIT_DIAL_SUFFIX, m_StrDialSuffix);
	DDX_Text(pDX, IDC_EDIT_HANGUP_STR, m_StrHangUp);
	DDX_Text(pDX, IDC_EDIT_MDM_CMD_1, m_StrMdmCmd1);
	DDX_Text(pDX, IDC_EDIT_MDM_CMD_2, m_StrMdmCmd2);
	DDX_Text(pDX, IDC_EDIT_MDM_CMD_3, m_StrMdmCmd3);
	DDX_Text(pDX, IDC_EDIT_MDM_CMD_4, m_StrMdmCmd4);
	DDX_Text(pDX, IDC_EDIT_MDM_CMD_5, m_StrMdmCmd5);
	DDX_Text(pDX, IDC_EDIT_CMD_OK, m_StrCmdOK);
	DDX_Text(pDX, IDC_EDIT_NO_CARRIER, m_StrNoCarrier);
	DDX_Text(pDX, IDC_EDIT_CMD_ERROR, m_StrCmdErr);
	DDX_Text(pDX, IDC_EDIT_NO_DIAL_TONE, m_StrNoDialTone);
	DDX_Text(pDX, IDC_EDIT_LINE_BUSY, m_StrLineBusy);
	DDX_Text(pDX, IDC_EDIT_NO_ANSWER, m_StrNoAnswer);
	DDX_Text(pDX, IDC_EDIT_CONNECT, m_StrConnect);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CModemTypes, CDialog)
	//{{AFX_MSG_MAP(CModemTypes)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CModemTypes message handlers

void CModemTypes::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CModemTypes::OnOK()
{
	// TODO: Add extra validation here

	int nRetVal ;
	if (!m_bActionAdd)
	{
		if (AreEditControlsModified())
		{
			nRetVal = MessageBox ("Contents have been modified.\n\
Do you want to save changes ?",
						"Modem Information", MB_YESNO | MB_ICONQUESTION) ;
			if (nRetVal == IDNO)
			{
				CDialog::OnCancel();
				return ;
			}
		}
		else
		{
			CDialog::OnCancel();
			return ;
		}
	}

	if (!UpdateData (TRUE))
		return ;

	CWanTab *pParent = (CWanTab *) GetParent() ;
	MODEM_SETUP *pModemSetup ;

	if (m_bActionAdd)
	{
		if (m_StrModemType.IsEmpty())
		{
			MessageBox ("Empty Modem Type not allowed",
				"Add Modem Type", MB_OK | MB_ICONINFORMATION) ;
			m_EditModemTypeWnd.SetFocus() ;
			return ;
		}

		if (FoundDuplicate (m_StrModemType))
		{
			MessageBox ("Duplicate Modem Type not allowed",
				"Add Modem Type", MB_OK | MB_ICONINFORMATION) ;
			m_EditModemTypeWnd.SetFocus() ;
			return ;
		}

		int nAddIndex = 
			pParent->m_advdlgWAN->m_combBoxModemTypes.AddString ((LPCSTR) m_StrModemType) ;
		for (int index = 0; index < pParent->tabcount; index++)
			pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.AddString ((LPCSTR) m_StrModemType) ;

		pModemSetup = (MODEM_SETUP *) new (MODEM_SETUP) ;
		if (pModemSetup == NULL)
		{
			MessageBox ("Out of memory!!!",
				"Modems - Add", MB_OK | MB_ICONSTOP) ;
			return ;
		}

		if (m_StrModemType == MODEM_TYPE_DIRECT_CONNECT)
		{
			MessageBox ("Other parameters will be ignored",
				"Modem Types - Add", MB_OK) ;
			memset (pModemSetup, 0x00, sizeof (MODEM_SETUP)) ;
			strcpy (pModemSetup->ModemType, (LPCSTR) m_StrModemType) ;
			pParent->m_advdlgWAN->m_combBoxModemTypes.SetItemDataPtr (nAddIndex,
								(MODEM_SETUP *) pModemSetup) ;
			for (index = 0; index < pParent->tabcount; index++)
				pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.SetItemDataPtr (nAddIndex,
								(MODEM_SETUP *) pModemSetup) ;
			CDialog::OnOK() ;
			return ;
		}

		strcpy (pModemSetup->ModemType, (LPCSTR) m_StrModemType) ;
		
		pParent->m_advdlgWAN->m_combBoxModemTypes.SetItemDataPtr (nAddIndex,
								(MODEM_SETUP *) pModemSetup) ;
		for (index = 0; index < pParent->tabcount; index++)
			pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.SetItemDataPtr (nAddIndex,
								(MODEM_SETUP *) pModemSetup) ;
	}
	else
	{
		int nCurSel = pParent->m_advdlgWAN->m_combBoxModemTypes.GetCurSel() ;

		pModemSetup = (MODEM_SETUP *)
			pParent->m_advdlgWAN->m_combBoxModemTypes.GetItemDataPtr (nCurSel) ;
	}

	GetAllFields (pModemSetup) ;
	
	CDialog::OnOK();
}

BOOL CModemTypes::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow() ;

	char CurrentHeading[80], NewHeading[80] ;
	GetWindowText (CurrentHeading, sizeof (CurrentHeading)) ;
	ModifyHeader (CurrentHeading, NewHeading) ;
	SetWindowText (NewHeading) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBmpBtn.SizeToContent();

	LimitAllFields() ;
	if (!m_bActionAdd)
		SetAllFields() ;

	UpdateData (FALSE) ;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CModemTypes::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_MODEM_TYPES, HELP_CONTEXT) ;
	
}


void CModemTypes::SetAllFields()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;

	MODEM_SETUP *pModemSetup ;
	pModemSetup = (MODEM_SETUP *) new (MODEM_SETUP) ;
	if (pModemSetup == NULL)
	{
		MessageBox ("Out of memory!!!",
			"Modems - Add", MB_OK | MB_ICONSTOP) ;
		return ;
	}
	
	int nCurSel = pParent->m_advdlgWAN->m_combBoxModemTypes.GetCurSel();
	pModemSetup = (MODEM_SETUP *)
	 		pParent->m_advdlgWAN->m_combBoxModemTypes.GetItemDataPtr (nCurSel) ;
	     			  
	m_StrModemType = pModemSetup->ModemType ;
	m_EditModemTypeWnd.EnableWindow (FALSE) ;
	m_StatModemTypeWnd.EnableWindow (FALSE) ;

	m_StrDialPrefix = pModemSetup->DialPrefix ;
	m_StrDialSuffix = pModemSetup->DialSuffix ;
	m_StrRingMsg = pModemSetup->RingMesg ;
	m_StrHangUp = pModemSetup->HangupStr ;
	m_StrMdmCmd1 = pModemSetup->InitStr1 ;
	m_StrMdmCmd2 = pModemSetup->InitStr2 ;
	m_StrMdmCmd3 = pModemSetup->InitStr3 ;
	m_StrMdmCmd4 = pModemSetup->InitStr4 ;
	m_StrMdmCmd5 = pModemSetup->InitStr5 ;
	m_StrCmdOK = pModemSetup->RespOK ;
	m_StrNoCarrier	= pModemSetup->RespNoCarrier ;
	m_StrCmdErr = pModemSetup->RespError ;
   m_StrNoDialTone = pModemSetup->RespNoDialtone ;
	m_StrLineBusy = pModemSetup->RespBusy ;
	m_StrNoAnswer = pModemSetup->RespNoAnswer ;
	m_StrConnect = pModemSetup->RespConnect ;

	return ;
}

void CModemTypes::LimitAllFields()
{
	m_EditModemTypeWnd.LimitText (MDM_TYPE_LEN - 1) ;
	m_EditDialPrefixWnd.LimitText (LEN_DIAL_PREFIX - 1) ; 
	m_EditDialSuffixWnd.LimitText (LEN_DIAL_SUFFIX - 1) ;
	m_EditRingMsgWnd.LimitText (LEN_RING_MESG - 1) ;
	m_EditHangUpWnd.LimitText (LEN_HANGUP_STR - 1) ;
	m_EditMdmCmd1Wnd.LimitText (LEN_MDM_STR - 1) ;
	m_EditMdmCmd2Wnd.LimitText (LEN_MDM_STR - 1) ;
	m_EditMdmCmd3Wnd.LimitText (LEN_MDM_STR - 1) ;
	m_EditMdmCmd4Wnd.LimitText (LEN_MDM_STR - 1) ;
	m_EditMdmCmd5Wnd.LimitText (LEN_MDM_STR - 1) ;
	m_EditCmdOKWnd.LimitText (LEN_RESP_OK - 1) ;
	m_EditNoCarrierWnd.LimitText (LEN_RESP_NO_CARRIER - 1) ;
	m_EditCmdErrWnd.LimitText (LEN_RESP_ERROR - 1) ;
	m_EditNoDialToneWnd.LimitText (LEN_RESP_NO_DIALTONE - 1) ;
	m_EditLineBusyWnd.LimitText (LEN_RESP_BUSY - 1) ;
	m_EditNoAnswerWnd.LimitText (LEN_RESP_NO_ANSWER - 1) ;
	m_EditConnectWnd.LimitText (LEN_RESP_CONNECT - 1) ;

	return ;
}

void CModemTypes::GetAllFields (MODEM_SETUP *pModemSetup)
{
	strcpy (pModemSetup->DialPrefix, (LPCSTR) m_StrDialPrefix) ;
	strcpy (pModemSetup->DialSuffix, (LPCSTR) m_StrDialSuffix) ;
	strcpy (pModemSetup->RingMesg, (LPCSTR) m_StrRingMsg) ;			
	strcpy (pModemSetup->HangupStr, (LPCSTR) m_StrHangUp) ;			
	strcpy (pModemSetup->InitStr1, (LPCSTR) m_StrMdmCmd1) ; 			
	strcpy (pModemSetup->InitStr2, (LPCSTR) m_StrMdmCmd2) ; 			
	strcpy (pModemSetup->InitStr3, (LPCSTR) m_StrMdmCmd3) ; 			
	strcpy (pModemSetup->InitStr4, (LPCSTR) m_StrMdmCmd4) ; 			
	strcpy (pModemSetup->InitStr5, (LPCSTR) m_StrMdmCmd5) ; 			
	strcpy (pModemSetup->RespOK, (LPCSTR) m_StrCmdOK) ;			
	strcpy (pModemSetup->RespNoCarrier, (LPCSTR) m_StrNoCarrier) ;			
	strcpy (pModemSetup->RespError, (LPCSTR) m_StrCmdErr) ;			
	strcpy (pModemSetup->RespNoDialtone, (LPCSTR) m_StrNoDialTone) ;			
	strcpy (pModemSetup->RespBusy, (LPCSTR) m_StrLineBusy) ;			
	strcpy (pModemSetup->RespNoAnswer, (LPCSTR) m_StrNoAnswer) ;			
	strcpy (pModemSetup->RespConnect, (LPCSTR) m_StrConnect) ;			

	return ;
}

BOOL CModemTypes::FoundDuplicate (CString &Modem)
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	int nSuccess ;
	if ((nSuccess = 
		pParent->m_advdlgWAN->m_combBoxModemTypes.FindStringExact (-1, Modem)) == CB_ERR)
	{
		return FALSE ;
	}
	else
		return TRUE ;
}


BOOL CModemTypes::AreEditControlsModified()
{
	if (m_EditConnectWnd.GetModify())
		return TRUE ;
	if (m_EditNoAnswerWnd.GetModify())
		return TRUE ;
	if (m_EditLineBusyWnd.GetModify())
		return TRUE ;
	if (m_EditNoDialToneWnd.GetModify())
		return TRUE ;
	if (m_EditCmdErrWnd.GetModify())
		return TRUE ;
	if (m_EditNoCarrierWnd.GetModify())
		return TRUE ;
	if (m_EditCmdOKWnd.GetModify())
		return TRUE ;
	if (m_EditMdmCmd5Wnd.GetModify())
		return TRUE ;
	if (m_EditMdmCmd4Wnd.GetModify())
		return TRUE ;
	if (m_EditMdmCmd3Wnd.GetModify())
		return TRUE ;
	if (m_EditMdmCmd2Wnd.GetModify())
		return TRUE ;
	if (m_EditMdmCmd1Wnd.GetModify())
		return TRUE ;
	if (m_EditHangUpWnd.GetModify())
		return TRUE ;
	if (m_EditRingMsgWnd.GetModify())
		return TRUE ;
	if (m_EditDialSuffixWnd.GetModify())
		return TRUE ;
	if (m_EditDialPrefixWnd.GetModify())
		return TRUE ;

	return FALSE ;
}

/*----------------------------------------------------------------------------
	Module 	: VerifyCheckSum
	Author 	: CFP
	Input  	: File ptr to file
	Output 	: Boolean indicating any read error or checksum validity
				  Returns TRUE if successful
	Synopsis	: Calculate checksum (simple add) on all bytes of file except
				  the first byte that is itself the checksum field
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL VerifyCheckSum (FILE *fptr)
{
	WORD result = 0 ;
	WORD one_word ;
	long filepos ;
	int ret_val ;

	// Save original position of file
	if ((filepos = ftell (fptr)) < 0)
		return FALSE ;

	// first seek to beginning 
	if (fseek (fptr, 0L, SEEK_SET) < 0)
		return FALSE ;

	while (TRUE)
	{
		ret_val = fread (&one_word, sizeof (WORD), 1, fptr) ;
		if (ret_val < 0) 
		{
			fseek (fptr, (long) filepos, SEEK_SET) ;
			return FALSE ; 
		}
		else
			if (ret_val == 0)
				break ;
		result += one_word ;
	}

	// Restore original position of file pointer
	fseek (fptr, (long) filepos, SEEK_SET) ;

	// As the checksum is in 2s complement
	// success should imply result being 0
	return (!result) ;
}

/*----------------------------------------------------------------------------
	Module 	: WriteCheckSum
	Author 	: CFP
	Input  	: File Ptr
	Output 	: Boolean indicating any read-write error
	Synopsis	: Calculate check sum for all bytes except
				  the first word and write the checksum as a 2s complement	
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL WriteCheckSum (FILE *fptr)
{
	WORD result = 0 ;
	WORD Buff ;
	long filepos ;
	int ret_val ;

	// Store previous position of pointer
	filepos = ftell (fptr) ; 
	if (filepos < 0)
		return FALSE ;

	// first seek to beginning of header version field
	if (fseek (fptr, (long) sizeof (WORD), SEEK_SET) < 0)
		return FALSE ;

	while (TRUE)
	{
		ret_val = fread (&Buff, sizeof (WORD), 1, fptr); 
		if (ret_val < 0)
			goto ret_false ;
		else 
			if (ret_val == 0)
				break ;
		result += Buff ;
	}

	// Make 2s complement
//	result = (WORD) -result ;
	result = -(int) result ;

	// Write the checksum
	if (fseek (fptr, 0L, SEEK_SET) < 0)
		goto ret_false ;

	if (fwrite (&result, sizeof(WORD), 1, fptr) != 1)
	{
ret_false:
		fseek (fptr, (long) filepos, SEEK_SET) ;
		return FALSE ;
	}

	// Reposition pointer to original position
	if (fseek (fptr, (long) filepos, 0) < 0)
		return FALSE ;
	return TRUE ;
}


void ConvertBlanksToBackSlashes (char *szDestination, char *szLocal)
{
	while (*szLocal)
	{
		if (*szLocal == ' ')
		{
			*szDestination++ = '\\' ;
			*szDestination++ = 'b' ;
		}
		else
		{
			*szDestination++ = *szLocal ;
		}
		szLocal ++ ;
	}
	*szDestination = 0x00 ;
	return ;
}

void ConvertBackSlashesToBlanks (char *szDestination, char *szLocal)
{
	while (*szLocal)
	{
		if ((*szLocal == '\\') && (*(szLocal + 1) == 'b'))
		{
		 	*szDestination++ = ' ' ;
			szLocal ++ ;
		}
		else
			*szDestination++ = *szLocal ;
 		szLocal ++ ;
	}
	*szDestination = 0x00 ;
	return ;
}


void WriteModemStringsToIni (int nPortNumber, MODEM_SETUP *pModemSetup) 
{
	char szBuf[20] ;
	char szLHSBuf[80] ;
	char szBlanksBackSlashes[100] ;

	sprintf (szBuf, "%s%d%s", "WAN Port", nPortNumber, " ") ;

	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MODEM_TYPE) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->ModemType) ;
	WritePrivateProfileString (WANSectionHeader,
				szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
		
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, DIAL_PREFIX) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->DialPrefix) ;
	WritePrivateProfileString (WANSectionHeader,
				szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, RING_MSG) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RingMesg) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, DIAL_SUFFIX) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->DialSuffix) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, HANGUP_STR) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->HangupStr) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MDM_CMD_1) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->InitStr1) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				

	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MDM_CMD_2) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->InitStr2) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MDM_CMD_3) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->InitStr3) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MDM_CMD_4) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->InitStr4) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, MDM_CMD_5) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->InitStr5) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, CMD_OK) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespOK) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																			
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, NO_CARRIER) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespNoCarrier) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, CMD_ERROR) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespError) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, NO_DIAL_TONE) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespNoDialtone) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, LINE_BUSY) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespBusy) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, NO_ANSWER) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespNoAnswer) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
																				
	strcpy (szLHSBuf, szBuf) ;
	strcat (szLHSBuf, CONNECT) ;
	ConvertBlanksToBackSlashes (szBlanksBackSlashes, pModemSetup->RespConnect) ;
	WritePrivateProfileString (WANSectionHeader,
			szLHSBuf, szBlanksBackSlashes, IniInWinForm) ;				
}

