// -------------------------------------------------------------------------
// Project Name			:	Standard progress gauges for MultiExpress Suite
//							programs.
// Module Name			:	Gauges implementation include file.
// File Name			:	MSGUVIEW.H
// Description			:	Implements horizontal, vertical, circular,
// 							counter and meter gauges for use in
//							MultiExpress Suite for Windows.
// Start Date			:	19 Oct 1994
// Author				:	Srini
// Date Last Modified	:	
// Modifications		:	
// -------------------------------------------------------------------------
                                                          
#ifndef		__MSGUVIEW__
#define		__MSGUVIEW__

// -------------------------------------------------------------------------
// The horizontal progress gauge.
// -------------------------------------------------------------------------
class	CHorzGauge : public CGauges {

	protected:
	
		void	DrawProgress(CWnd* pGaugeWnd);				// Updates the progress on screen
		void	DoPaint(CWnd* pGaugeWnd);					// Responds to a WM_PAINT message
		void	CalcGaugeWndSize(CWnd* pGaugeWnd);			// Calculates the gauge window size
};

// -------------------------------------------------------------------------
// The vertical progress gauge.
// -------------------------------------------------------------------------
class	CVertGauge : public CGauges {

	private:

		int		m_nRangeWd;									// Pixels needed for displaying
															// the range width
		int		m_nRangeHt;									// Pixels needed for height
		
	protected:
	
		void	DrawProgress(CWnd* pGaugeWnd);				// Updates the progress on screen
		void	DoPaint(CWnd* pGaugeWnd);					// Responds to a WM_PAINT message
		void	CalcGaugeWndSize(CWnd* pGaugeWnd);			// Calculates the gauge window size
};

// -------------------------------------------------------------------------
// The circular progress gauge.
// -------------------------------------------------------------------------
class	CCircleGauge : public CGauges {

	private:

		int		m_nCircleDia;								// Diameter of the circular gauge
		int		m_nRangeWd;									// Pixels needed for displaying
															// the range width
		int		m_nRangeHt;									// Pixels needed for height
		
	protected:
	
		void	DrawProgress(CWnd* pGaugeWnd);				// Updates the progress on screen
		void	DoPaint(CWnd* pGaugeWnd);					// Responds to a WM_PAINT message
		void	CalcGaugeWndSize(CWnd* pGaugeWnd);			// Calculates the gauge window size
};

// -------------------------------------------------------------------------
// The counter progress gauge.
// -------------------------------------------------------------------------
class	CCounterGauge : public CGauges {

	private:
	
		int		m_nNumDigits;								// Number of digits in the counter
		int		m_nCaptWidth;								// Pixels neede to write the caption

	protected:
	
		void	DrawProgress(CWnd* pGaugeWnd);				// Updates the progress on screen
		void	DoPaint(CWnd* pGaugeWnd);					// Responds to a WM_PAINT message
		void	CalcGaugeWndSize(CWnd* pGaugeWnd);			// Calculates the gauge window size
};

// -------------------------------------------------------------------------
// The meter progress gauge.
// -------------------------------------------------------------------------
class	CMeterGauge : public CGauges {

	private:

		int		m_nCircleDia;								// Diameter of the circular gauge
		CPoint	m_ptPrevPos;								// The previous position of the
															// pointer needle.

	protected:
	
		void	DrawProgress(CWnd* pGaugeWnd);				// Updates the progress on screen
		void	DoPaint(CWnd* pGaugeWnd);					// Responds to a WM_PAINT message
		void	CalcGaugeWndSize(CWnd* pGaugeWnd);			// Calculates the gauge window size
};

#endif		// __MSGUVIEW__

// -------------------------------------------------------------------------
// End of file - MSGUVIEW.H
// -------------------------------------------------------------------------
