// natdlg.h : header file
//
#include "dot.h"

struct STATIC_MAP_STRUCT
{
	char global_addr[25];
	char local_addr[25];
	STATIC_MAP_STRUCT *ptr_to_next;	
};

struct DYNAMIC_MAP_STRUCT
{
	char global_addr[25];
	char local_addr[25];
	char protocol[10];
	char port[50];
	DYNAMIC_MAP_STRUCT *ptr_to_next;	
};

extern void PadWithZeroes (char *dest, char *source, int size);
extern void GetProtocolNumber (char *dest, char *source);
int GetNumberOfPorts (char *port, char *protocol);
extern void GetPortNumber (char *dest, char *source, char *protocol, int number);
extern void GetProtocolName (char *dest, char *source);
extern void GetPortName (char *dest, char *source, char *protocol);

/////////////////////////////////////////////////////////////////////////////
// CNATDlg dialog

class CNATDlg : public CDialog
{
// Construction
public:
	CNATDlg(CWnd* pParent = NULL);	// standard constructor
	BOOL address_added;
	BOOL ValidateAdd();
	void GetConfig();
	void AcceptConfig();
	void free_memory();
	void save_global_list();
	void ShowMessageBox (int index);	

// Dialog Data
	//{{AFX_DATA(CNATDlg)
	enum { IDD = IDD_NAT_SETUP };
	CButton	m_ctrl_edit_map;
	CButton	m_ctrl_delete_map;
	CButton	m_ctrl_add_map;
	CButton	m_ctrl_delete;
	CButton	m_ctrl_add;
	CListBox	m_ctrl_mapping_details;
	CEdit	m_ctrl_edit_global_addr1;
	CListBox	m_ctrl_global_ip;
	CDotDecimal	m_edit_global_addr1;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;
	CBitmapButton AddMapBmpBtn;
	CBitmapButton DeleteMapBmpBtn;
	CBitmapButton EditMapBmpBtn;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CNATDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonDelete();
	virtual void OnOK();
	afx_msg void OnAddMap();
	afx_msg void OnEditMap();
	afx_msg void OnDeleteMap();
	virtual void OnCancel();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CNATMap dialog

class CNATMap : public CDialog
{
// Construction
public:
	CNATMap(CWnd* pParent = NULL);	// standard constructor
	BOOL ValidateMapping();
	void PutMappingInParentList();
	void ShowMessageBox (int index);	
	int mappings;
	char edit_gl_addr[16];
	char edit_lo_addr[16];
	char edit_protocol[16];
	char edit_port[50];

// Dialog Data
	//{{AFX_DATA(CNATMap)
	enum { IDD = IDD_NAT_MAPPING };
	CEdit	m_ctrl_local_address;
	CComboBox	m_ctrl_combo_port;
	CComboBox	m_ctrl_combo_protocol;
	CStatic	m_ctrl_static_port;
	CStatic	m_ctrl_static_protocol;
	CListBox	m_ctrl_global_address;
	CListBox	m_ctrl_global_addr;
	CButton	m_ctrl_radio_static;
	CButton	m_ctrl_radio_dynamic;
	CString	m_global_address;
	CDotDecimal	m_local_address;
	CString	m_protocol;
	CString	m_port;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton MapBmpBtn;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CNATMap)
	virtual void OnOK();
	afx_msg void OnButtonMap();
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioStatic();
	afx_msg void OnRadioDynamic();
	afx_msg void OnSelchangeComboProtocol();
	virtual void OnCancel();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
