// -------------------------------------------------------------------------
// Project Name                 :       MultiRouter Setup for Windows 
// File Name                    :       PARAMTR.h
// Description                  :       Defines various parameter structures.
// Start Date                   :       23rd Sept 1997
// Author                   	  :       Sudha
// Date Last Modified   		  :       
// Modifications                :       
// -------------------------------------------------------------------------


#ifndef _PARAMTR_H_

#define _PARAMTR_H_


#define NUMBER_OF_PROXY_PORTS 3
#define MDM_TYPE_LEN		50

//structure of Port_Status_Request
typedef struct
{
   unsigned char Ptype ;
   unsigned char major_version ; //0
   unsigned char minor_version ; //99
   unsigned long request_id ; // increment circularly
   unsigned char start_port ; //0
   unsigned char end_port ; // 0
} PortStatusRequest ;


//structure of Port_Status_Information
typedef struct {
   unsigned char port_number ;
   unsigned char status ;
   char user_name[PPP_USER_NAME_SIZE] ;
   unsigned long BaudRate ;
   char modem_name[MDM_TYPE_LEN] ;
   char modem_report[30] ;
   unsigned long local_ip_address ;
   unsigned long remote_ip_address ;
   unsigned long subnet_mask ;
   unsigned long connection_up_time ;
   unsigned long connection_tx_count ;
   unsigned long connection_rx_count ;

   unsigned long aggregate_tx_count ;
   unsigned long aggregate_rx_count ;
   unsigned long number_of_calls;
   unsigned long aggregate_connection_time ;

	//Vidy added
   unsigned long connection_tx_pkt_count ;
   unsigned long connection_rx_pkt_count ;

   unsigned long aggregate_tx_pkt_count ;
   unsigned long aggregate_rx_pkt_count ;

} PortStatusInfo ;

#if PROXY_SERVER
#define TFTP_HEADER_SIZE 512
#endif

#define PORT_STATUS_SIZE sizeof(PortStatusInfo)

//structure of Port_Status_Response
typedef struct
{
   unsigned char packet_type ;
   unsigned char error_code ;
   unsigned long request_id ;
   unsigned char start_port ;
   unsigned char end_port ;
   unsigned char number_of_records ;
	unsigned long system_up_time;
   PortStatusInfo port_information[NUMBER_OF_PROXY_PORTS] ;
} PortStatusResp ;

extern char *port_status_desc[] ;


#endif

