/// -------------------------------------------------------------------------
// Project Name                 :       MultiRouter Setup for Windows 
// File Name                    :       PORTINFO.CPP
// Description                  :       Displays the port status information
// Start Date                   :       23rd Sept 1997
// Author                   	  :       Sudha
// Date Last Modified   		  :       
// Modifications                : 
/// -------------------------------------------------------------------------

// portinfo.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "portstat.h"
#include "portinfo.h"
#include "boot.h"
#include "tftpwrit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


void dotted_to_decimal (unsigned long int_ip_address,char *dot_decimal_ip_address)
{
   unsigned long addr1,addr2,addr3,addr4 ;

   if (int_ip_address == 01)
   {
      strcpy(dot_decimal_ip_address," ") ;
      return ;
   }

   addr4 = int_ip_address & 0xFF ;
   addr3 = (int_ip_address & 0xFF00) >> 8 ;
   addr2 = (int_ip_address & 0xFF0000) >> 16 ;
   addr1 = (int_ip_address & 0xFF000000) >> 24 ;

   sprintf(dot_decimal_ip_address,"%lu.%lu.%lu.%lu",addr1,addr2,addr3,addr4) ;
   return ;
}

void CPortInfo::DisplayPortInfo (void)
{
   PortStatusInfo port_info ;
   char temp_string[80] ;
   int selected_port ;

   selected_port = ((CPortStat *)GetParent())->SelectedPort ;
   if (selected_port == LB_ERR)
      return ;

   ((CPortStat *)GetParent())->pChild = this ;

   memcpy (&port_info, ((CPortStat *)GetParent())->PortInformation[selected_port], sizeof(PortStatusInfo)) ;

   sprintf(temp_string, "%d", port_info.port_number + 1) ;	//Vidy
   m_Port     = temp_string ;

   m_Status   = port_status_desc[port_info.status] ;

   m_UserName = port_info.user_name ;

   sprintf (temp_string, "%lu", port_info.BaudRate) ;
   m_Baud     = temp_string ;

   m_Modem    = port_info.modem_name ;
   m_ModemRep = port_info.modem_report ;

   dotted_to_decimal (port_info.local_ip_address, temp_string) ;
   m_Local    = temp_string ;

   dotted_to_decimal (port_info.remote_ip_address, temp_string) ;
   m_Remote    = temp_string ;

   dotted_to_decimal (port_info.subnet_mask, temp_string) ;
   m_Subnet = temp_string ;

	//Vidy added the following parameters 31/10/97

	DwordToDayHrMinSecs(temp_string, port_info.connection_up_time) ;
   m_CUp     = temp_string ;

	PunctuateLong(temp_string, port_info.connection_tx_count);
   m_CBSnt     = temp_string ;

   PunctuateLong(temp_string, port_info.connection_rx_count) ;
   m_CBRcv     = temp_string ;

   PunctuateLong(temp_string, port_info.aggregate_tx_count) ;
   m_TBSnt     = temp_string ;

   PunctuateLong(temp_string, port_info.aggregate_rx_count) ;
   m_TBRcv     = temp_string ;

   PunctuateLong(temp_string, port_info.number_of_calls) ;
   m_TCalls     = temp_string ;

	DwordToDayHrMinSecs(temp_string, port_info.aggregate_connection_time) ;
   m_TUp     = temp_string ;

   PunctuateLong(temp_string, port_info.connection_tx_pkt_count) ;
	m_CPSnt = temp_string;

   PunctuateLong(temp_string, port_info.connection_rx_pkt_count) ;
	m_CPRcv = temp_string;

   PunctuateLong(temp_string, port_info.aggregate_tx_pkt_count) ;
	m_TPSnt = temp_string;

   PunctuateLong(temp_string, port_info.aggregate_rx_pkt_count) ;
	m_TPRcv = temp_string;

   UpdateData(FALSE) ;
}

/////////////////////////////////////////////////////////////////////////////
// CPortInfo dialog


CPortInfo::CPortInfo(CWnd* pParent /*=NULL*/)
	: CDialog(CPortInfo::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortInfo)
	m_Local = "";
	m_Port = "";
	m_Remote = "";
	m_Subnet = "";
	m_Baud = "";
	m_UserName = "";
	m_Modem = "";
	m_ModemRep = "";
	m_CBRcv = "";
	m_CPRcv = "";
	m_CPSnt = "";
	m_CBSnt = "";
	m_TUp = "";
	m_TCalls = "";
	m_TPRcv = "";
	m_TPSnt = "";
	m_TBRcv = "";
	m_TBSnt = "";
	m_CUp = "";
	m_Status = "";
	//}}AFX_DATA_INIT
}

void CPortInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortInfo)
	DDX_Text(pDX, IDC_STATIC_ELOCAL, m_Local);
	DDX_Text(pDX, IDC_STATIC_EPORT, m_Port);
	DDX_Text(pDX, IDC_STATIC_EREMOTE, m_Remote);
	DDX_Text(pDX, IDC_STATIC_EMASK, m_Subnet);
	DDX_Text(pDX, IDC_STATIC_EBAUD, m_Baud);
	DDX_Text(pDX, IDC_STATIC_EUSER, m_UserName);
	DDX_Text(pDX, IDC_STATIC_EMODEM, m_Modem);
	DDX_Text(pDX, IDC_STATIC_EMODEMREP, m_ModemRep);
	DDX_Text(pDX, IDC_STATIC_ECBYTRCV, m_CBRcv);
	DDX_Text(pDX, IDC_STATIC_ECPKTRCV, m_CPRcv);
	DDX_Text(pDX, IDC_STATIC_ECPKTSNT, m_CPSnt);
	DDX_Text(pDX, IDC_STATIC_ECBYTSNT, m_CBSnt);
	DDX_Text(pDX, IDC_STATIC_ETUPTIME, m_TUp);
	DDX_Text(pDX, IDC_STATIC_ETCALLS, m_TCalls);
	DDX_Text(pDX, IDC_STATIC_ETPKTRCV, m_TPRcv);
	DDX_Text(pDX, IDC_STATIC_ETPKTSNT, m_TPSnt);
	DDX_Text(pDX, IDC_STATIC_ETBYTRCV, m_TBRcv);
	DDX_Text(pDX, IDC_STATIC_ETBYTSNT, m_TBSnt);
	DDX_Text(pDX, IDC_STATIC_ECUP, m_CUp);
	DDX_Text(pDX, IDC_STATIC_STATUS, m_Status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPortInfo, CDialog)
	//{{AFX_MSG_MAP(CPortInfo)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_CANCEL, OnCancel)
	ON_BN_CLICKED(IDC_BUTTON_HUP_DIAL, OnButtonHupAndDial)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPortInfo message handlers

// -------------------------------------------------------------------------
// Function             :	CPortInfo::OnInitDialog.
// Arguments            :  None.
// Synopsis             :  Initialilzes the port information dialog box.
// Returns              :  TRUE.
// Globals Affected     :  None.
// -------------------------------------------------------------------------
extern char *port_status_desc[] ;
BOOL CPortInfo::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
    
   GetWindowText (CurrentHeading, 80) ;
   SubHeadingPointer = strchr (CurrentHeading, '-') ;

   if (SubHeadingPointer == NULL)
      SubHeadingPointer = CurrentHeading ;
   else
      SubHeadingPointer += 2 ;
    
   strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
   strcat (WindowHeader, " - ") ;
   strcat (WindowHeader, SubHeadingPointer) ;
   SetWindowText (WindowHeader) ;
   CenterWindow() ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDC_CANCEL, this));
	OKBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!RedialBmpBtn.LoadBitmaps ("REDIAL1", "REDIAL2", "REDIAL3", "REDIAL4"))
		AfxMessageBox ("Failed to load REDIAL bitmap");

	VERIFY (RedialBmpBtn.SubclassDlgItem (IDC_BUTTON_HUP_DIAL, this));
	RedialBmpBtn.SizeToContent();

   DisplayPortInfo() ;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPortInfo::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PORT_INFO, HELP_CONTEXT) ;	
}


void CPortInfo::OnCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel() ; 
	
}

int CPortInfo::RouMsgBox (HWND hWnd, int StrId, LPCSTR Header, int Opts)
{
	CString Message ;
	int Ret_val ;
	char NewHeader[50] ;

	Message.LoadString (StrId) ;
	ModifyHeader (Header, (LPCSTR) &NewHeader[0]) ;
	Ret_val = MessageBox (Message, (LPCSTR) &NewHeader[0], Opts) ;
	return Ret_val ;
}



void CPortInfo::OnButtonHupAndDial(void)
{
	// TODO: Add your control notification handler code here

  	int selected_port ;
	if (!IsPortIP)
	{	
		ReqType HupAndRedialPkt ;

	   selected_port = ((CPortStat *)GetParent())->SelectedPort ;

		HupAndRedialPkt.Ptype = (BYTE) HANGUP_AND_REDIAL;
		HupAndRedialPkt.ReqType = (BYTE)selected_port ;  //port number
		HupAndRedialPkt.ReqSubType = 0;
		HupAndRedialPkt.Dmy0 = 0;

		cPortSta.FlushReadBuf() ;	// Flush the receive buffer
		cPortSta.snd_packet ((BYTE *) &HupAndRedialPkt, sizeof (ReqType)) ;
	}
	else
	{
 	   selected_port = ((CPortStat *)GetParent())->SelectedPort ;
//		sprintf (TFTPPutLocalFileName, "%s_%d", "HUPANDREDIAL", selected_port) ;
//		For this command there is no need for any local file name.
//		But our TFTP download assumes that you really want send a file!
//		When it tries to open it gives a problem. SO I fix it by sending
//		a small file's name which is sure to exist. say Setup.ini
		sprintf (TFTPPutLocalFileName, "%s_%d", "setup.ini", selected_port) ;
  		sprintf (TFTPPutRemoteFileName, "%s_%d", "HUPANDREDIAL", selected_port) ;
 		tftpwrit tftpwrite;
 		tftpwrite.DoModal();
	}
}
