// -------------------------------------------------------------------------
// Project Name                 :       MultiRouter Setup for Windows 
// File Name                    :       POWERCOD.CPP
// Description                  :       Defines the CPowerCode Class 
// Start Date                   :       8th May 1995
// Author                   	  :       Pravin
// Date Last Modified   		  :       
// Modifications                :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include	"locport.h"
#include "powercod.h"
#include "boot.h"
#include "check.h"
#include "reboot.h"
#include "dialdlg.h"

#define TimerCount 4000    //Used for setting 4 Sec. timer.
#define CodeTimerID	840
#define CodeInterval 65000   // 65 Sec. timer for downloading code.

#define BufSize 150
#define DefaultFile 			"MTROUTER.BIN"

LPCSTR	FMUpMsgHeader = "Proxy Server Setup - Firmware update";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPowerCode dialog


CPowerCode::CPowerCode(CWnd* pParent /*=NULL*/)
	: CDialog(CPowerCode::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPowerCode)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CPowerCode::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPowerCode)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPowerCode, CDialog)
	//{{AFX_MSG_MAP(CPowerCode)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPowerCode message handlers

BOOL CPowerCode::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	CenterWindow() ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer (0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	
	// Open COM port for communication
	if (!cMiscDown.Open_Comm())
	{
		RouMsgBox (MSG_COM_ERR_OPEN, FMUpMsgHeader, MB_OK | MB_ICONSTOP) ;
		CDialog::OnCancel() ;
		return TRUE ;
	}

	// Dial the Router if the Dial string is present.
	if (!Connect())
	{
		RouMsgBox (MSG_COM_ERR_CONNECT, FMUpMsgHeader, MB_OK | MB_ICONSTOP) ;
		OnCancel() ;
		return FALSE ;
	}

	// Check if target is found and running
	CCheck cCheck (this) ;
	GetRouterStatus (FALSE) ;
	cCheck.DestroyWindow() ;

	if (TargetFound) 
	{
		if (RouterUp) 
		{
			if (boot_upgraded)
			{
				if (RouMsgBox (MSG_PWN_REBT_UPGR,
						 FMUpMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES) 
				{
					OnCancel() ;
					return FALSE ;
				}
			}
			else
			{
				if (RouMsgBox (MSG_PWN_REBT_DNLD_CODE,
						 FMUpMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES) 
				{
					OnCancel() ;
					return FALSE ;
				}
			}
			RebootDnld() ;
		}
	}
	else 
	{
		return TRUE ;  // return TRUE  unless you set the focus to a control
	}

	if (TargetFound && !RouterUp)
	{
		SetCapture() ;
		AfxGetApp()->LoadCursor (IDC_WAIT) ;
		AfxGetApp()->DoWaitCursor (1) ;

		DnldCode() ;
		AfxGetApp()->DoWaitCursor (0) ;
		ReleaseCapture() ;
//		Disconnect() ;			// we will fall thru to main dlg
		cMiscDown.Close_Comm() ;
		CDialog::OnOK() ;
	}

	return TRUE ;  // return TRUE  unless you set the focus to a control

}	// end of OnInitDialog

BOOL CPowerCode::LookString()
{
   UINT nTimerID = 51;
	char szBuf[BufSize];
	szBuf[BufSize -1] = 0;		//Ensure a null character at the end.
	int i = 0;
	char ch;

	while(nTimerID != SetTimer(nTimerID,(UINT)10000 ,NULL))
      if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER,  (FMUpMsgHeader),MB_RETRYCANCEL 
									| MB_ICONINFORMATION))
			return FALSE;
	
	cMiscDown.TimeOut = FALSE;

	//Fill the first few characters without comparison
	while ((i < 15) && (!cMiscDown.TimeOut)) {
		ch = cMiscDown.rcv_char(&cMiscDown.TimeOut);
		if ((!cMiscDown.TimeOut) && (ch != 0))
			szBuf[i++] = ch;
	}

	// Look for the string "download" in the buffer.
	while((strstr(szBuf, "download") == NULL) && (!cMiscDown.TimeOut)) {
		ch = cMiscDown.rcv_char(&cMiscDown.TimeOut);
		if ((!cMiscDown.TimeOut) && (ch != 0))
			szBuf[i++] = ch;
		if (i >= (BufSize-1))
			cMiscDown.TimeOut = TRUE;
	}
	KillTimer(nTimerID);
	cMiscDown.snd_char('d');	//send char 'd' to the target.
	return (!cMiscDown.TimeOut);
}	//end of LookString

void CPowerCode::OnTimer (UINT nIDEvent)
{
   if (nIDEvent == CodeTimerID) 
	{			// Timer for downloading Code.
      if (Loopcount >= 10) 
		{
			KillTimer (nIDEvent) ;
			cMiscDown.TimeOut = TRUE ;
      }
      Loopcount ++ ;
   }
   else 
	{
		KillTimer (nIDEvent) ;
		cMiscDown.TimeOut = TRUE ;
	}
	CDialog::OnTimer (nIDEvent) ;
}	// end of OnTimer

void CPowerCode::OnOK()
{
	SetCapture();
	AfxGetApp()->LoadCursor(IDC_WAIT);
	AfxGetApp()->DoWaitCursor(1);

	CCheck cCheck(this);

	// if the "download" string is found download the Configuration.
	if (LookString()) {
cCheck.ShowWindow(FALSE);
		DnldCode();
		AfxGetApp()->DoWaitCursor(0);
		ReleaseCapture();
//		Disconnect();		// we will fall through to main
		cMiscDown.Close_Comm();
		CDialog::OnOK();
	}
	else {
cCheck.ShowWindow(FALSE);
		AfxGetApp()->DoWaitCursor(0);
		ReleaseCapture();
		if (IDRETRY == RouMsgBox(MSG_GEN_NO_RESP_RTRY,
					 (FMUpMsgHeader), MB_RETRYCANCEL | MB_ICONQUESTION))
			return;
		else {
//			cCheck.ShowWindow(FALSE);
			Disconnect();
			cMiscDown.Close_Comm();
			CDialog::OnCancel();
		}
	}
}	//End of OnOK


#if 0
// Removed by cfp
// -------------------------------------------------------------------------
// Function   			:	CPowerCode::ConverttoHex
// Arguments  			:	char array and its length.
// Synopsis   			:	Converts the string to Hex DWORD
// Returns    			:	DWORD.
// Globals Affected  :	None.
// -------------------------------------------------------------------------
DWORD CPowerCode::ConverttoHEX(char *szBuf, int count)
{
   DWORD returnval = 0;
   BYTE *out;
   out = (BYTE *)&(returnval);                  
	int l = 0;
   int k = 0;
	AnsiUpperBuff(szBuf, count);

   while(( k < count) && (l < 4)) {
		char temp;
		temp = szBuf[count-1-k];
		if(temp >= 'A')
			temp = temp + 9;
		out[l] = 0x0F & temp ;
		k++;
		if(k != count){
			temp = szBuf[count-1-k];
			if(temp >= 'A')
				temp = temp + 9;
			out[l] |= ((0x0F & temp) << 4);
			k++;
		}       
		l++;    
   }
   return(returnval);
}	//end of ConverttoHEX
#endif

// -------------------------------------------------------------------------
// Function       	:	CPowerCode::DnldCode()
// Arguments      	:	None.
// Synopsis       	:	If Router is up call RebootDnld().Call DnldBIN().
// Returns           :	None.
// Globals Affected  :	RouterUp , TargetFound.
// -------------------------------------------------------------------------
void CPowerCode::DnldCode()
{
	int Retry = 0 ;
	ReqType brd_req_type ;
	OpenConnectionType bridge1 ;
	
	brd_req_type.Ptype = QUERY_BRIDGE_NAME ;	// 13
   CCheck cCheck (this) ;			// Display the checking message.

RETRY :   	
   cMiscDown.TimeOut = FALSE ;
   cCheck.ShowWindow (SW_SHOW) ;

	UINT nTimerID = 52 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, FMUpMsgHeader, 
						MB_RETRYCANCEL | MB_ICONINFORMATION)) 
		{
		  return ;                       
		}
	}
	
   while (1)
	{
		cMiscDown.FlushReadBuf() ;	// Flush the receive buffer
		cMiscDown.snd_packet ((BYTE *) &brd_req_type.Ptype,
														sizeof (brd_req_type)) ;
		if (!(cMiscDown.rcv_packet2 ((BYTE *) &bridge1,
						sizeof (bridge1),	(BOOL *) &cMiscDown.TimeOut)))
		{
			break ;    // No CRC error
		}
	}
	KillTimer (nTimerID) ;

	if (!cMiscDown.TimeOut)
	{
      cCheck.ShowWindow (SW_HIDE) ;
		if (bridge1.Ptype == RES_TYPE)				// 12
		{
			BYTE *incor ;
			WORD pra ;
			incor = (BYTE *) &pra ;
			incor[0] = bridge1.BrdName[1] ;
			incor[1] = bridge1.BrdName[2] ;
			pra = cMiscDown.ltl_endian_word (pra) ;
			switch (pra)
			{
				case ERR_NO_BRD_GET_PASSWORD :		// 18
					PasswordPktType passwd_pkt ;
					ResultType restype ;
					
					passwd_pkt.Ptype = (BYTE) PASSWD_TYPE ;	// 30
					passwd_pkt.Password[0] = (BYTE) 'x' ;
					passwd_pkt.Password[1] = (BYTE) '\0' ;
					
					cMiscDown.FlushReadBuf() ;	// Flush the receive buffer
					cMiscDown.snd_packet ((BYTE *) &passwd_pkt,
																sizeof (passwd_pkt)) ;
				
					cMiscDown.TimeOut = FALSE ;
					
					nTimerID = 53 ;
					while (nTimerID != SetTimer (nTimerID, 
												(UINT) TimerCount, NULL))
					{
						if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
							FMUpMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION)) 
						{
							return ;                  
						}
					}
						
					cMiscDown.rcv_packet2 ((BYTE *) &restype,
							sizeof (restype), (BOOL *) &cMiscDown.TimeOut) ;
					KillTimer (nTimerID) ;

					if (cMiscDown.TimeOut)
						RouMsgBox (MSG_GEN_NO_PWRD_RESP,  FMUpMsgHeader, 
								MB_OK | MB_ICONINFORMATION) ;
					else
					{
						if (restype.Ptype == ERR_PASSWORD)			// 13
						{
							RouMsgBox (MSG_GEN_ERR_PWRD_RESP,
								FMUpMsgHeader, MB_OK | MB_ICONINFORMATION) ;
						}
						else
							DnldBIN() ;		// Get the code file name and download.
					}
					break ;  

				case ERR_NO_BRD_NO_PASSWORD :		// 19
					DnldBIN() ;				// Get the code file name and download.
					break ;

				case ERR_CRC :			// 12
					break ;

	    		case 21 :  // Router Up
			   	RouMsgBox (MSG_GEN_ROUTER_IS_UP, FMUpMsgHeader,
													MB_OK | MB_ICONINFORMATION) ;
	       		break ;

				default :
					break ;
			}       
		}
		else 
		{
			if (Retry < 1)
			{
				Retry ++ ;
				goto RETRY ;
			}
			RouMsgBox (MSG_GEN_UNKNOWN_PKT, 
					FMUpMsgHeader, MB_OK | MB_ICONINFORMATION) ;
		}
	}
	else
   {
		if (Retry < 2)
		{
			Retry ++ ;
			goto RETRY ;
		}
      cCheck.ShowWindow (SW_HIDE) ;
		RouMsgBox (MSG_GEN_NO_ROUTER,
			FMUpMsgHeader, MB_OK | MB_ICONINFORMATION) ;
   }
}       // End of DnldCode

// -------------------------------------------------------------------------
// Function       	:	CPowerCode::DnldBIN()
// Arguments      	:	None.
// Synopsis       	:	Get Code file name. Send the Header. Call LZWCompress.
//								Call Reboot() if downloaded successfully.
//								DownLoad Firmware Update
// Returns           :	None.
// Globals Affected  :	None.
// -------------------------------------------------------------------------
void CPowerCode::DnldBIN()
{
	CString CodeFileName;

	if (boot_upgraded == 0)
	{
		CFileDialog cFileDlg (TRUE, (LPCSTR) "*.BIN", NULL, OFN_HIDEREADONLY 
  				| OFN_CREATEPROMPT, (LPCSTR) "Code Files (*.bin) | *.bin ||" , 
							AfxGetMainWnd()) ;
		cFileDlg.CenterWindow() ;
		if (IDOK != cFileDlg.DoModal())
  			return ;
  
		CodeFileName = cFileDlg.GetPathName() ;
	}
	else
	{
		CodeFileName = BootUpgrBinFile;
	}

	if ((boot_upgraded == 0) && ((strcmp(CodeFileName,B8BitBinFile) == 0)
		|| (strcmp(CodeFileName,B16BitBinFile) == 0)))
	{
		if (strncmp(BootVerString,"3.00",4) >= 0)
		{
			if (RouMsgBox (MSG_PWN_REBT_UPGR_NO_NEED,
					 FMUpMsgHeader, MB_YESNO | MB_ICONQUESTION) != IDYES) 
			{
				return ;
			}
		}
		if((buswidth == PROM_WIDTH_8BITS) &&
			(strcmp(CodeFileName,BootUpgrBinFile) != 0))
		{
			RouMsgBox (MSG_PWN_REBT_UPGR_8BIT,
				 FMUpMsgHeader, MB_OK | MB_ICONSTOP);
			return ;
		}
		else if((buswidth == PROM_WIDTH_16BITS) &&
			(strcmp(CodeFileName,BootUpgrBinFile) != 0))
		{
			RouMsgBox (MSG_PWN_REBT_UPGR_16BIT,
				 FMUpMsgHeader, MB_OK | MB_ICONSTOP);
			return ;
		}
		boot_upgraded = 1 ;
	}

	TargetCmdType cmd_type ;
	ResultType restype ;
	
	cMiscDown.CODE_CRC = 0xFFFF ;
	cMiscDown.ComprCodeSize = 0 ;
	cMiscDown.TimeOut = FALSE ;
	UINT nTimerID = 54 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, FMUpMsgHeader, 
										MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;                  
		}
	}

	cmd_type.Ptype = (BYTE) 0 ;
	cmd_type.TargetAction = (BYTE) DN_LD ;	 // 0

	cMiscDown.FlushReadBuf() ;	// Flush the receive buffer
	cMiscDown.snd_packet ((BYTE *) &cmd_type, sizeof (cmd_type)) ;
	cMiscDown.rcv_packet2 ((BYTE *) &restype, sizeof (restype),
													(BOOL *) &cMiscDown.TimeOut) ;
	KillTimer (nTimerID) ;

	if (cMiscDown.TimeOut)
	{
		RouMsgBox (MSG_GEN_NO_RESP, FMUpMsgHeader, MB_OK | MB_ICONINFORMATION);
	}
	else
	{
		dnld_head_type dnld_header ;
		DnLdPktHdrType hdr_type ;
		char *ptr ;
		int i ;

		for (i = sizeof (dnld_header), ptr = (char *) &dnld_header ; i ; i --)
		{
	  		*ptr++ = 0 ;
		}

		// Read the Code File and fill the version and Date fields.
		CStdioFile input;
		if (!input.Open (CodeFileName, CFile::modeRead | CFile::typeBinary))
		{
			RouMsgBox (MSG_GEN_FILE_OPEN_ERR, FMUpMsgHeader, 
												MB_OK | MB_ICONINFORMATION) ;
	   	return ;
		}

		struct
		{
			BYTE Version[8] ;
			BYTE DateStamp[24] ;
			BYTE MagicNum[5] ;
		} FileHeader ;

		input.Read (&FileHeader, 37);
		input.Close() ;	// Close the file.
		lstrcpy ((LPSTR) dnld_header.headtype.Version,
										(LPCSTR) &FileHeader.Version) ;
		lstrcpy ((LPSTR) dnld_header.headtype.DateStamp,
										(LPCSTR) &FileHeader.DateStamp) ;

		char szMagic[10] ;
		sprintf (szMagic, "%X", (WORD) MAGIC_NUM) ;
		if (strcmp ((LPCSTR) &FileHeader.MagicNum, szMagic)) 
		{
			RouMsgBox (MSG_PWN_INV_CODE, FMUpMsgHeader, MB_OK | MB_ICONSTOP) ;
			return ;
		}

		// Fill the other fields of download_header.
#ifdef NEW_BOOT_2
		dnld_header.headtype.LoadAddr = CodeLoadAddress ;
		dnld_header.headtype.StartAddr = CodeStartAddress ;
      dnld_header.headtype.DnLdAddress = FlCodeStartAddress ;
#else
		dnld_header.headtype.LoadAddr = COD_LOAD_ADDR ;
		dnld_header.headtype.StartAddr = COD_START_ADDR ;
      dnld_header.headtype.DnLdAddress = FL_CODE_START ;
#endif /* NEW_BOOT_2 */
		dnld_header.headtype.MagicNum = (WORD) MAGIC_NUM ;
		dnld_header.headtype.MagicNum = 
				cMiscDown.ltl_endian_word (dnld_header.headtype.MagicNum) ;
		dnld_header.headtype.LoadAddr =  
				cMiscDown.little_endian (dnld_header.headtype.LoadAddr) ;
		dnld_header.headtype.StartAddr = 
				cMiscDown.little_endian (dnld_header.headtype.StartAddr) ;
		dnld_header.headtype.DnLdAddress =  
				cMiscDown.little_endian (dnld_header.headtype.DnLdAddress) ;
						      
		dnld_header.hdr.PacketType = PT_HEADER ; // 1
		dnld_header.hdr.SeqNum = (BYTE) 0 ;
		hdr_type.PacketType = PT_UNKNOWN ; // 0
		cMiscDown.TimeOut = FALSE ;
		cMiscDown.ABORT = FALSE ;
		int no_of_ABORT = 0 ;

		nTimerID = 55 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 32000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
					FMUpMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;                 
			}
		}
		while ((hdr_type.PacketType != PT_ACK) && !cMiscDown.ABORT) // 6
		{
			cMiscDown.FlushReadBuf() ;	    // Flush the receive buffer
			cMiscDown.snd_dnld_packet ((BYTE *) &dnld_header,
														sizeof (dnld_header)) ;
			if (cMiscDown.rcv_dnld_packet2 ((BYTE *) &hdr_type,
					sizeof (hdr_type), (BOOL *) &cMiscDown.TimeOut))
			{
				continue ;
			}
			if (!cMiscDown.TimeOut)
			{
				KillTimer (nTimerID) ;

				switch (hdr_type.PacketType)
				{
					case 3 :
						if (no_of_ABORT == 1) 
						{
							RouMsgBox (MSG_COM_ROUTER_ABORT, 
								FMUpMsgHeader, MB_OK | MB_ICONINFORMATION) ;
							cMiscDown.ABORT = TRUE ;
						}
						no_of_ABORT ++ ;
						break ;

					default :
						break ;
				}
			}
		}
		if (cMiscDown.ABORT)
			return ;

		// Send the compressed code 
		cMiscDown.TimeOut = FALSE ;
		Loopcount = 0 ;
		while (CodeTimerID != SetTimer (CodeTimerID,
														(UINT) CodeInterval, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
						FMUpMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
			{
				return ;
			}
		}
									
		cMiscDown.LZWcompress ((BOOL *) &cMiscDown.TimeOut,
														CodeFileName, TRUE, TRUE) ;
		KillTimer (CodeTimerID) ;

		if (!cMiscDown.ABORT) 
		{
			cMiscDown.FlushReadBuf() ;	   // Flush the receive buffer
			cMiscDown.snd_eof_packet ((BOOL *) &cMiscDown.TimeOut, TRUE) ;
			Reboot() ;		// Reboot the target.
		}
	}       
}       //End of DnldBIN

// --------------------------------------------------------------------------
//	Function	:	GetRouterStatus
//	This routine will check for the router and set TargetFound and RouterUp
//	variables
// --------------------------------------------------------------------------
void CPowerCode::GetRouterStatus (BOOL ShowCheckDlg)
{
	ReqType brd_req_type ;
   OpenConnectionType bridge1 ;

	if (ShowCheckDlg)
		CCheck cCheck (this) ;
	   
	brd_req_type.Ptype = QUERY_BRIDGE_NAME ;		// 13
	cMiscDown.TimeOut = FALSE ;
	TargetFound = RouterUp = FALSE ;

	UINT nTimerID = 15 ;
	while (nTimerID != SetTimer (nTimerID, (UINT) TimerCount, NULL))
	{
		if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
				FMUpMsgHeader, MB_RETRYCANCEL | MB_ICONINFORMATION))
		{
			return ;    
		}
	}

	while (1)
	{
		cMiscDown.snd_packet ((BYTE *) &brd_req_type.Ptype,
														sizeof (brd_req_type)) ;
		if (!(cMiscDown.rcv_packet2 ((BYTE *) &bridge1,
					sizeof (bridge1), (BOOL *) &cMiscDown.TimeOut)))
		{
			break ;   // No CRC error
		}
	}
 
   KillTimer (nTimerID) ;
	TargetFound = !cMiscDown.TimeOut ;
 
	if (TargetFound)
	{
		if (bridge1.Ptype == RES_TYPE)		// 12
		{
			BYTE *incor ;
			WORD pra ;
			incor = (BYTE *) &pra ;
			incor[0] = bridge1.BrdName[1] ;
			incor[1] = bridge1.BrdName[2] ;
			pra = cMiscDown.ltl_endian_word (pra) ;
			switch (pra)
			{
				case 21 :       // Router is Up
					RouterUp = TRUE ;     // Router is running 
												 // and you can't Download
					break ;                                                          

				default :
					break ;
			}
		}
	}
}
// -------------------------------------------------------------------------
// Function         :       CPowerCode::RebootDnld()
// Arguments        :       None.
// Synopsis         :       Brings Router down so that it waits for download
//									 and updates its status.
// Returns          :       None.
// Globals Affected :       TargetFound, RouterUp.
// -------------------------------------------------------------------------
void CPowerCode::RebootDnld()
{
	RebootType rebootpkt ;

	rebootpkt.Ptype = (BYTE) REBOOT_TYPE ;		// 22
	rebootpkt.BootType = 0 ;         // Reboot to Download Code

	cMiscDown.FlushReadBuf() ;	// Flush the receive buffer
	cMiscDown.snd_packet ((BYTE *) &rebootpkt, sizeof (rebootpkt)) ;
	
	TargetFound = FALSE ;
	RouterUp = FALSE ;
	CReboot cReboot (this) ;
	AfxGetApp()->LoadCursor (IDC_WAIT) ;
	AfxGetApp()->DoWaitCursor (1) ;
	
	CCheck cCheck (this) ;

	for (int k = 0 ; (k < 20 && !TargetFound) ; k ++)
		GetRouterStatus (FALSE) ;

	cReboot.DestroyWindow() ;
	AfxGetApp()->DoWaitCursor (0) ;
	cMiscDown.FlushReadBuf() ;	// Flush the receive buffer
}  // END OF   RebootDnld

void CPowerCode::Reboot()
{
   CReboot cReboot(this);

	RebootType	rebootpkt;
	BOOL RouterUp;

	rebootpkt.Ptype = (BYTE)REBOOT_TYPE;	//  22;
	rebootpkt.BootType = 1;         // System Reboot

	UINT nTimerID = 56;
	cMiscDown.TimeOut = FALSE;
	while(nTimerID != SetTimer(nTimerID,(UINT)3000,NULL))
		if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, (FMUpMsgHeader),MB_RETRYCANCEL | 
					MB_ICONINFORMATION)) 
			return;    
   while ( ! cMiscDown.TimeOut)	//Delay
	{
		MSG msg;
		while(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	cMiscDown.FlushReadBuf();	//Flush the receive buffer
	cMiscDown.snd_packet((BYTE *)&rebootpkt, sizeof(rebootpkt));

	nTimerID = 57;
	cMiscDown.TimeOut = FALSE;
	while(nTimerID != SetTimer(nTimerID,(UINT)60000,NULL))
		if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, (FMUpMsgHeader),MB_RETRYCANCEL | 
					MB_ICONINFORMATION)) 
			return;    
   while ( ! cMiscDown.TimeOut)	//Delay
	{
		MSG msg;
		while(PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	cMiscDown.FlushReadBuf();	//Flush the receive buffer

   RouterUp = FALSE;
   for (int k=0; ( k<20 && !RouterUp); k++)
   {
		ReqType  brd_req_type;
	  	OpenConnectionType bridge1;
	  
		brd_req_type.Ptype = QUERY_BRIDGE_NAME;		//13
		cMiscDown.TimeOut = FALSE;
		RouterUp = FALSE;
		UINT nTimerID = 58;
		while(nTimerID != SetTimer(nTimerID,(UINT)TimerCount,NULL))
			if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, (FMUpMsgHeader),MB_RETRYCANCEL | 
				MB_ICONINFORMATION)) 
				return;    
		while(1)
		{
			cMiscDown.FlushReadBuf();	//Flush the receive buffer
			cMiscDown.snd_packet((BYTE *)&brd_req_type.Ptype, sizeof(brd_req_type));
			if(!(cMiscDown.rcv_packet2((BYTE *)&bridge1, sizeof(bridge1), (BOOL *)&cMiscDown.TimeOut)))
				break;//No CRC error
		}
    
	   if(!cMiscDown.TimeOut)
		{
   	  	KillTimer(nTimerID);
			if(bridge1.Ptype == RES_TYPE)			//12
			{
	     		BYTE *incor;
				WORD pra;
				incor = (BYTE *)&pra;
				incor[0]=bridge1.BrdName[1];
				incor[1]=bridge1.BrdName[2];
				pra=cMiscDown.ltl_endian_word(pra);
				switch (pra)
				{
					case 21 :       //RouterUp
						RouterUp = TRUE;                        //Router is running and you can't Download
						break;                                                          
					default:
						break;
				}       
		  	}
		}
	}
   cReboot.DestroyWindow();
}	//end of Reboot

BOOL CPowerCode::Connect()
{
	char szBuf[50] ;
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse ;

	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
			(LPCSTR) DialString,	(LPCSTR) "ATDP", (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) OwnIniFile) ;
	m_DialString = szBuf ;
	if (m_DialString.IsEmpty() || cMiscDown.IsDCDPresent())
		return TRUE ;

	CDialDlg cDialDlg (this) ;

	// Dial the Router.
	UINT nTimerID = 2 ;
	{
		char mdm_init_string[50] ;
		char mdm_resp[30] ;
		char *tmp ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) InitString,	(LPCSTR) "ATS0=1&E5",
					(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_InitString = szBuf ;

		m_InitString += "^M" ;
		tmp = m_InitString.GetBuffer(50) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_init_string, (BYTE *) tmp) ;
		m_InitString.ReleaseBuffer() ;

		GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
			(LPCSTR) InitRespString, (LPCSTR) "OK", (LPSTR) szBuf,
					sizeof(szBuf),	(LPCSTR) OwnIniFile) ;
		m_InitResponse = szBuf ;
		tmp = m_InitResponse.GetBuffer(30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_resp, (BYTE *) tmp) ;
		m_InitResponse.ReleaseBuffer() ;

		cMiscDown.TimeOut = FALSE ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 5000, NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER, 
									FMUpMsgHeader, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// send modem init string and look for response
		cMiscDown.snd_mdm_command ((BYTE *) mdm_init_string,
													strlen (mdm_init_string)) ;
		if (!cMiscDown.rcv_mdm_response ((BYTE *) mdm_resp, 
														(BOOL *) &cMiscDown.TimeOut))
		{
			// timeout occured and no response
			KillTimer (nTimerID) ;
			RouMsgBox (MSG_PWN_NO_MDM_RESP, 
							FMUpMsgHeader, MB_OK | MB_ICONSTOP) ;
			SendMessage (WM_CLOSE) ;
			goto Error_Exit ;
		}
		KillTimer (nTimerID) ;
	}

	// Modem initialized successfully now send the dial string.
	{	
		char mdm_dial_string[30] ;
		char mdm_connect_resp[30] ;
		char *tmp ;

		m_DialString += "^M" ;
		tmp = m_DialString.GetBuffer (30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_dial_string, (BYTE *) tmp) ;
		m_DialString.ReleaseBuffer() ;

   	GetPrivateProfileString ((LPCSTR) LPortSectionHeader,
				(LPCSTR) ConnectString,	(LPCSTR) "CONNECT",
					(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) OwnIniFile) ;
		m_ConnectResponse = szBuf ;
		tmp = m_ConnectResponse.GetBuffer (30) ;
		cMiscDown.ConvertControls ((BYTE *) mdm_connect_resp, (BYTE *) tmp) ;
		m_ConnectResponse.ReleaseBuffer() ;

		cMiscDown.TimeOut = FALSE ;
		nTimerID = 3 ;
		while (nTimerID != SetTimer (nTimerID, (UINT) 45000 ,NULL))
		{
			if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
										FMUpMsgHeader, MB_RETRYCANCEL))
			{
				SendMessage (WM_CLOSE) ;
				goto Error_Exit ;
			}
		}

		// Send the dial string and wait for connect response.
		cMiscDown.snd_mdm_command ((BYTE *) mdm_dial_string,
													strlen (mdm_dial_string)) ;
		if (!cMiscDown.rcv_mdm_response ((BYTE *) mdm_connect_resp, 
													(BOOL *) &cMiscDown.TimeOut))
		{
			KillTimer (nTimerID) ;
			UINT nTimerID = 4 ;
			cMiscDown.TimeOut = FALSE ;
			char mdm_hangup[2] ;

			while (nTimerID != SetTimer (nTimerID, (UINT) 2000, NULL))
			{
				if (IDCANCEL == RouMsgBox (MSG_GEN_NO_TIMER,
												FMUpMsgHeader, MB_RETRYCANCEL))
				{
					SendMessage (WM_CLOSE) ;
					goto Error_Exit ;
				}
			}

			mdm_hangup[0] = 0x1b ;
			mdm_hangup[1] = 0 ;
			cMiscDown.hangup_mdm (mdm_hangup, (BOOL *) &cMiscDown.TimeOut) ;
			KillTimer (nTimerID) ;
		}       
		else
		{
			KillTimer (nTimerID) ;
			cDialDlg.DestroyWindow() ;
			return TRUE ;
		}
	}
Error_Exit:
	cDialDlg.DestroyWindow() ;
	return FALSE ;
}	// End of Connect

void CPowerCode::Disconnect()
{
	ShowWindow(FALSE);
	char 	szBuf[50];
	CString m_InitString, m_InitResponse, m_DialString, m_ConnectResponse;

	GetPrivateProfileString(LPortSectionHeader, DialString,
					(LPCSTR) "ATDP",(LPSTR) szBuf ,sizeof(szBuf),
					(LPCSTR) OwnIniFile);
	m_DialString = szBuf;
	if (m_DialString.IsEmpty())
		return;

	if (cMiscDown.IsDCDPresent())
		if (RouMsgBox(MSG_GEN_ASK_HUP,  (FMUpMsgHeader), MB_YESNO
					| MB_DEFBUTTON1 | MB_ICONQUESTION) != IDYES)
		return;

	UINT nTimerID = 4;
	cMiscDown.TimeOut = FALSE;
	char mdm_hangup[2];

	while(nTimerID != SetTimer(nTimerID,(UINT)2000,NULL))
		if(IDCANCEL == RouMsgBox(MSG_GEN_NO_TIMER, (FMUpMsgHeader),MB_RETRYCANCEL)) {
			return;
		}

	mdm_hangup[0] = 0x1b ;
	mdm_hangup[1] = 0;
	cMiscDown.hangup_mdm(mdm_hangup, (BOOL *) &cMiscDown.TimeOut);
	KillTimer(nTimerID);
}	//End of Disconnect

void CPowerCode::OnCancel()
{
	Disconnect();
	cMiscDown.Close_Comm();

	CDialog::OnCancel();
}

int	CPowerCode::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message ;
	char NewHeader[50] ;
	int	Ret_val;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}


