// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	PPPDLG.CPP
// Description       :	Defines Classes :
//								CPPPDlg 		: Function of PPP Dialog
//								CPPortDlg	: Function of PPP Port Tabs
//								CPTab			: Function of PPP Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :	10/01/96 Vidy added DOD support
// -------------------------------------------------------------------------
// Vidy 05/12/96		: if only one wan, don't show WAN 1 (show WAN) - got it?

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "pppdlg.h"
#include "tabdlg.h"
#include	"cryptfns.h"
#include "hardware.h"

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         

LPCSTR	PPPSectionHeader = "PPP Device Driver";
LPCSTR	PPPMsgHeader = "ProxyServer Setup - PPP";
BOOL fClientOnly;

#define Max_BackoffInterval 65535
#define Min_BackoffInterval 5

#define Max_MaxConfigReq 65535
#define Min_MaxConfigReq 3

#define Max_MaxEchoReq 20
#define Min_MaxEchoReq 1

#define Max_MaxTermReq 20
#define Min_MaxTermReq 1

#define Max_MaxSendConfigInter 65535
#define Min_MaxSendConfigInter 5

#define Max_MaxSendEchoInter 65535
#define Min_MaxSendEchoInter 0

#define Max_MaxSendTermInter 65535
#define Min_MaxSendTermInter 5

#define Max_MaxAuthRetry 65535
#define Min_MaxAuthRetry 3

#define Max_AuthTimer 65535
#define Min_AuthTimer 5

#define Max_MaxReceive 4500
#define Min_MaxReceive 1500

#define Max_MaxRemoteReceive 4500
#define Min_MaxRemoteReceive 1500

#define Max_AsyncCount 65535
#define Min_AsyncCount 0

#define Max_AsyncSize 65535
#define Min_AsyncSize 0

#define Max_TimetoSendLQR 65535
#define Min_TimetoSendLQR 0

#define Max_SLIPMTU 1006
#define Min_SLIPMTU 100

#define Max_DODIdleTime 5 * 24 * 60		//hangup after hours idle
#define Min_DODIdleTime	1			//idle time before hangup
#define Def_DODIdleTime	3

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CPPPDlg dialog


CPPPDlg::CPPPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPPPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPPPDlg)
	m_nBackoffInterval = 5 ;
	m_nMaxConfigReq = 3 ;
	m_nMaxEchoReq = 1 ;
	m_nMaxTermReq = 1 ;
	m_Printf = FALSE;
	m_PrintfAlarm = FALSE;
	m_PrintfLCP = FALSE;
	m_PrintfNCP = FALSE;
	m_nMaxSendConfigInter = 5 ;
	m_nMaxSendEchoInter = 0 ;
	m_nMaxSendTermInter = 5 ;
	m_MLPPP = FALSE;
	//}}AFX_DATA_INIT
	Create(IDD,NULL);
}

void CPPPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPPPDlg)
	DDX_Control(pDX, IDC_CHECK2, m_dialout);
	DDX_Control(pDX, IDC_CHECK1, m_MLPPPWnd);
	DDX_Control(pDX, IDC_SEND_TERM_INTERVAL, m_SendTermWnd);
	DDX_Control(pDX, IDC_SEND_ECHO_INTERVAL, m_SendEchoWnd);
	DDX_Control(pDX, IDC_SEND_CONFIG_INTERVAL, m_SendConfigWnd);
	DDX_Control(pDX, IDC_MAX_TERM_REQ, m_MaxTermReqWnd);
	DDX_Control(pDX, IDC_MAX_ECHO_REQ, m_MaxEchoReqWnd);
	DDX_Control(pDX, IDC_MAX_CONFIG_REQ, m_MaxConfigReqWnd);
	DDX_Control(pDX, IDC_BACKOFF_CONFIG, m_BackoffWnd);
	DDX_Text(pDX, IDC_BACKOFF_CONFIG, m_nBackoffInterval);
	DDX_Text(pDX, IDC_MAX_CONFIG_REQ, m_nMaxConfigReq);
	DDX_Text(pDX, IDC_MAX_ECHO_REQ, m_nMaxEchoReq);
	DDX_Text(pDX, IDC_MAX_TERM_REQ, m_nMaxTermReq);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_ALARM, m_PrintfAlarm);
	DDX_Check(pDX, IDC_PRINTF_LCP, m_PrintfLCP);
	DDX_Check(pDX, IDC_PRINTF_NCP, m_PrintfNCP);
	DDX_Text(pDX, IDC_SEND_CONFIG_INTERVAL, m_nMaxSendConfigInter);
	DDX_Text(pDX, IDC_SEND_ECHO_INTERVAL, m_nMaxSendEchoInter);
	DDX_Text(pDX, IDC_SEND_TERM_INTERVAL, m_nMaxSendTermInter);
	DDX_Check(pDX, IDC_CHECK1, m_MLPPP);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPPPDlg, CDialog)
	//{{AFX_MSG_MAP(CPPPDlg)
	ON_BN_CLICKED(IDC_PPP_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPPPDlg message handlers

BOOL CPPPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;


	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_PPP_HELP, this));			  
	HelpBmpBtn.SizeToContent();

	char szBuf[30];

//Get the values of all PPP parameters from INI file.
	
   //Get the BOOL parameters.
	GetPrivateProfileString(PPPSectionHeader, 
		(LPCSTR) "PPP Printf", StrDisabled,
		(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_Printf = TRUE;
	else m_Printf = FALSE;
	
	GetPrivateProfileString(PPPSectionHeader, 
		(LPCSTR) "PPP Printf Alarm", StrDisabled,
		(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfAlarm = TRUE;
	else m_PrintfAlarm = FALSE;
	
	GetPrivateProfileString(PPPSectionHeader, 
		(LPCSTR) "PPP Printf LCP", StrDisabled,
		(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfLCP = TRUE;
	else m_PrintfLCP = FALSE;
	
	
	GetPrivateProfileString(PPPSectionHeader, 
		(LPCSTR) "PPP Printf NCP", StrDisabled,
		(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfNCP = TRUE;
	else m_PrintfNCP = FALSE;

/* sudha 17 Nov 1998 */
	GetPrivateProfileString(PPPSectionHeader, 
		(LPCSTR) "PPP Ports Need To Dial Out Initially", StrEnabled,
		(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_dialout.SetCheck(1) ;
	else m_dialout.SetCheck(0) ;
/* sudha 17 Nov 1998 */
	
   //Get the uint parameters.
	m_nBackoffInterval = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Configuration Request Backoff Interval", 5,
				(LPCSTR) IniInWinForm);

	m_nMaxConfigReq = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Number of Configuration Requests", 3,
				(LPCSTR) IniInWinForm);

	m_nMaxEchoReq = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Number of Unacknowledged Echo Requests",1,
				(LPCSTR) IniInWinForm);

	m_nMaxTermReq = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Number of Termination Requests", 1,
				(LPCSTR) IniInWinForm);

// Removed by cfp on 28-3-96
	m_nMaxSendConfigInter = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Configuration Request Send Interval", 5,
				(LPCSTR) IniInWinForm);

	m_nMaxSendEchoInter = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Echo Request Send Interval", 5,
				(LPCSTR) IniInWinForm);

	m_nMaxSendTermInter = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Maximum Termination Request Send Interval", 5,
				(LPCSTR) IniInWinForm);


	// TODO: Add extra initialization here

	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
				StrNull, szBuf, sizeof(szBuf), IniInWinForm))
   {
		m_MLPPP = TRUE;
      MLPPPENABLED = TRUE;
   }
	else
   {
		m_MLPPP = FALSE;
      MLPPPENABLED = FALSE;
   }

//If model is ISDN we need to disable MLPPP
	if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT))
	{
		m_MLPPPWnd.EnableWindow(FALSE);
	}

#if 0
//if RAS is enabled on any port, we need to disable MLLPPP, as we don't
//support these two at a time.
	char szLHS[80];
	int index;

	for (index = 0; index < 3 ; index++)
	{
		wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index);
	  	GetPrivateProfileString ((LPCSTR) PPPSectionHeader, (LPCSTR) szLHS,
			StrDisabled, (LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (!strcmp (szBuf, StrEnabled))
		{
			m_MLPPPWnd.EnableWindow(FALSE);
			break;
		}
	}
#endif

//Update the Dialog Box fields.
	UpdateData(FALSE);
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// Removed by cfp on 28-3-96

void CPPPDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PPP_CONFIG,HELP_CONTEXT);
	
}

BOOL CPPPDlg::ValidEditFields()
{
	char szMsgBuf[100] ;
	char szNewHeader[50] ;

	ModifyHeader (PPPMsgHeader, szNewHeader) ;

	if((m_nBackoffInterval < Min_BackoffInterval) 
                     || (m_nBackoffInterval > Max_BackoffInterval))
	{
//		RouMsgBox(MSG_PPP_INV_BKOFF,PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Backoff Interval\n",
				"Interval must be between ",
					Min_BackoffInterval, " and ", Max_BackoffInterval, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_BackoffWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nMaxConfigReq < Min_MaxConfigReq) 
                     || (m_nMaxConfigReq > Max_MaxConfigReq))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_CNF_REQ,PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Maximum Number Of Configuration Requests\n",
				"Requests must be between ",
				Min_MaxConfigReq, " and ", Max_MaxConfigReq, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MaxConfigReqWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nMaxEchoReq < Min_MaxEchoReq) || (m_nMaxEchoReq > Max_MaxEchoReq))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_EKO_REQ,PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Maximum Echo Requests\n", "Requests must be between ",
				Min_MaxEchoReq, " and ", Max_MaxEchoReq, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MaxEchoReqWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nMaxTermReq < Min_MaxTermReq) || (m_nMaxTermReq > Max_MaxTermReq))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_TRM_REQ, PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Number Of Termination Requests\n",
				"Requests must be between ",
					Min_MaxTermReq, " and ", Max_MaxTermReq, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MaxTermReqWnd.SetFocus();
      return(FALSE);
   }	

	if((m_nMaxSendConfigInter < Min_MaxSendConfigInter) 
                     || (m_nMaxSendConfigInter > Max_MaxSendConfigInter))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_SND_CNF_TIME,PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
  		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Send Configuration Interval\n",
				"Interval must be between ",
					Min_MaxSendConfigInter, " and ", Max_MaxSendConfigInter, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_SendConfigWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nMaxSendEchoInter < Min_MaxSendEchoInter) 
                     || (m_nMaxSendEchoInter > Max_MaxSendEchoInter))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_SND_EKO_TIME, PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Maximum Echo Request Interval\n",
				"Interval must be between ",
					Min_MaxSendEchoInter, " and ", Max_MaxSendEchoInter, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_SendEchoWnd.SetFocus();
      return(FALSE);
   }	  
	if((m_nMaxSendTermInter < Min_MaxSendTermInter) 
                     || (m_nMaxSendTermInter > Max_MaxSendTermInter))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_SND_TRM_TIME, PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid maximum send termination interval\n",
				"Interval must be between ",
					Min_MaxSendTermInter, " and ", Max_MaxSendTermInter, "") ;				
		::MessageBox (GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_SendTermWnd.SetFocus();
      return(FALSE);
   }	

   return(TRUE);
}
void CPPPDlg::OnOK()
{
// Update the parameters from the Dialog Box.
	if(!UpdateData(TRUE))
      return;

//if the parameters are invalid return
   if(!ValidEditFields())
	   return;
   if((!MLPPPENABLED) && m_MLPPP)
   {
      ::MessageBox(GetSafeHwnd(),(LPCSTR)"1. Make sure that the UserName & PassWord\
\n    are the same for all the participating links.\
\n2. Remote Access will be disabled on all Ports.", PPPMsgHeader,
            MB_OK);
   }
	LPCSTR temp;
	char m_szTempBuf[12];
	temp = (char *)m_szTempBuf;

// Write the parameters to the INI file.

   //Write the BOOL parameters
	if(m_Printf)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(PPPSectionHeader , 
		(LPCSTR) "PPP Printf",temp, 
		(LPCSTR) IniInWinForm);
		
	if(m_PrintfAlarm)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(PPPSectionHeader , 
		(LPCSTR) "PPP Printf Alarm",temp, 
		(LPCSTR) IniInWinForm);
		
	if(m_PrintfLCP)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(PPPSectionHeader , 
		(LPCSTR) "PPP Printf LCP",temp, 
		(LPCSTR) IniInWinForm);
		
	if(m_PrintfNCP)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(PPPSectionHeader , 
		(LPCSTR) "PPP Printf NCP",temp, 
		(LPCSTR) IniInWinForm);

/* sudha 17 Nov 1998 */
	if(m_dialout.GetCheck())
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(PPPSectionHeader , 
		(LPCSTR) "PPP Ports Need To Dial Out Initially",temp, 
		(LPCSTR) IniInWinForm);
/* sudha 17 Nov 1998 */
		
   //Write the uint Parameters.
	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nBackoffInterval,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Configuration Request Backoff Interval",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxConfigReq,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Number of Configuration Requests",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxEchoReq,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Number of Unacknowledged Echo Requests",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxTermReq,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Number of Termination Requests",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxSendConfigInter,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Configuration Request Send Interval",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxSendEchoInter,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Echo Request Send Interval",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	wsprintf((LPSTR) m_szTempBuf, (LPSTR) "%-10u%s", m_nMaxSendTermInter,"");
	WritePrivateProfileString(PPPSectionHeader ,
			(LPCSTR) "PPP Maximum Termination Request Send Interval",
			(LPSTR)m_szTempBuf,(LPCSTR) IniInWinForm);

	// TODO: Add extra validation here

	//If MLPPP is enabled, we need to write the end point descriminator
	//string to the PPP Section
//PPP Port0 Option%LCP%EPD=19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000
//PPP Port0 Remote Option%LCP%EPD=19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000
	char MLPPPLocalLHS[] = "PPP Port0 Option%LCP%EPD";
	char MLPPPRemoteLHS[] = "PPP Port0 Remote Option%LCP%EPD";
	char MLPPPLocalMRRULHS[] = "PPP Port0 Option%LCP%MRRU";
	char MLPPPRemoteMRRULHS[] = "PPP Port0 Remote Option%LCP%MRRU";
	int	index;
	int m_nPorts = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Number of Ports",0,
				(LPCSTR) IniInWinForm);
	if (m_MLPPP)
	{
		for( index = 0; index < m_nPorts; index++)
		{
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalLHS,
				"19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000",
				IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteLHS,
				"19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000",
				IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalMRRULHS,
				"17,Auto,Negotiation Not Required,Negotiable,D2,1600",
				IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteMRRULHS,
				"17,Auto,Negotiation Not Required,Negotiable,D2,1600",
				IniInWinForm);

			MLPPPLocalLHS[8]++;
			MLPPPRemoteLHS[8]++;
			MLPPPLocalMRRULHS[8]++;
			MLPPPRemoteMRRULHS[8]++;
		}
		//Vidy 11/05/98, we need to disable remote access on all ports
		char szLHS[80];
		for (index = 0; index < m_nPorts; index++)
		{
			wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index);
		 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szLHS,
							(LPCSTR) StrDisabled, (LPCSTR) IniInWinForm);

			// brindha on 4/5/99. DialOut & Proxy only should be enabled.
			wsprintf(szLHS, "WAN Port%d DialInOut Type", index);
		 	WritePrivateProfileString(WANSectionHeader, (LPCSTR) szLHS,
							(LPCSTR) "0", (LPCSTR) IniInWinForm);

			wsprintf(szLHS, "WAN Port%d Function Type", index);
		 	WritePrivateProfileString(WANSectionHeader, (LPCSTR) szLHS,
							(LPCSTR) "1", (LPCSTR) IniInWinForm);
		}
	}
	else
	{
		for( index = 0; index < m_nPorts; index++)
		{
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalLHS,
				NULL, IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteLHS,
				NULL, IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalMRRULHS,
				NULL, IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteMRRULHS,
				NULL, IniInWinForm);
			MLPPPLocalLHS[8]++;
			MLPPPRemoteLHS[8]++;
			MLPPPLocalMRRULHS[8]++;
			MLPPPRemoteMRRULHS[8]++;
		}
	}
	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}

void CPPPDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
	
}

LRESULT CPPPDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}
void CPPPDlg::PostNcDestroy(void)
{
	delete this;
}

/////////////////////////////////////////////////////////////////////////////
// CPPortDlg dialog


CPPortDlg::CPPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPPortDlg)
	m_nMaxAuthRetry = 3 ;
	m_nAuthTimer = 5 ;
	m_Password = "";
	m_PortOption = "";
	m_RemoteOption = "";
	m_UserName = "";
	m_bVJC = FALSE;
	m_bDataCompression = FALSE;
	m_PPP = FALSE;
	m_SLIPEnable = FALSE;
	m_CSLIPEnable = FALSE;
	m_nSLIPMTU = 0;
	m_StrDialNumber = "";
	//}}AFX_DATA_INIT

	m_bClientOnly = FALSE;
	
	Create(IDD,NULL);
}

void CPPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPPortDlg)
	DDX_Control(pDX, IDC_STATIC_DIAL_NUMBER, m_StatDialNumber);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER, m_EditDialNumber);
	DDX_Control(pDX, IDC_RADIO_PAP_OR_CHAP, m_radio_pap_or_chap);
	DDX_Control(pDX, IDC_RADIO_CHAP, m_radio_chap);
	DDX_Control(pDX, IDC_RADIO_PAP, m_radio_pap);
	DDX_Control(pDX, IDC_STAT_NUM_RTRIES, m_NumRtryWnd);
	DDX_Control(pDX, IDC_STAT_PER_TIMER, m_PerTmrWnd);
	DDX_Control(pDX, IDC_STAT_AUTH_GRP, m_AuthGrpWnd);
	DDX_Control(pDX, IDC_CHECK_VJC, m_VJCWnd);
	DDX_Control(pDX, IDC_STATIC_GRP_PPP, m_PPPGrpWnd);
	DDX_Control(pDX, IDC_ENABLE_PPP, m_PPPWnd);
	DDX_Control(pDX, IDC_STATIC_GRP_SLIP, m_SLIPGrpWnd);
	DDX_Control(pDX, IDC_STATIC_SLIP_MTU, m_SLIPMTUStatWnd);
	DDX_Control(pDX, IDC_SLIP_MAX_TRANSMIT_UNIT, m_SLIPMTUWnd);
	DDX_Control(pDX, IDC_CHECK_CSLIP, m_CSLIPEnableWnd);
	DDX_Control(pDX, IDC_ENABLE_SLIP, m_SLIPEnableWnd);
	DDX_Control(pDX, IDC_CHECK_DATA_COMP, m_DataCompCtrl);
	DDX_Control(pDX, IDC_PASSWORD, m_EditUserPassword);
	DDX_Control(pDX, IDC_STATIC_USR_PASSWD, m_StatUserPassword);
	DDX_Control(pDX, IDC_USER_NAME, m_EditUserName);
	DDX_Control(pDX, IDC_STATIC_USR_NAME, m_StatUserName);
	DDX_Control(pDX, IDC_AUTH_TIMER, m_AuthTimerWnd);
	DDX_Control(pDX, IDC_AUTH_RETRIES, m_AuthRetryWnd);
	DDX_Text(pDX, IDC_AUTH_RETRIES, m_nMaxAuthRetry);
	DDX_Text(pDX, IDC_AUTH_TIMER, m_nAuthTimer);
	DDX_Text(pDX, IDC_PASSWORD, m_Password);
	DDV_MaxChars(pDX, m_Password, 60);
	DDX_Text(pDX, IDC_USER_NAME, m_UserName);
	DDV_MaxChars(pDX, m_UserName, 60);
	DDX_Check(pDX, IDC_CHECK_VJC, m_bVJC);
	DDX_Check(pDX, IDC_CHECK_DATA_COMP, m_bDataCompression);
	DDX_Check(pDX, IDC_ENABLE_PPP, m_PPP);
	DDX_Check(pDX, IDC_ENABLE_SLIP, m_SLIPEnable);
	DDX_Check(pDX, IDC_CHECK_CSLIP, m_CSLIPEnable);
	DDX_Text(pDX, IDC_SLIP_MAX_TRANSMIT_UNIT, m_nSLIPMTU);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER, m_StrDialNumber);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPPortDlg, CDialog)
	//{{AFX_MSG_MAP(CPPortDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_ENABLE_PPP, OnEnablePPP)
	ON_BN_CLICKED(IDC_ENABLE_SLIP, OnEnableSLIP)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPPortDlg message handlers

BOOL CPPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPPortDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_PPP_PORT_CONFIG,HELP_CONTEXT);
	
}

void CPPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CPPortDlg::OnOK()
{
	// TODO: Add extra validation here
	
	if(!UpdateData(TRUE))
		return;
   if(!ValidEditFields())  
      return;
/*   if (m_SLIPEnable && SLIPEnablednewly)
   {
      wsprintf(sLHS,"IP Port%d Address",GetMyID() + 1);
      GetPrivateProfileString ((LPCSTR) IPSectionHeader,
         (LPCSTR) sLHS,NULL, (LPSTR) sRHS,
             sizeof(sRHS), (LPCSTR) IniInWinForm) ;
      if(!(strcmp(sRHS,"0.0.0.0"))) 
      {
         ::MessageBox(GetSafeHwnd(),(LPCSTR) "Make sure to assign a valid WAN Ip Address\
            \nin the IP Port Setup Dialog.", (LPCSTR) "Check Box",MB_OK);
      }
   }*/
	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK);
}
LRESULT CPPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}
void CPPortDlg::PostNcDestroy(void)
{
	delete this;
}
BOOL CPPortDlg::ValidEditFields()
{
	char szMsgBuf[100] ;
	char szNewHeader[50] ;

	CPTab *pParent = (CPTab *) GetParent() ;
	ModifyHeader (PPPMsgHeader, szNewHeader) ;

//Validate the integer edit fields.
	if((m_nMaxAuthRetry < Min_MaxAuthRetry) 
               || (m_nMaxAuthRetry > Max_MaxAuthRetry))
	{
//		RouMsgBox(MSG_PPP_INV_MAX_AUTH_RTRY,
//                     PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Maximum Authentication Retries\n",
				"Retries must be between ",
					Min_MaxAuthRetry, " and ", Max_MaxAuthRetry, "") ;				
		::MessageBox (pParent->GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AuthRetryWnd.SetFocus();
      return(FALSE);
   }	

	if((m_nAuthTimer < Min_AuthTimer) || (m_nAuthTimer > Max_AuthTimer))
	{
//		RouMsgBox(MSG_PPP_INV_AUTH_TIME,
//                     PPPMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid Authentication Timer\n",
				"Timer interval must be between ",
					Min_AuthTimer, " and ", Max_AuthTimer, "") ;				
		::MessageBox (pParent->GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_AuthTimerWnd.SetFocus();
      return(FALSE);
   } 

	if((m_nSLIPMTU < Min_SLIPMTU ) || (m_nSLIPMTU > Max_SLIPMTU))
	{
		::wsprintf (szMsgBuf, "%s%s%u%s%u%s",
			"Invalid SLIP Maximum Transmit Unit.\n",
				"Must be between ",
					Min_SLIPMTU, " and ", Max_SLIPMTU, "") ;				
		::MessageBox (pParent->GetSafeHwnd(), (LPCSTR) szMsgBuf,
				(LPCSTR) szNewHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_SLIPMTUWnd.SetFocus();
      return(FALSE);
   }	
   return(TRUE);
}

void CPPortDlg::EnableDisableUsrNameAndPassWd()
{   
	char szLHS[100], szRHS[30];
	BOOL IsDirectConnect;

	wsprintf (szLHS, "WAN Port%d Direct Connect", GetMyID());
	GetPrivateProfileString (WANSectionHeader, szLHS, StrNull, (LPSTR) szRHS,
                               sizeof(szRHS), (LPCSTR)IniInWinForm) ;
    
	IsDirectConnect = (strcmp (szRHS, StrEnabled) == 0);

}


void CPPortDlg::EnablePPPControls (BOOL pEnable)
{
	// Other controls need to be handled here.
	m_PPPGrpWnd.EnableWindow (pEnable);
	m_PPPWnd.EnableWindow (pEnable);
	m_DataCompCtrl.EnableWindow (pEnable);
	m_VJCWnd.EnableWindow (pEnable);
	m_AuthGrpWnd.EnableWindow (pEnable);
	m_StatUserName.EnableWindow (pEnable);
	m_EditUserName.EnableWindow (pEnable);
	m_StatUserPassword.EnableWindow (pEnable);
	m_EditUserPassword.EnableWindow (pEnable);
	m_PerTmrWnd.EnableWindow (pEnable);
	m_AuthTimerWnd.EnableWindow (pEnable);
	m_NumRtryWnd.EnableWindow (pEnable);
	m_AuthRetryWnd.EnableWindow (pEnable);
	m_radio_pap.EnableWindow (pEnable);
	m_radio_chap.EnableWindow (pEnable);
	m_radio_pap_or_chap.EnableWindow (pEnable);

	if (!pEnable) m_PPP = FALSE;
	if (pEnable) EnableDisableUsrNameAndPassWd() ;
	
	// Chida
	BOOL IsDirectConnect;
	char szLHS[100], szRHS[30];
	wsprintf (szLHS, "WAN Port%d Direct Connect", GetMyID());
	GetPrivateProfileString (WANSectionHeader, szLHS, StrNull, (LPSTR) szRHS,
                               sizeof(szRHS), (LPCSTR)IniInWinForm) ;
    
	IsDirectConnect = (strcmp (szRHS, StrEnabled) == 0);
	
	UpdateData (FALSE);
}


void CPPortDlg::EnableSLIPControls (BOOL pEnable)
{
	m_SLIPGrpWnd.EnableWindow (pEnable);
	m_SLIPEnableWnd.EnableWindow (pEnable);
	m_CSLIPEnableWnd.EnableWindow (pEnable);
	m_SLIPMTUStatWnd.EnableWindow (pEnable);
	m_SLIPMTUWnd.EnableWindow (pEnable);
	
	if (!pEnable) m_SLIPEnable = FALSE;
	if (!pEnable) m_CSLIPEnable = FALSE;
	UpdateData (FALSE);
}

void CPPortDlg::OnEnablePPP()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
	if (!maindlg->IsWanPortAnswering(GetMyID()))
		EnableSLIPControls (!m_PPP);
}

void CPPortDlg::OnEnableSLIP()
{
   char sLHS[40],sRHS[40];
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
   if (m_SLIPEnable)
   {
      wsprintf(sLHS,"IP Port%d Address",GetMyID() + 1);
      GetPrivateProfileString ((LPCSTR) IPSectionHeader,
         (LPCSTR) sLHS,NULL, (LPSTR) sRHS,
             sizeof(sRHS), (LPCSTR) IniInWinForm) ;
      if(!(strcmp(sRHS,"0.0.0.0"))) 
      {
         ::MessageBox(GetSafeHwnd(),(LPCSTR) "Make sure to assign a valid WAN Ip Address\
            \nin the IP Port Setup Dialog.", (LPCSTR) "Check Box",MB_OK);
      }
   }
	if (!maindlg->IsWanPortAnswering(GetMyID()))
		EnablePPPControls (!m_SLIPEnable);
}

int CPPortDlg::GetMyID (void)
{
	CPTab *parent = (CPTab *)GetParent();
	int tabcount = parent->tabcount;
	
	for (int index = 0 ; index < tabcount ; index ++)
	{
			if (parent->m_pdlgPP[index] == this)
			{
				return (index);
			}
	}
	ASSERT (FALSE);
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CPTab Tabdialog


CPTab::CPTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CPTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPTab)
		// NOTE: the ClassWizard will add member initialization here

   // Added by cfp on 28-3-96
	m_nPort = 0 ;

	//}}AFX_DATA_INIT

	// Modified by cfp on 28-3-96
	m_nPort = GetPrivateProfileInt(PPPSectionHeader,
				(LPCSTR) "PPP Number of Ports",0,
				(LPCSTR) IniInWinForm);

//	tabcount = ((CPPPDlg *) pParent)->m_nPort;
	tabcount = m_nPort ;
	
// Chidanand - 25 Mar 1997		
	if (tabcount > 1 && pParent && ((CMainDlg *)pParent)->IsBackupEnabled())
		tabcount--;
// Chidanand - 25 Mar 1997		

	//Limit the tabcount
	if(tabcount > n_PORTMAX_PPP) tabcount = n_PORTMAX_PPP;
//	if(tabcount < MIN_TAB_NUM) tabcount = MIN_TAB_NUM;

//	tabcount = n_PORTMAX_PPP;	//for now

	for(int i=0; i < tabcount ; i++)
		m_pdlgPP[i] = new CPPortDlg(this);
	m_advdlgPP = new CPPPDlg(this);	
}

void CPTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPTab, CTabDialog)
	//{{AFX_MSG_MAP(CPTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPTab message handlers
BOOL ConfigRead = FALSE ;
void CPTab::GetConfig()
{
	char szBuf[200] ;
   // Changes by Sachin
   char TempBuff[30], String1[] = "WAN Port", String2[] = " DialInOut Type" ;
	char String3[] = " Direct Connect" ;
   char PortNum[5] ;
	BOOL IsDirectConnect, IsAutoAnswer ;
   char EnableString[] = "enabled", EnableDisable[10] ;
	char szLHS[80], szRHS[30];
	char szPWord[PPP_PASSWORD_SIZE+10];
	char *ch;

	// Get all parameters for PORT
	// Get the BOOL parameters
	char field[100];
	for(int i = 0; i < tabcount ; i++)
	{
		char Buf[12];
		_itoa(i, Buf, 10);

		// Chida 
		

		// Chida - 22 Apr 1997 - Additions for SLIP          
		wsprintf (szLHS, "PPP Port%d SLIP", i);
		GetPrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, szRHS ,sizeof(szRHS),IniInWinForm);
		if(!strcmp (szRHS,StrEnabled))
			m_pdlgPP[i]->m_SLIPEnable = TRUE;
		else 
			m_pdlgPP[i]->m_SLIPEnable = FALSE;

		wsprintf (szLHS, "PPP Port%d CSLIP", i);
		GetPrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, szRHS ,sizeof(szRHS),IniInWinForm);
		if(!strcmp (szRHS,StrEnabled))
			m_pdlgPP[i]->m_CSLIPEnable = TRUE;
		else 
			m_pdlgPP[i]->m_CSLIPEnable = FALSE;

        
		wsprintf (szLHS, "PPP Port%d SLIP Maximum Transmit Unit", i);
		m_pdlgPP[i]->m_nSLIPMTU = GetPrivateProfileInt (PPPSectionHeader,
													szLHS, Max_SLIPMTU, IniInWinForm);
        
		// Chida - 22 Apr 1997 - Additions for SLIP
		// Added by cfp on 25-3-96
		strcpy (field, "CCP Port") ;
		strcat (field, Buf) ;
		GetPrivateProfileString ((LPCSTR) "CCP Compression",
				(LPCSTR) field, (LPCSTR) EnableString, (LPSTR) EnableDisable,
 					sizeof (EnableDisable), (LPCSTR) IniInWinForm) ;
		if (!strcmpi (EnableDisable, EnableString))
			m_pdlgPP[i]->m_bDataCompression = TRUE ;
		else
			m_pdlgPP[i]->m_bDataCompression = FALSE ;

      // For Frame Relay
		wsprintf (szLHS, "PPP Port%d", i);
		GetPrivateProfileString (PPPSectionHeader, szLHS, StrDisabled, szBuf, sizeof(szBuf), IniInWinForm);
		if(!strcmp (szBuf,StrEnabled))
			m_pdlgPP[i]->m_PPP = TRUE;
		else 
			m_pdlgPP[i]->m_PPP = FALSE;
		// For Frame Relay

		strcpy(field, "PPP Port");
		strcat(field,Buf);
		strcpy(Buf,field);                  

		wsprintf (TempBuff, "PPP Port%d Option%%IPCP%%Compression", i);
		GetPrivateProfileString (PPPSectionHeader, TempBuff, "", szBuf,
					sizeof (szBuf), IniInWinForm) ;
					
		if (szBuf[0])
			m_pdlgPP[i]->m_bVJC = TRUE ;
		else
			m_pdlgPP[i]->m_bVJC = FALSE ;

//brindha modified on 30/4/99.       

		sprintf(TempBuff,"%s%d%s%s", String1, i, PortNum, String2);
    	GetPrivateProfileString (WANSectionHeader, TempBuff, "0", (LPSTR) EnableDisable,
                               2, (LPCSTR)IniInWinForm) ;
     	if (strcmp (EnableDisable, "0") == 0)
        	IsAutoAnswer = FALSE ;
     	else
        	IsAutoAnswer = TRUE ;

	 	sprintf(TempBuff,"%s%d%s%s", String1, i, PortNum, String3);
     	GetPrivateProfileString (WANSectionHeader, TempBuff, StrNull, (LPSTR) EnableDisable,
                               8, (LPCSTR)IniInWinForm) ;
      	if (strcmp (EnableDisable, StrEnabled) == 0)
        	IsDirectConnect = TRUE ;
      	else
        	IsDirectConnect = FALSE ;

		m_pdlgPP[i]->m_EditUserPassword.LimitText (PPP_PASSWORD_SIZE - 1) ;
	
	// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d User Password", i);
	   GetPrivateProfileString (PPPSectionHeader,(LPCSTR) field, StrNull,
    		(LPSTR) szBuf, sizeof(szBuf),(LPCSTR) IniInWinForm);
		Decrypt(szBuf, szPWord);
		m_pdlgPP[i]->m_Password = szPWord;

		m_pdlgPP[i]->m_EditUserName.LimitText (PPP_USER_NAME_SIZE - 1) ;

	// Chidanand - 25 Mar 1997	
		sprintf (field, "PPP Port%d User Name", i);
      GetPrivateProfileString (PPPSectionHeader,(LPCSTR) field, StrNull,(LPSTR) szBuf,sizeof(szBuf),(LPCSTR) IniInWinForm);
    
		m_pdlgPP[i]->m_UserName = szBuf;


   //Get the uint parameters.
    
	// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d Maximum Number of Authentication Retries", i);
   	m_pdlgPP[i]->m_nMaxAuthRetry = GetPrivateProfileInt (PPPSectionHeader,
	 								(LPCSTR) field, 3, (LPCSTR) IniInWinForm) ;

	// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d Periodic Authentication Timer", i);
   	m_pdlgPP[i]->m_nAuthTimer = GetPrivateProfileInt(PPPSectionHeader,
			(LPCSTR) field, 5,
			(LPCSTR) IniInWinForm);


	   wsprintf (field, "WAN Port%d", i) ;
	   strcat (field, " Dial Number") ;
      GetPrivateProfileString (WANSectionHeader,  
	 	   (LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		       (LPCSTR) IniInWinForm) ;  
	   m_pdlgPP[i]->m_StrDialNumber = szBuf ;
	   m_pdlgPP[i]->m_EditDialNumber.LimitText (LEN_DIAL_NUMBER - 1) ;

// brindha modified on 30/4/99.
      wsprintf (field, "WAN Port%d Function Type", i);
      GetPrivateProfileString (WANSectionHeader,  
	 	   (LPCSTR) field, "1", (LPSTR) szBuf, sizeof (szBuf),  
		       (LPCSTR) IniInWinForm) ;  
    	if (!strcmp (szBuf, "2") || !strcmp (szBuf, "4") || !strcmp (szBuf, "6") ||
			((model == MODEL_MTSR2_201) && (i == 0)) )		//Vidy 25/06/98
		{
			m_pdlgPP[i]->m_EditDialNumber.EnableWindow (FALSE);
			m_pdlgPP[i]->m_StatDialNumber.EnableWindow (FALSE);
		}
		else
		{
			m_pdlgPP[i]->m_EditDialNumber.EnableWindow (TRUE);
			m_pdlgPP[i]->m_StatDialNumber.EnableWindow (TRUE);
		}

	////Prabha, 24/2/98, for PAP, CHAP changes
		wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (CHAP)", i) ;
		GetPrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				StrNull, szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (szBuf[0])
			m_pdlgPP[i]->m_radio_chap.SetCheck(1);
		else 	
		{		
			wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (PAP)", i) ;
			GetPrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
					StrNull, szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
			if (szBuf[0])
			{
				if ((ch = strstr (szBuf, "Not Negotiable")) != NULL)
					m_pdlgPP[i]->m_radio_pap.SetCheck (1);			
				else
					m_pdlgPP[i]->m_radio_pap_or_chap.SetCheck(1);
			}
		}
   	//Update the Dialog Box fields
		m_pdlgPP[i]->UpdateData(FALSE); 
		if (!((CMainDlg *)GetParent())->IsWanPortEnabled(i))
		{
			////Prabha, 11.3.98
			m_pdlgPP[i]->m_StatDialNumber.EnableWindow (FALSE);
			m_pdlgPP[i]->m_EditDialNumber.EnableWindow (FALSE);
			m_pdlgPP[i]->EnablePPPControls (FALSE);
			m_pdlgPP[i]->EnableSLIPControls (FALSE);
		}
		else
		{
			BOOL Ans, IPOn, Async;
			Async = ((CMainDlg *)GetParent())->IsWanPortAsync(i);
			Ans = ((CMainDlg *)GetParent())->IsWanPortAnswering(i);
			IPOn = ((CMainDlg *)GetParent())->IsIPEnabled(i+1);

			if (Async)
			{
				if (Ans)
				{
					if (m_pdlgPP[i]->m_SLIPEnable && IPOn)
						m_pdlgPP[i]->EnableSLIPControls (TRUE);
					if (!m_pdlgPP[i]->m_PPP)
						m_pdlgPP[i]->EnablePPPControls (FALSE);
				}
				else	//dialing
				{
					if (IPOn && m_pdlgPP[i]->m_SLIPEnable)
					{
						m_pdlgPP[i]->EnableSLIPControls (TRUE);
						m_pdlgPP[i]->EnablePPPControls (FALSE);
					}
					else
					{
						m_pdlgPP[i]->EnableSLIPControls (FALSE);
					}

					if (!m_pdlgPP[i]->m_SLIPEnable)
					{
						m_pdlgPP[i]->EnablePPPControls (TRUE);
					}
					else
					{
						m_pdlgPP[i]->EnablePPPControls (FALSE);
					}
					if (!m_pdlgPP[i]->m_PPP)
						m_pdlgPP[i]->EnableSLIPControls (TRUE);
				}
			}
			else
			{
				m_pdlgPP[i]->EnablePPPControls (TRUE);
				m_pdlgPP[i]->EnableSLIPControls (FALSE);
			}
		}
   }
	ConfigRead = TRUE ;
}                         

BOOL CPTab::OnInitDialog()
{
	CDialog::OnInitDialog();

	ConfigRead = FALSE ;
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	char Buf[4][10];
	switch (tabcount)
	{
	case 1:
		strcpy(Buf[0], " &WAN ");
		strcpy(Buf[1], "&Advanced");
		break;
	case 2:
		strcpy(Buf[0], "WAN  &1");
		strcpy(Buf[1], "WAN  &2");
		strcpy(Buf[2], "&Advanced");
		break;
	case 3:
		strcpy(Buf[0], "WAN  &1");
		strcpy(Buf[1], "WAN  &2");
		strcpy(Buf[2], "WAN  &3");
		strcpy(Buf[3], "&Advanced");
		break;
	default:
		break;
	}

	//Add the Tabs
	for (int i=0; i < tabcount ; i++)               
		addTabView(m_pdlgPP[i],Buf[i], TRUE, (i==0), 100);
	addTabView(m_advdlgPP, Buf[tabcount], TRUE, FALSE, 100);
	
	
   //Get all the parameters of all the ports from INI file
	GetConfig();
   AfxGetApp()->DoWaitCursor(0);

   CTabDialog::OnInitDialog();
   CenterWindow();                                               
	return FALSE;
}


int CPTab::AcceptConfig()
{
   // Write parameters of Ports to INI file

	#define MAX_HANGUP_TIME (5*24*60)
	#define MIN_HANGUP_TIME (1)
	

   // Write the BOOL parameters
	LPCSTR temp ;
	char m_szTempBuf[12] ;
	temp = (char *) m_szTempBuf ;
	
	char field[100] ;
	char TempBuff[100] ;
	char Buf[100] ;
	char STPortStateLHSString[] = "Spanning Tree Port1 State" ;

	// Added by cfp on 4-4-96
	BOOL fDODWriteZero = FALSE ;
	int i ;
	CString szRHS;
	char szLHS[80];
    
	for (i = 0 ; i < tabcount ; i ++)
	{
		BOOL OldDialOnDemand ;
		if (tabcount > 1) {			//We don't know why! but this is needed
	      switchTab (1) ;			//for the dialog to redraw - Vidy
   	   enableView (1, TRUE) ;
		}
      switchTab (i) ;
      enableView (i, TRUE) ;
		
		// Chida - 22 Apr 1997 - Additions for SLIP          
		CMainDlg *pParent =  (CMainDlg *)GetParent();
		pParent->EnablePPP  (i, m_pdlgPP[i]->m_PPP);
		pParent->EnableSLIP  (i, m_pdlgPP[i]->m_SLIPEnable);
		pParent->EnableCSLIP (i, m_pdlgPP[i]->m_CSLIPEnable);

		wsprintf (szLHS, "PPP Port%d SLIP Maximum Transmit Unit", i);
		itoa(m_pdlgPP[i]->m_nSLIPMTU, TempBuff, 10);
		WritePrivateProfileString (PPPSectionHeader, szLHS, TempBuff, IniInWinForm);
		// Chida - 22 Apr 1997 - Additions for SLIP

		STPortStateLHSString[18] ++ ;

		_itoa (i, Buf, 10) ;

	   // Added by cfp on 25-3-96
		// to note whether CCP compression
		// is enabled or disabled for all ports
		char szTemp[20] ;
		if (m_pdlgPP[i]->m_bDataCompression)
			strcpy (szTemp, StrEnabled) ;
		else
			strcpy (szTemp, StrDisabled) ;
		strcpy (field, "CCP Port") ;
		strcat (field, Buf) ;
		WritePrivateProfileString ((LPCSTR) "CCP Compression",
				(LPCSTR) field, (LPCSTR) szTemp, (LPCSTR) IniInWinForm) ;

		// Added by cfp on 4-4-96
/*		if (m_pdlgPP[i]->m_DODEnable)
			fDODWriteZero = TRUE ;*/

// Chidanand - 25 Mar 1997
		sprintf (field, "PPP Port%d Connection Dial On Demand", i);
		GetPrivateProfileString (PPPSectionHeader, (LPCSTR) field, StrNull,
		      TempBuff, sizeof (TempBuff), IniInWinForm) ;

		if (strcmp (TempBuff, StrEnabled) == 0)
			OldDialOnDemand = TRUE ;
		else
			OldDialOnDemand = FALSE ;

		strcpy (field, "PPP Port") ;
		strcat (field, Buf) ;
		strcpy (Buf, field) ;


//Vidy 29/10/96. If CIPX is disabled, remove the strings from PPP
//PPP Port0 Option%IPXCP%Compression=3,Auto,Negotiation Not Required,Negotiable,H4,00020F00
//PPP Port0 Remote Option%IPXCP%Compression=3,Auto,Negotiation Not Required,Negotiable,H4,00020F00

		// Chida - 23 Apr 1997 - For ASYNC ports, have 000A0000 as control map
		wsprintf (szLHS, "PPP Port%d Option%%LCP%%ACCM", i); 
		if (((CMainDlg *)GetParent())->IsWanPortAsync(i))
			WritePrivateProfileString (PPPSectionHeader, szLHS, 
				(LPCSTR)"2,Auto,Negotiation Not Required,Negotiable,H4S,000A0000", IniInWinForm);
		else
			WritePrivateProfileString (PPPSectionHeader, szLHS, 
				(LPCSTR)"2,Auto,Negotiation Not Required,Negotiable,H4S,00000000", IniInWinForm);

//Vidy 29/10/96. If VJC is disabled, remove the strings from PPP
//PPP Port0 Option%IPCP%Compression=2,Auto,Negotiation Not Required,Negotiable,H4,002d0f00
//PPP Port0 Remote Option%IPCP%Compression=2,Auto,Negotiation Not Required,Negotiable,H4,002d0f00
		strcpy (field, "VJC ") ;
		strcat (field, Buf) ;
		if (m_pdlgPP[i]->m_bVJC) 
		{
/*	
	Chida - 23 Apr 1997	
	Change of handling VJC.
		If PPP's VJC is checked, then write string "PPP Port%d VJC=enabled" string in PPP Section
			and also write string "VJC Port%d=enabled" in VJC Section.
		But if PPP's VJC is unchecked, then write only the string "PPP Port%d VJC=disabled" in PPP Section.
*/
            wsprintf (szLHS, "VJC Port%d", i);
            WritePrivateProfileString ("VJC Compression", szLHS, StrEnabled, IniInWinForm);
            
			strcpy (field, Buf) ;
			strcat (field, " Option%IPCP%Compression") ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				(LPCSTR) "2,Auto,Negotiation Not Required,Negotiable,H4,002D0F00", 
							(LPCSTR) IniInWinForm) ;
			strcpy (field, Buf) ;
			strcat (field, " Remote Option%IPCP%Compression") ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				(LPCSTR) "2,Auto,Negotiation Not Required,Negotiable,H4,002D0F00", 
							(LPCSTR) IniInWinForm) ;
		} 
		else 
		{
			strcpy (field, Buf) ;
			strcat (field, " Option%IPCP%Compression") ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				NULL, (LPCSTR) IniInWinForm) ;
			strcpy (field, Buf) ;
			strcat (field, " Remote Option%IPCP%Compression") ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				NULL, (LPCSTR) IniInWinForm) ;
		}

		// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 

		sprintf (field, "PPP Port%d User Password", i);
		char szEncryptPassWd[PPP_PASSWORD_SIZE+10];
		char PWord[PPP_PASSWORD_SIZE];

		strcpy(PWord, (LPCSTR)m_pdlgPP[i]->m_Password);
		Encrypt (PWord, szEncryptPassWd) ;

  		WritePrivateProfileString (PPPSectionHeader, (LPCSTR) field,	
						(LPCSTR) szEncryptPassWd, (LPCSTR) IniInWinForm) ;

		// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d User Name", i);
		WritePrivateProfileString (PPPSectionHeader, (LPCSTR) field,	
					(LPCSTR) m_pdlgPP[i]->m_UserName, (LPCSTR) IniInWinForm) ;

	   // Write the uint Parameters.
		::wsprintf ((LPSTR) m_szTempBuf, (LPSTR) "%-10u",
										 m_pdlgPP[i]->m_nMaxAuthRetry) ;
	   
	// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d Maximum Number of Authentication Retries", i);
	   WritePrivateProfileString (PPPSectionHeader,
			(LPCSTR) field, (LPSTR) m_szTempBuf, (LPCSTR) IniInWinForm) ;

		::wsprintf ((LPSTR) m_szTempBuf, (LPSTR) "%-10u",
											 m_pdlgPP[i]->m_nAuthTimer) ;
											 
		// Chidanand - 25 Mar 1997 - UI Support for PPP Dial Backup 
		sprintf (field, "PPP Port%d Periodic Authentication Timer", i);
	   WritePrivateProfileString (PPPSectionHeader,
			(LPCSTR) field, (LPSTR) m_szTempBuf, (LPCSTR) IniInWinForm) ; 

		wsprintf (field, "WAN Port%d Dial Number", i) ;
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, m_pdlgPP[i]->m_StrDialNumber, 
					     (LPCSTR) IniInWinForm) ;  

	////Prabha, 24/2/98, for PAP, CHAP changes
		wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (CHAP)", i) ;
		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
						(LPCSTR) NULL, (LPCSTR) IniInWinForm) ;
		wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (PAP)", i) ;
		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
						(LPCSTR) NULL, (LPCSTR) IniInWinForm) ;

		if (m_pdlgPP[i]->m_radio_pap.GetCheck())
		{
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				(LPCSTR) "3,Auto,Negotiation Not Required,Not Negotiable,H2,c023", 
					(LPCSTR) IniInWinForm) ;
		}
		else	if (m_pdlgPP[i]->m_radio_pap_or_chap.GetCheck ())
		{
			wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (PAP)", i) ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
				(LPCSTR) "3,Auto,Negotiation Not Required,Negotiable,H2,c023",
					 (LPCSTR) IniInWinForm) ;
		}
		else if (m_pdlgPP[i]->m_radio_chap.GetCheck())
		{
			wsprintf (field, "PPP Port%d Remote Option%%LCP%%Authentication (CHAP)", i) ;
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,	(LPCSTR) field,
   		 (LPCSTR) "3,Auto,Negotiation Not Required,Not Negotiable,H3,c22305",
							(LPCSTR) IniInWinForm) ;
		}
   }	

	// Added by cfp on 4-4-96
	int nIPRipRouteAgingTimeout = (fDODWriteZero) ? 0 : 180;
	sprintf (field, "%d", nIPRipRouteAgingTimeout) ;
	WritePrivateProfileString ((LPCSTR) IPSectionHeader,
	 	(LPCSTR) "IP RIP Route Aging Timeout", (LPCSTR) field,
			(LPCSTR) IniInWinForm) ;

	return TRUE ;
}                          

void CPTab::OnOK()
{
   for (int i = 0 ; i < tabcount ; i ++)
   {
      if (!m_pdlgPP[i]->ValidEditFields())
      {
         switchTab (i) ;
         enableView (i, TRUE) ;
         return ;
      }
   }
	if (!AcceptConfig())
		return ;
	CTabDialog::OnOK() ;
}

void CPTab::OnCancel()
{
	CTabDialog::OnCancel();
}

CString Str1 = "If you enable the Dial on Demand feature for this port, " ;
CString Str3 = "it will result in the following side effects : \n\n" ;
CString Str4 = "1. Spanning Tree Bridging for this port will\n     be disabled\n" ;
CString Str5 = "2. IP RIP for this port will be disabled\n" ;
CString Str6 = "3. IP RIP Aging for this port will be disabled\n" ;
CString Str7 = "";
CString Str8 = "";
CString Str9 = "Do you want to enable Dial on Demand ?" ;




