// proxy.h : header file
//
#define  DESC_LEN                      26
#define	MAX_NUMBER_OF_APPLICATIONS		100
#define	PROTOCOL_NAME_SIZE				20
#define	PORT_NAME_SIZE						(DESC_LEN + 3 + 5)
#define	MAX_PROXY_ENTRIES_IN_ONE_INI	5
#define  MAX_INFO_ENTRIES_IN_ONE_INI   2

/* sudha 17 Aug 1999 */
#define FTP_COMMAND_PORT	21
#define FTP_DATA_PORT      20

typedef	struct	tagNameNumber {
	char *Name;
	int  NumberOfPorts;	//Some Protocols use more than one ports (TFTP)
	char *Number1;
	char *Number2;
	char *SingleLineHelp;
}NameNumber;

static NameNumber ProtocolNameNumberMap[] = {
	{"TCP", 1, "00006", ""},
	{"UDP", 1, "00017", ""},
	NULL
};



extern NameNumber ProtocolNameNumberMap[];
extern NameNumber *PortNameNumberMap[];
extern NameNumber TCPPortStrings[];
extern NameNumber UDPPortStrings[];

extern char *pFootNote;
extern char *PortSeparator;  // Imran

/////////////////////////////////////////////////////////////////////////////
// Proxy dialog

class Proxy : public CDialog
{
// Construction
public:
	Proxy(CWnd* pParent = NULL);	// standard constructor

	BOOL	IsEntryUnique(LPCSTR Protocol, LPCSTR Port);
   BOOL	IsUserEntryUnique(LPCSTR Protocol, LPCSTR Port);
	BOOL	IsPortRangeEntryUnique(LPCSTR Protocol, LPCSTR Port);  // Imran
   BOOL	IsProtocolPortNameInMap(LPCSTR Protocol, LPCSTR Port);
	BOOL	AddEntry(LPCSTR Protocol, LPCSTR Port);
	BOOL	DeleteEntry(LPCSTR Protocol, LPCSTR Port);
	int	GetProtocolPortNumber(LPCSTR ProtocolPort, LPSTR Protocol, LPSTR Port, int PortIndex);
	LPSTR GetProtocolPortName(LPCSTR Protocol, LPCSTR Port, LPSTR ProtocolPort);
   LPSTR GetUserProtocolPortName(LPCSTR Protocol, LPCSTR Port, LPSTR ProtocolPort);
	LPSTR GetProtocolPortHelp(LPCSTR Protocol, LPCSTR Port);
	int	IsKnownProtocol(LPCSTR Protocol);
	LPSTR	GetPortName(int ProtocolIndex, int PortIndex, LPSTR PortName);
	LPCSTR GetOneLineMessage();
	int GlbIndex;  // Imran,7/11/99

// Dialog Data
	//{{AFX_DATA(Proxy)
	enum { IDD = IDD_DIALOG_PROXY };
	CButton	m_ProxyAnyApp;
	CStatic	m_FootNoteWnd;
	CStatic	m_LineHelp;
	CListBox	m_ProxyListWnd;
	CButton	m_EdtWnd;
	CButton	m_DelWnd;
	CButton	m_AddWnd;
	CString	m_CurProtocol;		//to be used to pass to Edit and get from Add/Edit
	CString	m_CurPort;
   CString  m_CurDesc;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;
	CBitmapButton EditBmpBtn;
	CBitmapButton FilterBmpBtn;
	CBitmapButton FTPBmpBtn;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(Proxy)
	afx_msg void OnButtonProxyAdd();
	afx_msg void OnButtonProxyDelete();
	afx_msg void OnButtonProxyEdit();
	afx_msg void OnButtonProxyHelp();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnSelchangeProxyList();
	afx_msg void OnButtonProxyFiltering();
	afx_msg void OnFtpPorts();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
