// prxaddit.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "prxaddit.h"
#include "proxy.h"

static LPCSTR ErrMsgHdr = "Proxy Add/Edit Entry";

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// PrxAddit dialog


PrxAddit::PrxAddit(CWnd* pParent /*=NULL*/)
	: CDialog(PrxAddit::IDD, pParent)
{
	//{{AFX_DATA_INIT(PrxAddit)
	m_Port = "";
	m_DescrpWnd = "";
	m_high_range = "";
	m_range = FALSE;
	//}}AFX_DATA_INIT
}

void PrxAddit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(PrxAddit)
	DDX_Control(pDX, IDC_CHECK_RANGE, m_ctrl_range);
	DDX_Control(pDX, IDC_EDIT_HIGH_RANGE, m_ctrl_high_range);
	DDX_Control(pDX, IDC_STATIC_HIGH_RANGE, m_static_high_range);
	DDX_Control(pDX, IDC_UDP_CHECK, m_UdpCheck);
	DDX_Control(pDX, IDC_TCP_CHECK, m_TcpCheck);
	DDX_Control(pDX, IDC_STATIC1, m_DesStatWnd);
	DDX_Control(pDX, IDC_EDIT1, m_DesEdtWnd);
	DDX_Control(pDX, IDC_STATIC_LINE_HELP, m_LineHelp);
	DDX_Control(pDX, IDC_COMBO_PORT, m_PortWnd);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_Port);
	DDX_Text(pDX, IDC_EDIT1, m_DescrpWnd);
	DDV_MaxChars(pDX, m_DescrpWnd, 25);
	DDX_Text(pDX, IDC_EDIT_HIGH_RANGE, m_high_range);
	DDV_MaxChars(pDX, m_high_range, 15);
	DDX_Check(pDX, IDC_CHECK_RANGE, m_range);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(PrxAddit, CDialog)
	//{{AFX_MSG_MAP(PrxAddit)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_PORT, OnSelchangeComboPort)
	ON_CBN_EDITCHANGE(IDC_COMBO_PORT, OnEditchangeComboPort)
	ON_BN_CLICKED(IDC_TCP_CHECK, OnTcpCheck)
	ON_BN_CLICKED(IDC_UDP_CHECK, OnUdpCheck)
	ON_BN_CLICKED(IDC_CHECK_RANGE, OnCheckRange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL IsStrNumericAndValid(LPCSTR String)
{
	LPCSTR tmpStr;
	int	LenStr;

	tmpStr = String;

	while (*String)
		if (*String < '0' || *String > '9')
			return FALSE;
		else
			String++;

	LenStr = strlen(tmpStr);	//If string id more than 5 digits error
	if (LenStr > 5)
		return FALSE;

	unsigned long Value;

	sscanf(tmpStr, "%ld", &Value);

	if (Value > 0xFFFFl)
		return FALSE;

	return TRUE;
}

BOOL IsValidDesc(LPCSTR String)
{
	while(*String)
	{
		if((*String < 'a') || (*String > 'z')) 
			if((*String < 'A') || (*String > 'Z')) 
			 	if((*String < '0') || (*String > '9')) 
					return FALSE;
		String++;
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// PrxAddit message handlers

BOOL PrxAddit::OnInitDialog()
{
	CDialog::OnInitDialog();
 
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
   char	Desc[DESC_LEN],dmy3,dmy1,dmy2,tmpPort[PORT_NAME_SIZE];
	char Port1[PORT_NAME_SIZE], Port2[PORT_NAME_SIZE]; 


/* Sudha 06 Nov 1998 */
	strcpy(&Desc[0],"");
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
										WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBmpBtn.SizeToContent();

	m_PortWnd.LimitText(5);				//Not more than 4 chars for port
	m_DesEdtWnd.LimitText(DESC_LEN-1);

	m_OProtocol = ((Proxy *)GetParent())->m_CurProtocol;
	m_Port = ((Proxy *)GetParent())->m_CurPort;
	m_OPort = m_Port;					//Store these as we need them in case
   if(strstr(m_Port, pFootNote))
   {
      sscanf(m_Port,"%c%[^(]%c%[^)]%c",&dmy3,Desc,&dmy1,tmpPort,&dmy2);

/* Sudha 06 Nov 1998 */		
		if (strcmp(Desc,"") == 0)
			sscanf(m_Port,"%c%c%[^)]%c",&dmy3,&dmy1,tmpPort,&dmy2);

/* sudha taken from Neelu 02 Feb 1999... */
   	if(strchr(tmpPort, (int) ','))
		{
			sscanf(tmpPort,"%[^,]%c%s",Port1,&dmy1,Port2);

			m_Port = Port1;
			m_high_range = Port2;
			m_ctrl_range.SetCheck(TRUE);
			m_range = TRUE;

			m_static_high_range.EnableWindow(TRUE);
			m_ctrl_high_range.EnableWindow(TRUE); 
				 
		 }
		 else
		 {
			m_Port = tmpPort;
			m_high_range = StrNull;
			m_range = FALSE;
			m_ctrl_range.SetCheck(FALSE);

			m_static_high_range.EnableWindow(FALSE);
			m_ctrl_high_range.EnableWindow(FALSE); 
		}
      m_DescrpWnd = Desc;
   }

	if(m_range == FALSE)
	{
		m_ctrl_range.SetCheck(FALSE);
		m_static_high_range.EnableWindow(FALSE);
		m_ctrl_high_range.EnableWindow(FALSE); 

	}
	else
	{
		m_ctrl_range.SetCheck(TRUE);
		m_static_high_range.EnableWindow(TRUE);
		m_ctrl_high_range.EnableWindow(TRUE); 
	
	}

/* ...sudha taken from Neelu on 02 Feb 1999 */

/* sudha taken firewall sources changes from ravi on 11 nov 1998 */
	if ( ! m_OProtocol.IsEmpty())
	{	
		if (m_OProtocol == "TCP")
		{
			m_TcpCheck.SetCheck(TRUE);
			m_UdpCheck.SetCheck(FALSE);
			m_UdpCheck.EnableWindow(FALSE);
			m_TcpCheck.EnableWindow(FALSE);
		}
		else
		{
			m_TcpCheck.SetCheck(FALSE);
			m_UdpCheck.SetCheck(TRUE);
			m_TcpCheck.EnableWindow(FALSE);
			m_UdpCheck.EnableWindow(FALSE);
		}
	}
	else
	{
		m_TcpCheck.SetCheck(TRUE);
		m_UdpCheck.SetCheck(TRUE);
	
		AddTcpUdpPorts();
	}
/* sudha taken firewall sources changes from ravi on 11 nov 1998 */

	//Since the above function clears the port field
   if(strstr(m_OPort, pFootNote))
	{
		if(strchr(tmpPort, (int) ','))
			m_Port = Port1;
		 else
	     	m_Port = tmpPort;
	}
   else
	   m_Port = ((Proxy *)GetParent())->m_CurPort;
	UpdateData(FALSE);
	OnSelchangeComboPort();	//display single line help message
//	m_LineHelp.SetWindowText("Enter a decimal Port number or select from list");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void PrxAddit::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_PROXY_ADD_EDIT, HELP_CONTEXT);
}

void PrxAddit::OnOK()
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	char	Protocol[PROTOCOL_NAME_SIZE], Port[PORT_NAME_SIZE];
	//WORD	IntVal;
   int list_index = 0;

	// Validate the Protocol and port values return if wrong
	if (!IsValidEditFields())
		return;

/* sudha taken changes from ravi. 11 nov 1998 */
	if (! m_OProtocol.IsEmpty())
		strcpy(Protocol, m_OProtocol);
/* sudha taken changes from ravi. 11 nov 1998 */

 	strcpy(Port, m_Port);

   // Check if this is going to be duplicate, if yes show msg and return
   if(m_DescrpWnd != StrNull) 
   {
		if (!m_ctrl_range.GetCheck())
	      sprintf(Port, "%s%s(%s)", pFootNote, (LPCSTR)m_DescrpWnd, (LPCSTR)m_Port);
		else
			sprintf(Port, "%s%s(%s,%s)", pFootNote, (LPCSTR)m_DescrpWnd, (LPCSTR)m_Port, (LPCSTR) m_high_range);
   }

	if (m_OProtocol.IsEmpty())		//We are adding a new Protocol-Port to Porxy
	{
		// Check if this is going to be duplicate, if yes show msg and return
      if(m_DescrpWnd != StrNull) 
      {
/* sudha taken changes from ravi. 11 nov 1998 */
			/* The Above Check is for user defined Ports */
			if(m_TcpCheck.GetCheck())
			{
				strcpy(Protocol, "TCP");
      	   if(((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
	         {
					if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
						Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
         		   return;
	         	}
				}
				else
				{
					m_PortWnd.SetFocus();
					return;
				}
			}

		 	if(m_UdpCheck.GetCheck())
		 	{
	   	 	strcpy(Protocol, "UDP");
		 		if (((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
		 		{
		 			if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
		 			{
		 				::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
		 				Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		 				return;
		 			}
		 		}
				else
				{
					m_PortWnd.SetFocus();
					return;
				}
		 	}
      }
		else  //Some Reserved Ports are to be added
		{
			if (m_TcpCheck.GetCheck())
			{
				strcpy(Protocol, "TCP");
				if (  ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
				{
					if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
						Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return;
					}
				}
			}

			// Code added for UDP Port 

			if (m_UdpCheck.GetCheck())
			{
				strcpy(Protocol, "UDP");
				if (  ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
				{
/*					::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry. Can't Add.\
	       	       			\nPlease refer to Notes in Help for details",
					   (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					return; */

					if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
					{
						::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached.\n\
						Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
						return;
					}
				}
			}
  		}
	}
	else		// This means that we are Editing an entry
	{
  		char Desc[20],dmy1;
		int LPort,HPort;
  		if(strstr(m_OPort, pFootNote))
		{
			if(strchr(m_OPort, (int) ','))
			{
			 	sscanf(m_OPort,"%c%[^(]%c%d%c%d",&dmy1,Desc,&dmy1,&LPort,&dmy1,&HPort);
				if ((Protocol == m_OProtocol) && (m_Port == LPort) && 
							(m_high_range == HPort) && (!strcmpi(Desc,m_DescrpWnd)))
					goto NOCHANGE;
			}
			else
			{
			  	sscanf(m_OPort,"%c%[^(]%c%d",&dmy1, Desc,&dmy1,&LPort);
				if ((Protocol == m_OProtocol) && (m_Port == LPort) && 
							(!strcmpi(Desc,m_DescrpWnd)))
					goto NOCHANGE;
			}
		}
/* ...sudha taken from Imran 0n 02 Feb 1999 */

		if ( ! ((Protocol == m_OProtocol) && (Port == m_OPort)))
		{
			// Check if this is a duplicate, if yes show msg and return
			if(m_DescrpWnd == StrNull)
     		{
			   if ( ! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)Protocol, (LPCSTR)Port))
			   {
				   ::MessageBox (GetSafeHwnd(), (LPCSTR) "New entry exits.\
		                  \nPlease refer to Notes in Help for details",
					      (LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				   return;
			   }
	      }

	      if(m_DescrpWnd != StrNull)
	      {
	         if(!((Proxy *)GetParent())->IsUserEntryUnique((LPCSTR)Protocol,(LPCSTR)Port))
	         {
	            ::MessageBox (GetSafeHwnd(), (LPCSTR) "Duplicate Entry of same Port for same Protocol.\
	       	      \nCan't add.",(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION);
	             m_PortWnd.SetFocus();
	             return;
	          }
	       }
			
			//Remove the old entry, since it is to be replaced
			if ( !((Proxy *)GetParent())->DeleteEntry((LPCSTR)m_OProtocol, (LPCSTR)m_OPort))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Internal Error.\n\
            			Couldn't Delete selection.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}

			// Add Entry the new entry to list box
			if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)Port))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached!\n\
		                Can't add any more.",	(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}
			
		}	//else means the new entry and old entry match so nothing to do
	}

NOCHANGE:
	((Proxy *)GetParent())->GlbIndex = 0; /* sudha from Imran on 02 Feb 1999 */
	CDialog::OnOK();
}

BOOL PrxAddit::IsValidEditFields(void)
{
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	Protocol[PROTOCOL_NAME_SIZE];
	char	Port[PORT_NAME_SIZE];
	CString m_Protocol;

	if (m_Port.IsEmpty())
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Port can't be empty",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}

	if (m_ctrl_range.GetCheck() && m_high_range == StrNull)
	{
	   ::MessageBox(GetSafeHwnd(),(LPCSTR) "Enter a higher port range",
         	(LPCSTR) ErrMsgHdr,MB_OK);
  		m_ctrl_high_range.SetFocus();
  		return FALSE;
   }

   if(m_DesEdtWnd.IsWindowEnabled() && ((m_DescrpWnd == StrNull) || (m_DescrpWnd == " ")))
   {
      ::MessageBox(GetSafeHwnd(),(LPCSTR) "Enter a description for the port",
         (LPCSTR) ErrMsgHdr,MB_OK);
      m_DesEdtWnd.SetFocus();
      return FALSE;
   }

	if (strstr((LPCSTR) m_DescrpWnd, pFootNote))
	{
		char szBuf[80];
		sprintf(szBuf, "Can't use '%s' in description", pFootNote);
      ::MessageBox(GetSafeHwnd(),(LPCSTR) szBuf,
         (LPCSTR) ErrMsgHdr,MB_OK);
      m_DesEdtWnd.SetFocus();
      return FALSE;
	}

	if (!IsValidDesc(m_DescrpWnd))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid description",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_DesEdtWnd.SetFocus();
		return FALSE;
	}

	int port;
	port = atoi (m_Port);
	if(m_DesEdtWnd.IsWindowEnabled())
	{
		if(port == 0)
		{	
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port entered",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_PortWnd.SetFocus();
			return FALSE;
		}

		port = atoi (m_high_range);
		if(m_ctrl_range.GetCheck() && !port)
		{	
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port entered",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_ctrl_high_range.SetFocus();
			return FALSE;
		}
	}	

 	if(strchr(m_DescrpWnd, (int) ','))
	{
		char szBuf[80];
		sprintf(szBuf, "Can't use '%s' in description", PortSeparator);
	        ::MessageBox(GetSafeHwnd(),(LPCSTR) szBuf,
        	 (LPCSTR) ErrMsgHdr,MB_OK);
	        m_DesEdtWnd.SetFocus();
	        return FALSE;
	}

	if (m_TcpCheck.GetCheck())
		m_Protocol = "TCP";
	else 
		m_Protocol = "UDP";

	//Form the ProtocolPortName
	((Proxy *)GetParent())->GetProtocolPortName(
									m_Protocol, m_Port, ProtocolPort);

	//Now get the ProtocolPortNumber from the ProtocolPortName
	((Proxy *)GetParent())->GetProtocolPortNumber(ProtocolPort,
									Protocol, Port, 0);

	if ( ! IsStrNumericAndValid(Port))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_PortWnd.SetFocus();
		return FALSE;
	}

	if (m_ctrl_range.GetCheck())
	{
		//Form the ProtocolPortName
		((Proxy *)GetParent())->GetProtocolPortName(m_Protocol, m_high_range, ProtocolPort);

		//Now get the ProtocolPortNumber from the ProtocolPortName
		((Proxy *)GetParent())->GetProtocolPortNumber(ProtocolPort, Protocol, Port, 0);

		 if ( ! IsStrNumericAndValid(Port))
		 {
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_ctrl_high_range.SetFocus();
			return FALSE;
		 }

		int LRange,HRange;
		
		sscanf(m_Port,"%d",&LRange);
		sscanf(m_high_range,"%d",&HRange);

		if((LRange > HRange) || (LRange == HRange))
		{
		  ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Port Range",
			(LPCSTR) ErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_ctrl_high_range.SetFocus();
			return FALSE;
		 }
	}

	return TRUE;
}


void PrxAddit::OnSelchangeComboPort()
{
	// TODO: Add your control notification handler code here
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];
	int	SelIndex;

/* sudha taken changes from ravi. 11 nov 1998 */
	if (  m_OProtocol.IsEmpty()) // When Add Option Choosed
	{
		m_TcpCheck.SetCheck(TRUE);
		m_TcpCheck.EnableWindow(TRUE);
		m_UdpCheck.SetCheck(TRUE);
		m_UdpCheck.EnableWindow(TRUE);
	}

	if ((SelIndex = m_PortWnd.GetCurSel()) != LB_ERR)
	{
		m_PortWnd.GetLBText(SelIndex, PortName);		
		m_LineHelp.SetWindowText(((Proxy *) GetParent())->GetProtocolPortHelp(ProtocolName, PortName));
		m_DesEdtWnd.EnableWindow(FALSE);
		m_DesStatWnd.EnableWindow(FALSE);

		m_ctrl_range.SetCheck(FALSE);
		m_static_high_range.EnableWindow(FALSE);
		m_ctrl_high_range.EnableWindow(FALSE);

		// Added by Ravi. on 16 Oct.
		// Scope : To show the status of the protocol for the 
		//         currently specified Port.

		strcpy(ProtocolName, "TCP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_TcpCheck.SetCheck(TRUE);
			m_TcpCheck.EnableWindow(FALSE);
		}

		strcpy(ProtocolName, "UDP");
		if (! ((Proxy *)GetParent())->IsEntryUnique((LPCSTR)ProtocolName,(LPCSTR)PortName))
		{
			m_UdpCheck.SetCheck(TRUE);
			m_UdpCheck.EnableWindow(FALSE);
		}

		m_LineHelp.SetWindowText("Note : Protocol that is grayed-out is already mapped.");

		// Till Here

	}
	else if(m_OProtocol.IsEmpty())
	{
		m_LineHelp.SetWindowText("Enter a decimal Port number or select from list");
		m_DesEdtWnd.EnableWindow(TRUE);
		m_DesStatWnd.EnableWindow(TRUE);
	}
}

void PrxAddit::OnEditchangeComboPort()
{
	// TODO: Add your control notification handler code here

	if (m_PortWnd.GetCurSel() != LB_ERR)
	{
		m_PortWnd.SetCurSel(-1);	//remove the selection, reset edit box
		OnSelchangeComboPort();		//change the single line help message
	}
}

void PrxAddit::OnTcpCheck()
{
	// TODO: Add your control notification handler code here
	
}

void PrxAddit::OnUdpCheck()
{
	// TODO: Add your control notification handler code here
	
}

/* Till Here */

/*  */
/* Function Name : AddTcpUdpPorts                      */
/* Author	 : Ravi				       */	
/* Date 	 : 15 October 1998                     */
/* Scope         : To adding the Tcp/Udp Ports in the  */
/*               : Combo Box                           */
/*  */
void PrxAddit::AddTcpUdpPorts()
{
	int	ProtocolIndex, PortIndex = 0;
	char PortName[PORT_NAME_SIZE];
	char ProtocolName[PROTOCOL_NAME_SIZE];

	UpdateData(TRUE);		//update the variables from dialog
	
	//First rest the contents of the list in combobox
	m_PortWnd.ResetContent();

	ProtocolIndex = 0;
	strcpy(ProtocolName, "TCP");

	// add the ports known for this protocol
	while (((Proxy *) GetParent())->GetPortName(ProtocolIndex, PortIndex, PortName))
	{
		//Add this port if not present in list already
		if (((Proxy *) GetParent())->IsEntryUnique(ProtocolName, PortName))
			m_PortWnd.AddString(PortName);
		PortIndex++;
	}

	ProtocolIndex = 1;
        PortIndex = 0;
	strcpy(ProtocolName, "UDP");
      
	while (((Proxy *) GetParent())->GetPortName(ProtocolIndex, PortIndex, PortName))
	{
		//Add this port if not present in list already
		if (((Proxy *) GetParent())->IsEntryUnique(ProtocolName, PortName) && (m_PortWnd.FindStringExact(-1, PortName) == CB_ERR))
			m_PortWnd.AddString(PortName);
		PortIndex++;
	}
}
/* Till Here */


void PrxAddit::OnCheckRange()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if( m_range == TRUE )
	{
		m_ctrl_range.SetCheck(TRUE);
		m_static_high_range.EnableWindow(TRUE);
		m_ctrl_high_range.EnableWindow(TRUE);
	}
	else
	{	
		m_ctrl_range.SetCheck(FALSE);
		m_static_high_range.EnableWindow(FALSE);
		m_ctrl_high_range.EnableWindow(FALSE);
	}
}
