
// prxfilt.cpp : implementation file
//

#include <ctype.h>
#include "stdafx.h"
#include "procon.h"
#include "prxfilt.h"
#include "natdlg.h"
#include "proxy.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char *PrxFiltHeader = "Proxy - Filtering";

char *FilteringTypes[] = {						////Types of filtering
	 "Internet Sites (IP Address)",
	 "Internet Sites (Domain Name)",
	 "Client Workstations (IP Address)",
	 "Client Workstations (MAC Address)",
	 "Applications",
	 NULL};

FILT_ON_DEST_ADDRESS *filt_dest_start;
FILT_ON_SOURCE_ADDRESS *filt_source_start;
FILT_ON_APPLICATION *filt_applcn_start;
FILT_ON_MAC_ADDRESS *filt_mac_start;
FILT_ON_DOMAIN_NAME *filt_domain_name_start;

CString Padded_IPAddr;

CString PadWithZeroes (CString address)
{
	int IntVal;
	char buf1[16], buf2[16];
	char *ch;
	strcpy (buf1, address);
	address.Empty();
	while ((ch = strchr (buf1, (int) '.')) != NULL)
	{
		*ch = '\0';
		sscanf (buf1, "%u", &IntVal);
		sprintf (buf2, "%03u", IntVal);
		address += buf2;
		address += ".";
		strcpy (buf1, ++ch);
	}
	sscanf (buf1, "%u", &IntVal);
	sprintf (buf2, "%03u", IntVal);
	address += buf2;
	return (address);
}

/////////////////////////////////////////////////////////////////////////////
// CPrxfilt dialog


CPrxfilt::CPrxfilt(CWnd* pParent /*=NULL*/)
	: CDialog(CPrxfilt::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrxfilt)
	m_port = "";
	m_protocol = "";
	m_combo_filtering_type = "";
	m_edit_entry = "";
	//}}AFX_DATA_INIT
	selection = 0;
}

void CPrxfilt::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrxfilt)
	DDX_Control(pDX, IDC_BUTTON_DELETE, m_ctrl_delete);
	DDX_Control(pDX, IDC_COMBO_FILTERING_TYPE, m_ctrl_combo_filtering_type);
	DDX_Control(pDX, IDC_STATIC_FILTERING_ENTRY, m_ctrl_static_filtering_entry);
	DDX_Control(pDX, IDC_STATIC_PORT, m_ctrl_static_port);
	DDX_Control(pDX, IDC_LIST_FILTERING_DETAILS, m_ctrl_filtering_details);
	DDX_Control(pDX, IDC_EDIT_ENTRY, m_ctrl_edit_entry);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_ctrl_combo_protocol);
	DDX_Control(pDX, IDC_COMBO_PORT, m_ctrl_combo_port);
	DDX_CBString(pDX, IDC_COMBO_PORT, m_port);
	DDX_CBString(pDX, IDC_COMBO_PROTOCOL, m_protocol);
	DDX_CBString(pDX, IDC_COMBO_FILTERING_TYPE, m_combo_filtering_type);
	DDX_Text(pDX, IDC_EDIT_ENTRY, m_edit_entry);
	DDV_MaxChars(pDX, m_edit_entry, 255);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPrxfilt, CDialog)
	//{{AFX_MSG_MAP(CPrxfilt)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_CBN_SELCHANGE(IDC_COMBO_FILTERING_TYPE, OnSelchangeComboFilteringType)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, OnSelchangeComboProtocol)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPrxfilt message handlers

BOOL CPrxfilt::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	int index = 0;
	char ftp_name[30], ftp_Number1[10], ftp_Number2[10];

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;
	
	// TODO: Add extra initialization here

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BUTTON_DELETE, this));
	DeleteBmpBtn.SizeToContent();

	int TabStops[] = {15};
	m_ctrl_filtering_details.SetTabStops (1, (LPINT)&TabStops); 

	filt_dest_start = NULL;			
	filt_source_start = NULL;
	filt_applcn_start = NULL;
	filt_mac_start = NULL;
	filt_domain_name_start = NULL;

	GetConfig();						////Get the various parameters from the ini
	selection = 0;
	index = 0;
	while (FilteringTypes[index] != NULL)
	{
		m_ctrl_combo_filtering_type.AddString (FilteringTypes[index]);	
		index++;
	}
	////First display the entries for destination address filtering
	m_combo_filtering_type = FilteringTypes[0];
	m_ctrl_combo_protocol.ShowWindow (SW_HIDE);
	m_ctrl_combo_port.ShowWindow (SW_HIDE);
	m_ctrl_static_port.ShowWindow (SW_HIDE);
	m_ctrl_static_filtering_entry.SetWindowText ("Destination IP Address:");
	if (!m_ctrl_combo_filtering_type.GetCount())
		m_ctrl_delete.EnableWindow (FALSE);

	FILT_ON_DEST_ADDRESS *entry;
	entry = filt_dest_start;
	while (entry != NULL)
	{
		m_ctrl_filtering_details.AddString (entry->dest_ip);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPrxfilt::OnOK()
{
	// TODO: Add extra validation here
	AcceptConfig();
	free_allocated_mem();	
	CDialog::OnOK();
}

void CPrxfilt::OnCancel()
{
	// TODO: Add extra cleanup here
	free_allocated_mem();	
	CDialog::OnCancel();
}

void CPrxfilt::free_allocated_mem()
{
	////Free whatever memory allocated
	FILT_ON_DEST_ADDRESS *dest_entry;
	dest_entry = filt_dest_start;
	while (dest_entry != NULL)
	{
		filt_dest_start = dest_entry->ptr_to_next;
		free (dest_entry);
		dest_entry = filt_dest_start;
	}
	FILT_ON_SOURCE_ADDRESS *source_entry;
	source_entry = filt_source_start;
	while (source_entry != NULL)
	{
		filt_source_start = source_entry->ptr_to_next;
		free (source_entry);
		source_entry = filt_source_start;
	}
	FILT_ON_APPLICATION *app_entry;
	app_entry = filt_applcn_start;
	while (app_entry != NULL)
	{
		filt_applcn_start = app_entry->ptr_to_next;
		free (app_entry);
		app_entry = filt_applcn_start;
	}
	FILT_ON_MAC_ADDRESS *mac_entry;
	mac_entry = filt_mac_start;
	while (mac_entry != NULL)
	{
		filt_mac_start = mac_entry->ptr_to_next;
		free (mac_entry);
		mac_entry = filt_mac_start;
	}
	FILT_ON_DOMAIN_NAME *dn_entry;
	dn_entry = filt_domain_name_start;
	while (dn_entry != NULL)
	{
		filt_domain_name_start = dn_entry->ptr_to_next;
		free (dn_entry);
		dn_entry = filt_domain_name_start;
	}
}

void CPrxfilt::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	////Add the entry in the corresponding linked list
	char buf[50];
	UpdateData (TRUE);
  	switch (selection)
  	{
  	case 0:
  			FILT_ON_DEST_ADDRESS *dest_entry;
  			if ((dest_entry = (FILT_ON_DEST_ADDRESS *) malloc (sizeof (FILT_ON_DEST_ADDRESS))) == NULL)
  			{
  				ShowMessageBox(0);
  				return;
  			}
  			Padded_IPAddr = PadWithZeroes (m_edit_entry);
  			if (!ValidateAdd())
  				return;
  			strcpy (dest_entry->dest_ip, Padded_IPAddr);
  			dest_entry->ptr_to_next = filt_dest_start;
  			filt_dest_start = dest_entry;
  			m_ctrl_filtering_details.AddString (Padded_IPAddr);
  			break;
  	case 1:
  			FILT_ON_DOMAIN_NAME *dn_entry;
  			if ((dn_entry = (FILT_ON_DOMAIN_NAME *) malloc (sizeof (FILT_ON_DOMAIN_NAME))) == NULL)
  			{
  				ShowMessageBox(0);
  				return;
  			}
			if (!ValidateAdd())
				return;
  			strcpy (dn_entry->domain_name, m_edit_entry);
			dn_entry->ptr_to_next = filt_domain_name_start;
			filt_domain_name_start = dn_entry;
			m_ctrl_filtering_details.AddString (m_edit_entry);
			break;
	case 2:
			FILT_ON_SOURCE_ADDRESS *source_entry;
			if ((source_entry = (FILT_ON_SOURCE_ADDRESS *) malloc (sizeof (FILT_ON_SOURCE_ADDRESS))) == NULL)
			{
				ShowMessageBox(0);
				return;
			}
			Padded_IPAddr = PadWithZeroes (m_edit_entry);
			if (!ValidateAdd())
				return;
			strcpy (source_entry->source_ip, Padded_IPAddr);
			source_entry->ptr_to_next = filt_source_start;
			filt_source_start = source_entry;
			m_ctrl_filtering_details.AddString (Padded_IPAddr);
			break;
	case 3:
			FILT_ON_MAC_ADDRESS *mac_entry;
			if ((mac_entry = (FILT_ON_MAC_ADDRESS *) malloc (sizeof (FILT_ON_MAC_ADDRESS))) == NULL)
			{
				ShowMessageBox(0);
				return;
			}
			if (!ValidateAdd())
				return;
			sprintf (buf, "%012s", m_edit_entry);
			strcpy (mac_entry->mac_address, buf);
			mac_entry->ptr_to_next = filt_mac_start;
			filt_mac_start = mac_entry;
			m_ctrl_filtering_details.AddString (buf);
			break;
	case 4:
			FILT_ON_APPLICATION *app_entry;
			if ((app_entry = (FILT_ON_APPLICATION *) malloc (sizeof (FILT_ON_APPLICATION))) == NULL)
			{
				ShowMessageBox(0);
				return;
			}
			if (!ValidateAdd())
				return;
			strcpy (app_entry->protocol, m_protocol);
			strcpy (app_entry->port, m_port);
			app_entry->ptr_to_next = filt_applcn_start;
			filt_applcn_start = app_entry;
			strcpy (buf, m_protocol);
			strcat (buf, "\t");
			strcat (buf, m_port);
			m_ctrl_filtering_details.AddString (buf);	
			break;
		default:
			break;
	}
	m_edit_entry.Empty();
	UpdateData (FALSE);
}

void CPrxfilt::OnButtonDelete()
{
	// TODO: Add your control notification handler code here
	//Delete the selected entry from the linked list and also from the listbox.
	if (m_ctrl_filtering_details.GetCurSel() == CB_ERR)
		return;
	char tempbuf[50], pr_buf[5];
	char *ch;
	m_ctrl_filtering_details.GetText (m_ctrl_filtering_details.GetCurSel(), tempbuf);
	switch (selection)
	{
	case 0:
			FILT_ON_DEST_ADDRESS *dest_entry;
			FILT_ON_DEST_ADDRESS *prev_entry;
			dest_entry = filt_dest_start;
			prev_entry = filt_dest_start;
			while (dest_entry != NULL)
			{
				if (!strcmp (dest_entry->dest_ip, tempbuf))
					if (filt_dest_start == dest_entry)
					{
						filt_dest_start = dest_entry->ptr_to_next;
						free (dest_entry);
						break;
					}
					else
					{
						prev_entry->ptr_to_next = dest_entry->ptr_to_next;
						free (dest_entry);
						break;
					}
					prev_entry = dest_entry;
					dest_entry = dest_entry->ptr_to_next;
			}
			break;
	case 1:
			FILT_ON_DOMAIN_NAME *dn_entry;
			FILT_ON_DOMAIN_NAME *prev_dn_entry;
			dn_entry = filt_domain_name_start;
			prev_dn_entry = filt_domain_name_start;
			while (dn_entry != NULL)
			{
				if (!strcmp (dn_entry->domain_name, tempbuf))
					if (filt_domain_name_start == dn_entry)
					{
						filt_domain_name_start = filt_domain_name_start->ptr_to_next;
						free (dn_entry);
						break;
					}
					else
					{
						prev_dn_entry->ptr_to_next = dn_entry->ptr_to_next;
						free (dn_entry);
						break;
					}
					prev_dn_entry = dn_entry;
					dn_entry = dn_entry->ptr_to_next;
			}
			break;
	case 2:
			FILT_ON_SOURCE_ADDRESS *source_entry;
			FILT_ON_SOURCE_ADDRESS *prev_source_entry;
			source_entry = filt_source_start;
			prev_source_entry = filt_source_start;
			while (source_entry != NULL)
			{
				if (!strcmp (source_entry->source_ip, tempbuf))
					if (filt_source_start == source_entry)
					{
						filt_source_start = filt_source_start->ptr_to_next;
						free (source_entry);
						break;
					}
					else
					{
						prev_source_entry->ptr_to_next = source_entry->ptr_to_next;
						free (source_entry);
						break;
					}
					prev_source_entry = source_entry;
					source_entry = source_entry->ptr_to_next;
			}
			break;
	case 3:
			FILT_ON_MAC_ADDRESS *mac_entry;
			FILT_ON_MAC_ADDRESS *prev_mac_entry;
			mac_entry = filt_mac_start;
			prev_mac_entry = filt_mac_start;
			while (mac_entry != NULL)
			{
				if (!strcmp (mac_entry->mac_address, tempbuf))
					if (filt_mac_start == mac_entry)
					{
						filt_mac_start = filt_mac_start->ptr_to_next;
						free (mac_entry);
						break;
					}
					else
					{
						prev_mac_entry->ptr_to_next = mac_entry->ptr_to_next;
						free (mac_entry);
						break;
					}
					prev_mac_entry = mac_entry;
					mac_entry = mac_entry->ptr_to_next;
			}
			break;
	case 4:
			ch = strchr (tempbuf, (int) '\t');
			*ch = '\0';
			strcpy (pr_buf, tempbuf);
			strcpy (tempbuf, ++ch);
			FILT_ON_APPLICATION *app_entry;
			FILT_ON_APPLICATION *prev_app_entry;
			app_entry = filt_applcn_start;
			prev_app_entry = filt_applcn_start;
			while (app_entry != NULL)
			{
				if (!strcmp (app_entry->protocol, pr_buf))
					if (!strcmp (app_entry->port, tempbuf))
						if (filt_applcn_start == app_entry)
						{
							filt_applcn_start = filt_applcn_start->ptr_to_next;
							free (app_entry);
							break;
						}
						else
						{
							prev_app_entry->ptr_to_next = app_entry->ptr_to_next;
							free (app_entry);
							break;
						}
				prev_app_entry = app_entry;
				app_entry = app_entry->ptr_to_next;
			}
			break;
	}
	m_ctrl_filtering_details.DeleteString (m_ctrl_filtering_details.GetCurSel());
}

void CPrxfilt::OnSelchangeComboFilteringType()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	int index = 0;
	for (index = 0; index < 5; index++)
	{
		if (!strcmp (m_combo_filtering_type, FilteringTypes[index]))
		{
			switch (index)
			{
			case 0:
					selection = 0;
					OnFilterDestAddress();
					break;
			case 1:
					selection = 1;
					OnFilterDomainName();
					break;
			case 2:
					selection = 2;
					OnFilterSourceAddress();
					break;
			case 3:
					selection = 3;
					OnFilterMACAddress();
					break;
			case 4:
					selection = 4;
					OnFilterApplcn();
					break;
			}
		}
	}
	if (!m_ctrl_combo_filtering_type.GetCount())
		m_ctrl_delete.EnableWindow (FALSE);
	UpdateData (FALSE);
}


void CPrxfilt::GetConfig()
{
	int count, index, prefix_num = 0, IntVal;
	char templhs[128], temprhs[128], temp_pr[5];
	char *ch;
	char prefix_alphabet = 65;
	strcpy (templhs, "Proxy Server Number of Forbidden Sites");
	count = GetPrivateProfileInt (ProxySectionHeader, templhs, 0, IniInWinForm);	
	if (count)
	{
		FILT_ON_DEST_ADDRESS *dest_entry;
		for (index = 0; index < count; index++)
		{
			wsprintf (templhs, "$%c%dProxy Server Forbidden Address List", 
					prefix_alphabet, prefix_num);
			GetPrivateProfileString (ProxySectionHeader, (LPSTR) templhs, StrNull,
								temprhs, sizeof (temprhs), IniInWinForm);
			if ((dest_entry = (FILT_ON_DEST_ADDRESS *) malloc (sizeof (FILT_ON_DEST_ADDRESS))) == NULL)
			{
				ShowMessageBox (0);
				return;
			}
			Padded_IPAddr = PadWithZeroes (temprhs);
			strcpy (dest_entry->dest_ip, Padded_IPAddr);
			dest_entry->ptr_to_next = filt_dest_start;
			filt_dest_start = dest_entry;
			prefix_alphabet++;
			if (prefix_alphabet > 90)
			{
				prefix_num++;
				prefix_alphabet = 65;
			}
		}
	}
	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Clients");
	count = GetPrivateProfileInt (ProxySectionHeader, templhs, 0, IniInWinForm);	
	for (index = 0; index < count; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Client List", 
				prefix_alphabet, prefix_num);
		GetPrivateProfileString (ProxySectionHeader, (LPSTR) templhs, StrNull,
							temprhs, sizeof (temprhs), IniInWinForm);
		FILT_ON_SOURCE_ADDRESS *source_entry;
		if ((source_entry = (FILT_ON_SOURCE_ADDRESS *) malloc (sizeof (FILT_ON_SOURCE_ADDRESS))) == NULL)
		{
			ShowMessageBox (0);
			return;
		}
		Padded_IPAddr = PadWithZeroes (temprhs);
		strcpy (source_entry->source_ip, Padded_IPAddr);
		source_entry->ptr_to_next = filt_source_start;
		filt_source_start = source_entry;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_num++;
			prefix_alphabet = 65;
		}
	}
	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Applications");
	count = GetPrivateProfileInt (ProxySectionHeader, templhs, 0, IniInWinForm);	
	for (index = 0; index < count; index++)
	{
		FILT_ON_APPLICATION *app_entry;
		if ((app_entry = (FILT_ON_APPLICATION *) malloc (sizeof (FILT_ON_APPLICATION))) == NULL)
		{
			ShowMessageBox (0);
			return;
		}
		wsprintf (templhs, "$%c%dProxy Server Restricted Application List", 
				prefix_alphabet, prefix_num);
		GetPrivateProfileString (ProxySectionHeader, (LPSTR) templhs, StrNull,
							temprhs, sizeof (temprhs), IniInWinForm);
		if ((ch = strchr (temprhs, (int)',')) != NULL)
			*ch = '\0';
		sscanf((LPCSTR)temprhs, "%4x", &IntVal);	    ////This is because ini file
		sprintf((LPSTR)temp_pr, "%05u", IntVal);    //in 4 digits, but we want in
		GetProtocolName (app_entry->protocol, temp_pr);	    //in 5 digits.	
		strcpy (temprhs, ++ch);
		sscanf((LPCSTR)temprhs, "%4x", &IntVal);
		sprintf((LPSTR)temprhs, "%05u", IntVal);
		GetPortName (app_entry->port, temprhs, app_entry->protocol);
		if ((filt_applcn_start != NULL) && (!strcmp (app_entry->port, filt_applcn_start->port)))
		{////This is for ports which have two port nos. They shouldn't be repeated.
			free (app_entry);
			prefix_alphabet++;
			if (prefix_alphabet > 90)
			{
				prefix_num++;
				prefix_alphabet = 65;
			}
			continue;
		}
		app_entry->ptr_to_next = filt_applcn_start;
		filt_applcn_start = app_entry;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_num++;
			prefix_alphabet = 65;
		}
	}
	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted MAC Address");
	count = GetPrivateProfileInt (ProxySectionHeader, templhs, 0, IniInWinForm);	
	for (index = 0; index < count; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted MAC Address List", 
				prefix_alphabet, prefix_num);
		GetPrivateProfileString (ProxySectionHeader, (LPSTR) templhs, StrNull,
							temprhs, sizeof (temprhs), IniInWinForm);
		FILT_ON_MAC_ADDRESS *mac_entry;
		if ((mac_entry = (FILT_ON_MAC_ADDRESS *) malloc (sizeof (FILT_ON_MAC_ADDRESS))) == NULL)
		{
			ShowMessageBox (0);
			return;
		}
		strcpy (mac_entry->mac_address, temprhs);
		mac_entry->ptr_to_next = filt_mac_start;
		filt_mac_start = mac_entry;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_num++;
			prefix_alphabet = 65;
		}
	}
	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Domain Names");
	count = GetPrivateProfileInt (ProxySectionHeader, templhs, 0, IniInWinForm);	
	for (index = 0; index < count; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Domain Name List", 
				prefix_alphabet, prefix_num);
		GetPrivateProfileString (ProxySectionHeader, (LPSTR) templhs, StrNull,
							temprhs, sizeof (temprhs), IniInWinForm);
		FILT_ON_DOMAIN_NAME *dn_entry;
		if ((dn_entry = (FILT_ON_DOMAIN_NAME *) malloc (sizeof (FILT_ON_DOMAIN_NAME))) == NULL)
		{
			ShowMessageBox (0);
			return;
		}
		strcpy (dn_entry->domain_name, temprhs);
		dn_entry->ptr_to_next = filt_domain_name_start;
		filt_domain_name_start = dn_entry;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_num++;
			prefix_alphabet = 65;
		}
	}
}

void CPrxfilt::AcceptConfig()
{
	char prefix_alphabet = 65;
	int prefix_num = 0, no_of_entries = 0;
	char templhs[128], temprhs[50];
	////Delete all the entries first
	//This is because while writing the order is not maintained in the ini file
	//if some entries are already there.
	strcpy (templhs, "Proxy Server Number of Forbidden sites");
	no_of_entries = GetPrivateProfileInt (ProxySectionHeader, (LPSTR) templhs,
						0, IniInWinForm);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
	for (int index = 0; index < no_of_entries; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Forbidden Address List", prefix_alphabet, prefix_num);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) NULL, IniInWinForm);
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}
	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Clients");
	no_of_entries = GetPrivateProfileInt (ProxySectionHeader, (LPSTR) templhs,
						0, IniInWinForm);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
	for (index = 0; index < no_of_entries; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Client List", prefix_alphabet, prefix_num);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) NULL, IniInWinForm);
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Applications");
	no_of_entries = GetPrivateProfileInt (ProxySectionHeader, (LPSTR) templhs,
						0, IniInWinForm);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
	for (index = 0; index < no_of_entries; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Application List", prefix_alphabet, prefix_num);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) NULL, IniInWinForm);
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted MAC Address");
	no_of_entries = GetPrivateProfileInt (ProxySectionHeader, (LPSTR) templhs,
						0, IniInWinForm);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
	for (index = 0; index < no_of_entries; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted MAC Address List", prefix_alphabet, prefix_num);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	prefix_alphabet = 65;
	prefix_num = 0;
	strcpy (templhs, "Proxy Server Number of Restricted Domain Names");
	no_of_entries = GetPrivateProfileInt (ProxySectionHeader, (LPSTR) templhs,
						0, IniInWinForm);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
			(LPSTR) NULL, IniInWinForm);
	for (index = 0; index < no_of_entries; index++)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Domain Name List", prefix_alphabet, prefix_num);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) NULL, IniInWinForm);
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num++;
		}
	}

	FILT_ON_DEST_ADDRESS *dest_entry;
	if ((dest_entry = (FILT_ON_DEST_ADDRESS *) malloc (sizeof (FILT_ON_DEST_ADDRESS))) == NULL)
	{
		ShowMessageBox (0);
		return;
	}
	////First enter the number of entries in ini file. Then add the list entries.
	no_of_entries = 0;
	dest_entry = filt_dest_start;
	while (dest_entry != NULL)
	{
		no_of_entries++;
		dest_entry = dest_entry->ptr_to_next;
	}		
	strcpy (templhs, "Proxy Server Number of Forbidden sites");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	prefix_alphabet = 65;
	prefix_num = 0;
	dest_entry = filt_dest_start;
	while (dest_entry != NULL)
	{
		wsprintf (templhs, "$%c%dProxy Server Forbidden Address List", prefix_alphabet, prefix_num);
		strcpy (temprhs, dest_entry->dest_ip);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
					(LPSTR) temprhs, IniInWinForm);
		dest_entry = dest_entry->ptr_to_next;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num = 0;
		}
	}

	no_of_entries = 0;
	prefix_alphabet = 65;
	prefix_num = 0;
	FILT_ON_SOURCE_ADDRESS *source_entry;
	if ((source_entry = (FILT_ON_SOURCE_ADDRESS *) malloc (sizeof (FILT_ON_SOURCE_ADDRESS))) == NULL)
	{
		ShowMessageBox (0);
		return;
	}
	source_entry = filt_source_start;
	while (source_entry != NULL)
	{
		no_of_entries++;
		source_entry = source_entry->ptr_to_next;
	}
	strcpy (templhs, "Proxy Server Number of Restricted Clients");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	source_entry = filt_source_start;
	while (source_entry != NULL)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Client List", prefix_alphabet, prefix_num);
		strcpy (temprhs, source_entry->source_ip);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
					(LPSTR) temprhs, IniInWinForm);
		source_entry = source_entry->ptr_to_next;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num = 0;
		}
	}

	char port_buf[50], protocol_buf[5];
	int IntVal;
	no_of_entries = 0;
	prefix_alphabet = 65;
	prefix_num = 0;
	FILT_ON_APPLICATION *app_entry;
	if ((app_entry = (FILT_ON_APPLICATION *) malloc (sizeof (FILT_ON_APPLICATION))) == NULL)
	{
		ShowMessageBox (0);
		return;
	}
	app_entry = filt_applcn_start;
	while (app_entry != NULL)
	{
		no_of_entries++;
		app_entry = app_entry->ptr_to_next;
	}
	strcpy (templhs, "Proxy Server Number of Restricted Applications");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	no_of_entries = 0;
	app_entry = filt_applcn_start;
	while (app_entry != NULL)
	{
		GetProtocolNumber (protocol_buf, app_entry->protocol);
	   sscanf(protocol_buf, "%d", &IntVal);
		sprintf(protocol_buf, "%04x", IntVal);
		int ports = GetNumberOfPorts (app_entry->port, app_entry->protocol);
		for (index = 1; index <= ports; index++)
		{
			no_of_entries++;
			wsprintf (templhs, "$%c%dProxy Server Restricted Application List", prefix_alphabet, prefix_num);
			GetPortNumber (port_buf, app_entry->port, app_entry->protocol, index);
	      sscanf(port_buf, "%d", &IntVal);
			sprintf(port_buf, "%04x", IntVal);
			wsprintf (temprhs, "%s,%s", protocol_buf, port_buf);
			WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
					(LPSTR) temprhs, IniInWinForm);
			prefix_alphabet++;
			if (prefix_alphabet > 90)
			{
				prefix_alphabet = 65;
				prefix_num = 0;
			}
		}
		app_entry = app_entry->ptr_to_next;
	}
	strcpy (templhs, "Proxy Server Number of Restricted Applications");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	no_of_entries = 0;
	prefix_alphabet = 65;
	prefix_num = 0;
	FILT_ON_MAC_ADDRESS *mac_entry;
	if ((mac_entry = (FILT_ON_MAC_ADDRESS *) malloc (sizeof (FILT_ON_MAC_ADDRESS))) == NULL)
	{
		ShowMessageBox (0);
		return;
	}
	mac_entry = filt_mac_start;
	while (mac_entry != NULL)
	{
		no_of_entries++;
		mac_entry = mac_entry->ptr_to_next;
	}
	strcpy (templhs, "Proxy Server Number of Restricted MAC Address");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	mac_entry = filt_mac_start;
	while (mac_entry != NULL)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted MAC Address List", prefix_alphabet, prefix_num);
		strcpy (temprhs, mac_entry->mac_address);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
					(LPSTR) temprhs, IniInWinForm);
		mac_entry = mac_entry->ptr_to_next;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num = 0;
		}
	}

	no_of_entries = 0;
	prefix_alphabet = 65;
	prefix_num = 0;
	FILT_ON_DOMAIN_NAME *dn_entry;
	if ((dn_entry = (FILT_ON_DOMAIN_NAME *) malloc (sizeof (FILT_ON_DOMAIN_NAME))) == NULL)
	{
		ShowMessageBox (0);
		return;
	}
	dn_entry = filt_domain_name_start;
	while (dn_entry != NULL)
	{
		no_of_entries++;
		dn_entry = dn_entry->ptr_to_next;
	}
	strcpy (templhs, "Proxy Server Number of Restricted Domain Names");
	wsprintf (temprhs, "%d", no_of_entries);
	WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
				(LPSTR) temprhs, IniInWinForm);

	dn_entry = filt_domain_name_start;
	while (dn_entry != NULL)
	{
		wsprintf (templhs, "$%c%dProxy Server Restricted Domain Name List", prefix_alphabet, prefix_num);
		strcpy (temprhs, dn_entry->domain_name);
		WritePrivateProfileString (ProxySectionHeader, (LPSTR) templhs, 
					(LPSTR) temprhs, IniInWinForm);
		dn_entry = dn_entry->ptr_to_next;
		prefix_alphabet++;
		if (prefix_alphabet > 90)
		{
			prefix_alphabet = 65;
			prefix_num = 0;
		}
	}
}

void CPrxfilt::OnFilterDestAddress()
{
	m_ctrl_combo_protocol.ShowWindow (SW_HIDE);
	m_ctrl_combo_port.ShowWindow (SW_HIDE);
	m_ctrl_static_port.ShowWindow (SW_HIDE);
	m_ctrl_edit_entry.ShowWindow (SW_SHOW);
	m_ctrl_static_filtering_entry.SetWindowText ("Destination IP Address:");
	m_ctrl_filtering_details.ResetContent();
	m_edit_entry.Empty();
	
	FILT_ON_DEST_ADDRESS *entry;
	entry = filt_dest_start;
	while (entry != NULL)
	{
		m_ctrl_filtering_details.AddString (entry->dest_ip);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
}

void CPrxfilt::OnFilterSourceAddress()
{
	m_ctrl_combo_protocol.ShowWindow (SW_HIDE);
	m_ctrl_combo_port.ShowWindow (SW_HIDE);
	m_ctrl_static_port.ShowWindow (SW_HIDE);
	m_ctrl_edit_entry.ShowWindow (SW_SHOW);
	m_ctrl_static_filtering_entry.SetWindowText ("Source IP Address:");
	m_ctrl_filtering_details.ResetContent();
	m_edit_entry.Empty();

	FILT_ON_SOURCE_ADDRESS *entry;
	entry = filt_source_start;
	while (entry != NULL)
	{
		m_ctrl_filtering_details.AddString (entry->source_ip);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
}

void CPrxfilt::OnFilterApplcn()
{
	char tempbuf[50];
	int index;
	m_ctrl_combo_protocol.ShowWindow (SW_SHOW);
	m_ctrl_combo_protocol.ResetContent();
	m_ctrl_combo_port.ShowWindow (SW_SHOW);
	m_ctrl_combo_port.ResetContent();
	m_ctrl_static_port.ShowWindow (SW_SHOW);
	m_ctrl_edit_entry.ShowWindow (SW_HIDE);
	m_ctrl_static_filtering_entry.SetWindowText ("Protocol:");
	for (index = 0; index < 2; index++)
		m_ctrl_combo_protocol.AddString (ProtocolNameNumberMap[index].Name);
	m_protocol = ProtocolNameNumberMap[0].Name;

	index = 0;
	while (TCPPortStrings[index].Name != NULL)
	{
		m_ctrl_combo_port.AddString (TCPPortStrings[index].Name);
		index++;
	}
	m_port = TCPPortStrings[0].Name;
	m_ctrl_filtering_details.ResetContent();
	FILT_ON_APPLICATION *entry;
	entry = filt_applcn_start;
	while (entry != NULL)
	{
		strcpy (tempbuf, entry->protocol);
		strcat (tempbuf, "\t");
		strcat (tempbuf, entry->port);
		m_ctrl_filtering_details.AddString (tempbuf);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
}

void CPrxfilt::OnFilterMACAddress()
{
	m_ctrl_combo_protocol.ShowWindow (SW_HIDE);
	m_ctrl_combo_port.ShowWindow (SW_HIDE);
	m_ctrl_static_port.ShowWindow (SW_HIDE);
	m_ctrl_edit_entry.ShowWindow (SW_SHOW);
	m_ctrl_static_filtering_entry.SetWindowText ("MAC Address:");
	m_ctrl_filtering_details.ResetContent();
	m_edit_entry.Empty();

	FILT_ON_MAC_ADDRESS *entry;
	entry = filt_mac_start;
	while (entry != NULL)
	{
		m_ctrl_filtering_details.AddString (entry->mac_address);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
}

void CPrxfilt::OnFilterDomainName()
{
	m_ctrl_combo_protocol.ShowWindow (SW_HIDE);
	m_ctrl_combo_port.ShowWindow (SW_HIDE);
	m_ctrl_static_port.ShowWindow (SW_HIDE);
	m_ctrl_edit_entry.ShowWindow (SW_SHOW);
	m_ctrl_edit_entry.LimitText (64);
	m_ctrl_static_filtering_entry.SetWindowText ("Domain Name:");
	m_ctrl_filtering_details.ResetContent();
	m_edit_entry.Empty();

	FILT_ON_DOMAIN_NAME *entry;
	entry = filt_domain_name_start;
	while (entry != NULL)
	{
		m_ctrl_filtering_details.AddString (entry->domain_name);
		entry = entry->ptr_to_next;
	}
	UpdateData (FALSE);
}

void CPrxfilt::OnSelchangeComboProtocol()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	int index = 0;
	if (!strcmp (m_protocol, ProtocolNameNumberMap[0].Name))
	{
		m_ctrl_combo_port.ResetContent();
		while (TCPPortStrings[index].Name != NULL)
		{
			m_ctrl_combo_port.AddString (TCPPortStrings[index].Name);
			index++;
		}
	}
	else
	{
		m_ctrl_combo_port.ResetContent();
		while (UDPPortStrings[index].Name != NULL)
		{
			m_ctrl_combo_port.AddString (UDPPortStrings[index].Name);
			index++;
		}
	}
}

void CPrxfilt::ShowMessageBox(int err_index)
{
	char *ErrorMessage[] = {
		"Memory Allocation Failed",
		"Invalid IP Address",
		"Entry already exists",
		"Invalid MAC Address",
		"Invalid Domain Name",
		"Port Number already exists",
		"Enter a valid entry",
		"This is a default port number",
		"Invalid Port"
		};
	char tempbuf[128];
	strcpy (tempbuf, ErrorMessage[err_index]);
	::MessageBox (GetSafeHwnd(), tempbuf, (LPSTR) PrxFiltHeader, MB_OK);
	if (selection != 4)
		m_ctrl_edit_entry.SetFocus();
	else
		m_ctrl_combo_protocol.SetFocus();
	return;
}

BOOL CPrxfilt::ValidateAdd()
{
	CDotDecimal addr_buf;
	char buf[13], dn_buf[256];
	char port_buf1[50], port_buf2[50], pr_buf[5];
	int index;
	char *ch;

	if (selection != 4)
	{
		if (m_edit_entry.IsEmpty())
		{
			ShowMessageBox (6);
			return FALSE;
		}
	}
	switch (selection)
	{
	case 0:
			addr_buf = Padded_IPAddr;
			if (!addr_buf.IsValid())
			{
				ShowMessageBox (1);
				return FALSE;
			}
			FILT_ON_DEST_ADDRESS *dest_entry;
			dest_entry = filt_dest_start;
			while (dest_entry != NULL)
			{
				if (!strcmp (dest_entry->dest_ip, Padded_IPAddr))
				{
					ShowMessageBox (2);
					return FALSE;
				}
				dest_entry = dest_entry->ptr_to_next;
			}
			break;
	case 1:
			FILT_ON_DOMAIN_NAME *dn_entry;
			strcpy (dn_buf, m_edit_entry);
			if (m_edit_entry.IsEmpty())
			{
				ShowMessageBox (4);
				return FALSE;
			}
			////First character should not be a numeric character
			if (isdigit (dn_buf[0])) 
			{
				ShowMessageBox (4);
				return FALSE;
			}
			index = 0;
			while (dn_buf[index])
			{
				if (!isdigit (dn_buf[index]) && !isalpha (dn_buf[index]) &&
					(dn_buf[index] != '.')) 
				{
					ShowMessageBox (4);
					return FALSE;
				}
				index++;
			}
			index = 0;
			while ((ch = strchr (dn_buf, (int)'.')) != NULL)
			{
				index++;
				if (index > 2)
				{
					ShowMessageBox (4);
					return FALSE;
				}								
				*ch = '\0';
//				if (index != 1)
				if (strlen (dn_buf) > 64)
				{
					ShowMessageBox (4);
					return FALSE;
				}
				strcpy (dn_buf, ++ch);
			}
			if (strlen (dn_buf) > 64)
			{
				ShowMessageBox (4);
				return FALSE;
			}
			strcpy (dn_buf, m_edit_entry);
			if (strlen (dn_buf) > 255)
			{
				ShowMessageBox (4);
				return FALSE;
			}
			dn_entry = filt_domain_name_start;
			while (dn_entry != NULL)
			{
				if (!strcmp (dn_entry->domain_name, m_edit_entry))
				{
					ShowMessageBox(2);
					return FALSE;
				}
				dn_entry = dn_entry->ptr_to_next;
			}
			break;
	case 2:
			addr_buf = Padded_IPAddr;
			if (!addr_buf.IsValid())
			{
				ShowMessageBox (1);
				return FALSE;
			}
			FILT_ON_SOURCE_ADDRESS *source_entry;
			source_entry = filt_source_start;
			while (source_entry != NULL)
			{
				if (!strcmp (source_entry->source_ip, Padded_IPAddr))
				{
					ShowMessageBox(2);
					return FALSE;
				}
				source_entry = source_entry->ptr_to_next;
			}
			break;
	case 3:
			if (m_edit_entry.GetLength() > 12)
			{
				ShowMessageBox (3);
				return FALSE;
			}
			strcpy (buf, m_edit_entry);
			for (index = 0; index < m_edit_entry.GetLength(); index++)
			{
				if (!(((buf[index] >= 48) && (buf[index] <= 57)) || ((buf[index] >= 65)
						&& (buf[index] <= 70)) || ((buf[index] >= 97) && (buf[index] <= 102))))						
				{
					ShowMessageBox (3);
					return FALSE;
				}
			}
			////Pad with zeroes
			sprintf (buf, "%012s", m_edit_entry);
			FILT_ON_MAC_ADDRESS *mac_entry;
			mac_entry = filt_mac_start;
			while (mac_entry != NULL)
			{
				if (!strcmp (mac_entry->mac_address, buf))
				{
					ShowMessageBox(2);
					return FALSE;
				}
				mac_entry = mac_entry->ptr_to_next;
			}
			break;
	case 4:
			strcpy (pr_buf, m_protocol);
			if (m_port.IsEmpty())
			{
				ShowMessageBox (8);
				return FALSE;
			}
			if (m_ctrl_combo_port.FindString (0, m_port) == CB_ERR)
			{
				strcpy (port_buf1, m_port);
				index = 0;
				while (port_buf1[index])
				{
					if ((port_buf1[index] < '0')	|| (port_buf1[index] > '9'))
					{
						ShowMessageBox (8);
						return FALSE;		
					}
					index++;
				}
				strcpy (buf, m_port);
				PadWithZeroes (port_buf1, buf, 5);
				for (index = 0; index < m_ctrl_combo_port.GetCount(); index++)
				{
					m_ctrl_combo_port.GetLBText (index, port_buf2);
					int ports = GetNumberOfPorts (port_buf2, pr_buf);
					for (int i = 1; i <= ports; i++)
					{
						GetPortNumber (buf, port_buf2, pr_buf, i);
						if (!strcmp (buf, port_buf1))
						{
							ShowMessageBox (7);
							m_ctrl_combo_port.SetFocus();
							return FALSE;
						}
					}
				}
			}
			FILT_ON_APPLICATION *app_entry;
			app_entry = filt_applcn_start;
			while (app_entry != NULL)
			{
				if (!strcmp (app_entry->protocol, m_protocol))
					if (!strcmp (app_entry->port, m_port))
					{
						ShowMessageBox(2);
						return FALSE;
					}
				app_entry = app_entry->ptr_to_next;
			}
			break;
	}
	return TRUE;
}

void CPrxfilt::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_RESTRICTIONS,HELP_CONTEXT);
}

