// prxfilt.h : header file
//

struct FILT_ON_DEST_ADDRESS {
	char dest_ip[16];
	FILT_ON_DEST_ADDRESS *ptr_to_next;
	};

struct FILT_ON_SOURCE_ADDRESS {
	char source_ip[16];
	FILT_ON_SOURCE_ADDRESS *ptr_to_next;
	};

struct FILT_ON_APPLICATION {
	char protocol[50];
	char port[50];
	FILT_ON_APPLICATION *ptr_to_next;
	};

struct FILT_ON_MAC_ADDRESS {
	char mac_address[13];
	FILT_ON_MAC_ADDRESS *ptr_to_next;
	};

struct FILT_ON_DOMAIN_NAME {
	char domain_name[65];
	FILT_ON_DOMAIN_NAME *ptr_to_next;
	};

/////////////////////////////////////////////////////////////////////////////
// CPrxfilt dialog

class CPrxfilt : public CDialog
{
// Construction
public:
	CPrxfilt(CWnd* pParent = NULL);	// standard constructor
	int selection;
	BOOL ValidateAdd();
	void GetConfig();
	void AcceptConfig();
	void OnFilterDestAddress();
	void OnFilterSourceAddress();
	void OnFilterApplcn();
	void OnFilterMACAddress();
	void OnFilterDomainName();
	void ShowMessageBox(int err_index);
	void free_allocated_mem();

// Dialog Data
	//{{AFX_DATA(CPrxfilt)
	enum { IDD = IDD_DIALOG_RESTRICTIONS };
	CButton	m_ctrl_delete;
	CComboBox	m_ctrl_combo_filtering_type;
	CStatic	m_ctrl_static_filtering_entry;
	CStatic	m_ctrl_static_port;
	CListBox	m_ctrl_filtering_details;
	CEdit	m_ctrl_edit_entry;
	CComboBox	m_ctrl_combo_protocol;
	CComboBox	m_ctrl_combo_port;
	CString	m_port;
	CString	m_protocol;
	CString	m_combo_filtering_type;
	CString	m_edit_entry;
	//}}AFX_DATA

	CBitmapButton OKBmpBtn;
	CBitmapButton CancelBmpBtn;
	CBitmapButton HelpBmpBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBmpBtn;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CPrxfilt)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnButtonAdd();
	afx_msg void OnButtonDelete();
	afx_msg void OnSelchangeComboFilteringType();
	afx_msg void OnSelchangeComboProtocol();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
