/*--------------------------------------------------------------------------*/
/*	File		:	DISPRTNS.C												*/
/*	Purpose		:	This file contains display routines.					*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifndef WIN
#include	"\me_2\inc\misc.h"
#else
#include	"windows.h"
#include	"misc.h"
#endif

#include	"scrtcons.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

#define	MC_FN_CALL		0xcc

/*--------------------------------------------------------------------------*/
/*	Name		:	CheckForMeterm											*/
/*	Input		:	None													*/
/*	Output		:	METERM or MEREMOTE signature.							*/
/*	Synopsis	:	This issues int 16 call to find out if METERM or		*/
/*						MEREMOTE is loaded in memory.						*/
/*--------------------------------------------------------------------------*/

word	CheckForMeterm(void)
{
#ifndef WIN
	_asm {
		mov		ah, MC_FN_CALL
		int		16H
	}
#else
	return 0;
#endif
}

/*--------------------------------------------------------------------------*/
/*	Name		:	PutStr													*/
/*	Input		:	str, string to display.									*/
/*	Output		:	None													*/
/*	Synopsis	:	Displays the string.									*/
/*--------------------------------------------------------------------------*/

void	PutStr(byte *string)
{
#ifndef WIN
	_asm {
		push	ax		; save registers.
		push	bx
		push	si
		mov		bh, DisplayPage
		mov		ah, 0eH
		mov		si, string		; str
	PutNextChar :
		lodsb
		or		al, al
		jz		StringOver
		int		10H
		jmp		SHORT	PutNextChar
	StringOver :
		pop		si		; restore registers.
		pop		bx
		pop		ax
	}
#else
	MessageBox(hCompileWnd, string, "MultiExpress Script Compiler", MB_OK);
#endif
}

/*--------------------------------------------------------------------------*/
/*	Name		:	ShowMesg												*/
/*	Input		:	str, string to display,									*/
/*					wait, wait for key or not.								*/
/*	Output		:	None													*/
/*	Synopsis	:	Displays the string.									*/
/*--------------------------------------------------------------------------*/

void	ShowMesg(byte *string, byte key_wait)
{
#ifndef WIN
	#define	TERM_SHOW_MESG	48				; METERM only.

	_asm {
		mov		al, MeTermPresent	; METERM or MERMT present ?
		or		al, MeRmtPresent
		jz		WriteOnTty
		mov		ah, TERM_SHOW_MESG
		mov		dx, string
		mov		bl, key_wait
		int		0E2H		; call meterm services.
		jmp		SHORT MesgShown
	WriteOnTty :
		push	string
		call	PutStr
		add		sp, 2
	MesgShown :
	}
#else
	MessageBox(hCompileWnd, string, "MultiExpress Script Compiler", MB_OK);
#endif
}
