/*--------------------------------------------------------------------------*/
/*	File		:	FILEIO.C												*/
/*	Purpose		:	This file contains file IO routines.					*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifdef WIN
#include	"windows.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

/*--------------------------------------------------------------------------*/
/*	Name		:	Open													*/
/*	Input		:	file_name, file name to open,							*/
/*					mode, mode in which to open file.						*/
/*	Output		:	file handle if file opened, else -1.					*/
/*	Synopsis	:	Opens the file and returns the file handle.				*/
/*--------------------------------------------------------------------------*/

int		Open(byte *file_name, byte mode)
{
	int		file_handle;
#ifndef WIN
	_asm {
		mov		file_handle, -1
		mov		ah, 3dH				; file open.
		mov		al, mode			; open mode.
		mov		dx, file_name
		int		21H
		jc		OpenError
		mov		file_handle, ax
	OpenError :
	}
#else
	file_handle = _lopen(file_name, READ_WRITE);
#endif
	return(file_handle);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Close													*/
/*	Input		:	file_handle, file handle to close.						*/
/*	Output		:	None													*/
/*	Synopsis	:	Closes the file.										*/
/*--------------------------------------------------------------------------*/

void	Close(int file_handle)
{
#ifndef WIN
	_asm {
		mov		ah, 3eH
		mov		bx, file_handle
		int		21H
	}
#else
	_lclose(file_handle);
#endif
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Create													*/
/*	Input		:	file_name, file name to create.							*/
/*	Output		:	file handle.											*/
/*	Synopsis	:	Creates the file and returns the file handle.			*/
/*--------------------------------------------------------------------------*/

int		Create(byte *file_name)
{
	int		file_handle;

#ifndef WIN
	_asm {
		mov		file_handle, -1
		mov		ah, 3cH				; create file.
		xor		cx, cx				; normal attribute.
		mov		dx, file_name
		int		21H
		jc		CreateError
		mov		file_handle, ax
	CreateError :
	}
#else
	file_handle = _lcreat(file_name, 0);
#endif
	return(file_handle);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Read													*/
/*	Input		:	file_handle, file handle to read,						*/
/*					buffer, buffer to read into,							*/
/*					count, number of characters to read.					*/
/*	Output		:	number of characters read if no error, else -1.			*/
/*	Synopsis	:	Reads specified number of characters from the file.		*/
/*--------------------------------------------------------------------------*/

int		Read(int file_handle, byte *buffer, int count)
{
	int	read_count;

#ifndef WIN
	_asm {
		mov		ah, 3fH				; read from file.
		mov		bx, file_handle		; file handle to read from.
		mov		cx, count			; number of characters to read.
		mov		dx, buffer			; buffer address.
		int		21H
		jnc		ReadDone
		mov		ax, -1				; error reading.
	ReadDone :
	}
#else
	read_count = _lread(file_handle, buffer, count);
	return read_count;
#endif
}

/*--------------------------------------------------------------------------*/
/*	Name		:	FWrite													*/
/*	Input		:	file_handle, file handle to write into,					*/
/*					buffer, buffer to write,								*/
/*					count, number of characters to write.					*/
/*	Output		:	number of characters written if no error, else -1.		*/
/*	Synopsis	:	Writes specified number of characters to the file.		*/
/*--------------------------------------------------------------------------*/

int		FWrite(int file_handle, byte *buffer, int count)
{
	int	write_count;

#ifndef WIN
	_asm {
		mov		ah, 40H				; write to file.
		mov		bx, file_handle		; file handle to write to.
		mov		cx, count			; number of characters to write.
		mov		dx, buffer			; buffer address.
		int		21H
		jnc		WriteDone
		mov		ax, -1				; error writing.
	WriteDone :
	}
#else
	write_count = _lwrite(file_handle, buffer, count);
	return write_count;
#endif
}

/*--------------------------------------------------------------------------*/
/*	Name		:	Delete													*/
/*	Input		:	file_name, file name to delete,							*/
/*	Output		:	0 if file deleted, else -1.								*/
/*	Synopsis	:	Deletes specified file.									*/
/*--------------------------------------------------------------------------*/

int		Delete(byte *file_name)
{
	_asm {
		mov		ah, 41H				; delete file.
		mov		dx, file_name		; file name.
		int		21H
		mov		ax, 0				; assume delete done.
		jnc		DeleteDone
		mov		ax, -1				; error deleting.
	DeleteDone :
	}
}

/*--------------------------------------------------------------------------*/
/*	Name		:	GetChar													*/
/*	Input		:	None													*/
/*	Output		:	Next character in input.								*/
/*	Synopsis	:	Returns the next character in the input.				*/
/*--------------------------------------------------------------------------*/

int		GetChar(void)
{
	#define	INBUF_SIZE	512

	static	byte	InBuffer[INBUF_SIZE];
	static	int		ReadIdx = 0;
	static	int		NoOfChars = 0;
	int		ch;

	if (ReadIdx == NoOfChars) {
		ReadIdx = 0;
#ifndef WIN
		_asm {
			mov		ax, 3f00H
			mov		bx, InFileHandle
			mov		dx, OFFSET InBuffer
			mov		cx, INBUF_SIZE
			int		21H
			jnc		ReadDone
			mov		ax, -1		; indicate read error.
		ReadDone :
			mov		NoOfChars, ax
		}
#else
		NoOfChars = _lread(InFileHandle, InBuffer, INBUF_SIZE);
#endif
		if (NoOfChars == -1)
			goto error_exit;
		if (!NoOfChars)
			return(-1);
	}
	ch = InBuffer[ReadIdx++];
	if (ch == 0x1a)		/*	End of file ?	*/
		ch = -1;
	return(ch);

	error_exit :
	return(-1);
}
