;---------------------------------------------------------------------------
; File		: INTRTNS.ASM
; Purpose	: This file contains interrupt routines.
; Package	: MultiExpress Ver 2.00
; Authors	: S. Narasimhan
; Date		: April 6, 1992.
;---------------------------------------------------------------------------

		DOSSEG
		.MODEL SMALL, C


		.DATA

		EVEN

Int24StackTop	DW	128	DUP (0)
Int24StackBottom	LABEL	WORD
		DW	0

		.CODE

	IF @CodeSize
		EXTRN	CriticalErrorHndlr:FAR
	ELSE
		EXTRN	CriticalErrorHndlr:NEAR
	ENDIF

	; Interrupt handler table.

		PUBLIC	IntInfoTable
IntInfoTable	LABEL	BYTE

		DB	24H		; Int 24H
OldInt24Rtn	DD	(?)		; Old int 24 address to be kept here
		DW	OFFSET Int24Rtn	; Address of new int 24

		DB	0		; End of table

;------------------------------------------------------------------------------

Int24Rtn	PROC	FAR

		cld
		push	bx			; save bx in old stack.
		cli				; prevent context change.
		mov	cs:OldInt24SS, ss	; Save old stack segment and sp.
		mov	cs:OldInt24SP, sp
		sti
		mov	bx, DGROUP		; Switch stack.
		mov	ss, bx
		mov	sp, OFFSET DGROUP:Int24StackBottom
		push	cx
		push	dx
		push	ds
		push	es
		mov	ds, bx			; init data segment.
		mov	cs:OldInt24AH, ah
		push	di			; error code.
		push	ax			; status code.
		call	CriticalErrorHndlr
		add	sp, 4			; clean up stack.
		mov	ah, cs:OldInt24AH
		pop	es
		pop	ds
		pop	dx
		pop	cx
		cli				; prevent context change.
		mov	ss, cs:OldInt24SS	; restore old stack.
		mov	sp, cs:OldInt24SP
		sti
		pop	bx		; restore bx from old stack.
		iret

OldInt24AH	DB	(?)
OldInt24SS	DW	(?)
OldInt24SP	DW	(?)
Int24Rtn	ENDP
;------------------------------------------------------------------------------

		PUBLIC	SetVectors
SetVectors	PROC

		push	si
		mov	si, OFFSET IntInfoTable	; Get int info table ptr.
SetNextVector:
		mov	al, cs:[si]		; Get int no in al
		inc	si			; Update si
		or	al, al			; End of table ?
		jz	ExitSetVectors		; Yes, so all ints over
		mov	cl, al			; Save it in cl also
		mov	ah, 35H			; Issue get vector call
		int	21H
		mov	cs:[si], bx		; Store offset in the table
		add	si, 2			; Update si
		mov	cs:[si], es		; Store segment val in table
		add	si, 2			; Update si
		mov	dx, cs:[si]		; Get int handler address
		add	si, 2			; Update si
		mov	al, cl			; Get back int no in al
		mov	ah, 25H			; Make set vector call
		push	ds			; Save ds
		push	cs
		pop	ds			; Make ds = cs
		int	21H
		pop	ds			; Restore ds
		jmp	SetNextVector		; Set the next vector now
ExitSetVectors:
		pop	si
		ret

SetVectors	ENDP

;----------------------------------------------------------------------------

		; Following routine resets the ints trapped by MC

		PUBLIC	ResetVectors
ResetVectors	PROC

		push	si
		mov	si, OFFSET IntInfoTable	; Get ptr to table of int info
ResetNextVector:
		mov	al, cs:[si]		; Get int no in al
		inc	si			; Update si
		or	al, al			; Is it null?
		jz	ExitResetVectors	; Yes, so all ints over
		mov	dx, cs:[si]		; Get old int handler offset
		add	si, 2			; Update si
		push	ds			; Save ds
		mov	ds, cs:[si]		; Get old int handler seg
		add	si, 2			; Update si
		mov	ah, 25H			; Make set vector call
		int	21H
		pop	ds			; Restore ds
		add	si, 2			; Skip MC int handler's offset
		jmp	ResetNextVector		; Set the next vector now
ExitResetVectors:
		pop	si
		ret

ResetVectors	ENDP
;------------------------------------------------------------------------------
		END
