/*--------------------------------------------------------------------------*/
/*	File		:	OPTIMIZE.C												*/
/*	Purpose		:	This file contains script code optimization routines.	*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifdef WIN
#include	"windows.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"
#include	"scrtmesg.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

#include	<string.h>
#include	<stdlib.h>

/*	Optimizations still to be done : (1) jump over jumps, (2) kill	*/
/*	temporaries assigned but not used (functions which return value	*/
/*	but not used; should be done with care because functions returning	*/
/*	strings could leave the string memory unreachable to release),	*/
/*	(3) jumps following return statement, (4) renumbering of	*/
/*	temporaries after optimizing on moving into temporaries.	*/

/*--------------------------------------------------------------------------*/
/*	Name		:	OptTransMovs											*/
/*	Input		:	c_ptr, Pointer to code list.							*/
/*	Output		:	0														*/
/*	Synopsis	:	Removes transitive mov instructions.					*/
/*--------------------------------------------------------------------------*/

int		OptTransMovs(CodeTypeFptr c_ptr)
{
	CodeTypeFptr	prev_ptr;
	CodeTypeFptr	curr_ptr;
	CodeTypeFptr	next_ptr;
	byte	reduced;	/*	Indicates if any instruction optimized.	*/
	byte	arg_idx;
	byte	deleted;

	/*	Look for two consecutive mov instructions of the form	*/
	/*	(mov INT a INT b) and (mov INT b INT c) and replace the	*/
	/*	sequence by (mov INT a INT c). Repeat this until no more	*/
	/*	reduction is possible.	*/

	if (!c_ptr)
		goto ignore_exit;
	do {
		prev_ptr = 0;
		curr_ptr = c_ptr;
		reduced = false;
		while (next_ptr = curr_ptr->NextCode) {
			deleted = false;
			switch (curr_ptr->Operator) {
				case Q_MOV :
					switch (next_ptr->Operator) {
						/*	Change mov x y; mov y z; to mov x z.	*/
						case Q_MOV :
						/*	Change mov x y, plus y z t; to plus x z t.	*/
						/*	Change mov x y, plus z y t; to plus z x t.	*/
						case Q_NOT :
						case Q_UNARY_MINUS :
						case Q_PLUS :
						case Q_MINUS :
						case Q_TIMES :
						case Q_DIV :
						case Q_LESS_OR_EQUAL :
						case Q_GREATER_OR_EQUAL :
						case Q_LESS :
						case Q_GREATER :
						case Q_IS_EQUAL :
						case Q_IS_NOT_EQUAL :
						case Q_AND :
						case Q_OR :
							arg_idx = 0;	/*	Invalid value.	*/
							if (next_ptr->Operator == Q_MOV ||
										next_ptr->Operator == Q_NOT ||
										next_ptr->Operator == Q_UNARY_MINUS) {
								if (curr_ptr->Type2 == next_ptr->Type1 &&
									!strcmp(curr_ptr->Arg3, next_ptr->Arg1))
									arg_idx = 1;
							}
							else {
								if (curr_ptr->Type2 == next_ptr->Type1 &&
									!strcmp(curr_ptr->Arg3, next_ptr->Arg1))
									arg_idx = 1;
								if (curr_ptr->Type2 == next_ptr->Type2 &&
									!strcmp(curr_ptr->Arg3, next_ptr->Arg2))
									arg_idx = 2;
							}
							if (!arg_idx)
								break;	/*	Can't optimize.	*/
							reduced = true;	/*	One instruction reduced.	*/
							deleted = true;
							if (arg_idx == 1) {
#ifndef WIN
								free(next_ptr->Arg1);
#else
								LocalFree((byte *) next_ptr->Arg1);
#endif
								next_ptr->Arg1 = curr_ptr->Arg1;
								next_ptr->Type1 = curr_ptr->Type1;
							}
							else {
#ifndef WIN
								free(next_ptr->Arg2);
#else
								LocalFree((byte *) next_ptr->Arg2);
#endif
								next_ptr->Arg2 = curr_ptr->Arg1;
								next_ptr->Type2 = curr_ptr->Type1;
							}
							curr_ptr->Arg1 = 0;
							prev_ptr->NextCode = curr_ptr->NextCode;
							/*	Make current node into a list by	*/
							/*	itself and release it.	*/
							curr_ptr->NextCode = 0;
							FreeCodes(curr_ptr);
							/*	Re-init pointer to new current node.	*/
							curr_ptr = prev_ptr->NextCode;
							break;
					}
					break;
				case Q_NOT :
				case Q_UNARY_MINUS :
				case Q_PLUS :
				case Q_MINUS :
				case Q_TIMES :
				case Q_DIV :
				case Q_LESS_OR_EQUAL :
				case Q_GREATER_OR_EQUAL :
				case Q_LESS :
				case Q_GREATER :
				case Q_IS_EQUAL :
				case Q_IS_NOT_EQUAL :
				case Q_AND :
				case Q_OR :
					/*	Change greater z y z, mov z t; to	*/
					/*	greater z y t.	*/
					if (next_ptr->Operator == Q_MOV &&
								!strcmp(curr_ptr->Arg3, next_ptr->Arg1)) {
						reduced = true;	/*	One instruction reduced.	*/

						/*	Free first variable name memory and copy	*/
						/*	second variable name memory. Invalidate	*/
						/*	second variable name memory.	*/
#ifndef WIN
						free(curr_ptr->Arg3);
#else
						LocalFree((byte *) curr_ptr->Arg3);
#endif
						curr_ptr->Arg3 = next_ptr->Arg3;
						next_ptr->Arg3 = 0;

						curr_ptr->NextCode = next_ptr->NextCode;

						/*	Make second node into a list by itself	*/
						/*	and release it.	*/
						next_ptr->NextCode = 0;
						FreeCodes(next_ptr);
					}
					break;
				case Q_RET :
					if (next_ptr->Operator == Q_RET) {
						reduced = true;	/*	One instruction reduced.	*/
						curr_ptr->NextCode = next_ptr->NextCode;
						/*	Make second node into a list by itself	*/
						/*	and release it.	*/
						next_ptr->NextCode = 0;
						FreeCodes(next_ptr);
					}
					break;
			}
			if (!deleted) {
				prev_ptr = curr_ptr;
				curr_ptr = curr_ptr->NextCode;
			}
		}
	} while (reduced);

	ignore_exit :
	return(0);
}

/*--------------------------------------------------------------------------*/
/*	Name		:	OptTemps												*/
/*	Input		:	c_ptr, Pointer to code list.							*/
/*	Output		:	0														*/
/*	Synopsis	:	Removes kill of unused temporaries.						*/
/*--------------------------------------------------------------------------*/

int		OptTemps(CodeTypeFptr c_ptr)
{
	CodeTypeFptr	prev_t_ptr;	/*	Pointer to node before TEMPCOUNT code.	*/
	CodeTypeFptr	t_ptr;	/*	Pointer to TEMPCOUNT code.	*/
	CodeTypeFptr	prev_c_ptr;
	byte	*temp_usage;	/*	Indicates if a temporary is being used.	*/
	byte	deleted;	/*	Indicates if node deleted.	*/
	int		max_count;
	int		idx;
	byte	str[15];	/*	To change temporaries count.	*/
	byte	*ptr;

	/*	Looks for KILL $Tn, and if $Tn is not used, removes the same.	*/
	/*	This is possible because of an optimization done for transitive	*/
	/*	move instructions.	*/

	prev_c_ptr = t_ptr = prev_t_ptr = 0;
	temp_usage = 0;
	while (c_ptr) {
		deleted = false;
		switch (c_ptr->Operator) {
			case Q_TEMPCOUNT :
				prev_t_ptr = prev_c_ptr;
				t_ptr = c_ptr;
				max_count = atoi(c_ptr->Arg1);
				if (temp_usage)
#ifndef WIN
					free(temp_usage);	/*	Release earlier usage.	*/
#else
					LocalFree((byte *) temp_usage);	/*	Release earlier usage.	*/
#endif
#ifndef WIN
				temp_usage = malloc(max_count);
#else
				temp_usage = (byte *) LocalAlloc(LMEM_FIXED, max_count);
#endif
				if (temp_usage)
					for (idx = 0; idx < max_count; idx++)
						temp_usage[idx] = 0;
				max_count = -1;	/*	Max index of temp used.	*/
				break;
			case Q_KILL :
				idx = atoi(c_ptr->Arg1 + 2);
				if (temp_usage) {	/*	Temps usage table allocated ?	*/
					if (temp_usage[idx])
						temp_usage[idx] = 0;	/*	Temp no longer valid.	*/
					else {
						/*	Update the links and remove the instruction.	*/
						prev_c_ptr->NextCode = c_ptr->NextCode;
						/*	Make this node into a list by itself	*/
						/*	and release it.	*/
						c_ptr->NextCode = 0;
						FreeCodes(c_ptr);
						c_ptr = prev_c_ptr->NextCode;
						deleted = true;
					}
				}
				break;
			case Q_NOT :
			case Q_UNARY_MINUS :
			case Q_MOV :
			case Q_PLUS :
			case Q_MINUS :
			case Q_TIMES :
			case Q_DIV :
			case Q_LESS_OR_EQUAL :
			case Q_GREATER_OR_EQUAL :
			case Q_LESS :
			case Q_GREATER :
			case Q_IS_EQUAL :
			case Q_IS_NOT_EQUAL :
			case Q_AND :
			case Q_OR :
			case Q_PUSH :
				if (c_ptr->Operator == Q_PUSH)
					ptr = c_ptr->Arg1;
				else
					ptr = c_ptr->Arg3;
				if (ptr[0] == '$' && ptr[1] == 'T') {
					/*	Indicate that the temporary is being used.	*/
					idx = atoi(ptr + 2);
					temp_usage[idx] = 1;
					if (idx > max_count)
						max_count = idx;	/*	Count max temp index.	*/
				}
				break;
			case Q_ENDPROCEDURE :
				if (t_ptr) {
					if (max_count == -1) {	/*	No temps needed.	*/
						/*	No temps, so remove the tempcount node.	*/
						prev_t_ptr->NextCode = t_ptr->NextCode;
						/*	Make tempcount node into a list by	*/
						/*	itself and release it.	*/
						t_ptr->NextCode = 0;
						FreeCodes(t_ptr);
					}
					else {
						itoa(max_count + 1, str, 10);
#ifndef WIN
						ptr = malloc(strlen(str) + 1);
#else
						ptr = (byte *) LocalAlloc(LMEM_FIXED, strlen(str) + 1);
#endif
						if (ptr) {
#ifndef WIN
							free(t_ptr->Arg1);
#else
							LocalFree((byte *) t_ptr->Arg1);
#endif
							t_ptr->Arg1 = ptr;
							strcpy(ptr, str);
						}
					}
					t_ptr = 0;
				}
				if (temp_usage) {
#ifndef WIN
					free(temp_usage);	/*	Release temps used table.	*/
#else
					LocalFree((byte *) temp_usage);	/*	Release temps used table.	*/
#endif
					temp_usage = 0;	/*	Invalidate the temps usage table.	*/
				}
				break;
		}
		if (!deleted) {
			prev_c_ptr = c_ptr;	/*	Previous node becomes current node.	*/
			c_ptr = c_ptr->NextCode;	/*	Current node becomes next node.	*/
		}
	}
	if (temp_usage)
#ifndef WIN
		free(temp_usage);
#else
		LocalFree((byte *) temp_usage);
#endif
	return(0);
}
