/*--------------------------------------------------------------------------*/
/*	File		:	SCRTDATA.C												*/
/*	Purpose		:	This file contains data declarations for script file	*/
/*						processing.											*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifndef WIN
#include	"\me_2\inc\misc.h"
#else
#include	"windows.h"
#include	"misc.h"
#endif

#include	"errcons.h"
#include	"scrtcons.h"

#include	"scrttype.h"
#include	"scrtdata.h"
#include	"scrtfuns.h"

byte	Application = 0;	/*	Indicates the application context.	*/
byte	MeTermPresent = false;
byte	MeRmtPresent = false;

byte	Optimize = false;	/*	Switch to optimize.	*/
byte	Suppress = false;	/*	To suppress assembly psuedo code.	*/

dword	ScreenAddr;
byte	DisplayPage;
byte	DisplayMode;
byte	ScreenWidth;
byte	ScreenHeight;
word	CursorType;

PreDefVarType	PreDefVars[] = {	/*	List of pre-defined variables.	*/
	{"$CONDN_VAR", Q_INTEGER},
	{"$RET_VAR", Q_INTEGER},
};

int		NoOfPreDefVars = sizeof(PreDefVars) / sizeof(PreDefVarType);

byte	TokenStr[MAX_TOKEN_LEN];
word	TokenLen;
int		Token = -1;

int		ErrCount = 0;
int		LineNo = 1;		/*	Source line no.	*/
int		InFileHandle = -1;
int		OutFileHandle = -1;	/*	Handle for writing assembly psuedo code.	*/
int		CodeFileHandle = -1;	/*	Handle for code file.	*/
int		ErrorFileHandle = -1;	/*	Handle for error messages file.	*/
byte	*ErrorFileName = 0;	/*	File name to write error messages.	*/

int		TempVarCount;	/*	Counter for creating temporaries for expr.	*/
int		TotalTempCount;	/*	Max. temporaries within a function body.	*/
int		ParamCount;	/*	To count parameters in proc definitions.	*/
int		LabelCount;	/*	Counter for generating temporary labels.	*/
int		Scope;	/*	Lexical scope level.	*/

SymInfoType	*ProcNamePtr;	/*	Pointer to fn name being processed; used	*/
							/*	to check consistency of expression type in	*/
							/*	return statement.	*/
byte	*NullStr = "";

SymInfoType	*Display[MAX_LEVELS];	/*	Display of symbols.	*/

byte	FileName[PATH_NAME_LEN + FILE_NAME_LEN - 1];	/*	Script file.	*/
byte	*ScriptExtn = ".scr";	/*	Extension for script file name.	*/
byte	*PsuedoCodeExtn = ".out";	/*	Extension for psuedo code file.	*/
byte	*CodeExtn = ".cod";	/*	Extension for code file name.	*/
byte	*MainFnName = "MAIN";	/*	Main function name.	*/

CodeTypeFptr	ProcCode;	/*	Pointer to procedure code.	*/

byte	*TokenStrs[] = {
			/*	These strings should match with tok_type in scrtcons.h	*/
	"Q_UNARY_MINUS",
	"Q_PLUS",
	"Q_MINUS",
	"Q_TIMES",
	"Q_DIV",
	"Q_LESS_OR_EQUAL",
	"Q_GREATER_OR_EQUAL",
	"Q_IS_EQUAL",
	"Q_IS_NOT_EQUAL",
	"Q_LESS",
	"Q_GREATER",
	"Q_NOT",
	"Q_LP",
	"Q_RP",
	"Q_AND",
	"Q_OR",
	"Q_COMMA",
	"Q_ID",
	"Q_INT_CONST",
	"Q_REAL_CONST",
	"Q_STRING_CONST",
	"Q_SEMICOLON",
	"Q_COLON",
	"Q_ASSIGNMENT",
	"Q_LABEL",
	"Q_ILLEGAL",
	"Q_IF",
	"Q_THEN",
	"Q_ELSE",
	"Q_ENDIF",
	"Q_WHILE",
	"Q_DO",
	"Q_ENDWHILE",
	"Q_FOR",
	"Q_TO",
	"Q_DOWNTO",
	"Q_STEP",
	"Q_ENDFOR",
	"Q_SWITCH",
	"Q_CASE",
	"Q_DEFAULT",
	"Q_ENDCASE",
	"Q_ENDSWITCH",
	"Q_PROC",
	"Q_ENDPROC",
	"Q_FORWARD",
	"Q_RETURN",
	"Q_GOTO",
	"Q_VAR",
	"Q_INTEGER",
	"Q_REAL",
	"Q_STRING",
	"Q_VOID",
};

byte	*ResdWords[] = {
	"IF",
	"THEN",
	"ELSE",
	"ENDIF",
	"WHILE",
	"DO",
	"ENDWHILE",
	"FOR",
	"TO",
	"DOWNTO",
	"STEP",
	"ENDFOR",
	"SWITCH",
	"CASE",
	"DEFAULT",
	"ENDCASE",
	"ENDSWITCH",
	"PROC",
	"ENDPROC",
	"FORWARD",
	"RETURN",
	"GOTO",
	"VAR",
	"INTEGER",
	"REAL",
	"STRING",
	"VOID",
};

int		NoOfResdWords = sizeof(ResdWords) / sizeof(byte *);

byte	*ErrMsgs[] = {
	"Error in string constant",		/*	ERR_STRING_CONST	*/
	"Error in comments",			/*	ERR_COMMENTS	*/
	"Identifier expected",			/*	ERR_ID_EXPECTED	*/
	"; expected",					/*	ERR_SEMICOLON_EXPECTED	*/
	"( expected",					/*	ERR_LP_EXPECTED	*/
	") expected",					/*	ERR_RP_EXPECTED	*/
	"integer/real/string expected",	/*	ERR_TYPE_EXPECTED	*/
	"ENDPROC expected",				/*	ERR_ENDPROC_EXPECTED	*/
	"statement expected",			/*	ERR_STAT_EXPECTED	*/
	"THEN expected",				/*	ERR_THEN_EXPECTED	*/
	"ENDIF expected",				/*	ERR_ENDIF_EXPECTED	*/
	"= expected",					/*	ERR_ASSIGNMENT_EXPECTED	*/
	"TO/DOWNTO expected",			/*	ERR_TO_DOWNTO_EXPECTED	*/
	"DO expected",					/*	ERR_DO_EXPECTED	*/
	"ENDFOR expected",				/*	ERR_ENDFOR_EXPECTED	*/
	"ENDWHILE expected",			/*	ERR_ENDWHILE_EXPECTED	*/
	"Expression ill formed",		/*	ERR_ILL_FORMED_EXPRESSION	*/
	"Invalid symbol in expression",	/*	INVALID_EXPR_TOKEN	*/
									/*	ERR_EXPR_RP_EXPECTED	*/
	"Unmatched paranthesis, ')' expected",
									/*	ERR_BIN_OP_RP_UOP_EXPECTED	*/
	"Binary operator between ')' and unary operator expected",
									/*	ERR_BIN_OP_RP_LP_EXPECTED	*/
	"Binary operator between ')' and '(' expected",
									/*	ERR_BIN_OP_RP_ID_EXPECTED	*/
	"Binary operator between ')' and identifier expected",
									/*	ERR_BIN_OP_ID_ID_EXPECTED	*/
	"Binary operator between identifiers expected",
	"Null expression provided",		/*	ERR_NULL_EXPR_GIVEN	*/
	"Unexpected end of file",		/*	UNEXPECTED_EOF	*/
	"Out of memory",				/*	ERR_OUT_OF_MEMORY	*/
	"Identifier already declared",	/*	ERR_ID_ALREADY_DECLARED	*/
	"Label already declared",		/*	ERR_LABEL_ALREADY_DECLARED	*/
	"Identifier not declared",		/*	ERR_ID_NOT_DECLARED	*/
	"Identifier is not a procedure",	/*	ERR_ID_NOT_PROC	*/
	"Type conflict of operands",	/*	ERR_TYPE_CONFLICT	*/
	"Void function used in expression",	/*	ERR_VOID_IN_EXPR	*/
	"Argument types differ in function",	/*	ERR_ARG_TYPES_DIFFER	*/
	"Expression does not have lvalue",	/*	ERR_NO_LVALUE_FOR_EXPR	*/
	"Assignment to a void symbol",	/*	ERR_ASSIGNMENT_TO_VOID	*/
	"PROC expected",				/*	ERR_PROC_EXPECTED	*/
									/*	ERR_CASE_CONSTANT	*/
	"Error in case constant, integer/string expected",
	"ENDCASE expected",				/*	ERR_ENDCASE_EXPECTED	*/
	"ENDSWITCH expected",			/*	ERR_ENDSWITCH_EXPECTED	*/
	"Jump to a non-label",			/*	ERR_JUMP_TO_NON_LABEL	*/
	"Label not declared",			/*	ERR_LABEL_NOT_DECLARED	*/
	"No return value in function",	/*	ERR_FN_NO_RETURN_VALUE	*/
	"Assignment to a function name",	/*	ERR_ASSIGNMENT_TO_FN_NAME	*/
									/*	ERR_SWITCH_EXPRESSION	*/
	"Switch expression should be integer or string",
									/*	ERR_CASE_TYPE_CONFLICT	*/
	"Switch expression and case constant type mismatch",
	"Switch has more than one default",	/*	ERR_MORE_THAN_ONE_DEFAULT	*/
	"Duplicate case constant",	/*	ERR_DUPLICATE_CASE_CONSTANT	*/
	"Function 'main' not declared",	/*	ERR_MAIN_FN_NOT_DECLARED	*/
	"Statement is ill formed",		/*	ERR_STATEMENT_ILL_FORMED	*/
	"'=' or ':' expected",			/*	ERR_ASSIGNMENT_COLON_EXPECTED	*/
	"Function defined with no arguments",	/*	ERR_FN_HAS_NO_ARGUMENTS	*/
	"Few arguments given",	/*	ERR_FEW_ARGS_FOR_FN	*/
	"Too many arguments given",	/*	ERR_TOO_MANY_ARGS_FOR_FN	*/
								/*	ERR_ALREADY_FORWARD_DECLARED	*/
	"Function already forward declared",
								/*	ERR_PROC_BODY_NOT_FOUND	*/
	"Body of forward defined procedure not given",
	"PROC MAIN cannot have parameters",	/*	ERR_PROC_MAIN_HAS_ARGS	*/
	"PROC MAIN cannot have return value",	/*	ERR_PROC_MAIN_HAS_RETVALUE	*/
								/*	ERR_EXP_INT_REAL_EXPECTED	*/
	"Error in expression, integer/real expected",
};
int		NoOfErrMsgs = sizeof(ErrMsgs) / sizeof(byte *);

byte	Precedence[MAX_EXPR_TOKENS][MAX_EXPR_TOKENS] = {
		/*   ~  +  -  *  /  <= >= == != <  >  !  (  )  && || ,  id	*/
/* ~ */		{L, G, G, G, G, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* + */		{L, G, G, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* - */		{L, G, G, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* * */		{L, G, G, G, G, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* / */		{L, G, G, G, G, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* <= */	{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* >= */	{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* == */	{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* != */	{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* < */		{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* > */		{L, L, L, L, L, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* ! */		{L, G, G, G, G, G, G, G, G, G, G, L, L, G, G, G, G, L},
/* ( */		{L, L, L, L, L, L, L, L, L, L, L, L, L, E, L, L, E, L},
/* ) */		{E2,G, G, G, G, G, G, G, G, G, G, E2,E3,G, G, G, G, E4},
/* && */	{L, L, L, L, L, L, L, L, L, L, L, L, L, G, G, G, G, L},
/* || */	{L, L, L, L, L, L, L, L, L, L, L, L, L, G, L, G, G, L},
/* , */		{L, L, L, L, L, L, L, L, L, L, L, L, L, E, L, L, E, L},
/* id */	{G, G, G, G, G, G, G, G, G, G, G, G, E, G, G, G, G, E5},
};

#include	"scrtmesg.c"
