#ifndef __SCRTTYPE__

#define __SCRTTYPE__


/*--------------------------------------------------------------------------*/
/*	File		:	SCRTTYPE.H												*/
/*	Purpose		:	This file contains type declarations.					*/
/*	Package		:	MultiExpress Ver 2.00.									*/
/*	Authors		:	S. Narasimhan.											*/
/*	Date		:	April 6, 1992.											*/
/*--------------------------------------------------------------------------*/

#ifndef	byte
typedef unsigned char byte;
#endif
#ifndef word
typedef unsigned int word;
#endif
#ifndef	dword
typedef unsigned long dword;
#endif
#ifndef fchar
typedef	char far fchar;
#endif
#ifndef fbyte
typedef	byte far fbyte;
#endif
#ifndef bool
typedef	enum {false, true}	bool;
#endif

typedef	struct	stack_t {
	int		TokClass;		/*	Stack symbol token type.	*/
	byte	Operator;		/*	Operator.	*/
	byte	Attribute;		/*	Expr has lvalue or not.	*/
	byte	ExprType;		/*	Type of expr (int/real/string).	*/
	byte	*Name;			/*	Token name.	*/
	struct	stack_t	*Llink;
	struct	stack_t	*Rlink;
	struct	call_arg_t	*ArgList;	/*	Argument list in fn call.	*/
} ExprNodeType;

typedef	struct {
	byte	RetValue;	/*	Function return value type.	*/
	struct	defn_arg_t	*ArgList;	/*	Function argument list.	*/
	struct	sym_info_t	*SymTablePtr;	/*	Symbol table pointer for	*/
										/*	forward defined procedures.	*/
	struct	code_t	far	*ParamList;	/*	Code sequence pointer for forward	*/
									/*	defined procedures.	*/
} ProcInfoType;

/*	Status is used to identify labels used but not declared, and	*/
/*	procedures supposed to return a value but don't, and forward	*/
/*	defined but whose body is not given.	*/

typedef	struct	sym_info_t {
	byte	SymClass;	/*	intger/real/string/proc.	*/
	byte	SymType;	/*	Global/parameter/local variable.	*/
	int		Status;		/*	Symbol status.	*/
	byte	*Name;	/*	Pointer to symbol name.	*/
	struct	sym_info_t	*Llink;	/*	Ptr to lexically less nodes.	*/
	struct	sym_info_t	*Rlink;	/*	Ptr to lexically greater nodes.	*/
	ProcInfoType	*ProcInfoPtr;	/*	Pointer to proc info.	*/
} SymInfoType;

typedef	struct	defn_arg_t {	/*	Function definition argument list.	*/
	byte	ArgClass;	/*	integer/real/string.	*/
	byte	Attribute;	/*	Call by value / reference.	*/
	SymInfoType	*VarPtr;	/*	Pointer to symbol table of arg.	*/
	struct	defn_arg_t	*NextArgPtr;	/*	Next argument node.	*/
} DefnArgType;

typedef	struct	call_arg_t	{	/*	Function call argument list.	*/
	ExprNodeType	*ExprPtr;	/*	Pointer to expression node.	*/
	struct	call_arg_t	*NextArgPtr;	/*	Pointer to next argument node.	*/
} CallArgType;

typedef	struct	code_t {
	byte	Operator;	/*	Operator/instruction.	*/
	byte	Type1;		/*	Type of first operand.	*/
	byte	*Arg1;		/*	Name of first operand.	*/
	byte	Type2;		/*	Type of second operand.	*/
	byte	*Arg2;		/*	Name of second operand.	*/
	byte	*Arg3;		/*	Name of third operand.	*/
	struct	code_t	far	*NextCode;	/*	Pointer to next code.	*/
} CodeType;

typedef	CodeType	far	*CodeTypeFptr;	/*	Far ptr to code node.	*/

typedef struct	{
	byte	*VarName;	/*	Name of the variable.	*/
	byte	VarType;	/*	Type of the variable.	*/
} PreDefVarType;

#endif
