#include 	"windows.h"

#include <memory.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <commdlg.h>

#include	"edit.h"
#include	"file.h"
#include	"dlgbox.h"
#include	"ourdlgbx.h"


/****************************************************************************
Routine	:	ProcessDirName()
Input	:
Return	:	returns 1 if name OK and direcotry exists, 0 if name OK and
				directory not present  and -1 if name not OK (Sets name to NULL)
Synop	:	Scans name. returns -1 if wild cards. if name OK and dir present
			returns 1. if dir not present returns 0; also strupr is done
****************************************************************************/
int ProcessDirName (LPSTR DirName)
{
	int index ;

	AnsiUpper (DirName) ;
	for (index = 0; DirName[index] ; index ++)
	{
		if (DirName[index] == '*' || DirName[index] == '?') 
		{
WrongName:
			return -1 ;
		}
		if (index != 1 && DirName[index] == ':')	// check wrong : char
			goto WrongName ;
	}
	/* Check for back slash at end */
	if (index)
		index -- ;
	if (index && DirName[index] == '\\') 
	{
		index -- ;
		if (index && DirName[index] != ':')		// : can't be wrong now
			DirName[index+1] = 0 ;
	}
	return 0 ;
}


/****************************************************************************
 * FUNCTION	: SeparateFile(LPSTR, LPSTR, LPSTR)
 * PURPOSE	: Separate filename and pathname
 ****************************************************************************/
void
SeparateFile(LPSTR lpDestPath, LPSTR lpDestFileName, LPSTR lpSrcFileName)
{
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
    while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
        lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if (*lpTmp != ':' && *lpTmp != '\\') {
        lstrcpy(lpDestFileName, lpSrcFileName);
        lpDestPath[0] = 0;
        return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
     *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
ProcessDirName(lpDestPath);
}


/***************************************************************************
Routine	:	ForceExtn(Filename, Ext)
Input	:	Filename pointer, and needed extn (must be in ".xxx" format)
Return	:	
Synop	:	pointer Filename is forced to have Ext string as extension
***************************************************************************/
void	ForceExtn(LPSTR Name, LPSTR Ext)
{
	Name[8] = NULL;
	while (*Name && *Name != '.')
		Name++;
	lstrcpy(Name, Ext);
}


/****************************************************************************
Routine	:	MakeFullFileName
Input	:	pointers to destination, pathname and file name
Return	:	pointer to dest
Synop	:	filename is concatenated to pathname and \ is added if needed
****************************************************************************/
LPSTR	MakeFullFileName(LPSTR dest, LPSTR pathname, LPSTR filename)
{
	int		len;

	len = lstrlen(pathname);
	lstrcpy(dest, pathname);
	if (pathname[len-1] != '\\' && pathname[len-1] != ':')
		lstrcat(dest, "\\");
	lstrcat(dest, filename);
	return dest;
}


/****************************************************************************
 * FUNCTION	: GetMEWPathName
 * PURPOSE	: Get the MEW exe pathname.
 ***************************************************************************/
void GetMEWPathName (LPSTR szFileName)
{
	LPSTR	pcFileName ;
	int nFileNameLen ; 

	nFileNameLen = GetModuleFileName (hInst, szFileName, EXE_NAME_MAX_SIZE) ;
	pcFileName = szFileName + nFileNameLen ;

	while (pcFileName > szFileName) 
	{
		if (*pcFileName == '\\' || *pcFileName == ':') 
		{
			*(++pcFileName) = '\0';
			break ;
		}
		nFileNameLen--;
		pcFileName--;
	}
	return;
}


void OverWrite (HWND hOwner)
{
	OPENFILENAME FileStat ;
	char szFile[200] ;
	char szBuf[512] ;
	char szTitle[] = "Router Script - Overwrite" ;
	int hFrom ;
	int hTo ;
	int nRead ;
	struct _stat FileStats ;

	memset ((unsigned char *) &FileStat, 0, sizeof (FileStat)) ;
	FileStat.lStructSize = sizeof (FileStat) ;
	FileStat.hwndOwner = hOwner ;
	szFile[0] = 0x00 ;
	FileStat.lpstrFile = (LPSTR) &szFile ;
	FileStat.nMaxFile = sizeof (szFile) ;
	FileStat.lpstrTitle = (LPCSTR) &szTitle ;
	FileStat.lpstrFilter = "Script Files\0*.scr\0Backup Files\0*.bak\0\0" ;
	if (!GetOpenFileName (&FileStat))
		return ;
	
	hFrom = _open (szFile, _O_RDONLY | _O_BINARY) ;
	if (hFrom == -1)
	{
	 	MessageBox (hOwner, "Source File not found",
										"Script", MB_OK | MB_ICONINFORMATION) ;
		return ;
	}

	_fstat (hFrom, &FileStats) ;
	if (FileStats.st_size > MAXFILESIZE) 
	{
		_close (hFrom) ;
		MessageBox (hOwner, "Max File size exceeded",
										"Script", MB_OK | MB_ICONINFORMATION) ;
		return ;
	}

	MakeFullFileName (szBuf, ScriptFilesDir, EditFileName) ;
	hTo = _open (szBuf, _O_TRUNC | _O_BINARY) ;
	if (hTo == -1)
	{
		_close (hFrom) ;
		MessageBox (hOwner, "Destination File could not be created",
											"Script", MB_OK | MB_ICONINFORMATION) ;
		return ;
	}
	_close (hTo) ;

	hTo = _open (szBuf, _O_WRONLY | _O_BINARY) ;
	if (hTo == -1)
	{
		_close (hFrom) ;
		MessageBox (hOwner, "Destination File open error",
										"Script", MB_OK | MB_ICONINFORMATION) ;
		return ;
	}

	while (1)
	{
		nRead = read (hFrom, szBuf, sizeof (szBuf)) ;
		if (!nRead)
			break ;
		write (hTo, szBuf, nRead) ;
	}

	hEditBuffer = (HLOCAL) SendMessage (hEditWnd, EM_GETHANDLE, 0, 0L) ;
	LocalFree (hEditBuffer) ; 

	hEditBuffer = (HLOCAL) LocalAlloc (LMEM_MOVEABLE | LMEM_ZEROINIT, (UINT) FileStats.st_size + 1) ;
	pEditBuffer = LocalLock (hEditBuffer) ;
	_lseek (hFrom, 0L, SEEK_SET) ;
	read (hFrom, pEditBuffer, (WORD) FileStats.st_size);
	LocalUnlock (hEditBuffer) ;
	SendMessage (hEditWnd, EM_SETHANDLE, hEditBuffer, 0L) ;
	UpdateWindow (hEditWnd) ;
	_close (hFrom) ;
	_close (hTo) ;
}


void BackupScriptFile (void)
{
	char szBuf[200] ;
	char *ptr ;
	int nLen ;
	FILE *sfp, *dfp ;

	MakeFullFileName (szBuf, ScriptFilesDir, EditFileName) ;
	nLen = strlen (szBuf) ;
	ptr = szBuf + nLen - 1 ;
	while (*ptr != '.' && (ptr > szBuf))
		ptr -- ;
	*(ptr + 1) = 0x00 ;
	strcat (szBuf, "BAK") ;

	dfp = fopen (szBuf, "wb") ;
	if (dfp == NULL)
		return ;

	MakeFullFileName (szBuf, ScriptFilesDir, EditFileName) ;
	sfp = fopen (szBuf, "rb") ;
	if (sfp == NULL)
	{
		fclose (dfp) ;
		return ;
	}

	while (nLen = fread (szBuf, sizeof (char), sizeof (szBuf), sfp))
		fwrite (szBuf, sizeof (char), nLen, dfp) ;

	fclose (sfp) ;
	fclose (dfp) ;
}
