#ifndef __SCRIPT_H__

#define __SCRIPT_H__

// script.h : header file
//

#include "com.h"
#include <stdio.h>
#include <time.h>

/////////////////////////////////////////////////////////////////////////////
// CScriptDlg dialog

class CScriptDlg : public CDialog
{
// Construction
public:
	CScriptDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CScriptDlg)
	enum { IDD = IDD_DIALOG_SCRIPT };
	//}}AFX_DATA

	int m_nPortNum ;

	CBitmapButton CancelBmpBtn;
	CBitmapButton DnldBmpBtn;
	CBitmapButton CompileBmpBtn;
	CBitmapButton EditBmpBtn;

	CMiscCom cScriptCom ;
	int Go_on ;
	int CTRL_FLAG ;

private :
	CString m_szComprScriptSource ;
	CString m_szScriptSource ;
	CString m_szScriptCode ;
	CString m_szFullScript ;
	time_t m_timeOldScr ;

	BOOL ReadScript (void) ;
	BOOL ReadScriptThroCom (void) ;
	BOOL GetScriptHeaderCom (void) ;
	BOOL SeparateScriptScrAndCod (void) ;
	BOOL GetScriptCom (void) ;

	void WriteThroCom (void) ;
	BOOL WriteScriptScrAndCodToCom (void) ;
	BOOL CompressSrc (FILE *sfptr, FILE *dfptr) ;
	void WriteScriptHeaderCom (void) ;

	BOOL IsScrModified (void) ;
	BOOL IsCompilationNecessary (void) ;
	void GetOldScrTime (void) ;
	BOOL FileSizeOverFlow (void) ;
	BOOL ReadScriptThroEthernet (void) ;
	BOOL GetScriptHeaderEnet (void) ;
	void WriteScriptHeaderEnet (void) ;
	void WriteThroEnet (void) ;
	BOOL WriteScriptScrAndCodToEnet (void) ;
	BOOL CombineScrAndCod (void) ;
	BOOL CreateScrFile (void) ;
	BOOL CalculateCRCForEtherNet (void) ;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CScriptDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnBtnDnldScript();
	virtual void OnCancel();
	afx_msg void OnBtnEditScript();
	afx_msg void OnBtnCompile();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#define MAX_NO_OF_WAN_PORTS 3  /* Assume 3 WAN ports */

typedef struct PortScriptTag
{
	DWORD StartAddr ;
	WORD ScrLen ;           /* Script source is in compressed form */
	WORD CodLen ;          /* Code is always uncompressed */
	WORD CRC ;
   char DateStamp[25] ;
} PortScriptHdr ;  


typedef struct ScriptHeaderTag
{
	int NumberOfWANPorts ; 
	WORD MagicNumber ;
	PortScriptHdr Ports[MAX_NO_OF_WAN_PORTS] ;
	BYTE Reserved[512 - 4 - (MAX_NO_OF_WAN_PORTS * sizeof (PortScriptHdr))] ;  
} ScriptHeader ;

extern int ExpectingReplyPacket ;

#endif
