// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	STDLG.CPP
// Description       :	Defines Class :
//									CSTDlg		: Function of Spanning Tree Dialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "stdlg.h"
#include	"afxwin.h"


// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         
LPCSTR STMsgHeader = "MultiRouter Setup - Spanning Tree";
LPCSTR STSectionHeader = "Spanning Tree";

#define Max_STP_Ports 16

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSTDlg dialog

int Ports_Deleted = 0;

CSTDlg::CSTDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSTDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSTDlg)
	m_nPort = 0;
	m_Printf = FALSE;
	m_PrintfData = FALSE;
	m_ST = FALSE;
	m_P1Cost = "";
	m_P1State = "";
	m_P2Cost = "";
	m_P2State = "";
	m_P3Cost = "";
	m_P3State = "";
	m_P4Cost = "";
	m_P4State = "";
	m_bSTPAlgorithm = FALSE;
	m_bDOD2 = FALSE;
	m_bDOD3 = FALSE;
	m_bDOD4 = FALSE;
	m_Sel_In_List_Of_LWLs = -1;
	//}}AFX_DATA_INIT
}

void CSTDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSTDlg)
	DDX_Control(pDX, IDC_PRINTF_DATA, m_chkBoxPrintfData);
	DDX_Control(pDX, IDC_PRINTF, m_chkboxPrintf);
	DDX_Control(pDX, IDC_STATIC_PRNT_CTRL_GRP, m_PrintCtrlGrp);
	DDX_Control(pDX, IDC_STP_ALGO_ENA_DIS, m_chkboxSTPAlgorithm);
	DDX_Control(pDX, IDC_STATIC_GROUP4, m_Port4GroupControl);
	DDX_Control(pDX, IDC_STATIC_GROUP3, m_Port3GroupControl);
	DDX_Control(pDX, IDC_STATIC_GROUP2, m_Port2GroupControl);
	DDX_Control(pDX, IDC_STATIC_GROUP1, m_Port1GroupControl);
	DDX_Control(pDX, IDC_ST, m_STPEnableControl);
	DDX_Control(pDX, IDC_P3C, m_P4C);
	DDX_Control(pDX, IDC_P2C, m_P3C);
	DDX_Control(pDX, IDC_P1C, m_P2C);
	DDX_Control(pDX, IDC_P0C, m_P1C);
	DDX_Control(pDX, IDC_P3_COST, m_cP4Cost);
	DDX_Control(pDX, IDC_P2_COST, m_cP3Cost);
	DDX_Control(pDX, IDC_P1_COST, m_cP2Cost);
	DDX_Control(pDX, IDC_P0_COST, m_cP1Cost);
	DDX_Control(pDX, IDC_P3, m_P4);
	DDX_Control(pDX, IDC_P2, m_P3);
	DDX_Control(pDX, IDC_P1, m_P2);
	DDX_Control(pDX, IDC_P0, m_P1);
	DDX_Control(pDX, IDC_P3_STATE, m_cP4State);
	DDX_Control(pDX, IDC_P2_STATE, m_cP3State);
	DDX_Control(pDX, IDC_P1_STATE, m_cP2State);
	DDX_Control(pDX, IDC_P0_STATE, m_cP1State);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_DATA, m_PrintfData);
	DDX_Check(pDX, IDC_ST, m_ST);
	DDX_CBString(pDX, IDC_P0_COST, m_P1Cost);
	DDX_CBString(pDX, IDC_P0_STATE, m_P1State);
	DDX_CBString(pDX, IDC_P1_COST, m_P2Cost);
	DDX_CBString(pDX, IDC_P1_STATE, m_P2State);
	DDX_CBString(pDX, IDC_P2_COST, m_P3Cost);
	DDX_CBString(pDX, IDC_P2_STATE, m_P3State);
	DDX_CBString(pDX, IDC_P3_COST, m_P4Cost);
	DDX_CBString(pDX, IDC_P3_STATE, m_P4State);
	DDX_Check(pDX, IDC_STP_ALGO_ENA_DIS, m_bSTPAlgorithm);
	//}}AFX_DATA_MAP
	
	// Chidanand - 11 Apr 1997 - Frame Relay Changes
	DDX_Control(pDX, IDC_ST_DELETE_BUTTON, m_DeleteButton);
	DDX_Control(pDX, IDC_ST_ADD_BUTTON, m_AddButton);
	DDX_Control(pDX, IDC_ST_COST_COMBO, m_ST_Cost_Combo);
	DDX_Control(pDX, IDC_ST_COST_STATIC, m_ST_Cost_Static);
	DDX_Control(pDX, IDC_ST_STATE_COMBO, m_ST_State_Combo);
	DDX_Control(pDX, IDC_ST_STATE_STATIC, m_ST_State_Static);
	DDX_Control(pDX, IDC_ST_LIST_OF_LWLS, m_ST_List_Of_Logical_WANs);
	DDX_Control(pDX, IDC_ST_LIST_OF_LWL_STATIC, m_ST_List_Of_Logical_WANs_Static);  
	DDX_LBIndex(pDX, IDC_ST_LIST_OF_LWLS, m_Sel_In_List_Of_LWLs);
}

BEGIN_MESSAGE_MAP(CSTDlg, CDialog)
	//{{AFX_MSG_MAP(CSTDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_ST_DELETE_BUTTON, OnSTDeleteButton)
	ON_BN_CLICKED(IDC_ST_ADD_BUTTON, OnSTAddButton)
	ON_LBN_SELCHANGE(IDC_ST_LIST_OF_LWLS, OnSelChangeInListBox)
	ON_CBN_SELCHANGE(IDC_ST_STATE_COMBO, OnSTChange)
	ON_CBN_SELCHANGE(IDC_ST_COST_COMBO, OnSTChange)
	ON_BN_CLICKED(IDC_ST, OnSt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSTDlg message handlers

BOOL CSTDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
		
	char szBuf[15];
	char DODLHSString[] = "PPP Port0 Link Connection Dial On Demand" ;
	char DODRHSString[20] ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;
	CenterWindow();	

   AfxGetApp()->DoWaitCursor(0);
	Value_Modified = 0;

	// Get the values of all SP parameters from INI file.

#if 0
	for (int i = 0 ; i < 3 ; i++)
	{
		GetPrivateProfileString (PPPSectionHeader, (LPCSTR)DODLHSString, StrNull,
	                            DODRHSString, 20, IniInWinForm) ;
		if (!strcmp (DODRHSString, StrEnabled))
			break ;
		DODLHSString[8]++ ;
	}
	DODLHSString[8] = '0' ;
	if (i < 3)
		m_STPEnableControl.EnableWindow (FALSE) ;
#endif
	
   // Get the BOOL parameters.
	GetPrivateProfileString (STSectionHeader, (LPCSTR) "Spanning Tree",
					StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
							(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_ST = TRUE ;
	else
		m_ST = FALSE ;

	GetPrivateProfileString (STSectionHeader,
		(LPCSTR) "Spanning Tree Algorithm",	StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_bSTPAlgorithm = TRUE ;
	else 
		m_bSTPAlgorithm = FALSE ;
	m_chkboxSTPAlgorithm.EnableWindow (m_ST) ;

	GetPrivateProfileString (STSectionHeader, (LPCSTR) 
					"Spanning Tree Printf",	StrDisabled,
					(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_Printf = TRUE;
	else m_Printf = FALSE;

	GetPrivateProfileString(STSectionHeader, (LPCSTR) 
					"Spanning Tree Data Printf",StrDisabled,
					(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
	if(!strcmp(szBuf,StrEnabled))
		m_PrintfData = TRUE;
	else m_PrintfData = FALSE;
	

	extern LPCSTR  FrameRelaySectionHeader;
	GetPrivateProfileString (FrameRelaySectionHeader, "Frame Relay Port0", 
								StrDisabled, szBuf, sizeof (szBuf), IniInWinForm);
	UpdateData (FALSE);
	if ( !(strcmp(szBuf, StrEnabled)))
	{
		m_FR_Enable = 1;
		OnSt();
		InitializeFRRelatedParameters ();
		m_ST_List_Of_Logical_WANs.SetFocus ();
		m_ST_List_Of_Logical_WANs.SetCurSel (0);
		m_Sel_In_List_Of_LWLs = 0;
	}
	else
	{
		m_FR_Enable = 0;
		OnSt();
		GetPrivateProfileString(STSectionHeader, (LPCSTR) 
					"Spanning Tree Port1 State", StrDisabled,
					(LPSTR) szBuf ,sizeof(szBuf), (LPCSTR) IniInWinForm);
		m_P1State = szBuf;

		GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port1 Path Cost",	(LPCSTR) "100",
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
		m_P1Cost =  szBuf;
	
		GetPrivateProfileString (PPPSectionHeader, (LPCSTR)DODLHSString, StrNull,
	      	DODRHSString, 20, IniInWinForm) ;

		// Chidanand - 25 Mar 1997
		strcpy (DODLHSString, "PPP Port10 Link Connection Dial On Demand");
		if (strcmp (DODRHSString, StrEnabled))
		{
			GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port2 State", StrDisabled,
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
			m_P2State = szBuf;
		}
		else
		{
			m_P2State = StrDisabled;
			m_cP2State.EnableWindow (FALSE) ;
			m_P2.EnableWindow (FALSE) ;
			m_Port2GroupControl.EnableWindow (FALSE) ;
			m_cP2Cost.EnableWindow (FALSE) ;
			m_P2C.EnableWindow (FALSE) ;
			m_bDOD2 = TRUE ;
		}

		GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port2 Path Cost",	(LPCSTR) "1000",
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
		m_P2Cost = szBuf;


		GetPrivateProfileString (PPPSectionHeader, (LPCSTR)DODLHSString, StrNull,
	      	DODRHSString, 20, IniInWinForm) ;
	      
		// DODLHSString[8]++ ;
		// Chidanand - 25 Mar 1997
		strcpy (DODLHSString, "PPP Port20 Link Connection Dial On Demand");
	
		if (!m_FR_Enable && strcmp (DODRHSString, StrEnabled))
		{
			GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port3 State", StrDisabled,
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
			m_P3State = szBuf;
		}
		else
		{
			m_P3State = StrDisabled ;
			m_cP3State.EnableWindow (FALSE) ;
			m_P3.EnableWindow (FALSE) ;
			m_Port3GroupControl.EnableWindow (FALSE) ;
			m_cP3Cost.EnableWindow (FALSE) ;
			m_P3C.EnableWindow (FALSE) ;
			m_bDOD3 = TRUE ;
		}

		GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port3 Path Cost",	(LPCSTR) "1000",
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
		m_P3Cost = szBuf;

		GetPrivateProfileString (PPPSectionHeader, (LPCSTR)DODLHSString, StrNull,
	      	DODRHSString, 20, IniInWinForm) ;
		// DODLHSString[8]++ ;
		// Chidanand - 25 Mar 1997
	
		if (!m_FR_Enable && strcmp (DODRHSString, StrEnabled))
		{
			GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port4 State",StrDisabled,
						(LPSTR) szBuf ,sizeof(szBuf),	(LPCSTR) IniInWinForm);
			m_P4State = szBuf; 
		}
		else
		{
			m_P4State = StrDisabled ;
			m_cP4State.EnableWindow (FALSE) ;
			m_P4.EnableWindow (FALSE) ;
			m_Port4GroupControl.EnableWindow (FALSE) ;
			m_cP4Cost.EnableWindow (FALSE) ;
			m_P4C.EnableWindow (FALSE) ;
			m_bDOD4 = TRUE ;
		}

		GetPrivateProfileString(STSectionHeader, (LPCSTR) 
						"Spanning Tree Port4 Path Cost",(LPCSTR) "1000",
						(LPSTR) szBuf ,sizeof(szBuf),(LPCSTR) IniInWinForm);
		m_P4Cost = szBuf; 

/* chetan 9/7/97 */
/*		m_nPort = GetPrivateProfileInt(STSectionHeader,
						(LPCSTR) "Spanning Tree Number of Ports",4,
					(LPCSTR) IniInWinForm); */
		m_nPort = GetPrivateProfileInt ((LPCSTR) WANSectionHeader,
						(LPCSTR) "WAN Number of Ports", 3, (LPCSTR) IniInWinForm);
		m_nPort ++ ; /* LAN Port */
		if (m_nPort < 2 || m_nPort > 4)
			m_nPort = 4;
		
	// Chidanand - 25 Mar 1997		
		CMainDlg *pParent = (CMainDlg *) GetParent() ;
	
		if (m_nPort > 2 && pParent && ((CMainDlg *)pParent)->IsBackupEnabled())
			m_nPort = 3;
// Chidanand - 25 Mar 1997		
	}


	if (m_nPort != 4 || m_FR_Enable) {		// we need to show some port(s) less
		RECT	DlgRect;
		RECT	FirstInvisibleGroupRect;
		int	FirstInvisibleGroup;

		GetWindowRect(&DlgRect);
		if (m_FR_Enable)
			FirstInvisibleGroup = IDC_STATIC_GROUP3;
		else if (m_nPort == 3) {
			FirstInvisibleGroup = IDC_STATIC_GROUP4;
		} else if (m_nPort == 2) {
			FirstInvisibleGroup = IDC_STATIC_GROUP3;
		}
		(GetDlgItem(FirstInvisibleGroup))->GetWindowRect(&FirstInvisibleGroupRect);
		// we need some border also
		(GetDlgItem(FirstInvisibleGroup))->EnableWindow (FALSE) ;
		(GetDlgItem(FirstInvisibleGroup))->ShowWindow(SW_HIDE);
        
        if (m_FR_Enable || m_nPort < 3)
        {
			(GetDlgItem (IDC_P2_STATE))->EnableWindow (FALSE) ;
			(GetDlgItem (IDC_P2_STATE))->ShowWindow (SW_HIDE) ;
			(GetDlgItem (IDC_P2_COST))->EnableWindow (FALSE) ;
			(GetDlgItem (IDC_P2_COST))->ShowWindow (SW_HIDE) ;
		}
		if (m_FR_Enable || m_nPort < 4)
		{
			(GetDlgItem (IDC_P3_STATE))->EnableWindow (FALSE) ;
			(GetDlgItem (IDC_P3_STATE))->ShowWindow (SW_HIDE) ;
			(GetDlgItem (IDC_P3_COST))->EnableWindow (FALSE) ;
			(GetDlgItem (IDC_P3_COST))->ShowWindow (SW_HIDE) ;
		}


		DlgRect.bottom = FirstInvisibleGroupRect.top + 8;
		MoveWindow(&DlgRect, TRUE);
	}

	CenterWindow() ;	
	// Update the Dialog Box fields.
	UpdateData (FALSE) ;
	OnSt() ;

	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void CSTDlg::OnHelp()
{

	AfxGetApp()->WinHelp(0x20000 + IDD_ST_CONFIG,HELP_CONTEXT);
	
}

void CSTDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CSTDlg::ValidEditFields()
{
//Validate the integer edit fields
#if 0
	//the message boxes won't compile now !!!!

	if((m_nPort < 0) || (m_nPort > n_PORTMAX_ST))
	{
		RouMsgBox("Invalid Number of Ports", STMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_PortWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nFilteringEntries < Min_FilteringEntries) 
                  || (m_nFilteringEntries > Max_FilteringEntries))
	{
		RouMsgBox("Invalid Number of Filtering Entries", STMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_FilteringWnd.SetFocus();
      return(FALSE);
   }	
	if((m_nHashEntries < Min_HashEntries) 
                  || (m_nHashEntries > Max_HashEntries))
	{
		RouMsgBox("Invalid Number of Hash Table Entries", STMsgHeader,MB_OK | MB_ICONEXCLAMATION);
		m_HashEntryWnd.SetFocus();
      return(FALSE);
   }	
#endif

	if (!m_FR_Enable)	
	{
		// Added by cfp on 8-4-96
		if (NotInt (m_P1Cost))
		{
			RouMsgBox (MSG_INVALID_SPTREE_COST, STMsgHeader,
													MB_OK | MB_ICONEXCLAMATION) ;						
			m_cP1Cost.SetFocus() ;
			return FALSE ;
		}
		if (NotInt (m_P2Cost))
		{
			RouMsgBox (MSG_INVALID_SPTREE_COST, STMsgHeader,
													MB_OK | MB_ICONEXCLAMATION) ;						
			m_cP2Cost.SetFocus() ;
			return FALSE ;
		}
		if (m_nPort > 2)
		{
			if (NotInt (m_P3Cost))
			{
				RouMsgBox (MSG_INVALID_SPTREE_COST, STMsgHeader,
													MB_OK | MB_ICONEXCLAMATION) ;						
				m_cP3Cost.SetFocus() ;
				return FALSE ;
			}
			if (NotInt (m_P4Cost))
			{
				RouMsgBox (MSG_INVALID_SPTREE_COST, STMsgHeader,
													MB_OK | MB_ICONEXCLAMATION) ;						
				m_cP4Cost.SetFocus() ;
				return FALSE ;
			}
		}
	}
	else
	{
		if (m_ST_Cost_Combo.GetCurSel() == CB_ERR)
			return FALSE;
		if (m_ST_State_Combo.GetCurSel() == CB_ERR)
			return FALSE;
	}

   return(TRUE);
}

void CSTDlg::OnOK()
{
// Update the parameters from the Dialog Box.
	if(!UpdateData(TRUE))
      return;
	
//if the parameters are invalid return
   if(!ValidEditFields())
	   return;
	LPCSTR temp;
	char m_szTempBuf[12];
	temp = (char *)m_szTempBuf;

   // Write the SP parameters to the INI file.

   // Write the BOOL parameters
	if (m_ST)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString (STSectionHeader,
			(LPCSTR) "Spanning Tree", temp, (LPCSTR) IniInWinForm) ;

	if (m_bSTPAlgorithm)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
		
	WritePrivateProfileString (STSectionHeader,
			(LPCSTR) "Spanning Tree Algorithm", temp, (LPCSTR) IniInWinForm) ;

	if(m_Printf)
		temp = StrEnabled;
	else temp = StrDisabled;
		
	WritePrivateProfileString(STSectionHeader , (LPCSTR) 
					"Spanning Tree Printf",temp, (LPCSTR) IniInWinForm);

	if (m_PrintfData)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
		
	WritePrivateProfileString(STSectionHeader , (LPCSTR) 
					"Spanning Tree Data Printf",temp, 
					(LPCSTR) IniInWinForm);

	if (m_FR_Enable)
	{
	   AfxGetApp()->DoWaitCursor(0);
		char PortValue[5];
		itoa (No_Of_Ports, PortValue, 10);
		WritePrivateProfileString (STSectionHeader, "Spanning Tree Number of Ports",
											PortValue, IniInWinForm);
		if (Value_Modified)
			WriteToFile (m_Sel_In_List_Of_LWLs + 1, TempFileName);
		for (int j = 1; j <= No_Of_Ports; j++)
		{
			ReadFromFile (j, TempFileName);
			WriteToFile  (j, IniInWinForm);
		}
		int k = No_Of_Ports;
		while (Ports_Deleted > 0)
		{
		      k ++;
		      WriteToFile (k, IniInWinForm, 0);
		      Ports_Deleted --;
		}
		WritePrivateProfileString (STSectionHeader, NULL, NULL, TempFileName);
		CDialog::OnOK();
		return;
	}	

   // Write the CComboBox parameters
	WritePrivateProfileString ((LPCSTR) STSectionHeader,
			(LPCSTR) "Spanning Tree Port1 State", (LPCSTR) m_P1State, 
							(LPCSTR) IniInWinForm) ;

	WritePrivateProfileString(STSectionHeader , (LPCSTR) 
				"Spanning Tree Port1 Path Cost", (LPCSTR) m_P1Cost, 
				(LPCSTR) IniInWinForm);

	WritePrivateProfileString(STSectionHeader , (LPCSTR) 
				"Spanning Tree Port2 State", (LPCSTR) m_P2State, 
				(LPCSTR) IniInWinForm);
	if (m_P2State == "disabled")
		temp = StrDisabled ;
	else 
		temp = StrEnabled ;
// Chidanand -  5 May 1997
/*	if (!m_bSTPAlgorithm)
		temp = StrDisabled ; */
		
	/* check the master bridging enable also */
	if (!m_ST)
		temp = StrDisabled ;
		
// Chidanand - 25 Mar 1997		
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port0 STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port0 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port1 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
// Chidanand - 25 Mar 1997		


	WritePrivateProfileString(STSectionHeader , (LPCSTR) 
				"Spanning Tree Port2 Path Cost", (LPCSTR) m_P2Cost, 
				(LPCSTR) IniInWinForm);
 
	if (m_nPort > 2) 
	{
		WritePrivateProfileString(STSectionHeader , (LPCSTR) 
				"Spanning Tree Port3 State", (LPCSTR) m_P3State, 
				(LPCSTR) IniInWinForm);
		if (m_P3State == "disabled")
			temp = StrDisabled ;
		else 
			temp = StrEnabled ;
			
// Chidanand -  5 May 1997
/*	if (!m_bSTPAlgorithm)
		temp = StrDisabled ; */
		
	/* check the master bridging enable also */
	if (!m_ST)
		temp = StrDisabled ;
		
// Chidanand - 25 Mar 1997		
				
// Chidanand - 25 Mar 1997		
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port1 STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port10 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port11 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
// Chidanand - 25 Mar 1997		


		WritePrivateProfileString(STSectionHeader , (LPCSTR) 
				"Spanning Tree Port3 Path Cost", (LPCSTR) m_P3Cost, 
				(LPCSTR) IniInWinForm);
		if (m_nPort > 3) 
		{
			WritePrivateProfileString(STSectionHeader , (LPCSTR) 
						"Spanning Tree Port4 State", (LPCSTR) m_P4State, 
								(LPCSTR) IniInWinForm);
			if (m_P3State == "disabled")
				temp = StrDisabled ;
			else 
				temp = StrEnabled ;
// Chidanand -  5 May 1997
/*	if (!m_bSTPAlgorithm)
		temp = StrDisabled ; */
		
			/* check the master bridging enable also */
			if (!m_ST)
				temp = StrDisabled ;
// Chidanand - 25 Mar 1997		

// Chidanand - 25 Mar 1997		
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port2 STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port20 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) "PPP Port21 Link STP", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
// Chidanand - 25 Mar 1997		
				
			WritePrivateProfileString(STSectionHeader , (LPCSTR) 
					"Spanning Tree Port4 Path Cost", (LPCSTR) m_P4Cost, 
					(LPCSTR) IniInWinForm);
		}
	}
	
	CDialog::OnOK();
}

int	CSTDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

// Added by cfp on 8-4-96
BOOL CSTDlg::NotInt (CString &TempStr)
{
	if (TempStr.IsEmpty())
		return TRUE ;

	int len = TempStr.GetLength() ;
	if (len > 5)
		return TRUE ;  // assuming 32767

	for (int i = 0 ; i < len ; i ++)
	{
		char c = TempStr.GetAt (i) ;
		if  (! (c >= '0' && c <= '9'))
			return TRUE ;
	}
	return FALSE ;
}
		


void CSTDlg::OnSTDeleteButton()
{
	// TODO: Add your control notification handler code here
	if (No_Of_Ports <= 2)
	{
		AfxMessageBox (MSG_MIN_2_STP_PORTS, MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	AfxMessageBox (MSG_GEN_DELETING_PORTS_ALTER_DLCI, MB_OK | MB_ICONEXCLAMATION);
	int PortNumber = m_Sel_In_List_Of_LWLs + 1;
	while (PortNumber < No_Of_Ports)
	{
		ReadFromFile (PortNumber + 1, TempFileName);
		WriteToFile  (PortNumber, TempFileName);
		PortNumber ++;
	}
//	m_ST_List_Of_Logical_WANs.SetFocus ();
	m_ST_List_Of_Logical_WANs.SetCurSel (m_Sel_In_List_Of_LWLs);
	ReadFromFile (m_Sel_In_List_Of_LWLs + 1, TempFileName);
	No_Of_Ports -- ;
	if (m_Sel_In_List_Of_LWLs == No_Of_Ports)
	{
		ReadFromFile (m_Sel_In_List_Of_LWLs, TempFileName);
		m_Sel_In_List_Of_LWLs -= 1;
	}
	m_ST_List_Of_Logical_WANs.DeleteString (No_Of_Ports);
	Value_Modified = 0;
	Ports_Deleted ++;
	UpdateData (FALSE);
}

void CSTDlg::OnSTAddButton()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	if (Value_Modified)
		if (AfxMessageBox (MSG_GEN_DATA_CHANGED, MB_YESNO | MB_ICONQUESTION) == IDYES)
		 	WriteToFile (m_Sel_In_List_Of_LWLs + 1, TempFileName);
	Value_Modified = 0;

	if (No_Of_Ports >= Max_STP_Ports)
	{
		AfxMessageBox (MSG_MAX_STP_NO_EXCEEDED, MB_OK | MB_ICONEXCLAMATION);
		return;
	}
	m_Sel_In_List_Of_LWLs = No_Of_Ports;
	No_Of_Ports ++;
	char StringToAdd[10];
	wsprintf (StringToAdd, "WAN %d", No_Of_Ports);
	m_ST_List_Of_Logical_WANs.AddString (StringToAdd);
	m_ST_List_Of_Logical_WANs.SelectString (-1, StringToAdd);
	m_ST_Cost_Combo. SelectString (-1, "1000");
	m_ST_State_Combo. SelectString (-1, "forwarding");
	WriteToFile (No_Of_Ports, TempFileName);
	UpdateData (FALSE);
}

void CSTDlg::InitializeFRRelatedParameters()
{
	m_Port1GroupControl.ShowWindow (FALSE);
	m_Port2GroupControl.ShowWindow (FALSE);
	m_P1C.ShowWindow (FALSE);
	m_P2C.ShowWindow (FALSE);
	m_cP1Cost.ShowWindow (FALSE);
	m_cP2Cost.ShowWindow (FALSE);
	m_P1.ShowWindow (FALSE);
	m_P2.ShowWindow (FALSE);
	m_cP2State.ShowWindow (FALSE);
	m_cP1State.ShowWindow (FALSE);

	m_DeleteButton.ShowWindow (TRUE);
	m_AddButton.ShowWindow (TRUE);
	m_ST_Cost_Combo.ShowWindow (TRUE);
	m_ST_Cost_Static.ShowWindow (TRUE);
	m_ST_State_Combo.ShowWindow (TRUE);
	m_ST_State_Static.ShowWindow (TRUE);
	m_ST_List_Of_Logical_WANs.ShowWindow (TRUE);
	m_ST_List_Of_Logical_WANs_Static.ShowWindow (TRUE);

	// Chida - 28 Apr 1997
	m_Port1GroupControl.EnableWindow (FALSE);
	m_Port2GroupControl.EnableWindow (FALSE);
	m_P1C.EnableWindow (FALSE);
	m_P2C.EnableWindow (FALSE);
	m_cP1Cost.EnableWindow (FALSE);
	m_cP2Cost.EnableWindow (FALSE);
	m_P1.EnableWindow (FALSE);
	m_P2.EnableWindow (FALSE);
	m_cP2State.EnableWindow (FALSE);
	m_cP1State.EnableWindow (FALSE);

	m_DeleteButton.EnableWindow (TRUE);
	m_AddButton.EnableWindow (TRUE);
	m_ST_Cost_Combo.EnableWindow (TRUE);
	m_ST_Cost_Static.EnableWindow (TRUE);
	m_ST_State_Combo.EnableWindow (TRUE);
	m_ST_State_Static.EnableWindow (TRUE);
	m_ST_List_Of_Logical_WANs.EnableWindow (TRUE);
	m_ST_List_Of_Logical_WANs_Static.EnableWindow (TRUE);



	strcpy (TempFileName, LoadPath);
	strcat (TempFileName, "Muxcon.INI");

	No_Of_Ports = GetPrivateProfileInt (STSectionHeader, 
													"Spanning Tree Number of Ports", 
										 			2, IniInWinForm);
	int i = 1;
	char temp[10];
	while ( i <= No_Of_Ports)
	{
		ReadFromFile (i, IniInWinForm);
		WriteToFile  (i, TempFileName);
		wsprintf (temp, "WAN %d", i);
		m_ST_List_Of_Logical_WANs.AddString (temp);
		i ++;
	}
	ReadFromFile (1, TempFileName);
}

void CSTDlg::OnSelChangeInListBox()
{
	// TODO: Add your control notification handler code here
	if (Value_Modified)
		if (AfxMessageBox (MSG_GEN_DATA_CHANGED, MB_YESNO | MB_ICONQUESTION) == IDYES)
		{
			int BeforeUpdate = m_Sel_In_List_Of_LWLs;
			UpdateData (TRUE);
			WriteToFile (BeforeUpdate + 1, TempFileName);
		}
	UpdateData (TRUE);
	Value_Modified = 0;	
	ReadFromFile (m_Sel_In_List_Of_LWLs + 1, TempFileName);
	UpdateData (FALSE);
}

void CSTDlg::OnSTChange()
{
	// TODO: Add your control notification handler code here
	Value_Modified = 1;
}

void CSTDlg::ReadFromFile(int PortNo, char *FileName)
{
	char StoreString[50], temp[25];
	wsprintf (StoreString, "Spanning Tree Port%d Path Cost", PortNo);
	GetPrivateProfileString (STSectionHeader, StoreString, "1000",
									 temp, sizeof (temp), FileName);
	m_ST_Cost_Combo.SelectString (-1, temp);

	wsprintf (StoreString, "Spanning Tree Port%d State", PortNo);
	GetPrivateProfileString (STSectionHeader, StoreString, "Disabled",
									 temp, sizeof (temp), FileName);
	m_ST_State_Combo.SelectString (-1, temp);
}


void CSTDlg::OnSt()
{
	// TODO: Add your control notification handler code here
	if (!UpdateData (TRUE))
		return ;

	m_chkboxSTPAlgorithm.EnableWindow (m_ST) ;

	m_PrintCtrlGrp.EnableWindow (m_ST) ;
	m_chkboxPrintf.EnableWindow (m_ST) ;
	m_chkBoxPrintfData.EnableWindow (m_ST) ;
    
    if (m_FR_Enable)
	{
		m_DeleteButton.EnableWindow (m_ST);
		m_AddButton.EnableWindow (m_ST);

		m_ST_Cost_Combo.EnableWindow (m_ST);
		m_ST_Cost_Static.EnableWindow (m_ST);
		m_ST_State_Combo.EnableWindow (m_ST);
		m_ST_State_Static.EnableWindow (m_ST);
		m_ST_List_Of_Logical_WANs.EnableWindow (m_ST);
		m_ST_List_Of_Logical_WANs_Static.EnableWindow (m_ST);
	}
	else
    {
		m_Port1GroupControl.EnableWindow (m_ST) ;
		m_P1C.EnableWindow (m_ST) ;
		m_cP1Cost.EnableWindow (m_ST) ;
		m_P1.EnableWindow (m_ST) ;
		m_cP1State.EnableWindow (m_ST) ;

		m_Port2GroupControl.EnableWindow (m_ST && !m_bDOD2) ;
		m_P2C.EnableWindow (m_ST && !m_bDOD2) ;
		m_cP2Cost.EnableWindow (m_ST && !m_bDOD2) ;
		m_P2.EnableWindow (m_ST && !m_bDOD2) ;
		m_cP2State.EnableWindow (m_ST && !m_bDOD2) ;

		m_Port3GroupControl.EnableWindow (m_ST && !m_bDOD3) ;
		m_P3C.EnableWindow (m_ST && !m_bDOD3) ;
		m_cP3Cost.EnableWindow (m_ST && !m_bDOD3) ;
		m_P3.EnableWindow (m_ST && !m_bDOD3) ;
		m_cP3State.EnableWindow (m_ST && !m_bDOD3) ;

		m_Port4GroupControl.EnableWindow (m_ST && !m_bDOD4) ;
		m_P4C.EnableWindow (m_ST && !m_bDOD4) ;
		m_cP4Cost.EnableWindow (m_ST && !m_bDOD4) ;
		m_P4.EnableWindow (m_ST && !m_bDOD4) ;
		m_cP4State.EnableWindow (m_ST && !m_bDOD4) ;
    }
    
	if (!m_ST)
		m_bSTPAlgorithm = FALSE ;
	UpdateData (FALSE) ;
}

void CSTDlg::WriteToFile(int PortNo, char *FileName, int Flag)
{
/*
.	Flag : 0 - Delete the corresponding INI strings
		   <> 0 - Write the corresponding INI strings
*/
	char StoreString[50], temp[25];
	int Cur_Sel;
	Cur_Sel = m_ST_Cost_Combo.GetCurSel();
	m_ST_Cost_Combo.GetLBText (Cur_Sel, temp);
	wsprintf (StoreString, "Spanning Tree Port%d Path Cost", PortNo);
	if (!Flag)
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				       NULL, FileName);
	else
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				   temp, FileName);

	Cur_Sel = m_ST_State_Combo.GetCurSel();
	m_ST_State_Combo.GetLBText (Cur_Sel, temp);
	wsprintf (StoreString, "Spanning Tree Port%d State", PortNo);
	if (!Flag)
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				       NULL, FileName);
	else
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				   temp, FileName);

	
    if (PortNo > 1 && PortNo < 5)
    {
		/* check the master bridging enable also */
		// Chidanand -  5 May 1997
		/*	if (!m_bSTPAlgorithm) 
					strcpy (temp, StrDisabled) ; */
		/* If the state is other than "disabled" state, write enabled string */
		if (strcmp(temp, "disabled"))
			strcpy (temp, StrEnabled) ;
		
		/* check the master bridging enable also */
		if (!m_ST)
			strcpy (temp, StrDisabled) ;
		// Chidanand - 5 May 1997		
				
// Chidanand - 25 Mar 1997
		wsprintf (StoreString, "PPP Port%d Link STP", (PortNo - 2)*10);		
		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) StoreString, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

//Vidy 06/06/97 ...
//		wsprintf (StoreString, "PPP Port%d Link STP", (PortNo - 2)*10 + 1);		
//		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
//			(LPCSTR) StoreString, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
// ... Vidy 06/06/97
// Chidanand - 25 Mar 1997		
//Vidy 06/06/97 ...
		wsprintf (StoreString, "PPP Port%d STP", (PortNo - 2));		
		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) StoreString, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
// ... Vidy 06/06/97
	}
     
	wsprintf (StoreString, "Spanning Tree Port%d Maximum Frame Size", PortNo);
	if (!Flag)
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				       NULL, FileName);
	else
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				   "1534", FileName);

	wsprintf (StoreString, "Spanning Tree Port%d WAN", PortNo);
	if (!Flag)
	    WritePrivateProfileString (STSectionHeader, StoreString, 
				       NULL, FileName);
	else if (PortNo <= 1)
	    WritePrivateProfileString (STSectionHeader, StoreString, StrDisabled, FileName);
	else
	    WritePrivateProfileString (STSectionHeader, StoreString, StrEnabled, FileName);
}

 
