//	15/07/97 fixed the menu reorderings since wandevice 
//config thru telnet has to follow the telnet main screen

#include "stdafx.h"
#include "procon.h"

#include "terminal.h"
#include "telnet.h"
#include "tnetif.h"
#include "hardware.h"

extern LPCSTR MainMsgHeader ;
LPCSTR WANTalkMessageHeader = "WAN Port Configuration" ;

#define MAX_TELNET_BUFFER_SIZE 1024
char TelnetBuffer[MAX_TELNET_BUFFER_SIZE] ;

enum TELNET_CLIENT_STATE TelnetClientState ;
int WANPortNumber = -1 ;
unsigned int BytesRead = 0 ;
unsigned long TelnetTimerCount = 0 ;
char ServerIPAddress[20] ;
BOOL TelnetSocketRead = FALSE, TelnetPasswordSent = FALSE ;
HWND MainWindowHandle = NULL ;

#define	RESPONSE_TO_MAIN_MENU	4

BOOL CheckForSinglePortRouter(void);

/* After telnet connection The sequence is
	Main Menu Screen arrives
	for Wan device type 3 and enter
	if there is passord for the router password prompt arrives
		get password and send it
	Port list arrives
	Get port number and send it
*/

void TelnetClientStateMachine (void)
{
	int Dummy = -1 ;
	char *TempPointer, TempString[30], PortString[5] ;
	unsigned int Offset ;

	char CommandResponse[10];

	int ports;
	switch (model)
	{
	case MODEL_MTSR3_200:
	case MODEL_MTSR2_201:
					  ports = 3;
					  break;
	case MODEL_MTSR1_202ST:
	case MODEL_MTSR1_202NT:
					  ports = 1;
					  break;
	default:
					  ports = 3;
					  break;
	}

	switch (TelnetClientState)
	{
		case (TELNET_NOOP) :
			return ;

			//Telnet Socket opned successfully
			// Wait for main menu.
		case (TELNET_CONNECTED) :
			TermInitTerminal (MainWindowHandle, (LPSTR)LoadPath, (int FAR *)&Dummy, 4, ports) ;
			TermSetFocusTerminal () ;
			TelnetClientState = TELNET_WAIT_FOR_MAIN_MENU ;
			break ;

		case (TELNET_WAIT_FOR_MAIN_MENU) :
			if (TelnetSocketRead)
			{
				if (TelnetProcess (&TelnetBuffer[0], MAX_TELNET_BUFFER_SIZE, &BytesRead))
					break ;
//				TelnetSend ("3\r",  2) ;
				sprintf(CommandResponse, "%d\r", RESPONSE_TO_MAIN_MENU);
				TelnetSend(CommandResponse, strlen(CommandResponse));
				TelnetClientState = TELNET_TERMINAL_INITED ;
				TelnetSocketRead = FALSE ;
				BytesRead = 0 ;
			}
			break ;


		case (TELNET_TERMINAL_INITED) :
			if (!IsTerminalWindowInited ())
				break ;

			if (TelnetSocketRead)
			{
				if (TelnetProcess (&TelnetBuffer[0], MAX_TELNET_BUFFER_SIZE, &BytesRead))
					break ;
				TempPointer = strstr (TelnetBuffer, "Enter Password") ;
				if (TempPointer)
				{
					TelnetClientState = TELNET_READ_PASSWORD ;
					TelnetPasswordSent = FALSE ;
					strcpy (TempString, "\n\rEnter Password : ") ;
					TermEmulation (TempString, strlen (TempString)) ;
				}
				else
				{
					TelnetClientState = TELNET_WAN_PORT_MENU_RECEIVED ;
				}
				TelnetSocketRead = FALSE ;
				BytesRead = 0 ;
			}
			break ;

		 case (TELNET_READ_PASSWORD) :
		 	if ((!TelnetPasswordSent) || (!TelnetSocketRead))
				break ;
			if (TelnetProcess (&TelnetBuffer[0], MAX_TELNET_BUFFER_SIZE, &BytesRead))
 				break ;
			if (strstr (TelnetBuffer, "Closing Connection"))
			{
				TermCloseTerminal () ;
				TelnetClientState = TELNET_NOOP ;
				TelnetDeInit() ;
				PostQuitMessage(0) ;
				break ;
			}
			if (strstr (TelnetBuffer, "Invalid"))
			{
				TelnetPasswordSent = FALSE ;
				TermEmulation (TelnetBuffer, BytesRead) ;
			}
			else
			{
				TelnetClientState = TELNET_WAN_PORT_MENU_RECEIVED ;
			}
			TelnetSocketRead = FALSE ;
			BytesRead = 0 ;
			break ;


		case (TELNET_WAN_PORT_MENU_RECEIVED) :
			/* Dont reply until the terminal window is inited and
			   the port number is set */
			if (IsTerminalWindowInited())
			{
				if (CheckForSinglePortRouter())
					WANPortNumber = 1 ;
				else
					WANPortNumber = GetSelectedPort() ;
				if (WANPortNumber != -1)
				{
					char Buffer[20] ;
					sprintf (Buffer, "%d", WANPortNumber) ;
					strcat (Buffer, "\r") ;
					TelnetSend (Buffer, strlen (Buffer)) ;
					TelnetClientState = TELNET_WAN_PORT_MENU_ANSWERED ;
				}
			}
			break ;

		case (TELNET_WAN_PORT_MENU_ANSWERED) :
			// Stay here till the string "WAN Port in " comes along
			if (TelnetSocketRead)
			{
				if (TelnetProcess (&TelnetBuffer[0], MAX_TELNET_BUFFER_SIZE, &BytesRead))
					break ;

				strcpy (TempString, "WAN Port ") ;
				sprintf(PortString, "%d", WANPortNumber);
				strcat (TempString, PortString) ;
				strcat (TempString, " in") ;
				TempPointer = strstr (TelnetBuffer, TempString) ;
				if (TempPointer != NULL)
				{
					TermEmulation ("\n", 1) ;
					Offset = TempPointer - &TelnetBuffer[0] ;
					TermEmulation (TempPointer, (BytesRead - Offset)) ;
					TelnetClientState = TELNET_EXCHANGE_MODE ;
				} else {
					// WAN device configuration normally reboots at the
					// end of a session. But don't do if didn't get the port
					TermNeedToRebootAtClose(FALSE);
				}

				TelnetSocketRead = FALSE ;
				BytesRead = 0 ;
			}
			break ;

		case  (TELNET_EXCHANGE_MODE) :
			if (TelnetSocketRead)
			{
				if (TelnetProcess (&TelnetBuffer[0], MAX_TELNET_BUFFER_SIZE, &BytesRead))
					break ;
				TelnetSocketRead = FALSE ;
				TermEmulation (TelnetBuffer, BytesRead) ;
				BytesRead = 0 ;
			}
			break ;

		default :
			break ;
	}
}


void TelnetClientTimer (void)
{
	if (TelnetTimerCount)
		TelnetTimerCount-- ;

	TelnetClientStateMachine () ;
}


int InitializeTelnetClient (HWND WindowHandle)
{
	enum TELNET_CLIENT_INIT_RESULT TelnetInitResult ;

	GetPrivateProfileString ((LPCSTR)"Port Setup", (LPCSTR) "Router IP Address", (LPCSTR)"",
	                         (LPSTR)&ServerIPAddress[0], sizeof (ServerIPAddress), (LPCSTR)OwnIniFile) ;

	if (ServerIPAddress[0] == 0)
	{
		return (-1) ;
	}

	TelnetClientState = TELNET_NOOP ;
	WANPortNumber = -1 ;
	TelnetSocketRead = TelnetPasswordSent = FALSE ;
	BytesRead = 0 ;

	TelnetInitResult = TelnetInit (WindowHandle, ServerIPAddress) ;
	if (TelnetInitResult)
	{
		return (-1) ;
	}
	TelnetClientState = TELNET_CONNECTED ;

	MainWindowHandle = WindowHandle ;
	return (0) ;
}


void DeInitializeTelnetClient (void)
{
}


void TelnetWriteMsgReceived (WPARAM wParam, LPARAM lParam)
{
	char x[5] ;
	char PortSelectMessage[] = "\n\n\rTo Setup a WAN device, you must select \
the port \n\ron which it is connected (use 'WANTalk' Menu)\n\n\n\r" ;

	if (TelnetClientState == TELNET_READ_PASSWORD)
	{
		x[0] = *((char *)&wParam) ;
		TelnetSend (&x[0], 1) ;
		if (x[0] == '\r')
		{
			TermEmulation ("\n\r", 2) ;
			TelnetPasswordSent = TRUE ;
		}
		return ;
	}
	if (lParam == 0) /* Normal character */
	{
		x[0] = *((char *)&wParam) ;
		TelnetSend (&x[0], 1) ;
	}
	else
	{
		//x[0] = 0xFF ;
		x[0] = -1; //same as 0xff, but this avoids compiler warning
		x[1] = *((char *)&wParam) ;
		TelnetSend (&x[0], 2) ;

		/* Abort output */
		if ((unsigned char)x[1] == (unsigned char)0xF5)
		{
			if (CheckForSinglePortRouter())
				TermEmulation (PortSelectMessage, strlen (PortSelectMessage)) ;
			TelnetClientState = TELNET_MAIN_MENU_ANSWERED ;
		}
	}
}


void TelnetReadMsgReceived (void)
{
	TelnetSocketRead = TRUE ;
}
BOOL CheckForSinglePortRouter(void)
{
#define	NAME_SIZE	50
	BOOL	SinglePort = TRUE;

	char Buffer[NAME_SIZE];
#if 0
	GetPrivateProfileString("Port Setup", "Application Name",
			"", Buffer, NAME_SIZE, OwnIniFile);

	if ( !strcmpi(Buffer, "MultiRouter"))
		SinglePort = FALSE;

	if ( !strcmpi(Buffer, "ProxyServer"))
		SinglePort = FALSE;
#endif
	////Prabha, 15/4/98, to find out the no. of ports based on model
	switch (model)
	{
	case MODEL_MTSR3_200:
	case MODEL_MTSR2_201:
		SinglePort = FALSE;
		break;
	case MODEL_MTSR1_202ST:
	case MODEL_MTSR1_202NT:
		SinglePort = TRUE;
		break;
	default:
		SinglePort = FALSE;
		break;
	}		
	return SinglePort;
}

