/*----------------------------------------------------------------------------
*	File		:	config.c
*	Purpose		:	MEW profile init routines
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

#include	<windows.h>
#include	<fcntl.h>
#include	<commdlg.h>
#include	"sys\types.h"
#include	"sys\stat.h"

#include	"main.h"
#include	"mew.h"
#include	"session.h"
#include	"config.h"
#include	"emlntype.h"
#include	"emlncons.h"
#include	"emlndata.h"
#include	"emlnfuns.h"
#include	"wstdio.h"
#include	"fnkey.h"
#include	"status.h"
#include	"file.h"
#include	"scroll.h"
#include	"time.h"
#include	"term.h"
#include	"clrsetup.h"
#include	"kbd.h"
#include	"fonts.h"

BYTE	*OnStr = "ON";
BYTE	*OffStr = "OFF";
BYTE	LocalINI[128];

/***************************************************************************
 *	Routine	:	InitDefaults (void)
 *	Input	:	None
 *	Return	:	None
 *	Synopsis :	This init uses the #define values to init the various
 *				session params. It is useful when there are no .cfg files
 *				at all or an error in the cfg files.
 ***************************************************************************/
void InitDefaultConfig (void)
{
	/* Set all PbkEntry fields to Defaults */
	SetDefSessionInfo() ;
}

/***************************************************************************
Synop	:	This routine will check if the mew default cfg file is updated
			for this system after the installation is over.
****************************************************************************/
void ReadPbkEntrySetup (void)
{
	InitDefaultConfig() ;
}

/****************************************************************************/
/*++++++++++++++++++ System Parameters Stored in WIN.INI file ++++++++++++++*/
/****************************************************************************/

extern	BYTE	*OnStr;
extern	BYTE	*OffStr;
extern	RECT	MainDim;
extern	BOOL	TruncRecvFile;
extern	int		sscanf(char *, char *, ...);

#define	MAX_SYSTEM_DEFAULTS	(sizeof(SystemParams) / sizeof (char *))

char	*MEWParamsSec = "MTRouter Console";
char	*SystemParams[] = {

/* The following are related to system looks */
	"ConsoleWindow",		 	/* 0 */
	"TopStatusWindow",	 	/* 1 */
	"BottomStatusWindow",	/* 2 */
	"ToolBarWindow",			/* 3 */
	"TerminalFont",			/* 4 */
	"ColorSetup",				/* 5 */

/* The following are system defaults */
	"ScrollBufSize",	 		/* 6 */
};

char	*DefSysParams[] = {		// defaults for system parameters
	"0 0 796 377",				// "0 0 0 0",
	"ON",
	"ON",
	"ON",
	"System -12 0 400",
	"7 0 15 7 7 0 7",
	"8192",
};

/****************************************************************************
 * Name		: ReadSystemInfo (void)
 * Synopsis : Reads the system paramaters stored in WIN.INI under the
 *			  section head MEW.
 ***************************************************************************/
char RetStr[128] ;
int	ConInt ;

BOOL ReadSystemInfo (void)
{
	int	i ;

	strcpy (LocalINI, LoadPath) ;
	strcat (LocalINI, "SETUP.INI") ;

	for (i = 0 ; i < MAX_SYSTEM_DEFAULTS ; i ++)
	{
		if (GetPrivateProfileString (MEWParamsSec, SystemParams[i],
				   (LPSTR) DefSysParams[i], (LPSTR) RetStr, 128, LocalINI))
		{
			AnalyseIniStr (i, &RetStr[0]) ;
		}
	}
	return TRUE ;
}


int myatoid (LPSTR ptr)
{
	int	Num = 0 ;

	while (*ptr)
	{
		if (*ptr >= '0' && *ptr <= '9') 
		{
			Num *= 10 ;
			Num += *ptr++ - '0' ;
		}
		else 
			return 0 ;
	}
	return Num ;
}

/****************************************************************************
 * Name		: AnalyseIniStr (int, char *)
 * Synopsis : Analyses the INI string read from the WIN.INI file.
 ***************************************************************************/
void AnalyseIniStr (int index, char *Val)
{
//	static int		int1, int2, int3, int4, int5, int6, int7;
	char *ptr ;

	if (! *Val)
	{
		if (index == 0)
			MainDim.right = 0 ;
		if (index == 6)
			SetScrollBuffSize (DEF_SCROLL_BUF_SIZE) ;
		return ;
	}

	switch (index)
	{
		case 0 :				/* MEW main window position & size */
//			sscanf (Val, "%d %d %d %d", 
//					&MainDim.left, &MainDim.top, &MainDim.right, &MainDim.bottom);

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			MainDim.left = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			MainDim.top = myatoid (Val) ;
			Val = ptr ; 

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			MainDim.right = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			MainDim.bottom = myatoid (Val) ;
			break ;

		case 1 :				/* top status window */
			ShowTimeWnd = (lstrcmp (Val, OnStr) ? FALSE : TRUE) ;
			break ;

		case 2 :				/* bottom status window */
			ShowStatusWnd = (lstrcmp (Val, OnStr) ? FALSE : TRUE) ;
			break ;

		case 3 :				/* Tool bar window */
			ShowTbarWnd = (lstrcmp (Val, OnStr) ? FALSE : TRUE) ;
			break ;

		case 4 :				/* terminal font name & geometry */

			// Since Font face name could be having enbedded spaces
			// we can't use sscanf directly
			ptr = Val ;
			for (ptr = Val ; IsCharAlpha (*ptr) ; ptr = AnsiNext (ptr)) ;
			if (ptr <= Val)
				break ;	// no chars present or invalid format str;
			*ptr++ = NULL ;
			lstrcpy (TerminalLogFont.lfFaceName, Val) ;	// copy font name
			Val = ptr ;			// advance Val to point to font dimensions

//			sscanf (Val, "%d %d %d",
//				&TerminalLogFont.lfHeight,
//				&TerminalLogFont.lfWidth, &TerminalLogFont.lfWeight);

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			TerminalLogFont.lfHeight = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			TerminalLogFont.lfWidth = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			TerminalLogFont.lfWeight = myatoid (Val) ;
			Val = ptr ;
			break ;

		case 5 :				/* Color setup */
#if 0
			sscanf (Val, "%d %d %d %d %d %d %d",
				&int1, &int2, &int3, &int4,
				&int5, &int6, &int7);

			ColorSetup.TermFg = (BYTE)int1;	ColorSetup.TermBg = (BYTE)int2;
			ColorSetup.TermWin = (BYTE)int3; ColorSetup.Tbar = (BYTE)int4;
			ColorSetup.KeyBg = (BYTE)int5; ColorSetup.KeyFg = (BYTE)int6;
			ColorSetup.StatBg = (BYTE)int7;
#endif
			ptr = Val ; 
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.TermFg = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ; 
			if (*ptr)
				*ptr++ = NULL ; 
			ColorSetup.TermBg = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.TermWin = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.Tbar = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.KeyBg = myatoid (Val);
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.KeyFg = myatoid (Val) ;
			Val = ptr ;

			ptr = Val ;
			while (*ptr && *ptr != ' ')
				ptr ++ ;
			if (*ptr)
				*ptr++ = NULL ;
			ColorSetup.StatBg = myatoid (Val) ;
			Val = ptr ;

			CheckColorVals() ;
			break ;

		case 6 :
			SetScrollBuffSize (myatoid (Val)) ;
			break ;
	}
}

/****************************************************************************
 * Name		: MakeIniStr (int, char *)
 * Synopsis : Makes the INI string to store it in the WIN.INI file.
 ***************************************************************************/
void
MakeIniStr (int index, char *Val)
{
	RECT	rct;

	switch (index) {

		case 0:				/* MEW main window position & size */
			GetWindowRect (hMainWnd, (LPRECT)&rct);
			sprintf (Val, "%d %d %d %d",
				rct.left, rct.top, (rct.right-rct.left), (rct.bottom-rct.top));
			break;

		case 1:				/* top status window */
			if (ShowTimeWnd)
				lstrcpy (Val, OnStr);
			else
				lstrcpy (Val, OffStr);
			break;

		case 2:				/* bottom status window */
			if (ShowStatusWnd)
				lstrcpy (Val, OnStr);
			else
				lstrcpy (Val, OffStr);
			break;

		case 3:				/* tool bar window */
			if (ShowTbarWnd)
				lstrcpy (Val, OnStr);
			else
				lstrcpy (Val, OffStr);
			break;

		case 4:				/* terminal font info */
			sprintf (Val, "%s %d %d %d", 
			TerminalLogFont.lfFaceName, TerminalLogFont.lfHeight,
			TerminalLogFont.lfWidth, TerminalLogFont.lfWeight);
			break;

		case 5:				/* Color setup */
			sprintf (Val, "%d %d %d %d %d %d %d",
				ColorSetup.TermFg, ColorSetup.TermBg, ColorSetup.TermWin,
				ColorSetup.Tbar, ColorSetup.KeyBg, ColorSetup.KeyFg,
				ColorSetup.StatBg);
			break;

		case 6:			/* System startup script */
			// itoa (ScrollBuffSize, Val, 10);
			wsprintf(Val,"%u",ScrollBuffSize);
			break;
		default :
			*Val = NULL;
			break;
	}
}

/****************************************************************************
 * Name		: SaveSystemInfo (void)
 * Synopsis : Saves the MEW system params in WIN.INI.
 ***************************************************************************/
char	RetStr[128];

BOOL
SaveSystemInfo (void)
{
	int		i;

	for (i=0; i < MAX_SYSTEM_DEFAULTS; i++) {
		MakeIniStr (i, RetStr);
		WritePrivateProfileString (MEWParamsSec, SystemParams[i],
			(LPSTR)RetStr, LocalINI);
	}
	return (TRUE);
}


BOOL
SaveSystemDefaults (void)
{

	MakeIniStr (7, RetStr);
	WritePrivateProfileString (MEWParamsSec, SystemParams[7],
		(LPSTR)RetStr, LocalINI);
	return TRUE;
}



BOOL
SaveSystemLook (void)
{
	int	index;

	/* first seven are system looks related stuff, 7 to 12 are sysdefs */
	for (index = 0; index < 7; index++) {
		MakeIniStr (index, RetStr);
		WritePrivateProfileString (MEWParamsSec, SystemParams[index],
			(LPSTR)RetStr, LocalINI);
	}
	return TRUE;

}

/*****************************   Last  Line   *******************************/
