/****************************************************************************
*	File	:	Config.h
*	Synop	:	Configuration related routines and data.
*****************************************************************************/

/* masks for noting changes in the CfgChanged variable */
#define	CFG_MSK_OTHERS		0x01		/* any change which is irreversible */
#define	CFG_MSK_DUPLEX		0x02		/* a change which can toggle */
#define	CFG_MSK_80_132		0x04
#define	CFG_MSK_FNKEYS		0x08
#define	CFG_MSK_TIME		0x10
#define	CFG_MSK_STATUS		0x20

typedef struct	tagCfgHeader {
	BYTE	CfgName[20];
	BYTE	DefaultsSet;
	BYTE	Reserved[4];
} CfgHeaderType;


	/* prototypes for the configuration section */
extern	void	InitDefaultConfig(void);
extern	void	ReadPbkEntrySetup(void);

	/* system defaults and looks section */
extern	BOOL	ReadSystemInfo (void);
extern	void	AnalyseIniStr (int index, char *Val);
extern	void	MakeIniStr (int index, char *Val);
extern	BOOL	SaveSystemInfo (void);
extern	BOOL	SaveSystemDefaults (void);
extern	BOOL	SaveSystemMdmInfo(void);
extern	BOOL	SaveSystemLook (void);
