/* ------------------------------------------------------------------------
	File		:	DLGBOX.C
	Program		:	DLGBOX.DLL
	Synopsis	:	Modifies the dialog control colors and draws borders
					for Listbox, Edit controls and group box.  This DLL
					is proposed to be used with all MultiExpress Windows
					applications for a common interface.
	Author		:	Srinivasan S
	Date		:	4 March 1994
 ----------------------------------------------------------------------- */

#include <windows.h>
#include <memory.h>

#include	<commdlg.h>
#include	"main.h"
#include "dlgbox.h"

/* ********************************************************************** */
/* *** Internal Structures to support Ownerdraw Radio and Check boxes *** */
/* ********************************************************************** */

typedef	struct {
	WORD	ID;								// Control id.
	BYTE	State;							// Button state.
} CONTROLINFO;

typedef	CONTROLINFO	*PCTLINFO;

typedef	struct tagDIALOGINFO {
	HWND			hDlg;					// Dialog handle.
	int				NumCtls;				// Number of owner draw controls.
	struct 			tagDIALOGINFO far *next;// Next dialog info.
	CONTROLINFO		CtlArray[1];			// Space for 1 control.
} DIALOGINFO;

typedef	DIALOGINFO	FAR *LPDLGINFO;

/* ************************* Internal Globals *************************** */

HINSTANCE	hDLGInst;						// Global instance of owner.
int			NumCalls;

HBRUSH		hBkGndBrush;					// Handle of background brush.
HPEN		hBorderPen;						// Handle of border pen.
LPDLGINFO	lpHead;							// The first node in the list.

RECT		DlgRect = {0, 0, 0, 0};			// The coordinates of the dialog.
HWND		hDlgWnd = NULL;					// The handle of the dialog.

/* -------------------------------------------------------------------------
	Function	:	DLGCenterDialog()
	Synopsis	:	Centers the dialog on screen.
	Input		:	Dialog box handle.
	Output		:	None.
 ------------------------------------------------------------------------ */
void FAR PASCAL
DLGCenterDialog(HWND hDlg)
{
	int		Left, Top, Height, Width;
	int		ScrnHeight, ScrnWidth;
	RECT	rcDlgOld;

	GetWindowRect(hDlg, (LPRECT) &rcDlgOld);

	Width = rcDlgOld.right - rcDlgOld.left;
	Height = rcDlgOld.bottom - rcDlgOld.top;

	ScrnWidth = GetSystemMetrics(SM_CXSCREEN);
	ScrnHeight = GetSystemMetrics(SM_CYSCREEN);

	Left = ((ScrnWidth - Width) / 2);
	Top = ((ScrnHeight - Height) / 2);

	MoveWindow(hDlg, Left, Top, Width, Height, TRUE);
}

/* -------------------------------------------------------------------------
	Function	:	DLGCtlColorFunc()
	Synopsis	:	Callback function for the hook for common dialog box.
	Input		:	Window, message, wParam, lParam.
	Output		:	Depends on the message processed.
 ------------------------------------------------------------------------ */
UINT CALLBACK
DLGCtlColorFunc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
		case WM_INITDIALOG:		/* !!! Don't change focus !!! */
			DLGCenterDialog(hWnd);
			return (TRUE);

		default:				/* Let the CommDlgProc process */
			return (NULL);
	}
}
/* -------------------------------------------------------------------------
	Function	:	DLGShowFileOpenDlgBox(OPENFILENAME Ofn)
	Synopsis	:	Displays the File open common dialog box after installing
					a hook procedure to modify the colors.
	Input		:	Pointer to OPENFILENAME structure.
	Output		:	TRUE on success, FALSE otherwise.  If the function is
					successful then the OPENFILENAME structure has the
					file chosen.
 ------------------------------------------------------------------------ */
BOOL FAR PASCAL
DLGShowFileOpenDlgBox(LPOPENFILENAME lpOfn)
{
	BOOL	RetVal;

	/* Install a hook procedure */
	lpOfn->Flags |= OFN_ENABLEHOOK;
	lpOfn->lpfnHook = DLGCtlColorFunc;

	/* Invoke the dialog box */
	RetVal = GetOpenFileName(lpOfn);

	return (RetVal);
}

/* -------------------------------------------------------------------------
	Function	:	DLGShowSaveAsDlgBox(LPOPENFILENAME lpOfn)
	Synopsis	:	Displays the Save as common dialog box after installing
					a hook procedure to modify the colors.
	Input		:	Pointer to OPENFILENAME structure.
	Output		:	TRUE on success, FALSE otherwise.  If the function is
					successful then the OPENFILENAME structure has the
					file chosen.
 ------------------------------------------------------------------------ */
BOOL FAR PASCAL
DLGShowSaveAsDlgBox(LPOPENFILENAME lpOfn)
{
	BOOL	RetVal;

	/* Install a hook procedure */
	lpOfn->Flags |= OFN_ENABLEHOOK;
	lpOfn->lpfnHook = DLGCtlColorFunc;

	/* Invoke the dialog box */
	RetVal = GetSaveFileName(lpOfn);

	return (RetVal);
}

/* -------------------------------------------------------------------------
	Function	:	DLGShowPrintDlgBox(LPPRINTDLG lpPd)
	Synopsis	:	Displays the Print common dialog box.
	Input		:	Pointer to PRINTDLG structure.
	Output		:	TRUE on success, FALSE otherwise.  On success the
					chosen printer details are available in the
					PRINTDLG structure.
 ------------------------------------------------------------------------ */
BOOL FAR PASCAL
DLGShowPrintDlgBox(LPPRINTDLG lpPd)
{
	BOOL	RetVal;
	FARPROC	HookFuncProc;
	
	/* Install a hook procedure */
	lpPd->Flags |= (PD_ENABLEPRINTHOOK|PD_ENABLESETUPHOOK);
	HookFuncProc = MakeProcInstance( DLGCtlColorFunc, hInst);
	lpPd->lpfnPrintHook = HookFuncProc;
	lpPd->lpfnSetupHook = lpPd->lpfnPrintHook;


	/* Invoke the dialog box */
	RetVal = PrintDlg(lpPd);
	FreeProcInstance(HookFuncProc);

	return(RetVal);
}

/* -------------------------------------------------------------------------
	Function	:	DLGShowFontDlgBox(LPCHOOSEFONT lpCf)
	Synopsis	:	Displays the Font common dialog box.
	Input		:	Pointer to CHOOSEFONT structure.
	Output		:	TRUE on success, FALSE otherwise.  On success the
					chosen printer details are available in the
					LOGFONT item in the CHOOSEFONT structure.
 ------------------------------------------------------------------------ */
BOOL FAR PASCAL
DLGShowFontDlgBox(LPCHOOSEFONT lpCf)
{
	BOOL	RetVal;
	FARPROC	HookFuncProc;
	
	/* Install a hook procedure */
	lpCf->Flags |= CF_ENABLEHOOK;

	HookFuncProc = MakeProcInstance( DLGCtlColorFunc, hInst);
	lpCf->lpfnHook = HookFuncProc;

	/* Invoke the dialog box */
	RetVal = ChooseFont(lpCf);
	FreeProcInstance(HookFuncProc);

	return(RetVal);
}

/* -------------------------  End of File  -------------------------- */

