/*----------------------------------------------------------------------------
*	File		:	EMLNCONS.H
*	Purpose		:	defines the emulation constants
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

#define	MAX_NO_OF_TERMINALS	25			/*	Max no. of terminals supported.	*/
#define	TERM_NAME_LEN		9			/*	Max length of a terminal name.	*/
#define	PATH_NAME_LEN		68			/*	Path length.					*/
#define	FILE_NAME_LEN		13			/*	File name length.				*/
#define	MAX_STATES			100			/*	Max no. of states in terminal	*/
										/*	emulation transition table.		*/

#define	EMULATION_BUF_LEN	100			/*	Emulation buffer size.			*/
#define	MAX_EMLN_ARGS		10			/*	Max no. of emulation args.		*/

enum {									/*	Terminal types supported.		*/
	TERM_MC = 0,
	TERM_ASCII,
	TERM_ANSI,
	TERM_VT100,

	TERM_LAST_IDX						/*	Index for the last terminal,	*/
										/*	used as size of ExpansionList.	*/
} term_type;

#define	NO_OF_ESC_SEQS		7			/*	Number of esc seq for a term.	*/

#define	MAX_ESC_SEQ_LEN	30			/*	Max length of esc sequence.		*/

#define	MAX_EXPANSION_KEYS	100	/*	Max no. of keys expandable.		*/

#define	DEFAULT_TAB_STOP	8			/*	Default tab width.				*/

#define	SPACE_ASCII			0x20
#define	BKSPACE_ASCII		0x08
#define	CR_ASCII				0x0d		/*	Ascii for ENTER key.			*/
#define	LF_ASCII				0x0a		/*	Ascii for line feed.			*/
#define	ESCAPE_ASCII		0x1b		/*	Ascii for ESCAPE key.			*/
#define	BELL_ASCII			0x07		/* Ascii for BELL char */
#define	TAB_ASCII			0x09		/* Ascii for TAB */

#define	INVALID_KEY			0xff		/*	Key value specified for menus	*/
												/*	invoked from forms.				*/
#define	LINE_CURSOR			0x0b0c	/*	Top and bottom row of cursor.	*/

#define	KEY_NOT_PRESENT	0xffff	/*	Value returned by KbdRdy when	*/
												/*	there is no key.				*/

#define	MIN_TAB_WIDTH		2			/*	Minimum tab width.				*/
#define	MAX_TAB_WIDTH		9			/*	Maximum tab width.				*/

#define	DATA_BITS_MASK		0x03		/*	Mask to get no. of data bits.	*/
#define	MIN_DATA_BITS		5			/*	Minimum number of data bits.	*/
#define	MAX_DATA_BITS		8			/*	Maximum number of data bits.	*/

#define	STOP_BIT_MASK		0x04		/*	mask to get no. of stop bits.	*/
#define	ONE_STOP_BIT		1			/*	One stop bit.					*/
#define	TWO_STOP_BITS		2			/*	Two stop bits.					*/

#if 0
#define	OPENDUMP
#endif

#define	TERM_COLOR_BG		1
#define	TERM_COLOR_FG		2
