/*--------------------------------------------------------------------------*/
/*	File		:	EMLNDATA.H												*/
/*	Purpose		:	This file contains data structure definitions for		*/
/*						terminal emulation.									*/
/*	Package		:	MultiConnect Ver 1.00.									*/
/*	Authors		:	Kumar Prabhas & S. Narasimhan.							*/
/*	Date		:	November 25, 1990.										*/
/*--------------------------------------------------------------------------*/


extern	BYTE	*TermFileExtn;
extern	BYTE	*TmpTermFileExtn;
extern	BYTE	TerminalName[TERM_NAME_LEN];
extern	BYTE	DefTerminalName[TERM_NAME_LEN];
extern	BYTE	Terminals[MAX_NO_OF_TERMINALS][TERM_NAME_LEN];
extern	BYTE	NoOfTerminals;
extern	int	NoOfFunctions;
extern	BYTE	ScrollTopMargin;		// for Set scroll region command
extern	BYTE	ScrollBottomMargin;		// for Set Scroll region command

extern	WORD	CursorType;
extern	TermParamsType	TermParams;			/*	Params of session terminal	*/

extern	BYTE	BackSpaceChar;				/*	Back space character.		*/
extern	BYTE	*TermCfgFile;
extern	BYTE	Attribute;
extern	BYTE	EmlnAttribute;					/*	Attribute for the character to	*/
extern	BYTE	GraphicsAdd;
extern	BYTE	SuppressEcho;

extern	WORD	EmlnArgs[MAX_EMLN_ARGS];
extern	BYTE	EmlnArgCnt;
extern	WORD	EmlnCursorPosition;
extern	WORD	EmlnCursorType;
extern	BYTE	EmlnVT100originMode;			/*	Sets row for home position; 0	*/
										/*	for top left corner, else 1.	*/
extern	BYTE	EmlnVT100insertMode;			/*	Set if in insert mode.			*/
extern	BYTE	EmlnVT100charSet;				/*	To save character set.			*/
extern	BYTE	*EmlnVT100_G0charSet;			/*	To save G0 character set.		*/
extern	BYTE	*EmlnVT100_G1charSet;			/*	To save G1 character set.		*/

extern	WORD	CurrentState;
extern	WORD	NoOfStates;
extern	StateType	*StateTable;
extern	BYTE	RecdChar;

extern	KeyExpansionType	*KeyExpansion;

extern	void	(*EmulnFnTable[])();
extern	BYTE	VT100charSet;
extern	BYTE	*VT100_G0charSet;
extern	BYTE	*VT100_G1charSet;
extern	BYTE	VT100_UScharSet[];
extern	BYTE	VT100_UKcharSet[];
extern	BYTE	VT100_SpecialCharSet[];


