/*----------------------------------------------------------------------------
*	File		:	EMLNFUNS.H
*	Purpose		:	prototype declaration od emulation functions
*	Package		:	MultiExpress (Windows) - Version 1.00
*	Authors		:	Vidy
*	Date		:	21st December 1991.
*---------------------------------------------------------------------------*/

/*	functions defined in EMULN.C	*/
extern	BOOL	CurTerminal (BYTE *name);
extern	BOOL	ChangeEmulationType (BYTE *newtype);
extern	BYTE	InitEmulation(void);
extern	BYTE	ReadTermInfo(BYTE *term_name);
extern	void	PurgeTermInfo(void);
extern	BYTE	ReadTermCfgFile(void);
extern	BYTE	SaveTermCfgFile(void);
extern	void	SetTermDefaultCfg(void);
extern	int		PumpStream(void);

/*	functions defined in EMLNRTNS.C	*/

extern	void	EmlnScrollWinUp(BYTE nlines, BYTE Startline, BYTE Endline);
extern	void	Emulation(BYTE FAR *buf, WORD cnt);
extern	void	ResetArgs(void);
extern	void	EchoChar(void);
extern	void	CursorUp(void);
extern	void	CursorDown(void);
extern	void	CursorLeft(void);
extern	void	CursorRight(void);
extern	void	DelToBeginningOfLine(void);
extern	void	DelToEndOfLine(void);
extern	void	ClearScreen(void);
extern	void	EmlnClearScreen(void);
extern	void	EmlnSetCursor(void);
extern	void	ComputeArg(void);
extern	void	AdvanceArg(void);
extern	void	ClearFromCursor(void);
extern	void	BeginReverseVideo(void);
extern	void	EndReverseVideo(void);
extern	void	ShowHexValue(void);
extern	void	EraseChar(void);
extern	void	DisplayCharacter(void);
extern	void	AdvanceCursor(void);
extern	void	EraseInLine(void);
extern	void	BeginHighlight(void);
extern	void	EndHighlight(void);
extern	void	BeginBlink(void);
extern	void	EndBlink(void);
extern	void	SetToNormalAttribute(void);
extern	void	SetDispNormAtt(void);
extern	void	ClearUptoCursor(void);
extern	void	SetANSIcolors(void);
extern	void	SaveCursorPosition(void);
extern	void	RestoreCursorPosition(void);
extern	void	SaveCursorType(void);
extern	void	RestoreCursorType(void);
extern	void	RefreshScreen(void);
extern	void	MoveToNextLine(void);
extern	void	PrintScreen(void);
extern	void	ComputeOffsetArg(void);
extern	void	SetTermBgFg(BYTE flag, BYTE color_indx);

extern	void	TurnOnPrintRedirection (void);
extern	void	TurnOffPrintRedirection (void);
extern	void	TurnOnNumlock (void);
extern	void	TurnOffNumlock (void);
extern	void	InsertLine (void);
extern	void	EmlnScrollUp (void);
extern	void	TurnOnGraphics (void);
extern	void	TurnOffGraphics (void);
extern	void	InsertChar (void);
extern	void	ANSIdeviceStatReq(void);
extern	void	VT100terminalStatReq(void);
extern	void	VT100deviceQuery(void);
extern	void	VT100printerStatReq(void);
extern	void	MoveToPrevLine(void);
extern	void	VT100printControl(void);
extern	void	SetVT100termParams(void);
extern	void	ResetVT100termParams(void);
extern	void	SetVT100LocalEcho(void);
extern	void	ResetVT100LocalEcho(void);
extern	void	SetVT100CharSet_0(void);
extern	void	SetVT100CharSet_1(void);
extern	void	SelectVT100CharSet_0(void);
extern	void	SelectVT100CharSet_1(void);
extern	void	VT100EchoChar(void);
extern	void	VT100cancelSeq(void);
extern	void	DeleteLine(void);
extern	void	SetVT100scrollRegion(void);

/*	misc functions defined  */

extern	void	DispChar(BYTE ch, BYTE attrib, WORD cnt);
extern	void	DispStr(BYTE *str, BYTE attrib);
extern	WORD	GetCursorPosition(void);
extern	void	SetCursorPosition(WORD position);
extern	WORD	GetCursorType(void);
extern	void	SetCursorType(WORD cursor_type);
extern	void	ClearScreen(void);
extern	WORD	KbdRdy(void);
extern	WORD	KbdRead(void);
extern	WORD	KbdReadNoWait(void);
extern	void	PutStr(BYTE *str);
extern	int	GetString(BYTE *str, WORD max_len);
extern	void	WriteChar(BYTE ch);
extern	void	Beep(void);

extern	void	kprintf(char *fmtstr,...);

extern 	void	MoveToLineBegin(void);
extern 	void	StripHighBit(void);
extern 	void	CheckVT100screenAlignment(void);
extern 	void	SetVT100insertMode(void);
extern 	void	ResetVT100insertMode(void);
