/****************************************************************************
 * Filename   : fnkey.h
 * Purpose    : This file contains the prototype declarations for fnkey.c.
 ****************************************************************************/

/*	the control ids  for the function key dialog box */
#define		IDC_LBL_F1		150		/* label field control id for F1 key	*/
#define		IDC_LBL_F2		152
#define		IDC_LBL_F3		154
#define		IDC_LBL_F4		156
#define		IDC_LBL_F5		158
#define		IDC_LBL_F6		160
#define		IDC_LBL_F7		162
#define		IDC_LBL_F8		164
#define		IDC_LBL_F9		166
#define		IDC_LBL_F10		168
#define		IDC_LBL_F11		170
#define		IDC_LBL_F12		172

#define		IDC_ACT_F1		151			/* Edit field control id for F1 Key	*/
#define		IDC_ACT_F2		153
#define		IDC_ACT_F3		155
#define		IDC_ACT_F4		157
#define		IDC_ACT_F5		159
#define		IDC_ACT_F6		161
#define		IDC_ACT_F7		163
#define		IDC_ACT_F8		165
#define		IDC_ACT_F9		167
#define		IDC_ACT_F10		169
#define		IDC_ACT_F11		171
#define		IDC_ACT_F12		173

#define		IDC_FNKEY_OK		137		/* Control id for OK push button	*/
#define		IDC_FNKEY_CANCEL	138		/* COntrol id for Cancel push btn	*/

/* Key modifier ids */
#define		IDC_MOD_NONE			200		/* radio button id for none	*/
#define		IDC_MOD_CTRL			201
#define		IDC_MOD_SHIFT			202
#define		IDC_MOD_CTRL_SHIFT		203

#ifdef XXX
/* All key combinations with ALT were abandoned later */
#define		IDC_MOD_ALT				204
#define		IDC_MOD_CTRL_ALT		205
#define		IDC_MOD_SHIFT_ALT		206
#define		IDC_MOD_CTRL_ALT_SHIFT	207
#endif

#define	MAX_DISP_FNKEYS	12			/* Number of function keys diaplayed	*/
#define	NUM_OF_KEYS		12			/* there are 12 keys F1 thru F12	*/
#define	MAX_LABEL_NAME	8
#define	MAX_ACTION_STR	81

#define	KEY_MOD_MASK		0x70		/* mask for getting the modifier	*/
#define	KEY_MASK			0x0F
#define	KEY_FREE			0x0F

#define	KEY_MOD_CTRL		0x10		/* Control key down	*/
#define	KEY_MOD_SHIFT		0x20		/* Shift key down	*/
#define	KEY_MOD_ALT			0x40		/* Alt key down	*/

#define	KEY_MOD_NONE			0x00
#define	KEY_MOD_CTRL_SHIFT		(KEY_MOD_CTRL | KEY_MOD_SHIFT)
#define	KEY_MOD_CTRL_ALT		(KEY_MOD_CTRL | KEY_MOD_ALT)
#define	KEY_MOD_SHIFT_ALT		(KEY_MOD_SHIFT | KEY_MOD_ALT)
#define	KEY_MOD_CTRL_ALT_SHIFT	(KEY_MOD_CTRL | KEY_MOD_SHIFT | KEY_MOD_ALT)


/* prototype declarations for fnkey.c */
extern	char	ToNumber (BYTE ch, BYTE base);
extern	BOOL	ConvertSlashes( BYTE *ptr);
extern	void	SendFnKey (WORD key);
extern	void	EraseAkey (int	index);
extern	void	DrawAkey (int index);
extern	void	ExpandAndXmit (BYTE *key_string);
extern	int		DisplayFnkeys (void);
extern	void	DrawFnkeys (HDC hDc);
extern	int		CheckClickOnFnkey (LONG XYPos);
extern	BOOL	InvokeFnkey(BYTE Mode, BYTE Num, LPSTR LabelStr);
extern	BOOL	UnmapFnkey(BYTE Mode, BYTE Num, LPSTR LabelStr);
extern	BOOL	MapFnkey(BYTE Mode, BYTE Num, LPSTR ActionStr, LPSTR LabelStr);
extern	void	DrawEmptyKey( int index);
extern	long	FAR PASCAL	FnkeyWndProc (HWND hWnd, unsigned message,
				WORD wParam, LONG lParam);
extern	int		CreateFnkeyWnd (HWND hParentWnd);
extern	int		ComputeFnkeyCoords (void);

