/* ------------------------------------------------------------------------
	File		:	OURDLGBOX.H
	Synopsis	:	Modifies the dialog control colors and draws borders
					for Listbox, Edit controls and group box.
					This file has to be included by all applications
					using the DLG module.
	Author		:	Srinivasan S
	Date		:	20 Apr 1993
 ----------------------------------------------------------------------- */
/* Files need include only dlgbox.h */
#include <commdlg.h>

/* Global PUSH BUTTON ids used in dialog boxes */
#define	OURIDOK			1000
#define	OURIDCANCEL		1001
#define	IDC_SELECT		1002
#define	IDC_SETTING		1003
#define	IDC_DIAL		1004
#define	IDC_DELETE		1005
#define	IDC_VIEW_EDT	1006
#define	IDC_NEW			1007
#define	IDC_ABORT		1008
#define	IDC_HIDE		1009
#define	IDC_MORE		1010
#define	IDC_CONNECT		1011
#define	IDC_SAVE		1012
#define	IDC_EXECUTE		1013
#define	IDC_DEBUG		1014
#define	IDC_COMPILE		1015
#define	IDC_LEARN		1016
#define	IDC_RESET		1017
#define	IDC_LOAD		1018

#define	DLG_BTN_UNCHKED		0
#define	DLG_BTN_CHKED		1
#define	DLG_BTN_GRAYED		2

#define	DLG_FOCUS_MARGIN	2

/* Bitmap ids to be used in the RC file */
/* Include dlg.h along with other files in the RC file */
/*
#define	IDR_CHECK_OFF		100
#define	IDR_CHECK_ON		101
#define	IDR_CHECK_GRAY		102
#define	IDR_RADIO_OFF		104
#define	IDR_RADIO_ON		103
#define	IDR_RADIO_GRAY		105
*/
/* Groupboxes will be modified only if the ids are greater then or equal */
/* to this base number */
#define		PUSH_BTN_BASE		1000
#define		PUSH_BTN_END		1099
/*
#define		CHECK_BOX_BASE		1100
#define		CHECK_BOX_END		1199
#define		RADIO_BTN_BASE		1200
#define		RADIO_BTN_END		1299
*/
#define		GROUP_BOX_BASE		1300
#define		GROUP_BOX_END		1399
#define		EDIT_BOX_BASE		1400
#define		EDIT_BOX_END		1499
#define		LIST_BOX_BASE		1500
#define		LIST_BOX_END		1599
#define		COMBO_BOX_BASE		1600
#define		COMBO_BOX_END		1699
#define		STAT_TEXT_BASE		1700
#define		STAT_TEXT_END		1799
#define		SCRL_BAR_BASE		1800
#define		SCRL_BAR_END		1899
#define		ICONS_BASE			1900
#define		ICONS_END			1999
#define		RECT_BASE			2000
#define		RECT_END			2099

/* Colors available for background and pen */

#define		DLG_BLACK		0
#define		DLG_WHITE		1
#define		DLG_LTGRAY		2
#define		DLG_DKGRAY		3

/* Functions available in the MDI module */
/*
BOOL 	FAR PASCAL DLGInit(HINSTANCE hInst, int BackGroundColor,
										int PenColor, int PenWidth);
void 	FAR PASCAL DLGClose(void);
BOOL 	FAR PASCAL DLGShowFileOpenDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowSaveAsDlgBox(LPOPENFILENAME lpOfn);
BOOL 	FAR PASCAL DLGShowPrintDlgBox(LPPRINTDLG lpPd);
BOOL 	FAR PASCAL DLGShowFontDlgBox(LPCHOOSEFONT lpCf);
HBRUSH	FAR PASCAL DLGModifyColors(WPARAM wParam, LPARAM lParam);
*/
/* Routines implementing owner draw radio buttons and check boxes */
/*
void 	FAR PASCAL DLGInitDialog(HWND hDlg, WORD FAR * ControlBuf);
void 	FAR PASCAL DLGEndDialog(void);
void 	FAR PASCAL DLGCheckDlgButton(HWND hDlg, WORD CntlId, UINT uChecked);
int 	FAR PASCAL DLGIsDlgButtonChecked(HWND hDlg, WORD CntlId);
void 	FAR PASCAL DLGCheckRadioButton(HWND hDlg, WORD StartId,
										WORD EndId, WORD CheckId);
void 	FAR PASCAL DLGEnableRadioButton(HWND hDlg, WORD CtlID, BOOL State);
void 	FAR PASCAL DLGDrawItemControl(HWND hDlg, WORD idCtl,
										LPDRAWITEMSTRUCT lpInfo);
*/
/* Call back function to be exported */
/*
UINT 	CALLBACK DLGCtlColorFunc(HWND, UINT, WPARAM, LPARAM);
*/
/* ************************ FUNCTION SYNOPSIS **************************** */
/*
	1.	DLGInit()				-	Initialises the Dlg module and creates
									the pen and brush of the required colors.

	2.	DLGClose()				-	Frees up the local resources.  Should be
									called before PostQuitMessage().

	3.	DLGShowFileOpenDlgBox()	-	Displays the FileOpen common dialog box
									after installing a HOOK function to
									modify the colors.
	4.	DLGShowSaveAsDlgBox()	-	Displays the Save as common dialog box
									after installing a HOOK function to
									modify the colors.
	5.	DLGShowPrintDlgBox()	-	Displays the printer common dialog box
									after installing a HOOK function to
									modify the colors.

	6.	DLGShowFontDlgBox()		-	Displays the Font common dialog box
									after installing a HOOK function to
									modify the colors.

	7.	DLGModifyColors()		-	Modifies the colors of a dialog box.
									Should be called in response to a
									WM_CTLCOLOR message.

	8.	DLGInitDialog()			-	To be called in response to WM_INITDIALOG
									message if the dialog box has owner
									draw radio buttons or check boxes.

	9.	DLGEndDialog()			-	To be called before EndDialog() is made
									if DLGInitDialog() call was made to use
									owner draw radio buttons or check boxes.

	10.	DLGCheckDlgButton()		-	Function to replace CheckDlgButton()
									for owner draw radio button or check box.

	11.	DLGIsDlgButtonChecked()	-	Function to replace IsDlgButtonChecked()
									for owner draw radio button or check box.

	12.	DLGCheckRadioButton()	-	Function to replace CheckRadioButton()
									for owner draw radio button or check box.

	13.	DLGEnableRadioButton()	-	Function to disable or enable a owner
									drawn radio button.  Should be used
									instead of EnableWindow() call.

	14.	DLGDrawItemControl()	-	Function to be called in response to
									WM_DRAWITEM message for drawing owner
									draw radio buttons and check boxes.

	14.	DLGCtlColorFunc()		-	The callback HOOK function.

	This line should be present in the EXPORTS section in your DEF file:

		DLGCtlColorFunc				@__
*/
