/****************************************************************************
 * Filename   : time.h
 * Purpose    : This file contains the prototype declarations for time.c.
 ****************************************************************************/

#define	MAX_TIME_FLDS	4

#define	DATE_FLD_IDX	0		/* current date and time field index */
#define	STATE_FLD_IDX	1		/* current state field index */
#define	CONTIME_FLD_IDX	2		/* connection time field index */
#define	TIME_FLD_IDX	3		/* current session name */

/* date format in ascii */
#define	DATE_NORMAL	1
#define	DATE_EXPAND	2

/* time format in ascii */
#define	TIME_NORMAL	1
#define	TIME_AMPM	2

#define	NUM_MONTHS	12

/* number of seconds for each value */
#define	MINUTE	60
#define	HOUR	(60 * MINUTE)
#define	DAY		(DWORD)(24 * HOUR)

/* structure for holding time (in hours, minutes, and seconds) */
typedef struct {
	int	hour;  		/* 0 - 23 */
	int	minute;		/* 0 - 59 */
	int 	second;		/* 0 - 59 */
} TIME;

/* structure for holding date (in year, month, and day) */
typedef struct {
	int 	year;  		/* full year */
	int 	month;		/* 1 - 12 */
	int 	day;			/* 1 - 31 */
} DATE;

/* global data from time.c */
extern	TIME	ConTime;
extern	RECT	TimeFields[];
extern	char 	*MonthNames[];

/* prototype declarations for time.c */
long 	FAR PASCAL TimeWndProc(HWND, unsigned, WORD, LONG);
int		CreateTimeWnd (HWND hParentWnd);
int		ComputeTimeFieldCoords (void);
int		DisplayTimeBar (HDC hDc);
void	UpdateStatusInBar (void);
void	UpdatePhoneBkName (char *FileName);

int		GetAsciiTimeDate (LPSTR pBuf);
void	GetAsciiDate (LPSTR buf);
void	FormatAsciiDate (DATE *pDate, LPSTR buf, WORD format);
void	GetAsciiTime (LPSTR buf);
void	FormatAsciiTime (TIME *pTime, LPSTR buf, WORD format);
int		FindTimeDiff(LPSTR FromTime, LPSTR ToTime);

void 	GetTime(TIME *);
void 	GetDate(DATE *);

