/****************************************************************************
	FILE     : TFTPIF.H
	SYNOPSIS : This file contains the extern declarations of all the functions
	           that are callable from the UI. It further gives the defn. of
	           all the constants, return codes etc. shared between TFTP and
	           ROUCON. As such, this is the only file that needs to be included
	           by ROUCON to use TFTP.
	DATE     : 13.11.95
****************************************************************************/

#ifndef _TFTPIF_H_

#define _TFTPIF_H_

enum TFTP_FILE_TRANSFER_RESULT
{
	TFTP_SUCCESS = 0,
	TFTP_SOCKET_INITIALIZATION_FAILED,
	TFTP_COMPRESSION_FAILED,
	TFTP_NETWORK_SUBSYSTEM_NOT_READY,
	TFTP_VERSION_NOT_SUPPORTED,
	TFTP_FAILURE = 0xFF
} ;

enum TFTP_FILE_TRANSFER_STATUS
{
	TFTP_FILE_TRANSFER_NOT_SCHEDULED = 0,
	TFTP_FILE_TRANSFER_IN_PROGRESS,
	TFTP_FILE_TRANSFER_SUCCESSFUL,
	TFTP_FILE_TRANSFER_FAILED = 0xFF
} ;

enum TFTP_COMPLETION_CODE_STATUS
{
	TFTP_COMPLETE = 0,
	TFTP_IN_PROGRESS,
	TFTP_NOT_SCHEDULED
} ;


#define WM_TFTP WM_USER + 25


extern enum TFTP_FILE_TRANSFER_RESULT FAR PASCAL __loadds
TFTPGetFile (char LocalFile[], char RemoteFile[], char IPAddressString[], HWND MainWindowHandle) ;
extern enum TFTP_FILE_TRANSFER_RESULT  FAR PASCAL __loadds
TFTPPutFile (char LocalFile[], char RemoteFile[], char IPAddressString[], HWND MainWindowHandle) ;
extern void  FAR PASCAL __loadds TFTPProcess (void) ;
extern void  FAR PASCAL __loadds TFTPTimer (void) ;
extern void  FAR PASCAL __loadds AbortTFTPTransfer () ;
extern unsigned long FAR PASCAL __loadds TFTPGetFileLength () ;
extern unsigned long FAR PASCAL __loadds TFTPGetBytesTransfered () ;
extern enum TFTP_COMPLETION_CODE_STATUS FAR PASCAL __loadds TFTPGetCompletionCode () ;
extern enum TFTP_FILE_TRANSFER_STATUS FAR PASCAL __loadds TFTPGetFileTransferStatus () ;

//extern enum TFTP_COMPLETION_CODE_STATUS TFTPCompletionCode ;
//extern enum TFTP_FILE_TRANSFER_STATUS TFTPFileTransferStatus ;
/* This variable keeps track of the TFTP file transfer status.
   This is absolutely necessary because any call to TFTPGetFile()
   or TFTPPutFile() will only schedule a file transfer and return.
   The completion and the success/failure of the file transfer is
   identified by looking at this variable */

//extern unsigned long TFTPFileLength, TFTPBytesTransfered ;

#endif


/****************************************************************************
	Overview of the TFTP File Transfer :
	----------------------------------
		Any application, seeking to do a TFTP file transfer needs to do the
	following :
	(a). Include the tftpif.h file.
	(b). Make a call to TFTPGetFile() or TFTPPutFile() as the case may be.
	     Having done this, the application should arrange to call TFTPTimer()
	     every 55 milliseconds and in the WindowProcedure, corresponding to
	     the Window Handle passed as a parameter to the above call, make a call
	     to TFTPProcess() on message WM_TFTP.
	(c). Note that TFTPGetFile() / TFTPPutFile() only prepare for file
	     transfer and return. The completion and result of the file transfer
	     are recorded in two globals, TFTPCompletioCode and TFTPFileTransferStatus.
	     It is up to the application to detect the completion of the file transfer
	     by monitoring the two variables.

	TFTPCompletionCode : If this variable holds a non-zero value, it implies
		that file transfer is in progress. Once this variables becomes zero,
		it means that TFTP is done with the file transfer. Note that this
		variable does NOT convey the success/failure of the file transfer.

	TFTPFileTransferStatus : This variable has meaning only after
		TFTPCompletionCode becomes zero. The value reflects the result of the
		file transfer.

****************************************************************************/
