#ifndef _TFTPENUM_H_

#define _TFTPENUM_H_

enum BOOLEAN
{
	SUCCESS = 0,
	FAILURE= -1
} ;

enum OPEN_MODE
{
	MODE_READ=1,
	MODE_WRITE=2
} ;

enum OPCODE
{
	OPCODE_READFILE=1,
	OPCODE_WRITEFILE=2,
	OPCODE_DATA=3,
	OPCODE_ACK=4,
	OPCODE_ERR=5
} ;

enum TFTP_CLIENT_STATE
{
	STATE_NOOP=0,
	STATE_SEND_REQUEST,
	STATE_RETRANSMIT_REQUEST,
	STATE_SEND_DATA,
	STATE_RETRANSMIT_DATA,
	STATE_WAIT_FOR_ACK,
	STATE_WAIT_FOR_DATA,
	STATE_SEND_ACK,
	STATE_CLOSE_CONN
} ;

enum TFTP_REQUEST
{
	TFTP_REQUEST_GET,
	TFTP_REQUEST_PUT
} ;

enum TFTP_FILE_TYPE
{
	FILE_TYPE_CONFIG = 0,
	FILE_TYPE_CODE = 1,
	FILE_TYPE_BOOT_CONFIG = 2,
	FILE_TYPE_USER_DATABASE = 3,
	FILE_TYPE_SCRIPT_CONFIG = 4,
	FILE_TYPE_SCRIPT_PORT1 = 5,
	FILE_TYPE_SCRIPT_PORT2 = 6,
	FILE_TYPE_SCRIPT_PORT3 = 7,
#if PROXY_SERVER
	FILE_TYPE_PORT_STATUS = 8,
#endif
	FILE_TYPE_HUPANDREDIAL = 9,
	FILE_TYPE_UNKNOWN
} ;

#endif
