#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "tftp.h"
#include "tftpglob.h"
#include "..\userdata.h"
#include "..\boot.h"
#include "..\tftpdnld.h"

#define VERSION_STRING "v1.00"
extern HANDLE hInst ;

char *MonthNames[] =
{
	"Jan.",
	"Feb.",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"Sept.",
	"Oct.",
	"Nov.",
	"Dec"
} ;

FileHeaderType FileHeader ;
char VersionString[10] ;
char DateStamp[25] ;

#define BLOCK_LENGTH 512

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 0xFF)] ^ (crc << 8) ^ ((cp) & 0xFF))


typedef struct {
	struct dosdate_t FileDate ;
	struct dostime_t FileTime ;
} DateStampType ;

unsigned long SwapDWord (unsigned long x)
{
	unsigned long y ;

	unsigned char *y_ptr = (unsigned char*) &y ;
	unsigned char *x_ptr = (unsigned char*) &x ;

	*(y_ptr + 0) = *(x_ptr + 3) ;
	*(y_ptr + 1) = *(x_ptr + 2) ;
	*(y_ptr + 2) = *(x_ptr + 1) ;
	*(y_ptr + 3) = *(x_ptr + 0) ;

	return y ;
}

unsigned short SwapWord (unsigned short x)
{
	unsigned short y ;

	unsigned char *y_ptr = (unsigned char*) &y ;
	unsigned char *x_ptr = (unsigned char*) &x ;

	*(y_ptr + 0) = *(x_ptr + 1) ;
	*(y_ptr + 1) = *(x_ptr + 0) ;

	return y ;
}

#define P 0x8408
unsigned int crctab[256] ;

void CalculateCRCTable (void)
{
	register unsigned int b, v ;
	register unsigned short i ;

	for (b = 0 ; ; ) 
	{
		v = b ;
		for (i = 8 ; i -- ; )
			v = (v & 1) ? ((v >> 1) ^ P) : (v >> 1) ;

		crctab[b] = v & 0xffff ;
		if (++b == 256)
			break ;
	}
}

unsigned short	GlobalCRC = 0xFFFF ;
void UpdateGlobalCRC (unsigned char *Pkt, unsigned long length)
{
	unsigned long i ;
	for(i = 0 ; i < length ; i ++)
		GlobalCRC = updcrc((0xff & Pkt[i]), GlobalCRC) ;
}

char TempBuffer[BLOCK_LENGTH] ;

int AddTFTPHeader (unsigned char SourceFile[], unsigned char TFTPFile[], TFTPCodeBurnStruct *CodeAddrPtr)
{
	FILE *SourceFilePointer, *TFTPFilePointer ;
	TFTPHeaderType TFTPHeader ;
	HEADER_TYPE UDBHeader ;
	char ReadMore = 1 ;
	long FileLength = 0 ;
	int BlockLength = 0 ;
	unsigned char ZeroZero[] = {0, 0} ;
	char TempBuff[25] ;
	DateStampType CurrentDate ;


	GlobalCRC = 0xFFFF ;

	SourceFilePointer = fopen (SourceFile, "rb") ;
	if (SourceFilePointer == NULL)
		return -1 ;

	TFTPFilePointer = fopen (TFTPFile, "wb") ;
	if (TFTPFilePointer == NULL)
	{
		fclose (SourceFilePointer) ;
		return -1 ;
	}

	fseek (TFTPFilePointer, 512L, SEEK_SET) ;
	CalculateCRCTable() ;

	while (ReadMore)
	{
		if (feof (SourceFilePointer))
			break ;

		BlockLength = fread (TempBuffer, 1,
					BLOCK_LENGTH, SourceFilePointer) ;
		UpdateGlobalCRC ((unsigned char*) TempBuffer, BlockLength) ;
		if (fwrite (TempBuffer, 1, BlockLength, TFTPFilePointer) <
															BlockLength)
		{
			fclose (SourceFilePointer) ;
			fclose (TFTPFilePointer) ;
			return -1 ;
		}
		FileLength += BlockLength ;
	}

	UpdateGlobalCRC ((unsigned char*) ZeroZero, 2) ;
	fseek (TFTPFilePointer, 0L, SEEK_SET) ;

	_dos_gettime (&CurrentDate.FileTime) ;
	_dos_getdate (&CurrentDate.FileDate) ;

	memset ((BYTE *) &TFTPHeader, 0, sizeof (TFTPHeader)) ;
	memset ((BYTE *) &UDBHeader, 0, sizeof (UDBHeader)) ;

	switch (FileType)
	{
		case FILE_TYPE_CODE :
		case FILE_TYPE_CONFIG :
			strcpy (TFTPHeader.DateStamp,
						MonthNames[CurrentDate.FileDate.month-1]) ;
			strcat (TFTPHeader.DateStamp, " ") ;
			sprintf(TempBuff, "%d", CurrentDate.FileDate.day) ;
			strcat (TFTPHeader.DateStamp, TempBuff) ;
			strcat (TFTPHeader.DateStamp, ", ") ;
			sprintf(TempBuff, "%d", CurrentDate.FileDate.year) ;
			strcat (TFTPHeader.DateStamp, TempBuff) ;
			break ;

		case FILE_TYPE_USER_DATABASE :
			strcpy (UDBHeader.date_stamp,
						MonthNames[CurrentDate.FileDate.month - 1]) ;
			strcat (UDBHeader.date_stamp, " ") ;
			sprintf(TempBuff, "%d", CurrentDate.FileDate.day) ;
			strcat (UDBHeader.date_stamp, TempBuff) ;
			strcat (UDBHeader.date_stamp, ", ") ;
			sprintf(TempBuff, "%d", CurrentDate.FileDate.year) ;
			strcat (UDBHeader.date_stamp, TempBuff) ;
			UDBHeader.magic_number = SwapWord (MAGIC_NUM) ;
			UDBHeader.crc = SwapWord (GlobalCRC) ;
			UDBHeader.no_of_users = SwapWord (
					   (unsigned short)	(UserDataBaseFileLength / 
					   								sizeof (USERDATA))) ;
   	   strcpy (UDBHeader.Description, "USER DATABASE") ;
			break ;
	}

	switch (FileType)
	{
		case FILE_TYPE_CODE :
		case FILE_TYPE_CONFIG :
		case FILE_TYPE_SCRIPT_CONFIG :
		case FILE_TYPE_SCRIPT_PORT1 :
		case FILE_TYPE_SCRIPT_PORT2 :
		case FILE_TYPE_SCRIPT_PORT3 :
			TFTPHeader.MagicNumber = SwapWord (MAGIC_NUM) ;
			TFTPHeader.CodeLength = SwapDWord (FileLength) ;
			TFTPHeader.Crc = SwapWord (GlobalCRC) ;
			break ;
	}
		
   switch (FileType)
   {
		case FILE_TYPE_CODE :
#if 0
        	TFTPHeader.DownLoadAddress = SwapDWord (FL_CODE_START) ;
	      TFTPHeader.LoadAddress = SwapDWord (COD_LOAD_ADDR) ;
    	   TFTPHeader.StartAddress = SwapDWord (COD_START_ADDR) ;
#else
        	TFTPHeader.DownLoadAddress = SwapDWord (CodeAddrPtr->TFTP_FlCodeStartAddress) ;
	      TFTPHeader.LoadAddress = SwapDWord (CodeAddrPtr->TFTP_CodeLoadAddress) ;
    	   TFTPHeader.StartAddress = SwapDWord (CodeAddrPtr->TFTP_CodeStartAddress) ;
#endif

			_fstrncpy (TFTPHeader.Version, FileHeader.Version, 8) ;
			_fstrncpy (TFTPHeader.DateStamp, FileHeader.DateStamp, 24) ;
         break ;

      case FILE_TYPE_CONFIG :
			TFTPHeader.DownLoadAddress = SwapDWord (FL_SYSTEM_CFG) ;
			TFTPHeader.LoadAddress = SwapDWord (FL_SYSTEM_CFG) ;
		   _fstrncpy (TFTPHeader.Version, VERSION_STRING, 8) ;
         break ;

	  	case FILE_TYPE_USER_DATABASE :
			UDBHeader.down_load_address = SwapDWord (UDB_DNLD_ADDR) ;
			UDBHeader.code_length = SwapDWord (FileLength) ;
//			strcpy (UDBHeader.version, "") ;
			strcpy (UDBHeader.version, VERSION2) ;
			break ;

		case FILE_TYPE_SCRIPT_CONFIG :
			TFTPHeader.DownLoadAddress = SwapDWord ((DWORD) SCRIPT_HEADER) ;
			break ;

		case FILE_TYPE_SCRIPT_PORT1 :
			TFTPHeader.DownLoadAddress = 
					SwapDWord ((DWORD) SCRIPT_ONE_DNLD_ADDR) ;
			break ;

		case FILE_TYPE_SCRIPT_PORT2 :
			TFTPHeader.DownLoadAddress = 
					SwapDWord ((DWORD) SCRIPT_TWO_DNLD_ADDR) ;
			break ;

		case FILE_TYPE_SCRIPT_PORT3 :
			TFTPHeader.DownLoadAddress = 
					SwapDWord ((DWORD) SCRIPT_THREE_DNLD_ADDR) ;
			break ;

/*      default :
         fclose (TFTPFilePointer) ;
         fclose (SourceFilePointer) ;
         return -1 ; */
   }

	switch (FileType)
	{
		case FILE_TYPE_CODE :
		case FILE_TYPE_CONFIG :
		case FILE_TYPE_SCRIPT_CONFIG :
		case FILE_TYPE_SCRIPT_PORT1 :
		case FILE_TYPE_SCRIPT_PORT2 :
		case FILE_TYPE_SCRIPT_PORT3 :
	    	if (fwrite (&TFTPHeader, 1, sizeof (TFTPHeader),
								TFTPFilePointer) < sizeof (TFTPHeader))
	    	{
				fclose (TFTPFilePointer) ;
				fclose (SourceFilePointer) ;
				return -1 ;
			}
			break ;

		case FILE_TYPE_USER_DATABASE :
			if (fwrite (&UDBHeader, 1, sizeof (UDBHeader),
							TFTPFilePointer) < sizeof (UDBHeader))
			{
				fclose (TFTPFilePointer) ;
				fclose (SourceFilePointer) ;
				return -1 ;
			}
			break ;
	}

	fclose (TFTPFilePointer) ;
	fclose (SourceFilePointer) ;

	TFTPFileLength = FileLength ;

	return 0 ;
}

char TFTPBuffer[500] ;

int StripTFTPHeader (unsigned char TFTPFile[], unsigned char DestinationFile[], char *TFTPHeader)
{
	FILE *TFTPFilePointer, *DestinationFilePointer ;
	long FileLength = 0 ;
	int BytesRead = 0 ;
	TFTPHeaderType *TFTPHeaderPointer = (TFTPHeaderType *) TFTPHeader ;
	struct find_t FileInfo ;
	FileHeaderType *FileHeaderPointer ;

	FILE *UDBHeaderFile ;
	char UDBHeaderFilePath[200] ;
	char *ptr ;
	int TempLen ;

	DestinationFilePointer = fopen (DestinationFile, "wb") ;
	if (DestinationFilePointer == NULL)
		return -1 ;

	TFTPFilePointer = fopen (TFTPFile, "rb") ;
	if (TFTPFilePointer == NULL)
	{
		fclose (DestinationFilePointer) ;
		return -1 ;
	}

	if ((FileType == FILE_TYPE_CODE) || (FileType == FILE_TYPE_CONFIG))
	{
		fread (TFTPHeaderPointer, 1, 512, TFTPFilePointer) ;
		FileHeaderPointer = (FileHeaderType*) TFTPHeaderPointer ;
		FileLength = SwapDWord (TFTPHeaderPointer->CodeLength) ;
		_fstrncpy (VersionString, FileHeaderPointer->Version, 8) ;
		_fstrncpy (DateStamp, FileHeaderPointer->Version, 24) ;
	}
	else
	{
		if (_dos_findfirst (TFTPFile, _A_NORMAL, &FileInfo))
		{
			fclose (TFTPFilePointer) ;
			fclose (DestinationFilePointer) ;
			return -1 ;
		}
		FileLength = FileInfo.size ;
		if (FileType == FILE_TYPE_USER_DATABASE)
		{
			fread (TFTPHeaderPointer, 1, 512, TFTPFilePointer) ;
			FileLength -= 512 ;

			memset (UDBHeaderFilePath, 0, sizeof (UDBHeaderFilePath)) ; 
			TempLen = GetModuleFileName (hInst, UDBHeaderFilePath,
														sizeof (UDBHeaderFilePath)) ;
			ptr = &UDBHeaderFilePath[TempLen] ;
		   while (*ptr != '\\')
      		ptr -- ;
			*(ptr + 1) = 0x00 ;
			strcat (UDBHeaderFilePath, UDB_HDR_FILE) ;

			UDBHeaderFile = fopen (UDBHeaderFilePath, "wb") ;
			if (UDBHeaderFile != NULL)
			{
				fwrite (TFTPHeaderPointer, 1, 512, UDBHeaderFile) ;
				fclose (UDBHeaderFile) ;
			}
		}
	}

	while (FileLength)
	{
		BytesRead = fread (TFTPBuffer, 1, 500, TFTPFilePointer) ;
		FileLength -= BytesRead ;
		if (fwrite (TFTPBuffer, 1, BytesRead,
						DestinationFilePointer) < BytesRead)
		{
			fclose (TFTPFilePointer) ;
			fclose (DestinationFilePointer) ;
			return -1 ;
		}
	}
	fclose (TFTPFilePointer) ;
	fclose (DestinationFilePointer) ;

	return 0 ;
}
