#ifndef _TFTPSTR_H_

#define _TFTPSTR_H_

typedef struct
{
	char FileName[MAX_FILE_LEN] ;
	char OpenMode ;
} FileOpenReqType ;

typedef struct
{
	u_short BlockNumber ;
	char BlockData[MAX_BLOCK_LEN] ;
} FileDataType ;

typedef struct
{
	u_short AckedBlockNumber ;
} AckType ;

typedef struct
{
	u_short ErrorNumber ;
	unsigned char ErrorMessage[100]  ;
} ErrorType ;

typedef struct
{
	u_short OpCode ;
	union
	{
		FileOpenReqType FileOpenReq ;
		FileDataType FileData ;
		AckType Ack ;
		ErrorType Error ;
	} MessageType ;
} TFTPPacketType ;

typedef struct HeaderType
{
	unsigned char Version[10] ;
	unsigned char DateStamp[25] ;
	unsigned char Dummy ;
	unsigned short MagicNumber ;
	unsigned short Crc ;
	unsigned long CodeLength ;
	unsigned long DownLoadAddress ;
	unsigned long LoadAddress ;
	unsigned long StartAddress ;
	char Reserved[20] ;
	char Pack[512-76] ;
} 
TFTPHeaderType ;

typedef struct {
	unsigned char Version[8] ;
	unsigned char DateStamp[24] ;
	char MagicNumber[5] ;
} FileHeaderType ;

typedef struct HEADER_TYPE
{
	BYTE version[10] ;
	BYTE date_stamp[25] ;
	BYTE dummy ;
	unsigned short magic_number ;
	unsigned short crc ;
	unsigned long code_length ;
	unsigned long down_load_address ;
	unsigned long load_address ;
	unsigned long start_address ;
	unsigned short no_of_users ;
	BYTE Description[15] ;
	BYTE reserved[20] ;
	BYTE padding[436 - 17] ;
} HEADER_TYPE ;

typedef struct UDP_DATA_PACKET_TYPE
{
  BYTE 				packet_type ;
  unsigned long  	ip_address ;
  BYTE   			mac_address[16] ;
  BYTE 				description[25] ;
} UDP_DATA_PACKET_TYPE ;

#endif
